

package org.apache.drill.exec.expr.fn.impl.gcast;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DrillBuf;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;

/*
 * This class is generated using freemarker and the CastFunctionsTargetVarLen.java template.
 */
@SuppressWarnings("unused")
@FunctionTemplate(name = "castVARCHAR",
    scope = FunctionTemplate.FunctionScope.SIMPLE,
    returnType = FunctionTemplate.ReturnType.STRING_CAST,
    nulls = NullHandling.NULL_IF_NULL)
public class CastFloat8VarChar implements DrillSimpleFunc{

  @Param Float8Holder in;
  @Param BigIntHolder len;
  @Inject DrillBuf buffer;     
  @Output VarCharHolder out;

  public void setup() {
  }

  public void eval() {
    buffer = buffer.reallocIfNeeded((int)len.value);
    String istr = (new Double(in.value)).toString();
    out.buffer = buffer;
    out.start = 0;
    out.end = Math.min((int)len.value, istr.length()); // truncate if target type has length smaller than that of input's string
    out.buffer.setBytes(0, istr.substring(0,out.end).getBytes());      
  }
}

 

