

/*
 * This class is generated using freemarker and the Decimal/DecimalAggrTypeFunctions3.java template.
 */


package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;

@SuppressWarnings("unused")

public class DecimalVariancePopFunctions {

  @FunctionTemplate(name = "var_pop",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_AVG_AGGREGATE)
  public static class VarDecimalVariancePop implements DrillAggFunc {
    @Param VarDecimalHolder in;
    @Inject DrillBuf buffer;
    @Workspace ObjectHolder avg;
    @Workspace ObjectHolder dev;
    @Workspace BigIntHolder count;
    @Workspace IntHolder scale;
    @Output NullableVarDecimalHolder out;
    @Workspace BigIntHolder nonNullCount;

    public void setup() {
      avg = new ObjectHolder();
      dev = new ObjectHolder();
      count = new BigIntHolder();
      scale = new IntHolder();
      scale.value = Integer.MIN_VALUE;
      // Initialize the workspace variables
      avg.obj = java.math.BigDecimal.ZERO;
      dev.obj = java.math.BigDecimal.ZERO;
      count.value = 1;
      nonNullCount = new BigIntHolder();
    }

    @Override
    public void add() {

      nonNullCount.value = 1;

      if (scale.value == Integer.MIN_VALUE) {
        scale.value = Math.max(in.scale, 6);
      }

      // Welford's approach to compute standard deviation
      // avg.value += ((in.value - temp) / count.value);
      // dev.value += (in.value - temp) * (in.value - avg.value);
      java.math.BigDecimal temp = (java.math.BigDecimal) avg.obj;
      java.math.BigDecimal input = org.apache.drill.exec.util.DecimalUtility
          .getBigDecimalFromDrillBuf(in.buffer, in.start, in.end - in.start, in.scale);
      avg.obj = ((java.math.BigDecimal) avg.obj)
          .add(input.subtract(temp)
                  .divide(java.math.BigDecimal.valueOf(count.value),
                      new java.math.MathContext(
                          org.apache.drill.exec.planner.types.DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision(),
                          java.math.RoundingMode.HALF_UP)));
      dev.obj = ((java.math.BigDecimal) dev.obj)
          .add(input.subtract(temp).multiply(input.subtract(((java.math.BigDecimal) avg.obj))));
      count.value++;
    }

    @Override
    public void output() {
      if (nonNullCount.value > 0) {
        out.isSet = 1;
        if (count.value  > 1) {
          // out.value = (dev.value / (count.value - 1));
          java.math.BigDecimal result =
              ((java.math.BigDecimal) dev.obj)
                  .setScale(scale.value, java.math.RoundingMode.HALF_UP)
                  .divide(java.math.BigDecimal.valueOf(count.value - 1),
                      java.math.RoundingMode.HALF_UP);
          out.scale = scale.value;
          result = result.setScale(out.scale, java.math.RoundingMode.HALF_UP);
          out.start  = 0;
          out.precision = org.apache.drill.exec.planner.types.DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision();
          org.apache.drill.exec.util.DecimalUtility.checkValueOverflow(result, out.precision, out.scale);
          byte[] bytes = result.unscaledValue().toByteArray();
          int len = bytes.length;
          out.buffer = buffer.reallocIfNeeded(len);
          out.buffer.setBytes(0, bytes);
          out.end = len;
        } else {
          out.start = 0;
          out.end = 0;
          out.buffer = buffer;
        }
      } else {
        out.isSet = 0;
      }
    }

    @Override
    public void reset() {
      avg.obj = java.math.BigDecimal.ZERO;
      dev.obj = java.math.BigDecimal.ZERO;
      count.value = 1;
      nonNullCount.value = 0;
    }
  }


  @FunctionTemplate(name = "var_pop",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_AVG_AGGREGATE)
  public static class NullableVarDecimalVariancePop implements DrillAggFunc {
    @Param NullableVarDecimalHolder in;
    @Inject DrillBuf buffer;
    @Workspace ObjectHolder avg;
    @Workspace ObjectHolder dev;
    @Workspace BigIntHolder count;
    @Workspace IntHolder scale;
    @Output NullableVarDecimalHolder out;
    @Workspace BigIntHolder nonNullCount;

    public void setup() {
      avg = new ObjectHolder();
      dev = new ObjectHolder();
      count = new BigIntHolder();
      scale = new IntHolder();
      scale.value = Integer.MIN_VALUE;
      // Initialize the workspace variables
      avg.obj = java.math.BigDecimal.ZERO;
      dev.obj = java.math.BigDecimal.ZERO;
      count.value = 1;
      nonNullCount = new BigIntHolder();
    }

    @Override
    public void add() {
      sout: {
      if (in.isSet == 0) {
        // processing nullable input and the value is null, so don't do anything...
        break sout;
      }

      nonNullCount.value = 1;

      if (scale.value == Integer.MIN_VALUE) {
        scale.value = Math.max(in.scale, 6);
      }

      // Welford's approach to compute standard deviation
      // avg.value += ((in.value - temp) / count.value);
      // dev.value += (in.value - temp) * (in.value - avg.value);
      java.math.BigDecimal temp = (java.math.BigDecimal) avg.obj;
      java.math.BigDecimal input = org.apache.drill.exec.util.DecimalUtility
          .getBigDecimalFromDrillBuf(in.buffer, in.start, in.end - in.start, in.scale);
      avg.obj = ((java.math.BigDecimal) avg.obj)
          .add(input.subtract(temp)
                  .divide(java.math.BigDecimal.valueOf(count.value),
                      new java.math.MathContext(
                          org.apache.drill.exec.planner.types.DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision(),
                          java.math.RoundingMode.HALF_UP)));
      dev.obj = ((java.math.BigDecimal) dev.obj)
          .add(input.subtract(temp).multiply(input.subtract(((java.math.BigDecimal) avg.obj))));
      count.value++;
      } // end of sout block
    }

    @Override
    public void output() {
      if (nonNullCount.value > 0) {
        out.isSet = 1;
        if (count.value  > 1) {
          // out.value = (dev.value / (count.value - 1));
          java.math.BigDecimal result =
              ((java.math.BigDecimal) dev.obj)
                  .setScale(scale.value, java.math.RoundingMode.HALF_UP)
                  .divide(java.math.BigDecimal.valueOf(count.value - 1),
                      java.math.RoundingMode.HALF_UP);
          out.scale = scale.value;
          result = result.setScale(out.scale, java.math.RoundingMode.HALF_UP);
          out.start  = 0;
          out.precision = org.apache.drill.exec.planner.types.DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision();
          org.apache.drill.exec.util.DecimalUtility.checkValueOverflow(result, out.precision, out.scale);
          byte[] bytes = result.unscaledValue().toByteArray();
          int len = bytes.length;
          out.buffer = buffer.reallocIfNeeded(len);
          out.buffer.setBytes(0, bytes);
          out.end = len;
        } else {
          out.start = 0;
          out.end = 0;
          out.buffer = buffer;
        }
      } else {
        out.isSet = 0;
      }
    }

    @Override
    public void reset() {
      avg.obj = java.math.BigDecimal.ZERO;
      dev.obj = java.math.BigDecimal.ZERO;
      count.value = 1;
      nonNullCount.value = 0;
    }
  }

}
