/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.util.impl;

import org.ojai.Value;
import org.ojai.annotation.API;

@API.Internal
public class ContainerContext {
    private final String fieldName;
    private final Value.Type type;
    private int index;
    public static final ContainerContext NULL = new ContainerContext(null);

    public ContainerContext(Value.Type t) {
        this(t, null);
    }

    public ContainerContext(Value.Type t, String n) {
        this.type = t;
        this.fieldName = n;
        this.index = -1;
    }

    public Value.Type getType() {
        return this.type;
    }

    public ContainerContext setIndex(int newIndex) {
        if (this.type != Value.Type.ARRAY) {
            throw new IllegalStateException("setIndex() called on a map");
        }
        this.index = newIndex;
        return this;
    }

    public int getIndex() {
        if (this.type != Value.Type.ARRAY) {
            throw new IllegalStateException("getIndex() called on a map");
        }
        return this.index;
    }

    public void incrementIndex() {
        if (this.type != Value.Type.ARRAY) {
            throw new IllegalStateException("incrementIndex() called on a map");
        }
        ++this.index;
    }

    public String toString() {
        return "[" + (Object)((Object)this.type) + ", " + this.index + ", " + this.fieldName + "]@" + this.hashCode();
    }

    public String getFieldName() {
        return this.fieldName;
    }
}

