/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLServerSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.mortbay.jetty.security.SslSocketConnector;

public class SslSocketConnectorSecure
extends SslSocketConnector {
    public static final Log LOG = LogFactory.getLog(SslSocketConnectorSecure.class);

    protected ServerSocket newServerSocket(String host, int port, int backlog) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)super.newServerSocket(host, port, backlog);
        ArrayList<String> nonSSLProtocols = new ArrayList<String>();
        Configuration conf = new Configuration();
        String excludeProtocols = conf.get("hadoop.ssl.exclude.insecure.protocols", "SSLv3,TLSv1");
        LOG.info((Object)("Exclude protocols: " + excludeProtocols));
        List<String> excludeProtocolsList = Arrays.asList(excludeProtocols.split(","));
        for (String p : socket.getEnabledProtocols()) {
            if (excludeProtocolsList.contains(p)) continue;
            nonSSLProtocols.add(p);
        }
        LOG.info((Object)("Enabled protocols: " + Arrays.toString(nonSSLProtocols.toArray(new String[nonSSLProtocols.size()]))));
        socket.setEnabledProtocols(nonSSLProtocols.toArray(new String[nonSSLProtocols.size()]));
        return socket;
    }
}

