/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.Version;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Environment {
    public static final String JAAS_CONF_KEY = "java.security.auth.login.config";

    private static void put(ArrayList<Entry> l, String k, String v) {
        l.add(new Entry(k, v));
    }

    public static List<Entry> list() {
        ArrayList<Entry> l = new ArrayList<Entry>();
        Environment.put(l, "zookeeper.version", Version.getFullVersion());
        try {
            Environment.put(l, "host.name", InetAddress.getLocalHost().getCanonicalHostName());
        }
        catch (UnknownHostException e) {
            Environment.put(l, "host.name", "<NA>");
        }
        Environment.put(l, "java.version", System.getProperty("java.version", "<NA>"));
        Environment.put(l, "java.vendor", System.getProperty("java.vendor", "<NA>"));
        Environment.put(l, "java.home", System.getProperty("java.home", "<NA>"));
        Environment.put(l, "java.class.path", System.getProperty("java.class.path", "<NA>"));
        Environment.put(l, "java.library.path", System.getProperty("java.library.path", "<NA>"));
        Environment.put(l, "java.io.tmpdir", System.getProperty("java.io.tmpdir", "<NA>"));
        Environment.put(l, "java.compiler", System.getProperty("java.compiler", "<NA>"));
        Environment.put(l, "os.name", System.getProperty("os.name", "<NA>"));
        Environment.put(l, "os.arch", System.getProperty("os.arch", "<NA>"));
        Environment.put(l, "os.version", System.getProperty("os.version", "<NA>"));
        Environment.put(l, "user.name", System.getProperty("user.name", "<NA>"));
        Environment.put(l, "user.home", System.getProperty("user.home", "<NA>"));
        Environment.put(l, "user.dir", System.getProperty("user.dir", "<NA>"));
        return l;
    }

    public static void logEnv(String msg, Logger log) {
        List<Entry> env = Environment.list();
        for (Entry e : env) {
            log.info(msg + e.toString());
        }
    }

    public static class Entry {
        private String k;
        private String v;

        public Entry(String k, String v) {
            this.k = k;
            this.v = v;
        }

        public String getKey() {
            return this.k;
        }

        public String getValue() {
            return this.v;
        }

        public String toString() {
            return this.k + "=" + this.v;
        }
    }
}

