/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway;

import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.data.gateway.Configs;
import com.mapr.security.JNISecurity;
import com.mapr.security.Security;
import com.mapr.web.security.SslConfig;
import com.mapr.web.security.WebSecurityConfig;
import com.mapr.web.security.WebSecurityManager;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import org.apache.commons.lang.StringUtils;
import org.ojai.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityProvider {
    private static final Logger log = LoggerFactory.getLogger(SecurityProvider.class);
    private static final String SSL_OPTION_CLUSTER = "cluster";
    private static final String SSL_PROVIDER_JDK = "jdk";
    private static final String SSL_PROVIDER_OPENSSL = "openssl";
    private static final String KS_TYPE_PKCS12 = "pkcs12";
    private static final String ALGO_SUN_X509 = "SunX509";
    private static final String KS_TYPE_JKS = "jks";
    private static final String ALGO_PKIX = "PKIX";
    private static final String MAPR_IMPERSONATION_ENABLED = System.getenv("MAPR_IMPERSONATION_ENABLED");
    private static final String OBFUSCATE_MAGIC = "OBF:";
    private static final String DEFAULT_CLUSTER_NAME;
    private static final String MAPR_CONF_DIR;
    private static final String[] TLS_PROTOCOLS;
    private static final boolean IS_CLUSTER_SECURED;
    static char[] keyStorePassphrase;
    private static volatile boolean intialized;

    private SecurityProvider() {
    }

    public static String getDefaultClusterName() {
        return DEFAULT_CLUSTER_NAME;
    }

    public static boolean isClusterSecured() {
        return IS_CLUSTER_SECURED;
    }

    public static void init(Document config) {
        if (!intialized) {
            if (IS_CLUSTER_SECURED) {
                File ticketFile = new File(JNISecurity.GetUserTicketAndKeyFileLocation());
                if (ticketFile.exists()) {
                    int errno = Security.SetTicketAndKeyFile((String)ticketFile.toString());
                    if (errno == 0) {
                        JNISecurity.UseClusterTicketAsServerTicketInternal();
                    } else {
                        log.error("SetTicketAndKeyFile returned Errno: " + errno);
                    }
                }
                if (StringUtils.isBlank((String)MAPR_IMPERSONATION_ENABLED)) {
                    log.warn("Environment variable MAPR_IMPERSONATION_ENABLED is not set. Impersonation will not be supported.");
                }
            }
            if (SecurityProvider.isSslEnabled(config)) {
                String passphrase = Configs.getString(config, "grpc.service.ssl.keystore.passphrase", null);
                if (passphrase != null) {
                    keyStorePassphrase = SecurityProvider.deobfuscate(passphrase).toCharArray();
                } else {
                    try (SslConfig sslConfig = WebSecurityManager.getSslConfig();){
                        keyStorePassphrase = sslConfig.getServerKeystorePassword();
                        log.info("Using SslConfig from WebSecurityManager.");
                    }
                }
                if (keyStorePassphrase == null && passphrase != null) {
                    keyStorePassphrase = SecurityProvider.deobfuscate(passphrase).toCharArray();
                }
                if (keyStorePassphrase == null) {
                    throw new RuntimeException("An SSL keystore passphrase is not configured!");
                }
            }
            intialized = true;
        }
    }

    public static boolean isSslEnabled(Document config) {
        String sslConfig = Configs.getString(config, "grpc.service.ssl.enabled", SSL_OPTION_CLUSTER);
        switch (sslConfig.toLowerCase()) {
            case "true": 
            case "false": {
                return Boolean.valueOf(sslConfig);
            }
            case "cluster": {
                return SecurityProvider.isClusterSecured();
            }
        }
        throw new IllegalArgumentException("Unrecognized value '" + sslConfig + "' for SSL option '" + "grpc.service.ssl.enabled" + "'. Valid values are 'cluster|true|false'.");
    }

    public static SslContext getSslContext(Document config) throws Exception {
        SslProvider sslProvider = null;
        SslContextBuilder sslContextBuilder = null;
        String sslProviderName = Configs.getString(config, "grpc.service.ssl.provider", SslProvider.OPENSSL.name());
        log.info("Creating SslContext with {} as the SSL Provider and TLS protocols {}", (Object)sslProviderName, (Object)TLS_PROTOCOLS);
        switch (sslProviderName.toLowerCase()) {
            case "jdk": {
                sslProvider = SslProvider.JDK;
                sslContextBuilder = SslContextBuilder.forServer((KeyManagerFactory)SecurityProvider.getJKSKeyManagerFactory(config));
                break;
            }
            case "openssl": {
                sslProvider = SslProvider.OPENSSL;
                sslContextBuilder = SslContextBuilder.forServer((KeyManagerFactory)SecurityProvider.getPKCS12KeyManagerFactory(config));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized SSL provider '" + sslProviderName + "'. Valid values are 'jdk|openssl'.");
            }
        }
        return GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder.sslProvider(sslProvider), (SslProvider)sslProvider).protocols(TLS_PROTOCOLS).build();
    }

    private static KeyManagerFactory getPKCS12KeyManagerFactory(Document config) throws Exception {
        return SecurityProvider.getKeyManagerFactory(config, "ssl_keystore.p12", KS_TYPE_PKCS12, ALGO_SUN_X509);
    }

    private static KeyManagerFactory getJKSKeyManagerFactory(Document config) throws Exception {
        return SecurityProvider.getKeyManagerFactory(config, "ssl_keystore", KS_TYPE_JKS, ALGO_PKIX);
    }

    private static KeyManagerFactory getKeyManagerFactory(Document config, String defaultName, String defaultKeystoreType, String defaultAlgorithm) throws Exception {
        String defaultKeyStoreFile = MAPR_CONF_DIR + "/" + defaultName;
        String keystoreFilePath = Configs.getString(config, "grpc.service.ssl.keystore", defaultKeyStoreFile);
        File keystoreFile = new File(keystoreFilePath);
        if (!keystoreFile.exists()) {
            throw new FileNotFoundException("Unable to find the keystore file: " + keystoreFile);
        }
        String keystoreType = Configs.getString(config, "grpc.service.ssl.keystore.type", defaultKeystoreType);
        String algorithm = Configs.getString(config, "grpc.service.ssl.keystore.algo", defaultAlgorithm);
        log.info("Initializing Java KeyManagerFactory with keystore '{}', type '{}', algorithm '{}'.", new Object[]{keystoreFile, keystoreType, algorithm});
        KeyStore ksKeys = KeyStore.getInstance(keystoreType);
        ksKeys.load(new FileInputStream(keystoreFile), keyStorePassphrase);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(ksKeys, keyStorePassphrase);
        return kmf;
    }

    private static String deobfuscate(String src) {
        if (src.startsWith(OBFUSCATE_MAGIC)) {
            src = src.substring(4);
            byte[] b = new byte[src.length() / 2];
            int l = 0;
            for (int i = 0; i < src.length(); i += 4) {
                int i0;
                String x;
                if (src.charAt(i) == 'U') {
                    x = src.substring(++i, i + 4);
                    i0 = Integer.parseInt(x, 36);
                    byte bx = (byte)(i0 >> 8);
                    b[l++] = bx;
                    continue;
                }
                x = src.substring(i, i + 4);
                i0 = Integer.parseInt(x, 36);
                int i1 = i0 / 256;
                int i2 = i0 % 256;
                byte bx = (byte)((i1 + i2 - 254) / 2);
                b[l++] = bx;
            }
            return new String(b, 0, l, StandardCharsets.UTF_8);
        }
        return src;
    }

    static {
        TLS_PROTOCOLS = new String[]{"TLSv1.2"};
        DEFAULT_CLUSTER_NAME = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        IS_CLUSTER_SECURED = JNISecurity.IsSecurityEnabled((String)DEFAULT_CLUSTER_NAME);
        MAPR_CONF_DIR = WebSecurityConfig.CONFIG.getMaprHome() + "/conf/";
        log.info("Default cluster: {}, secured: {}", (Object)DEFAULT_CLUSTER_NAME, (Object)IS_CLUSTER_SECURED);
        keyStorePassphrase = null;
        intialized = false;
    }
}

