/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai;

import com.google.common.base.Preconditions;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.ojai.ContainerContext;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBList;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.KeyValue;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Stack;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.Value;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.ojai.util.Decimals;

public class DBDocumentBuilder
implements DocumentBuilder {
    private DBDocumentImpl dbRecord = new DBDocumentImpl();
    private DBList curList;
    private boolean isClosed;
    private Stack<ContainerContext> ctxStack;
    private ContainerContext currentContext;

    public DBDocumentBuilder() {
        InsertContext ctx = new InsertContext();
        this.dbRecord.setRootFlags(ctx);
        this.curList = null;
        this.ctxStack = new Stack();
        this.isClosed = false;
        this.currentContext = ContainerContext.NULL;
    }

    public boolean inMap() {
        return this.currentContext.getType() == null || this.currentContext.getType() == Value.Type.MAP;
    }

    public DBDocumentBuilder put(String field, String value) {
        this.preparePut();
        this.dbRecord.insertKeyValue(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this.ctxStack.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, int value) {
        this.preparePut();
        this.dbRecord.insertKeyValue(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this.ctxStack.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, ODate value) {
        this.preparePut();
        this.dbRecord.insertKeyValue(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this.ctxStack.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, boolean value) {
        this.preparePut();
        this.dbRecord.insertKeyValue(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this.ctxStack.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, byte value) {
        this.preparePut();
        this.dbRecord.insertKeyValue(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this.ctxStack.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, short value) {
        this.preparePut();
        this.dbRecord.insertKeyValue(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this.ctxStack.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, long value) {
        this.preparePut();
        this.dbRecord.insertKeyValue(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this.ctxStack.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, float value) {
        this.preparePut();
        this.dbRecord.insertKeyValue(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this.ctxStack.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, double value) {
        this.preparePut();
        this.dbRecord.insertKeyValue(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this.ctxStack.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, BigDecimal value) {
        this.preparePut();
        this.dbRecord.insertKeyValue(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this.ctxStack.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, byte[] value) {
        this.preparePut();
        this.dbRecord.insertKeyValue(field, DBValueBuilderImpl.KeyValueBuilder.initFromArray(value), this.ctxStack.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, byte[] value, int off, int len) {
        this.preparePut();
        this.dbRecord.insertKeyValue(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(ByteBuffer.wrap(value, off, len)), this.ctxStack.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, ByteBuffer value) {
        this.preparePut();
        this.dbRecord.insertKeyValue(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this.ctxStack.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, OInterval value) {
        this.preparePut();
        this.dbRecord.insertKeyValue(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this.ctxStack.size() == 1);
        return this;
    }

    public DBDocumentBuilder putNewMap(String field) {
        this.preparePut();
        DBDocumentImpl newRecord = (DBDocumentImpl)MapRDBImpl.newDocument();
        this.dbRecord.insertKeyValue(field, newRecord, this.ctxStack.size() == 1);
        this.dbRecord = newRecord;
        this.currentContext = this.ctxStack.push(new ContainerContext(Value.Type.MAP, field, newRecord));
        return this;
    }

    public DBDocumentBuilder putNewArray(String field) {
        this.preparePut();
        this.curList = new DBList(InsertContext.OpType.NONE);
        this.currentContext = this.ctxStack.push(new ContainerContext(Value.Type.ARRAY, field, this.curList));
        return this;
    }

    public DBDocumentBuilder putNull(String field) {
        this.preparePut();
        this.dbRecord.insertKeyValue(field, new KeyValue(Value.Type.NULL), this.ctxStack.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, Value value) {
        this.preparePut();
        this.dbRecord.insertKeyValue(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this.ctxStack.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, Document value) {
        this.preparePut();
        this.dbRecord.insertKeyValue(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this.ctxStack.size() == 1);
        return this;
    }

    public DBDocumentBuilder putDecimal(String field, int unscaledValue, int scale) {
        this.preparePut();
        return this.put(field, Decimals.convertIntToDecimal((int)unscaledValue, (int)scale));
    }

    public DBDocumentBuilder putDecimal(String field, long unscaledValue, int scale) {
        this.preparePut();
        return this.put(field, Decimals.convertLongToDecimal((long)unscaledValue, (int)scale));
    }

    public DBDocumentBuilder putDecimal(String field, long decimalValue) {
        this.preparePut();
        return this.put(field, new BigDecimal(decimalValue));
    }

    public DBDocumentBuilder putDecimal(String field, double decimalValue) {
        this.preparePut();
        return this.put(field, new BigDecimal(decimalValue));
    }

    public DBDocumentBuilder putDecimal(String field, byte[] unscaledValue, int scale) {
        return this.put(field, Decimals.convertByteToBigDecimal((byte[])unscaledValue, (int)scale));
    }

    public DBDocumentBuilder put(String field, OTime value) {
        this.preparePut();
        this.dbRecord.insertKeyValue(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this.ctxStack.size() == 1);
        return this;
    }

    public DBDocumentBuilder put(String field, OTimestamp value) {
        this.preparePut();
        this.dbRecord.insertKeyValue(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value), this.ctxStack.size() == 1);
        return this;
    }

    public DBDocumentBuilder putDate(String field, int days) {
        this.preparePut();
        this.dbRecord.insertKeyValue(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(ODate.fromDaysSinceEpoch((int)days)), this.ctxStack.size() == 1);
        return this;
    }

    public DBDocumentBuilder putTime(String field, int millis) {
        if ((long)millis > 86400000L) {
            throw new IllegalArgumentException("Long value exceeds " + Long.toString(86400000L) + " " + Long.toString(millis));
        }
        return this.put(field, OTime.fromMillisOfDay((int)millis));
    }

    public DBDocumentBuilder putTimestamp(String field, long timeMillis) {
        return this.put(field, new OTimestamp(timeMillis));
    }

    public DBDocumentBuilder putInterval(String field, long durationInMs) {
        this.preparePut();
        this.dbRecord.insertKeyValue(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(new OInterval(durationInMs)), this.ctxStack.size() == 1);
        return this;
    }

    public DBDocumentBuilder putInterval(String field, int months, int days, int milliseconds) {
        this.preparePut();
        long total_milliseconds = (long)milliseconds + ((long)days + (long)months * 30L) * 86400000L;
        this.dbRecord.insertKeyValue(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(new OInterval(total_milliseconds)), this.ctxStack.size() == 1);
        return this;
    }

    private void preparePut() {
        this.checkContext(Value.Type.MAP);
    }

    private void prepareAdd() {
        this.checkContext(Value.Type.ARRAY);
        if (this.currentContext.getType() == Value.Type.ARRAY) {
            this.currentContext.incrementIndex();
        }
    }

    private void checkContext(Value.Type type) {
        if (this.isClosed) {
            throw new IllegalStateException("Writer is closed for put and add");
        }
        Preconditions.checkState((this.currentContext.getType() == type ? 1 : 0) != 0, (String)"Mismatch in writeContext. Expected %s but found %s", (Object[])new Object[]{type, this.currentContext.getType()});
    }

    private void addElementToList(KeyValue child) {
        this.prepareAdd();
        child.setOpTypeAndFlags(null, false);
        this.curList.addToDBListWithFlags(child);
    }

    public DocumentBuilder setArrayIndex(int index) {
        this.checkContext(Value.Type.ARRAY);
        int lastIndex = this.currentContext.getIndex();
        if (index <= lastIndex) {
            throw new IllegalArgumentException(String.format("Specified index %d is not larger than the last written index %d", index, lastIndex));
        }
        int nullCount = index - lastIndex;
        for (int i = 1; i < nullCount; ++i) {
            this.currentContext.incrementIndex();
            this.curList.addNullToList();
        }
        return this;
    }

    public DBDocumentBuilder add(boolean value) {
        this.addElementToList(DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(String value) {
        this.addElementToList(DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(byte value) {
        this.addElementToList(DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(short value) {
        this.addElementToList(DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(int value) {
        this.addElementToList(DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(long value) {
        this.addElementToList(DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(float value) {
        this.addElementToList(DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(double value) {
        this.addElementToList(DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(BigDecimal value) {
        this.addElementToList(DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(OTime value) {
        this.addElementToList(DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(ODate value) {
        this.addElementToList(DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(OTimestamp value) {
        this.addElementToList(DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(OInterval value) {
        this.addElementToList(DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(byte[] value) {
        this.addElementToList(DBValueBuilderImpl.KeyValueBuilder.initFrom(ByteBuffer.wrap(value)));
        return this;
    }

    public DBDocumentBuilder add(byte[] value, int off, int len) {
        this.addElementToList(DBValueBuilderImpl.KeyValueBuilder.initFrom(ByteBuffer.wrap(value, off, len)));
        return this;
    }

    public DBDocumentBuilder add(ByteBuffer value) {
        this.addElementToList(DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder addNull() {
        this.addElementToList(DBValueBuilderImpl.KeyValueBuilder.initFromNull());
        return this;
    }

    public DBDocumentBuilder add(Value value) {
        this.addElementToList(DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder add(Document value) {
        this.addElementToList(DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
        return this;
    }

    public DBDocumentBuilder addNewArray() {
        this.prepareAdd();
        this.curList = new DBList(InsertContext.OpType.NONE);
        this.currentContext = this.ctxStack.push(new ContainerContext(Value.Type.ARRAY, null, this.curList));
        return this;
    }

    public DBDocumentBuilder addNewMap() {
        if (this.currentContext.getType() == Value.Type.MAP) {
            throw new IllegalStateException("Context mismatch : addNewMap() can not be called in a Map");
        }
        if (this.currentContext.getType() != null) {
            this.prepareAdd();
            this.dbRecord = new DBDocumentImpl();
            InsertContext ctx = new InsertContext();
            this.dbRecord.setRootFlags(ctx);
        }
        this.currentContext = this.ctxStack.push(new ContainerContext(Value.Type.MAP, null, this.dbRecord));
        return this;
    }

    public DBDocumentBuilder addDecimal(long decimalValue) {
        return this.add(new BigDecimal(decimalValue));
    }

    public DBDocumentBuilder addDecimal(double decimalValue) {
        return this.add(new BigDecimal(decimalValue));
    }

    public DBDocumentBuilder addDecimal(int unscaledValue, int scale) {
        return this.add(Decimals.convertIntToDecimal((int)unscaledValue, (int)scale));
    }

    public DBDocumentBuilder addDecimal(long unscaledValue, int scale) {
        return this.add(Decimals.convertLongToDecimal((long)unscaledValue, (int)scale));
    }

    public DBDocumentBuilder addDecimal(byte[] unscaledValue, int scale) {
        return this.add(Decimals.convertByteToBigDecimal((byte[])unscaledValue, (int)scale));
    }

    public DBDocumentBuilder addDate(int days) {
        return this.add(ODate.fromDaysSinceEpoch((int)days));
    }

    public DBDocumentBuilder addTime(int millis) {
        if ((long)millis > 86400000L) {
            throw new IllegalArgumentException("Long value exceeds " + Long.toString(86400000L) + " " + Long.toString(millis));
        }
        return this.add(OTime.fromMillisOfDay((int)millis));
    }

    public DBDocumentBuilder addTimestamp(long timeMillis) {
        return this.add(new OTimestamp(timeMillis));
    }

    public DBDocumentBuilder addInterval(long durationInMs) {
        return this.add(new OInterval(durationInMs));
    }

    public DBDocumentBuilder endArray() {
        this.checkContext(Value.Type.ARRAY);
        if (this.curList == null) {
            throw new IllegalStateException("The array was not started");
        }
        ContainerContext nextStage = this.ctxStack.pop();
        this.currentContext = this.ctxStack.peek();
        if (this.currentContext.getType() == Value.Type.ARRAY) {
            DBList l = this.curList;
            this.curList = (DBList)this.currentContext.getKv();
            this.curList.addToDBListWithFlags(l);
        } else {
            this.dbRecord = (DBDocumentImpl)this.currentContext.getKv();
            this.dbRecord.insertKeyValue(nextStage.getFieldName(), this.curList, this.ctxStack.size() == 1);
        }
        return this;
    }

    public DBDocumentBuilder endMap() {
        this.preparePut();
        this.ctxStack.pop();
        if (!this.ctxStack.empty()) {
            this.currentContext = this.ctxStack.peek();
            if (this.currentContext.getType() == Value.Type.MAP) {
                this.dbRecord = (DBDocumentImpl)this.currentContext.getKv();
            } else {
                this.curList = (DBList)this.currentContext.getKv();
                this.curList.addToDBListWithFlags(this.dbRecord);
            }
        } else {
            this.isClosed = true;
        }
        return this;
    }

    public Document getDocument() {
        if (!this.isClosed) {
            throw new IllegalStateException("Record is not written completely");
        }
        return this.dbRecord;
    }

    public DBDocumentBuilder put(String field, Map<String, Object> value) {
        return this.put(field, DBValueBuilderImpl.KeyValueBuilder.initFrom(value));
    }
}

