

package org.apache.drill.exec.expr.fn.impl.gcast;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.*;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.record.RecordBatch;

/*
 * This class is generated using freemarker and the CastFunctions.java template.
 */

@SuppressWarnings("unused")
@FunctionTemplate(name = "castINT",
                  scope = FunctionTemplate.FunctionScope.SIMPLE,
                  nulls = NullHandling.NULL_IF_NULL)
public class CastFloat8Int implements DrillSimpleFunc {

  @Param Float8Holder in;
  @Output IntHolder out;

  public void setup() {}

  public void eval() {
    double fractional = in.value % 1;
    int digit = ((int) (fractional * 10));
    int carry = 0;
    if (java.lang.Math.abs(digit) > 4) {
      carry = (int) java.lang.Math.signum(digit);
    }
    out.value = (int) (in.value + carry);
  }
}

 

