

package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.ByteBuf;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import org.joda.time.MutableDateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.DateMidnight;

/*
 * This class is generated using freemarker and the DateIntervalFunctionTemplates/DateIntervalArithmeticFunctions.java template.
 */

public class DateBigIntFunctions {


    @SuppressWarnings("unused")
    @FunctionTemplate(names = {"date_add", "add"}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class DateBigIntAddFunction implements DrillSimpleFunc {
    @Param DateHolder left;
    @Param BigIntHolder right;
    @Workspace org.joda.time.MutableDateTime temp;
    @Output DateHolder out;
        public void setup() {
            temp = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
        }

        public void eval() {

    temp.setMillis(left.value);

    temp.addDays((int) right.value );

    out.value = temp.getMillis();
        }
    }

    @SuppressWarnings("unused")
    @FunctionTemplate(names = {"date_add", "add"}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class BigIntDateAddFunction implements DrillSimpleFunc {

    @Param BigIntHolder right;
    @Param DateHolder left;
    @Workspace org.joda.time.MutableDateTime temp;
    @Output DateHolder out;
        public void setup() {
            temp = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
        }

        public void eval() {


    temp.setMillis(left.value);

    temp.addDays((int) right.value );

    out.value = temp.getMillis();
        }
    }

    @SuppressWarnings("unused")
    @FunctionTemplate(names = {"date_sub", "subtract", "date_diff"}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class DateBigIntSubtractFunction implements DrillSimpleFunc {
    @Param DateHolder left;
    @Param BigIntHolder right;
    @Workspace org.joda.time.MutableDateTime temp;
    @Output DateHolder out;

        public void setup() {
            temp = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
        }

        public void eval() {

    temp.setMillis(left.value);

    temp.addDays((int) right.value  * -1 );

    out.value = temp.getMillis();
        }
    }
}

