/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mapr.db.impl.AefTransformer;
import com.mapr.db.impl.AlwaysTrueCondition;
import com.mapr.db.impl.ConditionDescriptor;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.ConditionVisitor;
import com.mapr.db.impl.CorrelationTracker;
import com.mapr.db.impl.ElementAndScreener;
import com.mapr.db.impl.FieldPathStack;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.db.impl.MapRDBIndexImplWrapper;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.proto.Dbfilters;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import com.mapr.utils.IndentingStringBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.ojai.FieldPath;
import org.ojai.annotation.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API.Internal
class ConditionBlock
extends ConditionNode {
    private static final Logger logger = LoggerFactory.getLogger(ConditionBlock.class);
    private BlockType type;
    private List<ConditionNode> children;
    private boolean closed = false;
    private FieldPath prefixPath;
    private boolean isTopEAND = false;
    private boolean nestedElemPath = false;

    ConditionBlock(BlockType type, ConditionImpl c) {
        this(type, c, null);
    }

    ConditionBlock(BlockType type, ConditionImpl c, FieldPath fieldPath) {
        super(c);
        Preconditions.checkArgument((fieldPath != null == (type == BlockType.elementAnd) ? 1 : 0) != 0, (String)"type => %s fieldPath => %s", (Object[])new Object[]{type, fieldPath});
        this.type = type;
        this.children = Lists.newArrayList();
        this.prefixPath = fieldPath;
    }

    @Override
    protected ConditionBlock clone(ConditionImpl topLevelCondition, Boolean cloneLeafCondition) {
        ConditionBlock newBlock = (ConditionBlock)super.clone();
        newBlock.setTopLevelCondition(topLevelCondition);
        newBlock.children = Lists.newArrayList();
        for (int i = 0; i < this.children.size(); ++i) {
            newBlock.children.add(this.children.get(i).clone(topLevelCondition, cloneLeafCondition));
        }
        return newBlock;
    }

    BlockType getType() {
        return this.type;
    }

    void add(ConditionNode node) {
        this.children.add(node);
    }

    @Override
    public boolean isEmpty() {
        return this.children == null || this.children.size() == 0;
    }

    @Override
    boolean isLeaf() {
        return false;
    }

    List<ConditionNode> getChildren() {
        return this.children;
    }

    @Override
    void addProjections(Set<FieldPath> proj) {
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).addProjections(proj);
        }
    }

    public String toString() {
        return this.expressionBuilder(new StringBuilder()).toString();
    }

    @Override
    StringBuilder expressionBuilder(StringBuilder sb) {
        if (this.type == BlockType.elementAnd) {
            sb.append((Object)this.type).append('(').append('\"').append(this.prefixPath).append('\"').append(',').append(' ');
        } else {
            sb.append('(');
        }
        BlockType displayType = this.type == BlockType.elementAnd ? BlockType.and : this.type;
        int nChildren = this.children.size();
        for (int i = 0; i < nChildren; ++i) {
            this.children.get(i).expressionBuilder(sb);
            if (i >= nChildren - 1) continue;
            sb.append(' ').append((Object)displayType).append(' ');
        }
        sb.append(')');
        return sb;
    }

    @Override
    StringBuilder treeBuilder(StringBuilder sb, int level) {
        int indent = 2 * level;
        ++level;
        sb.append((Object)this.type).append(" [");
        for (ConditionNode node : this.children) {
            sb.append('\n');
            ConditionBlock.indent(sb, indent);
            node.treeBuilder(sb, level);
        }
        if (this.closed) {
            sb.append('\n');
            ConditionBlock.indent(sb, indent - 2).append(']');
        }
        return sb;
    }

    @Override
    StringBuilder jsonBuilder(StringBuilder sb) {
        boolean elementAnd = this.type == BlockType.elementAnd;
        sb.append('{').append('\"').append('$').append((Object)this.type).append('\"').append(':');
        if (elementAnd) {
            sb.append('{').append('\"').append(this.prefixPath).append('\"').append(':');
        }
        sb.append('[');
        for (ConditionNode node : this.children) {
            node.jsonBuilder(sb).append(',').append(' ');
        }
        if (this.children.size() > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(']').append('}');
        if (elementAnd) {
            sb.append('}');
        }
        return sb;
    }

    static void gatherChildFamilyFieldPaths(Map<Integer, Set<FieldPath>> blockFamilyFieldPathsMap, ConditionDescriptor child) {
        Map<Integer, ? extends Set<FieldPath>> childFamilyFieldPathsMap = child.getFamilyFieldPathsMap();
        for (Map.Entry<Integer, ? extends Set<FieldPath>> childFamilyFieldPathsEntry : childFamilyFieldPathsMap.entrySet()) {
            Integer familyId = childFamilyFieldPathsEntry.getKey();
            TreeSet set = blockFamilyFieldPathsMap.get(familyId);
            if (set == null) {
                set = Sets.newTreeSet();
                blockFamilyFieldPathsMap.put(familyId, set);
            }
            set.addAll((Collection)childFamilyFieldPathsEntry.getValue());
        }
    }

    static int getFamilyIdOfPrefix(BiMap<FieldPath, Integer> pathIdMap, FieldPath prefixPath) {
        Map<Integer, FieldPath> idMap = MapRDBTableImplHelper.getOneCFQualifier(prefixPath, pathIdMap, true);
        if (idMap == null) {
            throw new IllegalStateException("Could not find column family for " + prefixPath);
        }
        if (idMap.size() != 1) {
            throw new IllegalStateException("Unexpected column family lookup for " + prefixPath + " : " + idMap);
        }
        Iterator<Map.Entry<Integer, FieldPath>> mapIter = idMap.entrySet().iterator();
        Map.Entry<Integer, FieldPath> mapEntry = mapIter.next();
        return mapEntry.getKey();
    }

    @Override
    ConditionDescriptor getDescriptor(BiMap<FieldPath, Integer> pathIdMap, MapRDBIndexImplWrapper idxWrapper) {
        Dbfilters.FilterListProto.Builder builder = Dbfilters.FilterListProto.newBuilder();
        builder.setOperator(this.type == BlockType.and ? Dbfilters.FilterListProto.OperatorProto.MUST_PASS_ALL : Dbfilters.FilterListProto.OperatorProto.MUST_PASS_ONE);
        HashMap blockFamilyFieldPathsMap = Maps.newHashMap();
        for (ConditionNode filter : this.children) {
            ConditionDescriptor child = filter.getDescriptor(pathIdMap, idxWrapper);
            if (child == null) continue;
            builder.addFilters(child.getFilterMsg());
            Map<Integer, ? extends Set<FieldPath>> childFamilyFieldPathsMap = child.getFamilyFieldPathsMap();
            for (Map.Entry<Integer, ? extends Set<FieldPath>> childFamilyFieldPathsEntry : childFamilyFieldPathsMap.entrySet()) {
                Integer familyId = childFamilyFieldPathsEntry.getKey();
                Set set = (Set)blockFamilyFieldPathsMap.get(familyId);
                if (set == null) {
                    set = Sets.newTreeSet();
                    blockFamilyFieldPathsMap.put(familyId, set);
                }
                set.addAll((Collection)childFamilyFieldPathsEntry.getValue());
            }
        }
        Dbfilters.FilterMsg filterMsg = Dbfilters.FilterMsg.newBuilder().setId("a42ebf64").setSerializedState(builder.build().toByteString()).build();
        return new ConditionDescriptor(filterMsg, blockFamilyFieldPathsMap);
    }

    @Override
    List<List<ConditionNode.RowkeyRange>> getRowkeyRanges() {
        if (this.children.size() == 0) {
            return this.getLLRR();
        }
        List<List<ConditionNode.RowkeyRange>> nodeRanges = this.children.get(0).getRowkeyRanges();
        for (int i = 1; i < this.children.size(); ++i) {
            List<List<ConditionNode.RowkeyRange>> nextNodeRanges = this.children.get(i).getRowkeyRanges();
            nodeRanges = this.mergeNodeRanges(nodeRanges, nextNodeRanges);
        }
        return nodeRanges;
    }

    ConditionBlock close() {
        this.closed = true;
        return this;
    }

    @Override
    boolean checkAndPrune(ConditionNode.OptimizationMode optimizeMode) {
        ConditionNode child = null;
        if (optimizeMode == ConditionNode.OptimizationMode.OptimizeNone) {
            return false;
        }
        if (this.type == BlockType.and) {
            Iterator<ConditionNode> itr = this.children.iterator();
            while (itr.hasNext()) {
                child = itr.next();
                if (!child.checkAndPrune(optimizeMode) && !(child instanceof AlwaysTrueCondition)) continue;
                itr.remove();
            }
        }
        if (this.children.size() == 1 && !this.children.get(0).isLeaf() && this.type != BlockType.elementAnd) {
            ConditionBlock rootBlock = (ConditionBlock)this.children.get(0);
            this.children = rootBlock.children;
            this.type = rootBlock.type;
            this.prefixPath = rootBlock.prefixPath;
        }
        return this.children.size() == 0;
    }

    private static boolean gt(byte[] left, byte[] right) {
        return Bytes.compareTo((byte[])left, (byte[])right) > 0;
    }

    private static boolean ge(byte[] left, byte[] right) {
        return Bytes.compareTo((byte[])left, (byte[])right) >= 0;
    }

    private static boolean lt(byte[] left, byte[] right) {
        return Bytes.compareTo((byte[])left, (byte[])right) < 0;
    }

    private static boolean le(byte[] left, byte[] right) {
        return Bytes.compareTo((byte[])left, (byte[])right) <= 0;
    }

    private ConditionNode.RowkeyRange getIntersection(ConditionNode.RowkeyRange a, ConditionNode.RowkeyRange b) {
        byte[] aStartRow = a.getStartRow();
        byte[] aStopRow = a.getStopRow();
        byte[] bStartRow = b.getStartRow();
        byte[] bStopRow = b.getStopRow();
        assert (aStartRow.length > 0 || aStopRow.length > 0);
        assert (bStartRow.length > 0 || bStopRow.length > 0);
        if (aStopRow.length == 0 && bStopRow.length == 0) {
            return ConditionBlock.le(aStartRow, bStartRow) ? b : a;
        }
        if (aStopRow.length == 0) {
            return ConditionBlock.le(bStopRow, aStartRow) ? null : new ConditionNode.RowkeyRange(aStartRow, bStopRow);
        }
        if (bStopRow.length == 0) {
            return ConditionBlock.le(aStopRow, bStartRow) ? null : new ConditionNode.RowkeyRange(bStartRow, aStopRow);
        }
        if (ConditionBlock.le(aStopRow, bStartRow) || ConditionBlock.le(bStopRow, aStartRow)) {
            return null;
        }
        byte[] startRow = Bytes.maxOfStartRows((byte[])aStartRow, (byte[])bStartRow);
        byte[] stopRow = Bytes.minOfStopRows((byte[])aStopRow, (byte[])bStopRow);
        return new ConditionNode.RowkeyRange(startRow, stopRow);
    }

    private List<ConditionNode.RowkeyRange> mergeAndRanges(List<ConditionNode.RowkeyRange> as, List<ConditionNode.RowkeyRange> bs) {
        if (as.size() == 0) {
            return as;
        }
        if (bs.size() == 0) {
            return bs;
        }
        if (as == FULL_TABLE_RANGE) {
            return bs;
        }
        if (bs == FULL_TABLE_RANGE) {
            return as;
        }
        ArrayList<ConditionNode.RowkeyRange> merged = new ArrayList<ConditionNode.RowkeyRange>();
        int i = 0;
        int j = 0;
        while (i < as.size() && j < bs.size()) {
            ConditionNode.RowkeyRange a = as.get(i);
            ConditionNode.RowkeyRange b = bs.get(j);
            byte[] aStopRow = a.getStopRow();
            byte[] bStopRow = b.getStopRow();
            ConditionNode.RowkeyRange range = this.getIntersection(a, b);
            if (range != null) {
                merged.add(range);
            }
            if (aStopRow.length > 0 && bStopRow.length == 0 || ConditionBlock.lt(aStopRow, bStopRow)) {
                ++i;
                continue;
            }
            if (aStopRow.length == 0 && bStopRow.length > 0 || ConditionBlock.gt(aStopRow, bStopRow)) {
                ++j;
                continue;
            }
            ++i;
            ++j;
        }
        return merged;
    }

    private List<List<ConditionNode.RowkeyRange>> mergeAndRangeLists(List<List<ConditionNode.RowkeyRange>> as, List<List<ConditionNode.RowkeyRange>> bs) {
        int nPartitionKeys = this.topLevelCondition.getPartitionKeys().size();
        int rowkeyRangeArraySize = Math.max(nPartitionKeys, 1);
        ArrayList<List<ConditionNode.RowkeyRange>> llrr = new ArrayList<List<ConditionNode.RowkeyRange>>(rowkeyRangeArraySize);
        for (int i = 0; i < rowkeyRangeArraySize; ++i) {
            llrr.add(this.mergeAndRanges(as.get(i), bs.get(i)));
        }
        return llrr;
    }

    private ConditionNode.RowkeyRange getUnionOfIntersectingRanges(ConditionNode.RowkeyRange a, ConditionNode.RowkeyRange b) {
        byte[] aStartRow = a.getStartRow();
        byte[] aStopRow = a.getStopRow();
        byte[] bStartRow = b.getStartRow();
        byte[] bStopRow = b.getStopRow();
        byte[] startRow = Bytes.minOfStartRows((byte[])aStartRow, (byte[])bStartRow);
        byte[] stopRow = Bytes.maxOfStopRows((byte[])aStopRow, (byte[])bStopRow);
        if (aStartRow.equals(startRow) && aStopRow.equals(stopRow)) {
            return a;
        }
        if (bStartRow.equals(startRow) && bStopRow.equals(stopRow)) {
            return b;
        }
        return new ConditionNode.RowkeyRange(startRow, stopRow);
    }

    private boolean areIntersectingRanges(ConditionNode.RowkeyRange left, ConditionNode.RowkeyRange right) {
        byte[] leftStop = left.getStopRow();
        byte[] rightStart = right.getStartRow();
        return leftStop.length == 0 && rightStart.length > 0 || ConditionBlock.ge(leftStop, rightStart);
    }

    private void appendToRangeList(List<ConditionNode.RowkeyRange> merged, ConditionNode.RowkeyRange nextRange) {
        ConditionNode.RowkeyRange last;
        int size = merged.size();
        ConditionNode.RowkeyRange rowkeyRange = last = size > 0 ? merged.get(size - 1) : null;
        if (last != null && this.areIntersectingRanges(last, nextRange)) {
            ConditionNode.RowkeyRange union = this.getUnionOfIntersectingRanges(last, nextRange);
            if (union != last) {
                merged.set(size - 1, union);
            }
        } else {
            merged.add(nextRange);
        }
    }

    private List<ConditionNode.RowkeyRange> mergeOrRanges(List<ConditionNode.RowkeyRange> as, List<ConditionNode.RowkeyRange> bs) {
        if (as.size() == 0) {
            return bs;
        }
        if (bs.size() == 0) {
            return as;
        }
        if (as == FULL_TABLE_RANGE) {
            return as;
        }
        if (bs == FULL_TABLE_RANGE) {
            return bs;
        }
        ArrayList<ConditionNode.RowkeyRange> merged = new ArrayList<ConditionNode.RowkeyRange>();
        int i = 0;
        int j = 0;
        while (i < as.size() || j < bs.size()) {
            if (i < as.size() && j < bs.size()) {
                ConditionNode.RowkeyRange nextRange;
                byte[] bStartRow;
                ConditionNode.RowkeyRange a = as.get(i);
                ConditionNode.RowkeyRange b = bs.get(j);
                byte[] aStartRow = a.getStartRow();
                if (ConditionBlock.lt(aStartRow, bStartRow = b.getStartRow())) {
                    nextRange = a;
                    ++i;
                } else {
                    nextRange = b;
                    ++j;
                }
                this.appendToRangeList(merged, nextRange);
                continue;
            }
            if (i == as.size()) {
                while (j < bs.size()) {
                    this.appendToRangeList(merged, bs.get(j++));
                }
            } else {
                while (i < as.size()) {
                    this.appendToRangeList(merged, as.get(i++));
                }
            }
            break;
        }
        return merged;
    }

    private List<List<ConditionNode.RowkeyRange>> mergeOrRangeLists(List<List<ConditionNode.RowkeyRange>> as, List<List<ConditionNode.RowkeyRange>> bs) {
        int nPartitionKeys = this.topLevelCondition.getPartitionKeys().size();
        int rowkeyRangeArraySize = Math.max(nPartitionKeys, 1);
        ArrayList<List<ConditionNode.RowkeyRange>> llrr = new ArrayList<List<ConditionNode.RowkeyRange>>(rowkeyRangeArraySize);
        for (int i = 0; i < rowkeyRangeArraySize; ++i) {
            llrr.add(this.mergeOrRanges(as.get(i), bs.get(i)));
        }
        return llrr;
    }

    private List<List<ConditionNode.RowkeyRange>> mergeNodeRanges(List<List<ConditionNode.RowkeyRange>> leftRanges, List<List<ConditionNode.RowkeyRange>> rightRanges) {
        List<List<ConditionNode.RowkeyRange>> llrr = this.getLLRR();
        ConditionImpl cImpl = this.topLevelCondition;
        if (!cImpl.hasRowKeyCondition() && cImpl.isSecondaryIndexQueryCondition()) {
            switch (this.type) {
                case and: 
                case elementAnd: {
                    return this.mergeAndRangeLists(leftRanges, rightRanges);
                }
                case or: {
                    return this.mergeOrRangeLists(leftRanges, rightRanges);
                }
            }
            assert (false) : (Object)((Object)this.type) + " is not handled.";
            return llrr;
        }
        llrr = new ArrayList<List<ConditionNode.RowkeyRange>>(1);
        llrr.add(FULL_TABLE_RANGE);
        byte[] startRow = MapRConstants.EMPTY_BYTE_ARRAY;
        byte[] stopRow = MapRConstants.EMPTY_BYTE_ARRAY;
        byte[] leftStartRow = leftRanges.get(0).get(0).getStartRow();
        byte[] leftStopRow = leftRanges.get(0).get(0).getStopRow();
        byte[] rightStartRow = rightRanges.get(0).get(0).getStartRow();
        byte[] rightStopRow = rightRanges.get(0).get(0).getStopRow();
        switch (this.type) {
            case and: 
            case elementAnd: {
                startRow = Bytes.maxOfStartRows((byte[])leftStartRow, (byte[])rightStartRow);
                stopRow = Bytes.minOfStopRows((byte[])leftStopRow, (byte[])rightStopRow);
                break;
            }
            case or: {
                startRow = Bytes.minOfStartRows((byte[])leftStartRow, (byte[])rightStartRow);
                stopRow = Bytes.maxOfStopRows((byte[])leftStopRow, (byte[])rightStopRow);
                break;
            }
            default: {
                throw new IllegalStateException((Object)((Object)this.type) + " is not handled.");
            }
        }
        if (startRow != MapRConstants.EMPTY_BYTE_ARRAY || stopRow != MapRConstants.EMPTY_BYTE_ARRAY) {
            llrr.set(0, (List<ConditionNode.RowkeyRange>)ImmutableList.of((Object)new ConditionNode.RowkeyRange(startRow, stopRow)));
        }
        return llrr;
    }

    @Override
    void visit(ConditionVisitor visitor) {
        int additionalArgs = 0;
        FieldPathStack fpStack = this.topLevelCondition.getFpStack();
        if (this.type == BlockType.elementAnd) {
            visitor.field(this.prefixPath, fpStack.getPath(this.prefixPath), true);
            fpStack.push(this.prefixPath);
            ++additionalArgs;
        }
        for (ConditionNode node : this.children) {
            node.visit(visitor);
        }
        if (this.type == BlockType.elementAnd) {
            fpStack.pop();
        }
        visitor.operator(this.type.getName(), this.children.size() + additionalArgs, (ConditionNode)this);
    }

    @Override
    boolean hasRowKeyCondition() {
        for (ConditionNode node : this.children) {
            if (!node.hasRowKeyCondition()) continue;
            return true;
        }
        return false;
    }

    @Override
    public AefTransformer createAefTransformer(MapRDBIndexImplWrapper idxWrapper) {
        ArrayList<AefTransformer> childTransformers;
        int nChildren;
        if (this.type == BlockType.elementAnd && this.topLevelCondition.isTopEAND[0]) {
            this.topLevelCondition.isTopEAND[0] = false;
            this.isTopEAND = true;
        }
        if ((nChildren = this.children.size()) == 0) {
            childTransformers = null;
        } else {
            childTransformers = new ArrayList<AefTransformer>(this.children.size());
            for (ConditionNode cNode : this.children) {
                AefTransformer aefTransformer = cNode.createAefTransformer(idxWrapper);
                childTransformers.add(aefTransformer);
            }
        }
        if (this.type != BlockType.elementAnd) {
            AefTransformer thisTransformer = new AefTransformer(this, this.type, childTransformers);
            return thisTransformer;
        }
        AefTransformer lastTransformer = this.expandElementPath(this.prefixPath.toString(), childTransformers, idxWrapper == null ? null : idxWrapper.indexTable);
        return lastTransformer;
    }

    private AefTransformer expandElementPath(String arrayPath, ArrayList<AefTransformer> childTransformers, MapRDBIndexImpl indexTable) {
        String remainingArrayPath;
        int firstOpen = arrayPath.indexOf(91);
        String arrayName = arrayPath.substring(0, firstOpen);
        int toRemove = firstOpen + 2;
        if (arrayPath.length() > toRemove && arrayPath.charAt(toRemove) == '.') {
            ++toRemove;
        }
        if (!(remainingArrayPath = arrayPath.substring(toRemove, arrayPath.length())).isEmpty()) {
            this.nestedElemPath = true;
        }
        if (remainingArrayPath.isEmpty()) {
            AefTransformer lastTransformer = null;
            lastTransformer = indexTable != null && this.isTopEAND && !this.nestedElemPath ? new AefTransformer(indexTable.fieldPathToCFIdQual(arrayName), Dbfilters.ArrayElementFilterProto.OpTypeProto.MUST_PASS_ALL_SAME_ELEMENT, childTransformers) : new AefTransformer(arrayName, Dbfilters.ArrayElementFilterProto.OpTypeProto.MUST_PASS_ALL_SAME_ELEMENT, childTransformers);
            return lastTransformer;
        }
        AefTransformer childTransformer = this.expandElementPath(remainingArrayPath, childTransformers, indexTable);
        AefTransformer lastTransformer = null;
        lastTransformer = indexTable != null && this.isTopEAND && !arrayName.isEmpty() ? new AefTransformer(indexTable.fieldPathToCFIdQual(arrayName), Dbfilters.ArrayElementFilterProto.OpTypeProto.MUST_PASS_ALL_SAME_ELEMENT, childTransformer) : new AefTransformer(arrayName, Dbfilters.ArrayElementFilterProto.OpTypeProto.MUST_PASS_ALL_SAME_ELEMENT, childTransformer);
        return lastTransformer;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConditionBlock other = (ConditionBlock)o;
        if (this.prefixPath == null) {
            if (other.prefixPath != null) {
                return false;
            }
        } else {
            if (other.prefixPath == null) {
                return false;
            }
            if (!this.prefixPath.equals((Object)other.prefixPath)) {
                return false;
            }
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.children == null) {
            if (other.children != null) {
                return false;
            }
        } else {
            if (other.children == null) {
                return false;
            }
            if (this.children.size() != other.children.size()) {
                return false;
            }
            HashSet<ConditionNode> otherChildren = new HashSet<ConditionNode>(other.children);
            int nFound = 0;
            block0: for (ConditionNode childNode : this.children) {
                for (ConditionNode otherChild : otherChildren) {
                    if (!childNode.equals(otherChild)) continue;
                    otherChildren.remove(otherChild);
                    ++nFound;
                    continue block0;
                }
            }
            if (nFound != this.children.size() || otherChildren.size() > 0) {
                return false;
            }
        }
        return true;
    }

    public FieldPath getPrefixPath() {
        return this.prefixPath;
    }

    @Override
    void prepare(FieldPathStack fieldPathStack, CorrelationTracker correlationTracker) {
        ConditionBlock pushedNode;
        if (this.children == null) {
            return;
        }
        if (this.prefixPath != null) {
            fieldPathStack.push(this.prefixPath);
        }
        if (this.type == BlockType.elementAnd) {
            pushedNode = this;
            this.topLevelCondition.markArrayQuery();
        } else {
            pushedNode = this.type == BlockType.or ? this : null;
        }
        correlationTracker.push(pushedNode);
        for (ConditionNode childNode : this.children) {
            childNode.prepare(fieldPathStack, correlationTracker);
        }
        correlationTracker.pop(pushedNode);
        if (this.prefixPath != null) {
            fieldPathStack.pop();
        }
    }

    @Override
    public void appendSqlArrayCondition(IndentingStringBuilder sb, String tableAlias, String fieldAlias) {
        if (this.children == null) {
            return;
        }
        sb.append('(');
        String logicalOp = this.type.getAssumedLogicalConnector();
        boolean isFirst = true;
        for (ConditionNode childNode : this.children) {
            if (!isFirst) {
                sb.append(logicalOp);
            }
            isFirst = false;
            childNode.appendSqlArrayCondition(sb, tableAlias, fieldAlias);
        }
        sb.append(')');
    }

    @Override
    public void elementAndScreen(ElementAndScreener elementAndScreener) {
        if (this.children == null || this.children.isEmpty()) {
            return;
        }
        if (this.type == BlockType.elementAnd) {
            elementAndScreener.pushElementAnd(this);
        }
        for (ConditionNode condNode : this.children) {
            condNode.elementAndScreen(elementAndScreener);
        }
        if (this.type == BlockType.elementAnd) {
            elementAndScreener.popElementAnd(this);
        }
    }

    static enum BlockType {
        and("and", Dbfilters.FilterListProto.OperatorProto.MUST_PASS_ALL, Dbfilters.ArrayElementFilterProto.OpTypeProto.MUST_PASS_ALL_ANY_ELEMENT),
        or("or", Dbfilters.FilterListProto.OperatorProto.MUST_PASS_ONE, Dbfilters.ArrayElementFilterProto.OpTypeProto.MUST_PASS_ONE),
        elementAnd("elementAnd", null, Dbfilters.ArrayElementFilterProto.OpTypeProto.MUST_PASS_ALL_SAME_ELEMENT);

        private final String name;
        private final Dbfilters.FilterListProto.OperatorProto operatorProto;
        private final Dbfilters.ArrayElementFilterProto.OpTypeProto opTypeProto;
        private final String logicalConnector;

        private BlockType(String name, Dbfilters.FilterListProto.OperatorProto operatorProto, Dbfilters.ArrayElementFilterProto.OpTypeProto opTypeProto) {
            this.name = name;
            this.operatorProto = operatorProto;
            this.opTypeProto = opTypeProto;
            this.logicalConnector = ' ' + name + ' ';
        }

        public String getName() {
            return this.name;
        }

        static BlockType fromOperatorProto(Dbfilters.FilterListProto.OperatorProto operatorProto) {
            switch (operatorProto) {
                case MUST_PASS_ONE: {
                    return or;
                }
                case MUST_PASS_ALL: {
                    return and;
                }
            }
            throw new IllegalArgumentException("unrecognized OperatorProto value " + operatorProto);
        }

        boolean isLogicalOperator() {
            return this != elementAnd;
        }

        String getAssumedLogicalConnector() {
            if (this == elementAnd) {
                return BlockType.and.logicalConnector;
            }
            return this.logicalConnector;
        }

        BlockType demoteArrayType() {
            switch (this.opTypeProto) {
                case MUST_PASS_ALL_SAME_ELEMENT: {
                    return and;
                }
            }
            throw new IllegalArgumentException("Can't demote array filter type " + this.opTypeProto);
        }

        static BlockType fromOpTypeProto(Dbfilters.ArrayElementFilterProto.OpTypeProto opTypeProto) {
            switch (opTypeProto) {
                case MUST_PASS_ALL_ANY_ELEMENT: {
                    return and;
                }
                case MUST_PASS_ONE: {
                    return or;
                }
                case MUST_PASS_ALL_SAME_ELEMENT: {
                    return elementAnd;
                }
            }
            throw new IllegalArgumentException("unrecognized OpTypeProto value" + opTypeProto);
        }

        Dbfilters.FilterListProto.OperatorProto toOperatorProto() {
            if (this.operatorProto == null) {
                throw new IllegalArgumentException("No OperatorProto for " + this.name);
            }
            return this.operatorProto;
        }

        Dbfilters.ArrayElementFilterProto.OpTypeProto toOpTypeProto() {
            return this.opTypeProto;
        }
    }
}

