/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.mapr.ojai.store.impl.OjaiQuery;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.ojai.DocumentConstants;
import org.ojai.FieldPath;

public final class QueryContext {
    private static final Pattern STAR_QUERY_PATTERN = Pattern.compile("(?i)SELECT\\s+\\*.*|SELECT\\s+\\w+\\.\\*.*");
    private String sql;
    private Map<FieldPath, Integer> fieldPathToFamilyIdMap;
    private Map<Integer, String> familyIdToFieldPathMap;
    private String clusterName;
    private Builder builder;
    private boolean isOjaiQuery = false;
    private boolean isStarQuery = false;
    private boolean excludeId = false;
    private boolean needFieldProjection;
    private Set<FieldPath> projectedFields;
    private OjaiQuery ojaiQuery;

    private QueryContext() {
        this(null);
    }

    private QueryContext(String sql) {
        this.setSql(sql);
        this.builder = new Builder();
    }

    public QueryContext setSql(String sql) {
        this.sql = sql;
        this.isStarQuery = STAR_QUERY_PATTERN.matcher(sql).matches();
        return this;
    }

    public String getSql() {
        return this.sql;
    }

    public OjaiQuery getQuery() {
        return this.ojaiQuery;
    }

    public Map<FieldPath, Integer> fieldPathToFamilyIdMap() {
        return this.fieldPathToFamilyIdMap;
    }

    public Map<Integer, String> familyIdToFieldPathMap() {
        return this.familyIdToFieldPathMap;
    }

    public static Builder newBuilder(String sql) {
        return new QueryContext((String)sql).builder;
    }

    public boolean isOjaiQuery() {
        return this.isOjaiQuery;
    }

    public boolean isStarQuery() {
        return this.isStarQuery;
    }

    public boolean excludeId() {
        return this.excludeId;
    }

    public boolean isNeedFieldProjection() {
        return this.needFieldProjection;
    }

    public Set<FieldPath> getProjectedFields() {
        return this.projectedFields;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public final class Builder {
        private boolean built = false;

        private Builder() {
            QueryContext.this.builder = this;
        }

        public QueryContext build() {
            this.built = true;
            QueryContext.this.builder = null;
            return QueryContext.this;
        }

        public Builder sql(String sql) {
            this.checkNotBuilt();
            QueryContext.this.setSql(sql);
            return this;
        }

        public Builder query(OjaiQuery ojaiQuery) {
            this.checkNotBuilt();
            QueryContext.this.ojaiQuery = ojaiQuery;
            QueryContext.this.isOjaiQuery = true;
            QueryContext.this.isStarQuery = ojaiQuery.isStarQuery();
            QueryContext.this.excludeId = !ojaiQuery.includeId();
            if (!QueryContext.this.isStarQuery() && ojaiQuery.isPossiblyNeedProjection()) {
                QueryContext.this.projectedFields = ojaiQuery.getProjectedFieldSet();
                if (QueryContext.this.projectedFields.size() == 0) {
                    QueryContext.this.projectedFields.add(FieldPath.parseFrom((String)"*"));
                }
                QueryContext.this.projectedFields.add(DocumentConstants.ID_FIELD);
                if (ojaiQuery.hasProjectionWithArrayIndex()) {
                    QueryContext.this.needFieldProjection = true;
                } else {
                    Set<FieldPath> sortFields;
                    Set conditionFields;
                    if (ojaiQuery.hasCondition() && !(conditionFields = ojaiQuery.getCondition().getProjections()).isEmpty()) {
                        conditionFields.removeAll(QueryContext.this.projectedFields);
                        if (!conditionFields.isEmpty()) {
                            QueryContext.this.needFieldProjection = true;
                        }
                    }
                    if (!QueryContext.this.needFieldProjection && ojaiQuery.hasOrderBy() && !(sortFields = ojaiQuery.getOrderByFields()).isEmpty()) {
                        sortFields.removeAll(QueryContext.this.projectedFields);
                        if (!sortFields.isEmpty()) {
                            QueryContext.this.needFieldProjection = true;
                        }
                    }
                }
            }
            return this;
        }

        public Builder fieldPathToFamilyIdMap(Map<FieldPath, Integer> fieldPathToFamilyIdMap) {
            this.checkNotBuilt();
            QueryContext.this.fieldPathToFamilyIdMap = fieldPathToFamilyIdMap;
            return this;
        }

        public Builder familyIdToFieldPathMap(Map<Integer, String> familyIdToFieldPathMap) {
            this.checkNotBuilt();
            QueryContext.this.familyIdToFieldPathMap = familyIdToFieldPathMap;
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.checkNotBuilt();
            QueryContext.this.clusterName = clusterName;
            return this;
        }

        private void checkNotBuilt() {
            Preconditions.checkState((!this.built ? 1 : 0) != 0, (Object)"The QueryContext has already been built.");
        }
    }
}

