/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway.auth;

import com.mapr.data.gateway.auth.Authentication;

public class UserInfo
implements Authentication {
    private final String userName;
    private final boolean authenticated;
    private final Object credentials;
    private final String token;

    private UserInfo(String userName, boolean authenticated, Object credentials, String token) {
        this.userName = userName;
        this.authenticated = authenticated;
        this.credentials = credentials;
        this.token = token;
    }

    @Override
    public String getName() {
        return this.userName;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public Object getCredentials() {
        return this.credentials;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public static class Builder {
        private String userName;
        private boolean authenticated;
        private Object credentials;
        private String token;

        Builder() {
        }

        public Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder authenticated(boolean authenticated) {
            this.authenticated = authenticated;
            return this;
        }

        public Builder credentials(Object credentials) {
            this.credentials = credentials;
            return this;
        }

        public Builder token(String token) {
            this.token = token;
            return this;
        }

        public UserInfo build() {
            return new UserInfo(this.userName, this.authenticated, this.credentials, this.token);
        }

        public String toString() {
            return "UserInfo.Builder(userName=" + this.userName + ", authenticated=" + this.authenticated + ", credentials=" + this.credentials + ", token=" + this.token + ")";
        }
    }
}

