


/*
 * This class is automatically generated from AggrTypeFunctions1.tdd using FreeMarker.
 */

package org.apache.drill.exec.expr.fn.impl.gaggr;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;

import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.base.Charsets;
import com.google.common.collect.ObjectArrays;

import com.google.common.base.Preconditions;
import io.netty.buffer.*;

import org.apache.commons.lang3.ArrayUtils;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.expr.fn.impl.StringFunctionUtil;
import org.apache.drill.exec.memory.*;
import org.apache.drill.exec.proto.SchemaDefProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserBitShared.DrillPBError;
import org.apache.drill.exec.proto.UserBitShared.SerializedField;
import org.apache.drill.exec.record.*;
import org.apache.drill.exec.vector.*;
import org.apache.drill.common.exceptions.*;
import org.apache.drill.exec.exception.*;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.types.TypeProtos.*;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.vector.complex.*;
import org.apache.drill.exec.vector.complex.reader.*;
import org.apache.drill.exec.vector.complex.impl.*;
import org.apache.drill.exec.vector.complex.writer.*;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.MapWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.ListWriter;
import org.apache.drill.exec.util.JsonStringArrayList;

import org.apache.drill.exec.exception.OutOfMemoryException;

import com.sun.codemodel.JType;
import com.sun.codemodel.JCodeModel;

import javax.inject.Inject;

import java.util.Arrays;
import java.util.Random;
import java.util.List;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.math.BigDecimal;
import java.math.BigInteger;

import org.joda.time.DateTime;
import org.joda.time.Period;

import org.apache.drill.exec.util.Text;

import org.apache.drill.exec.vector.accessor.sql.TimePrintMillis;
import javax.inject.Inject;






import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.record.RecordBatch;
import io.netty.buffer.ByteBuf;

/*
 * This class is generated using freemarker and the Decimal/DecimalAggrTypeFunctions2.java template.
 */

@SuppressWarnings("unused")

public class DecimalAvgFunctions {

@FunctionTemplate(name = "avg",
                  scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE,
                  returnType = FunctionTemplate.ReturnType.DECIMAL_AVG_AGGREGATE)
public static class VarDecimalAvg implements DrillAggFunc {

  @Param VarDecimalHolder in;
  @Inject DrillBuf buffer;
  @Workspace ObjectHolder value;
  @Workspace BigIntHolder count;
  @Workspace IntHolder outputScale;
  @Output NullableVarDecimalHolder out;

  public void setup() {
    value = new ObjectHolder();
    value.obj = java.math.BigDecimal.ZERO;
    count = new BigIntHolder();
    count.value = 0;
    outputScale = new IntHolder();
    outputScale.value = Integer.MIN_VALUE;
  }

  @Override
  public void add() {
    count.value++;
    java.math.BigDecimal currentValue = org.apache.drill.exec.util.DecimalUtility
        .getBigDecimalFromDrillBuf(in.buffer, in.start, in.end - in.start, in.scale);
    value.obj = ((java.math.BigDecimal)(value.obj)).add(currentValue);
    if (outputScale.value == Integer.MIN_VALUE) {
      outputScale.value = in.scale;
    }
  }

  @Override
  public void output() {
    if (count.value > 0) {
      out.isSet = 1;
      out.start  = 0;
      out.scale = Math.max(outputScale.value, 6);
      java.math.BigDecimal average = ((java.math.BigDecimal) value.obj)
            .divide(java.math.BigDecimal.valueOf(count.value), out.scale, java.math.BigDecimal.ROUND_HALF_UP);
      out.precision = org.apache.drill.exec.planner.types.DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision();
      byte[] bytes = average.unscaledValue().toByteArray();
      int len = bytes.length;
      out.buffer = buffer.reallocIfNeeded(len);
      out.buffer.setBytes(0, bytes);
      out.end = len;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    value = new ObjectHolder();
    value.obj = java.math.BigDecimal.ZERO;
    count = new BigIntHolder();
    count.value = 0;
    outputScale = new IntHolder();
    outputScale.value = Integer.MIN_VALUE;
  }
}


@FunctionTemplate(name = "avg",
                  scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE,
                  returnType = FunctionTemplate.ReturnType.DECIMAL_AVG_AGGREGATE)
public static class NullableVarDecimalAvg implements DrillAggFunc {

  @Param NullableVarDecimalHolder in;
  @Inject DrillBuf buffer;
  @Workspace ObjectHolder value;
  @Workspace BigIntHolder count;
  @Workspace IntHolder outputScale;
  @Output NullableVarDecimalHolder out;

  public void setup() {
    value = new ObjectHolder();
    value.obj = java.math.BigDecimal.ZERO;
    count = new BigIntHolder();
    count.value = 0;
    outputScale = new IntHolder();
    outputScale.value = Integer.MIN_VALUE;
  }

  @Override
  public void add() {
	  sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    count.value++;
    java.math.BigDecimal currentValue = org.apache.drill.exec.util.DecimalUtility
        .getBigDecimalFromDrillBuf(in.buffer, in.start, in.end - in.start, in.scale);
    value.obj = ((java.math.BigDecimal)(value.obj)).add(currentValue);
    if (outputScale.value == Integer.MIN_VALUE) {
      outputScale.value = in.scale;
    }
    } // end of sout block
  }

  @Override
  public void output() {
    if (count.value > 0) {
      out.isSet = 1;
      out.start  = 0;
      out.scale = Math.max(outputScale.value, 6);
      java.math.BigDecimal average = ((java.math.BigDecimal) value.obj)
            .divide(java.math.BigDecimal.valueOf(count.value), out.scale, java.math.BigDecimal.ROUND_HALF_UP);
      out.precision = org.apache.drill.exec.planner.types.DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision();
      byte[] bytes = average.unscaledValue().toByteArray();
      int len = bytes.length;
      out.buffer = buffer.reallocIfNeeded(len);
      out.buffer.setBytes(0, bytes);
      out.end = len;
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    value = new ObjectHolder();
    value.obj = java.math.BigDecimal.ZERO;
    count = new BigIntHolder();
    count.value = 0;
    outputScale = new IntHolder();
    outputScale.value = Integer.MIN_VALUE;
  }
}

}

