/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;

public final class ProxyParameters {
    public final InetSocketAddress proxyAddress;
    @Nullable
    public final String username;
    @Nullable
    public final String password;

    public ProxyParameters(InetSocketAddress proxyAddress, @Nullable String username, @Nullable String password) {
        Preconditions.checkNotNull((Object)proxyAddress);
        Preconditions.checkState((!proxyAddress.isUnresolved() ? 1 : 0) != 0);
        this.proxyAddress = proxyAddress;
        this.username = username;
        this.password = password;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ProxyParameters)) {
            return false;
        }
        ProxyParameters that = (ProxyParameters)o;
        return Objects.equal((Object)this.proxyAddress, (Object)that.proxyAddress) && Objects.equal((Object)this.username, (Object)that.username) && Objects.equal((Object)this.password, (Object)that.password);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.proxyAddress, this.username, this.password});
    }
}

