/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.authentication.server.CookieSignatureSecretFactory;
import org.apache.hadoop.security.authentication.util.RandomSignerSecretProvider;
import org.apache.hadoop.security.authentication.util.SignerSecretProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Unstable
@InterfaceAudience.Private
public class MapRSignerSecretProvider
extends SignerSecretProvider {
    private static Logger LOG = LoggerFactory.getLogger(MapRSignerSecretProvider.class);
    private byte[] secret;
    private byte[][] secrets;

    @Override
    public void init(Properties config, ServletContext servletContext, long tokenValidity) throws Exception {
        String signatureSecret = config.getProperty("signature.secret", "com.mapr.security.maprauth.MaprSignatureSecretFactory");
        Class<?> signatureFactoryClass = Thread.currentThread().getContextClassLoader().loadClass(signatureSecret);
        Object signatureFactory = signatureFactoryClass.newInstance();
        if (!(signatureFactory instanceof CookieSignatureSecretFactory)) {
            throw new ServletException("The cookie signature secret factory class should implement " + CookieSignatureSecretFactory.class.getName() + " interface");
        }
        signatureSecret = ((CookieSignatureSecretFactory)signatureFactory).getSignatureSecret();
        if (signatureSecret == null) {
            LOG.info("Fall back to random secret");
            this.initUsingRandomSecret(config, servletContext, tokenValidity);
        } else {
            this.secret = signatureSecret.getBytes();
            this.secrets = new byte[][]{this.secret};
        }
    }

    private void initUsingRandomSecret(Properties config, ServletContext ctx, long validity) throws Exception {
        RandomSignerSecretProvider provider = new RandomSignerSecretProvider();
        ((SignerSecretProvider)provider).init(config, ctx, validity);
        this.secret = ((SignerSecretProvider)provider).getCurrentSecret();
        this.secrets = ((SignerSecretProvider)provider).getAllSecrets();
    }

    @Override
    public byte[] getCurrentSecret() {
        return this.secret;
    }

    @Override
    public byte[][] getAllSecrets() {
        return this.secrets;
    }
}

