/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.scanner;

import com.google.common.collect.Lists;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.scanner.BuildTimeScan;
import org.apache.drill.common.scanner.ClassPathScanner;
import org.apache.drill.common.scanner.persistence.ScanResult;

public class RunTimeScan {
    private static final ScanResult PRESCANNED = BuildTimeScan.load();
    private static final Collection<URL> NON_PRESCANNED_MARKED_PATHS = RunTimeScan.getNonPrescannedMarkedPaths();

    static Collection<URL> getNonPrescannedMarkedPaths() {
        Set<URL> markedPaths = ClassPathScanner.getMarkedPaths();
        markedPaths.removeAll(BuildTimeScan.getPrescannedPaths());
        return markedPaths;
    }

    public static ScanResult fromPrescan(DrillConfig config) {
        List<String> packagePrefixes = ClassPathScanner.getPackagePrefixes(config);
        List<String> scannedBaseClasses = ClassPathScanner.getScannedBaseClasses(config);
        List<String> scannedAnnotations = ClassPathScanner.getScannedAnnotations(config);
        if (ClassPathScanner.isScanBuildTimeCacheEnabled(config)) {
            ScanResult runtimeScan = ClassPathScanner.scan(NON_PRESCANNED_MARKED_PATHS, packagePrefixes, scannedBaseClasses, scannedAnnotations, PRESCANNED);
            return runtimeScan.merge(PRESCANNED);
        }
        return ClassPathScanner.scan(ClassPathScanner.getMarkedPaths(), packagePrefixes, scannedBaseClasses, scannedAnnotations, ClassPathScanner.emptyResult());
    }

    public static ScanResult dynamicPackageScan(DrillConfig config, Set<URL> markedPath) {
        List<String> packagePrefixes = ClassPathScanner.getPackagePrefixes(config);
        return ClassPathScanner.scan(markedPath, packagePrefixes, Lists.newArrayList(), PRESCANNED.getScannedAnnotations(), ClassPathScanner.emptyResult());
    }
}

