/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.mapr.db.MetaTable;
import com.mapr.db.Table;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.exceptions.TableClosedException;
import com.mapr.db.exceptions.TableExistsException;
import com.mapr.db.exceptions.TableNotFoundException;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.scan.ScanRange;
import com.mapr.db.scan.ScanStats;
import com.mapr.fs.proto.Dbserver;
import com.mapr.ojai.store.impl.DedupStream;
import com.mapr.ojai.store.impl.DocumentStreamFactory;
import com.mapr.ojai.store.impl.DrillNotInClasspathException;
import com.mapr.ojai.store.impl.EligibleIndex;
import com.mapr.ojai.store.impl.EmptyQueryStream;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.IdDocumentStream;
import com.mapr.ojai.store.impl.IdIndexDesc;
import com.mapr.ojai.store.impl.MaterializedDocumentStream;
import com.mapr.ojai.store.impl.NaryOperator;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiOptions;
import com.mapr.ojai.store.impl.OjaiQuery;
import com.mapr.ojai.store.impl.QueryAnalyzer;
import com.mapr.ojai.store.impl.QueryContext;
import com.mapr.ojai.store.impl.QueryParser;
import com.mapr.ojai.store.impl.RowkeyLookup;
import com.mapr.ojai.store.impl.SharedReleaser;
import com.mapr.ojai.store.impl.SharedResource;
import com.mapr.ojai.store.impl.SharedTable;
import com.mapr.ojai.store.impl.UnionDocumentStream;
import com.mapr.ojai.store.impl.bean.DrillConnectionParams;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.exceptions.OjaiException;
import org.ojai.store.DocumentMutation;
import org.ojai.store.DocumentStore;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.QueryResult;
import org.ojai.store.exceptions.MultiOpException;
import org.ojai.store.exceptions.StoreException;
import org.ojai.store.exceptions.StoreExistsException;
import org.ojai.store.exceptions.StoreNotFoundException;
import org.ojai.util.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API.NotThreadSafe
public class OjaiDocumentStore
implements DocumentStore {
    private static final Logger logger = LoggerFactory.getLogger(OjaiDocumentStore.class);
    private static final String TABLET_LIMIT_NAME = "ojai.mapr.query.tablet-scan-limit";
    private static final String TABLET_LIMIT_DEFAULT = "4";
    private static final int TABLET_LIMIT = Integer.parseInt(System.getProperty("ojai.mapr.query.tablet-scan-limit", "4"));
    private static final String HASHED_TABLET_LIMIT_NAME = "ojai.mapr.query.hashed-tablet-scan-limit";
    private static final String HASHED_TABLET_LIMIT_DEFAULT = "32";
    private static final int HASHED_TABLET_LIMIT = Integer.parseInt(System.getProperty("ojai.mapr.query.hashed-tablet-scan-limit", "32"));
    private static final String INDEX_SELECTIVITY_MAX_NAME = "ojai.mapr.query.index-selectivity-max";
    private static final String INDEX_SELECTIVITY_MAX_DEFAULT = "0.25";
    private static final double INDEX_SELECTIVITY_MAX = Double.parseDouble(System.getProperty("ojai.mapr.query.index-selectivity-max", "0.25"));
    private final OjaiConnection ojaiConnection;
    private final String tableName;
    private final Path tablePath;
    private final OjaiOptions options;
    private final String clusterName;
    private String engineName;
    private boolean isClosed = false;
    private static final ObjectMapper objectMapper = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    private SharedTable sharedTable;
    private static final FieldPath[] SELECT_ROWKEY = new FieldPath[]{DocumentConstants.ID_FIELD};

    public OjaiDocumentStore(OjaiConnection ojaiConnection, String tableName, Document options) {
        this.ojaiConnection = ojaiConnection;
        this.tableName = tableName;
        this.options = new OjaiOptions(options);
        this.tablePath = new Path(tableName);
        try {
            this.clusterName = ojaiConnection.getFileSystem().getClusterName(this.tablePath.toUri());
        }
        catch (IOException e) {
            throw ExceptionHandler.handle((IOException)e, (String)"OjaiDocumentStore.<init>()");
        }
        this.getTable();
    }

    @VisibleForTesting
    public BaseJsonTable getTable() {
        if (this.isClosed) {
            throw new TableClosedException();
        }
        if (this.sharedTable == null) {
            try {
                BaseJsonTable jsonTable = (BaseJsonTable)MapRDBImpl.getTable((String)this.tableName).setOption(Table.TableOption.BUFFERWRITE, this.options.getBoolean("ojai.mapr.documentstore.buffer-writes", false));
                this.sharedTable = new SharedTable(jsonTable);
                logger.debug("getTable " + this.tableName + " fid " + jsonTable.getFidStr());
            }
            catch (TableNotFoundException e) {
                throw new StoreNotFoundException(this.tableName, (Throwable)e);
            }
        }
        return (BaseJsonTable)this.sharedTable.get();
    }

    public static String queryPlanToString(List<Map<String, Object>> queryPlan) {
        try {
            String queryPlanJson = objectMapper.writeValueAsString(queryPlan);
            return queryPlanJson;
        }
        catch (IOException ioe) {
            throw new StoreException((Throwable)ioe);
        }
    }

    public static void logQueryPlan(DocumentStream ds) {
        if (!logger.isTraceEnabled()) {
            return;
        }
        if (!(ds instanceof OjaiQueryProperties)) {
            logger.trace("OjaiQueryProperties is not implemented in '{}',", (Object)ds.getClass().getSimpleName());
            return;
        }
        ArrayList<Map<String, Object>> planList = new ArrayList<Map<String, Object>>();
        ((OjaiQueryProperties)ds).getQueryPlan(planList);
        String queryPlanJson = OjaiDocumentStore.queryPlanToString(planList);
        logger.trace("Ojai Query Plan: '{}'", (Object)queryPlanJson);
    }

    static SharedReleaser<BaseJsonTable> getSharedIndex(IndexDesc indexDesc, SharedTable sharedPrimaryTable) {
        SharedReleaser<BaseJsonTable> sharedReleaser;
        if (IdIndexDesc.isIdIndex(indexDesc)) {
            sharedPrimaryTable.addRef();
            sharedReleaser = new SharedReleaser<BaseJsonTable>(sharedPrimaryTable);
        } else {
            BaseJsonTable indexTable = (BaseJsonTable)MapRDBImpl.getIndexTable((IndexDesc)indexDesc);
            logger.debug("getSharedIndex " + indexDesc.getIndexName() + " fid " + indexDesc.getIndexFid() + " table " + indexDesc.getPrimaryTablePath());
            SharedTable sharedIndex = new SharedTable(indexTable);
            sharedReleaser = new SharedReleaser<BaseJsonTable>(sharedIndex);
        }
        return sharedReleaser;
    }

    private String getEngineName() {
        if (this.engineName == null) {
            DrillConnectionParams connectParam = this.ojaiConnection.getQueryServiceParam(this.clusterName);
            if (!connectParam.isEnabled()) {
                throw new DBException("MapR-DB Query Service is not enabled for cluster: " + this.clusterName);
            }
            this.engineName = connectParam.getStoragePlugin();
        }
        return this.engineName;
    }

    public boolean checkAndDelete(String _id, QueryCondition condition) throws StoreException {
        return this.applyTableFunction(this.getTable(), table -> table.checkAndDelete(_id, condition));
    }

    public boolean checkAndDelete(Value _id, QueryCondition condition) throws StoreException {
        return this.applyTableFunction(this.getTable(), table -> table.checkAndDelete(_id, condition));
    }

    public boolean checkAndMutate(String _id, QueryCondition condition, DocumentMutation mutation) throws StoreException {
        return this.applyTableFunction(this.getTable(), table -> table.checkAndMutate(_id, condition, mutation));
    }

    public boolean checkAndMutate(Value _id, QueryCondition condition, DocumentMutation mutation) throws StoreException {
        return this.applyTableFunction(this.getTable(), table -> table.checkAndMutate(_id, condition, mutation));
    }

    public boolean checkAndReplace(String _id, QueryCondition condition, Document document) throws StoreException {
        return this.applyTableFunction(this.getTable(), table -> table.checkAndReplace(_id, condition, document));
    }

    public boolean checkAndReplace(Value _id, QueryCondition condition, Document document) throws StoreException {
        return this.applyTableFunction(this.getTable(), table -> table.checkAndReplace(_id, condition, document));
    }

    public void close() throws StoreException {
        if (this.isClosed) {
            return;
        }
        if (this.sharedTable != null) {
            this.sharedTable.release();
            this.sharedTable = null;
            this.isClosed = true;
        }
    }

    public void delete(String _id) throws StoreException {
        this.applyTableFunctionVoid(table -> table.delete(_id));
    }

    public void delete(Value _id) throws StoreException {
        this.applyTableFunctionVoid(table -> table.delete(_id));
    }

    public void delete(Document document) throws StoreException {
        this.applyTableFunctionVoid(table -> table.delete(document));
    }

    public void delete(DocumentStream stream) throws MultiOpException {
        this.applyTableFunctionVoid(table -> table.delete(stream));
    }

    public void delete(Document document, FieldPath fieldPath) throws StoreException {
        this.applyTableFunctionVoid(table -> table.delete(document, fieldPath));
    }

    public void delete(Document document, String fieldAsKey) throws StoreException {
        this.applyTableFunctionVoid(table -> table.delete(document, fieldAsKey));
    }

    public void delete(DocumentStream stream, FieldPath fieldPath) throws MultiOpException {
        this.applyTableFunctionVoid(table -> table.delete(stream, fieldPath));
    }

    public void delete(DocumentStream stream, String fieldAsKey) throws MultiOpException {
        this.applyTableFunctionVoid(table -> table.delete(stream, fieldAsKey));
    }

    public DocumentStream find() throws StoreException {
        OjaiQuery query = new OjaiQuery().build();
        return this.findQuery(query);
    }

    public DocumentStream find(String ... paths) throws StoreException {
        OjaiQuery query = new OjaiQuery().select(paths).build();
        return this.findQuery(query);
    }

    public DocumentStream find(FieldPath ... fieldPaths) throws StoreException {
        OjaiQuery query = new OjaiQuery().select(fieldPaths).build();
        return this.findQuery(query);
    }

    public DocumentStream findQuery(String jsonQuery) throws StoreException {
        QueryParser queryParser = new QueryParser();
        return this.findQuery(queryParser.parseQuery(jsonQuery));
    }

    private static EligibleIndex getBestIndex(OjaiQuery ojaiQuery, List<EligibleIndex> eligibleIndexes) {
        int n;
        String indexHint;
        if (logger.isDebugEnabled()) {
            for (EligibleIndex eligibleIndex : eligibleIndexes) {
                logger.debug("getBestIndex() eligibleIndexes:");
                logger.debug(eligibleIndex.toString());
            }
        }
        if ((indexHint = ojaiQuery.getIndexHint()) != null) {
            for (EligibleIndex eligibleIndex : eligibleIndexes) {
                if (!indexHint.equals(eligibleIndex.indexDesc.getIndexName())) continue;
                logger.debug("getBestIndex() => using hinted index " + indexHint);
                logger.debug("Hinted EligibleIndex picked:");
                logger.debug(eligibleIndex.toString());
                return eligibleIndex;
            }
            logger.debug("getBestIndex() => hinted index " + indexHint + " not found");
        }
        if ((n = eligibleIndexes.size()) == 0) {
            return null;
        }
        PriorityQueue<EligibleIndex> heap = new PriorityQueue<EligibleIndex>(n, EligibleIndex.COST_COMPARATOR);
        for (EligibleIndex eligibleIndex : eligibleIndexes) {
            if (!eligibleIndex.isCovering && !(eligibleIndex.rowSelectivity <= INDEX_SELECTIVITY_MAX) && !eligibleIndex.canBeUsedForSort) continue;
            heap.add(eligibleIndex);
        }
        EligibleIndex bestIndex = heap.peek();
        return bestIndex;
    }

    private static QueryCondition getCompleteScanCondition(QueryCondition userCond, ScanRange scanRange) {
        QueryCondition rangeCondition = scanRange.getCondition();
        if (userCond == null || userCond.isEmpty()) {
            return rangeCondition;
        }
        if (rangeCondition.isEmpty()) {
            return userCond;
        }
        ConditionImpl scanCondition = MapRDBImpl.newCondition().and().condition(scanRange.getCondition(), Boolean.valueOf(false)).condition(userCond, Boolean.valueOf(false)).close().build();
        scanCondition.setUseIdxFieldTill(((ConditionImpl)userCond).getUseIdxFieldTill());
        return scanCondition;
    }

    private static FieldPath[] addExtraFields(FieldPath[] selectFieldPaths, List<FieldPath> extras) {
        int arraySize = 0;
        if (extras == null) {
            return selectFieldPaths;
        }
        arraySize += extras.size();
        if (selectFieldPaths != null) {
            arraySize += selectFieldPaths.length;
        }
        if (arraySize == 0) {
            return null;
        }
        FieldPath[] fieldPaths = new FieldPath[arraySize];
        int destPosition = 0;
        if (selectFieldPaths != null) {
            System.arraycopy(selectFieldPaths, 0, fieldPaths, 0, selectFieldPaths.length);
            destPosition = selectFieldPaths.length;
        }
        if (extras != null) {
            for (FieldPath extra : extras) {
                fieldPaths[destPosition++] = extra;
            }
        }
        return fieldPaths;
    }

    private static QueryResult createDocumentStream(final SharedResource<BaseJsonTable> sharedTable, final FieldPath[] fieldPaths, final QueryCondition cond) {
        List scanRanges;
        final BaseJsonTable table = sharedTable.get();
        try (MetaTable metaTable = table.getMetaTable();){
            scanRanges = cond == null ? metaTable.getScanRanges() : metaTable.getScanRanges(cond);
        }
        catch (IOException ex) {
            throw new OjaiException((Throwable)ex);
        }
        int nRanges = scanRanges.size();
        if (nRanges == 0) {
            return new EmptyQueryStream();
        }
        if (nRanges == 1) {
            QueryCondition scanCondition = OjaiDocumentStore.getCompleteScanCondition(cond, (ScanRange)scanRanges.get(0));
            QueryResult docStream = fieldPaths == null ? (QueryResult)table.find(scanCondition) : (QueryResult)table.find(scanCondition, fieldPaths);
            return docStream;
        }
        sharedTable.addRef();
        final String indexUsed = table instanceof MapRDBIndexImpl ? ((MapRDBIndexImpl)table).getIndexName() : table.getName();
        final Iterator rangeIter = scanRanges.iterator();
        return new UnionDocumentStream(new DocumentStreamFactory(){

            @Override
            public DocumentStream create() {
                if (!rangeIter.hasNext()) {
                    return null;
                }
                ScanRange scanRange = (ScanRange)rangeIter.next();
                QueryCondition scanCondition = OjaiDocumentStore.getCompleteScanCondition(cond, scanRange);
                DocumentStream docStream = fieldPaths == null ? table.find(scanCondition) : table.find(scanCondition, fieldPaths);
                return docStream;
            }

            @Override
            public Iterator<OjaiQueryProperties> iterator() {
                return new Iterator<OjaiQueryProperties>(){
                    private final Iterator<? extends ScanRange> ri;
                    {
                        this.ri = scanRanges.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.ri.hasNext();
                    }

                    @Override
                    public OjaiQueryProperties next() {
                        ScanRange scanRange = this.ri.next();
                        return new ScanRangeProperties((Table)table, scanRange);
                    }
                };
            }
        }){

            @Override
            protected void closeDerived() {
                sharedTable.release();
                super.closeDerived();
            }

            @Override
            public String getIndexUsed() {
                return indexUsed;
            }
        };
    }

    private static QueryResult createEmptyStream(FieldPath[] fieldPaths) {
        MaterializedDocumentStream emptyStream = new MaterializedDocumentStream(null, OjaiQueryProperties.QueryPath.DIRECT, null, fieldPaths);
        return emptyStream;
    }

    private int getTabletLimit(BaseJsonTable table) {
        Dbserver.SIndexInfo indexInfo;
        if (table.isIndex() && (indexInfo = this.applyTableFunction(table, table1 -> table1.getIndexInfo())).getHashed()) {
            return HASHED_TABLET_LIMIT;
        }
        return TABLET_LIMIT;
    }

    public QueryResult find(Query query) throws StoreException {
        return (QueryResult)this.findQuery(query);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DocumentStream findQuery(Query userQuery) throws StoreException {
        Set<Expression> otherPredicates;
        Preconditions.checkNotNull((Object)userQuery, (Object)"Query must be non-null");
        Preconditions.checkArgument((boolean)userQuery.isBuilt(), (Object)"Query is not built");
        Preconditions.checkArgument((boolean)(userQuery instanceof OjaiQuery), (Object)"Query argument is not a MapR OJAI query");
        String jsonQuery = userQuery.asJsonString();
        Query query = new QueryParser().parseQuery(jsonQuery);
        OjaiQuery ojaiQuery = (OjaiQuery)query;
        OjaiQuery userOjaiQuery = (OjaiQuery)userQuery;
        ojaiQuery.setCommitContext(userOjaiQuery.getCommitContext());
        boolean isQueryServiceEnabled = this.ojaiConnection.getQueryServiceParam(this.clusterName).isEnabled();
        BaseJsonTable table = this.getTable();
        QueryAnalyzer queryAnalyzer = ojaiQuery.getQueryAnalyzer();
        FieldPath[] fieldPaths = ojaiQuery.getSelectListAsArray();
        if (queryAnalyzer.isAlwaysFalse()) {
            return OjaiDocumentStore.createEmptyStream(fieldPaths);
        }
        Map<FieldPath, List<NaryOperator>> topRelations = queryAnalyzer.getTopRelations();
        if (topRelations.get(DocumentConstants.ID_FIELD) != null && (otherPredicates = queryAnalyzer.getOtherPredicates()).size() == 0) {
            boolean sortOnId;
            if (queryAnalyzer.isIdEquals()) {
                Value id = queryAnalyzer.getIdForLookup();
                if (id != null) return this._findById(id, ojaiQuery.includeId(), fieldPaths);
                return OjaiDocumentStore.createEmptyStream(fieldPaths);
            }
            Set<FieldPath> sortFields = ojaiQuery.getOrderByFields();
            int nSortFields = sortFields.size();
            boolean hasSort = nSortFields > 0;
            boolean bl = sortOnId = nSortFields == 1 && sortFields.contains(DocumentConstants.ID_FIELD);
            if (ojaiQuery.isIdIn() && (!hasSort || sortOnId)) {
                OjaiDocumentStore.setIdReturn(table, ojaiQuery.includeId());
                IdDocumentStream idDocStream = new IdDocumentStream(this.ojaiConnection, queryAnalyzer.getFieldInBundle(), ojaiQuery.getFieldOrdering(DocumentConstants.ID_FIELD));
                RowkeyLookup rowkeyLookup = new RowkeyLookup((DocumentStream)idDocStream, this.sharedTable, null, fieldPaths);
                OjaiDocumentStore.logQueryPlan((DocumentStream)rowkeyLookup);
                return rowkeyLookup;
            }
        }
        ConditionImpl queryCondition = ojaiQuery.getCondition();
        if (queryAnalyzer.canUseOneIndex() && !ojaiQuery.getForceDrill()) {
            List<EligibleIndex> eligibleIndexes;
            try {
                eligibleIndexes = ojaiQuery.getEligibleIndexes(this.ojaiConnection.getAdmin(), this.tablePath, this.sharedTable, this.ojaiConnection);
            }
            catch (IOException ioe) {
                throw new StoreException((Throwable)ioe);
            }
            EligibleIndex bestIndex22 = OjaiDocumentStore.getBestIndex(ojaiQuery, eligibleIndexes);
            if (bestIndex22 != null) {
                IndexDesc indexDesc = bestIndex22.indexDesc;
                try (SharedReleaser<BaseJsonTable> autoReleasedIndex = OjaiDocumentStore.getSharedIndex(indexDesc, this.sharedTable);){
                    SharedResource<BaseJsonTable> sharedIndex = autoReleasedIndex.getSharedResource();
                    if (bestIndex22.isCovering) {
                        OjaiDocumentStore.setIdReturn(sharedIndex.get(), ojaiQuery.includeId());
                        QueryResult docStream = OjaiDocumentStore.createDocumentStream(sharedIndex, OjaiDocumentStore.addExtraFields(fieldPaths, bestIndex22.sortLimitExtras), bestIndex22.prunedCondition);
                        if (bestIndex22.isArrayIndex) {
                            docStream = new DedupStream((DocumentStream)docStream);
                        }
                        QueryResult queryResult2 = ojaiQuery.decorateStream(docStream, this.ojaiConnection, bestIndex22.canBeUsedForSort, bestIndex22.sortLimitExtras, sharedIndex);
                        return queryResult2;
                    }
                    if (!ojaiQuery.getForceNonCoveringSort() || ojaiQuery.isSortLimit()) {
                        OjaiDocumentStore.setIdReturn(sharedIndex.get(), ojaiQuery.includeId());
                        QueryResult indexStream = OjaiDocumentStore.createDocumentStream(sharedIndex, SELECT_ROWKEY, bestIndex22.prunedCondition);
                        OjaiDocumentStore.setIdReturn(table, ojaiQuery.includeId());
                        if (bestIndex22.isArrayIndex) {
                            indexStream = new DedupStream((DocumentStream)indexStream);
                        }
                        RowkeyLookup rowkeyLookup = new RowkeyLookup((DocumentStream)indexStream, this.sharedTable, (QueryCondition)queryCondition, OjaiDocumentStore.addExtraFields(fieldPaths, bestIndex22.sortLimitExtras));
                        QueryResult queryResult3 = ojaiQuery.decorateStream(rowkeyLookup, this.ojaiConnection, bestIndex22.canBeUsedForSort, bestIndex22.sortLimitExtras, this.sharedTable);
                        return queryResult3;
                    }
                }
            }
        }
        if (ojaiQuery.getForceDirect() || !ojaiQuery.getForceDrill() && (ojaiQuery.isSortLimit() || !ojaiQuery.hasOrderBy())) {
            try (MetaTable primaryMetaTable = this.applyTableFunction(table, table1 -> table1.getMetaTable());){
                ScanStats scanStats = primaryMetaTable.getScanStats((QueryCondition)queryCondition);
                int nTablets = scanStats.getTabletCount();
                int tabletLimit = this.getTabletLimit(table);
                if (!isQueryServiceEnabled || nTablets <= tabletLimit) {
                    OjaiDocumentStore.setIdReturn((BaseJsonTable)this.sharedTable.get(), ojaiQuery.includeId());
                    List<FieldPath> sortLimitExtras = ojaiQuery.getSortLimitExtras();
                    QueryResult docStream = OjaiDocumentStore.createDocumentStream(this.sharedTable, OjaiDocumentStore.addExtraFields(fieldPaths, sortLimitExtras), (QueryCondition)queryCondition);
                    QueryResult queryResult = ojaiQuery.decorateStream(docStream, this.ojaiConnection, ojaiQuery.isSortOnId(), sortLimitExtras, this.sharedTable);
                    return queryResult;
                }
            }
            catch (IOException ex) {
                throw new StoreException((Throwable)ex);
            }
        }
        try {
            String sql = ojaiQuery.buildSqlString(this.getEngineName(), this.tableName);
            QueryContext queryContext = QueryContext.newBuilder(sql).clusterName(this.clusterName).familyIdToFieldPathMap(table.idToCFNameMap()).fieldPathToFamilyIdMap(table.sortedByPath()).query(ojaiQuery).build();
            QueryResult drillStream = ojaiQuery.createDrillStream(this.ojaiConnection, this.sharedTable, queryContext);
            OjaiDocumentStore.logQueryPlan((DocumentStream)drillStream);
            return drillStream;
        }
        catch (NoClassDefFoundError e) {
            throw new DrillNotInClasspathException(e);
        }
    }

    private static BaseJsonTable setIdReturn(BaseJsonTable table, boolean includeId) {
        return table.setOption(Table.TableOption.EXCLUDEID, !includeId);
    }

    private QueryResult _findById(Value idValue, boolean includeId, FieldPath ... fieldPath) {
        BaseJsonTable table = this.getTable();
        OjaiDocumentStore.setIdReturn(table, includeId);
        Document doc = fieldPath == null || fieldPath.length == 0 ? this.applyTableFunction(table, table1 -> table1.findById(idValue)) : this.applyTableFunction(table, table1 -> table1.findById(idValue, fieldPath));
        MaterializedDocumentStream mds = new MaterializedDocumentStream(doc, OjaiQueryProperties.QueryPath.DIRECT, table.getName(), new FieldPath[0]);
        OjaiDocumentStore.logQueryPlan((DocumentStream)mds);
        return mds;
    }

    public DocumentStream find(QueryCondition condition) throws StoreException {
        OjaiQuery ojaiQuery = new OjaiQuery().where(condition).build();
        return this.findQuery(ojaiQuery);
    }

    public DocumentStream find(QueryCondition condition, String ... field) throws StoreException {
        OjaiQuery ojaiQuery = new OjaiQuery().select(field).where(condition).build();
        return this.findQuery(ojaiQuery);
    }

    public DocumentStream find(QueryCondition condition, FieldPath ... fieldPath) throws StoreException {
        OjaiQuery ojaiQuery = new OjaiQuery().select(fieldPath).where(condition).build();
        return this.findQuery(ojaiQuery);
    }

    public void flush() throws StoreException {
        this.applyTableFunctionVoid(table -> table.flush());
    }

    public void increment(String _id, String field, byte inc) throws StoreException {
        this.applyTableFunctionVoid(table -> table.increment(_id, field, inc));
    }

    public void increment(String _id, String field, short inc) throws StoreException {
        this.applyTableFunctionVoid(table -> table.increment(_id, field, inc));
    }

    public void increment(String _id, String field, int inc) throws StoreException {
        this.applyTableFunctionVoid(table -> table.increment(_id, field, inc));
    }

    public void increment(String _id, String field, long inc) throws StoreException {
        this.applyTableFunctionVoid(table -> table.increment(_id, field, inc));
    }

    public void increment(String _id, String field, float inc) throws StoreException {
        this.applyTableFunctionVoid(table -> table.increment(_id, field, inc));
    }

    public void increment(String _id, String field, double inc) throws StoreException {
        this.applyTableFunctionVoid(table -> table.increment(_id, field, inc));
    }

    public void increment(String _id, String field, BigDecimal inc) throws StoreException {
        this.applyTableFunctionVoid(table -> table.increment(_id, field, inc));
    }

    public void increment(Value value, String field, byte v) throws StoreException {
        this.applyTableFunctionVoid(table -> table.increment(value, field, v));
    }

    public void increment(Value value, String field, short v) throws StoreException {
        this.applyTableFunctionVoid(table -> table.increment(value, field, v));
    }

    public void increment(Value value, String field, int v) throws StoreException {
        this.applyTableFunctionVoid(table -> table.increment(value, field, v));
    }

    public void increment(Value value, String field, long v) throws StoreException {
        this.applyTableFunctionVoid(table -> table.increment(value, field, v));
    }

    public void increment(Value value, String field, float v) throws StoreException {
        this.applyTableFunctionVoid(table -> table.increment(value, field, v));
    }

    public void increment(Value value, String field, double v) throws StoreException {
        this.applyTableFunctionVoid(table -> table.increment(value, field, v));
    }

    public void increment(Value value, String field, BigDecimal v) throws StoreException {
        this.applyTableFunctionVoid(table -> table.increment(value, field, v));
    }

    public void insert(Document document) throws StoreException {
        this.applyTableFunctionVoid(table -> table.insert(document));
    }

    public void insert(DocumentStream stream) throws MultiOpException {
        this.applyTableFunctionVoid(table -> table.insert(stream));
    }

    public void insert(String _id, Document document) throws StoreException {
        this.applyTableFunctionVoid(table -> table.insert(_id, document));
    }

    public void insert(Value value, Document document) throws StoreException {
        this.applyTableFunctionVoid(table -> table.insert(value, document));
    }

    public void insert(Document document, FieldPath fieldPath) throws StoreException {
        this.applyTableFunctionVoid(table -> table.insert(document, fieldPath));
    }

    public void insert(Document document, String fieldAsKey) throws StoreException {
        this.applyTableFunctionVoid(table -> table.insert(document, fieldAsKey));
    }

    public void insert(DocumentStream stream, FieldPath fieldPath) throws MultiOpException {
        this.applyTableFunctionVoid(table -> table.insert(stream, fieldPath));
    }

    public void insert(DocumentStream stream, String fieldAsKey) throws MultiOpException {
        this.applyTableFunctionVoid(table -> table.insert(stream, fieldAsKey));
    }

    public void insertOrReplace(Document document) throws StoreException {
        this.applyTableFunctionVoid(table -> table.insertOrReplace(document));
    }

    public void insertOrReplace(DocumentStream stream) throws MultiOpException {
        this.applyTableFunctionVoid(table -> table.insertOrReplace(stream));
    }

    public void insertOrReplace(String _id, Document document) throws StoreException {
        this.applyTableFunctionVoid(table -> table.insertOrReplace(_id, document));
    }

    public void insertOrReplace(Value _id, Document document) throws StoreException {
        this.applyTableFunctionVoid(table -> table.insertOrReplace(_id, document));
    }

    public void insertOrReplace(Document document, FieldPath fieldPath) throws StoreException {
        this.applyTableFunctionVoid(table -> table.insertOrReplace(document, fieldPath));
    }

    public void insertOrReplace(Document document, String fieldAsKey) throws StoreException {
        this.applyTableFunctionVoid(table -> table.insertOrReplace(document, fieldAsKey));
    }

    public void insertOrReplace(DocumentStream stream, FieldPath fieldPath) throws MultiOpException {
        this.applyTableFunctionVoid(table -> table.insertOrReplace(stream, fieldPath));
    }

    public void insertOrReplace(DocumentStream stream, String fieldAsKey) throws MultiOpException {
        this.applyTableFunctionVoid(table -> table.insertOrReplace(stream, fieldAsKey));
    }

    public boolean isReadOnly() {
        return this.applyTableFunction(this.getTable(), table -> table.isReadOnly());
    }

    public void replace(Document document) throws StoreException {
        this.applyTableFunctionVoid(table -> table.replace(document));
    }

    public void replace(DocumentStream stream) throws MultiOpException {
        this.applyTableFunctionVoid(table -> table.replace(stream));
    }

    public void replace(String _id, Document document) throws StoreException {
        this.applyTableFunctionVoid(table -> table.replace(_id, document));
    }

    public void replace(Value value, Document document) throws StoreException {
        this.applyTableFunctionVoid(table -> table.replace(value, document));
    }

    public void replace(Document document, FieldPath fieldPath) throws StoreException {
        this.applyTableFunctionVoid(table -> table.replace(document, fieldPath));
    }

    public void replace(Document document, String fieldAsKey) throws StoreException {
        this.applyTableFunctionVoid(table -> table.replace(document, fieldAsKey));
    }

    public void replace(DocumentStream stream, FieldPath fieldPath) throws MultiOpException {
        this.applyTableFunctionVoid(table -> table.replace(stream, fieldPath));
    }

    public void replace(DocumentStream stream, String fieldAsKey) throws MultiOpException {
        this.applyTableFunctionVoid(table -> table.replace(stream, fieldAsKey));
    }

    public void update(String _id, DocumentMutation mutation) throws StoreException {
        this.applyTableFunctionVoid(table -> table.update(_id, mutation));
    }

    public void update(Value value, DocumentMutation mutation) throws StoreException {
        this.applyTableFunctionVoid(table -> table.update(value, mutation));
    }

    public String endTrackingWrites() throws StoreException {
        return this.applyTableFunction(this.getTable(), table -> table.endTrackingWrites());
    }

    public void beginTrackingWrites() throws StoreException {
        this.applyTableFunctionVoid(table -> table.beginTrackingWrites());
    }

    public void beginTrackingWrites(String previousWritesContext) throws StoreException, IllegalArgumentException, IllegalStateException {
        Preconditions.checkNotNull((Object)previousWritesContext);
        this.applyTableFunctionVoid(table -> table.beginTrackingWrites(previousWritesContext));
    }

    public void clearTrackedWrites() throws StoreException {
        this.applyTableFunctionVoid(table -> table.clearTrackedWrites());
    }

    public OjaiOptions getStoreOptions() {
        return this.options;
    }

    public Document findById(String _id) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        return this.applyTableFunction(OjaiDocumentStore.setIdReturn(this.getTable(), true), table -> table.findById(_id));
    }

    public Document findById(Value _id) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        return this.applyTableFunction(OjaiDocumentStore.setIdReturn(this.getTable(), true), table -> table.findById(_id));
    }

    private static boolean hasId(FieldPath[] fieldPaths) {
        if (fieldPaths == null) {
            return true;
        }
        for (FieldPath fieldPath : fieldPaths) {
            if (!fieldPath.equals((Object)DocumentConstants.ID_FIELD)) continue;
            return true;
        }
        return false;
    }

    public Document findById(String _id, FieldPath ... fieldPaths) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        return this.applyTableFunction(OjaiDocumentStore.setIdReturn(this.getTable(), OjaiDocumentStore.hasId(fieldPaths)), table -> table.findById(_id, fieldPaths));
    }

    public Document findById(String _id, String ... fieldPaths) throws StoreException {
        return this.findById(_id, Fields.toFieldPathArray((String[])fieldPaths));
    }

    public Document findById(Value _id, String ... fieldPaths) throws StoreException {
        return this.findById(_id, Fields.toFieldPathArray((String[])fieldPaths));
    }

    public Document findById(Value _id, FieldPath ... fieldPaths) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        return this.applyTableFunction(OjaiDocumentStore.setIdReturn(this.getTable(), OjaiDocumentStore.hasId(fieldPaths)), table -> table.findById(_id, fieldPaths));
    }

    public Document findById(String _id, QueryCondition condition) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        if (condition != null) {
            Preconditions.checkArgument((boolean)condition.isBuilt(), (Object)"QueryCondition is not built");
        }
        return this.applyTableFunction(OjaiDocumentStore.setIdReturn(this.getTable(), true), table -> table.findById(_id, condition));
    }

    public Document findById(Value _id, QueryCondition condition) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        if (condition != null) {
            Preconditions.checkArgument((boolean)condition.isBuilt(), (Object)"QueryCondition is not built");
        }
        return this.applyTableFunction(OjaiDocumentStore.setIdReturn(this.getTable(), true), table -> table.findById(_id, condition));
    }

    public Document findById(String _id, QueryCondition condition, String ... fieldPaths) throws StoreException {
        return this.findById(_id, condition, Fields.toFieldPathArray((String[])fieldPaths));
    }

    public Document findById(String _id, QueryCondition condition, FieldPath ... fieldPaths) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        if (condition != null) {
            Preconditions.checkArgument((boolean)condition.isBuilt(), (Object)"QueryCondition is not built");
        }
        return this.applyTableFunction(OjaiDocumentStore.setIdReturn(this.getTable(), OjaiDocumentStore.hasId(fieldPaths)), table -> table.findById(_id, condition, fieldPaths));
    }

    public Document findById(Value _id, QueryCondition condition, String ... fieldPaths) throws StoreException {
        return this.findById(_id, condition, Fields.toFieldPathArray((String[])fieldPaths));
    }

    public Document findById(Value _id, QueryCondition condition, FieldPath ... fieldPaths) throws StoreException {
        Preconditions.checkNotNull((Object)_id);
        if (condition != null) {
            Preconditions.checkArgument((boolean)condition.isBuilt(), (Object)"QueryCondition is not built");
        }
        return this.applyTableFunction(OjaiDocumentStore.setIdReturn(this.getTable(), OjaiDocumentStore.hasId(fieldPaths)), table -> table.findById(_id, condition, fieldPaths));
    }

    private <T> T applyTableFunction(BaseJsonTable table, TableOperation<T> function) {
        try {
            return function.apply(table);
        }
        catch (TableNotFoundException e) {
            throw new StoreNotFoundException(this.tableName, (Throwable)e);
        }
        catch (TableExistsException e) {
            throw new StoreExistsException(this.tableName, (Throwable)e);
        }
    }

    private void applyTableFunctionVoid(TableOperationVoid function) {
        try {
            BaseJsonTable table = this.getTable();
            function.apply(table);
        }
        catch (TableNotFoundException e) {
            throw new StoreNotFoundException(this.tableName, (Throwable)e);
        }
        catch (TableExistsException e) {
            throw new StoreExistsException(this.tableName, (Throwable)e);
        }
    }

    @FunctionalInterface
    static interface TableOperationVoid {
        public void apply(BaseJsonTable var1);
    }

    @FunctionalInterface
    static interface TableOperation<T> {
        public T apply(BaseJsonTable var1);
    }

    private static class ScanRangeProperties
    implements OjaiQueryProperties {
        private final String indexUsed;
        private final ScanRange scanRange;

        public ScanRangeProperties(Table table, ScanRange scanRange) {
            BaseJsonTable baseTable = (BaseJsonTable)table;
            this.indexUsed = baseTable.isIndex() ? baseTable.getIndexInfo().getIndexName() : baseTable.getName();
            this.scanRange = scanRange;
        }

        public OjaiQueryProperties.QueryPath getQueryPath() {
            return OjaiQueryProperties.QueryPath.DIRECT;
        }

        public String getIndexUsed() {
            return this.indexUsed;
        }

        public void getQueryPlan(List<Map<String, Object>> planList) {
            HashMap queryPlan = new HashMap();
            planList.add(queryPlan);
            HashMap<String, Object> scan = new HashMap<String, Object>();
            queryPlan.put("ScanRange", scan);
            scan.put("cond", this.scanRange.getCondition());
            scan.put("locations", this.scanRange.getLocations());
        }
    }
}

