/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.annotations.VisibleForTesting;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.db.indexrowkeyfmt.IndexRowKeyEncoder;
import com.mapr.ojai.store.impl.AbstractDocumentFilter;
import com.mapr.ojai.store.impl.ByteArrayKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.Value;
import org.ojai.exceptions.OjaiException;

public class DedupStream
extends AbstractDocumentFilter {
    private static final String MAX_QUERY_DEDUP_LIMIT_NAME = "ojai.mapr.query.dedup-limit";
    private static final String MAX_QUERY_DEDUP_LIMIT_DEFAULT = "20000";
    @VisibleForTesting
    public static final int MAX_QUERY_DEDUP_LIMIT = Integer.parseInt(System.getProperty("ojai.mapr.query.dedup-limit", "20000"));
    private final HashSet<ByteArrayKey> idsSeen = new HashSet();
    private boolean hitSizeLimit;
    private static final boolean[] ENCODER_DESC_ORDERING = new boolean[]{false};
    private static final byte[] ZERO_KEY = new byte[]{0};

    public DedupStream(DocumentStream upstreamStream) {
        super(upstreamStream);
    }

    private static ByteArrayKey getIdAsKey(Document doc) {
        Value idValue = doc.getId();
        IndexRowKeyEncoder keyEncoder = new IndexRowKeyEncoder();
        keyEncoder.init(0, ENCODER_DESC_ORDERING);
        keyEncoder.setPrimaryKey(ZERO_KEY);
        keyEncoder.setComponent(0, idValue);
        byte[] encodedKey = new byte[keyEncoder.getEstimatedEncodingSize()];
        int encodedKeySize = keyEncoder.getRowKey(encodedKey);
        if (encodedKeySize < encodedKey.length) {
            encodedKey = Arrays.copyOfRange(encodedKey, 0, encodedKeySize);
        }
        return new ByteArrayKey(encodedKey, false);
    }

    @Override
    public Iterator<Document> iterator() {
        this.checkState();
        return new DedupIterator(super.iterator());
    }

    public void getQueryPlan(List<Map<String, Object>> planList) {
        if (this.upstreamStream == null) {
            return;
        }
        ((OjaiQueryProperties)this.upstreamStream).getQueryPlan(planList);
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", this.getClass().getSimpleName());
        HashMap valueMap = new HashMap();
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }

    private class DedupIterator
    implements Iterator<Document> {
        private final Iterator<Document> docIterator;
        private Document nextDocument;

        public DedupIterator(Iterator<Document> docIterator) {
            this.docIterator = docIterator;
        }

        @Override
        public boolean hasNext() {
            Document doc;
            ByteArrayKey idKey;
            if (DedupStream.this.hitSizeLimit) {
                throw new IllegalStateException("Can't continue iteration after dedup limit exceeded");
            }
            if (this.nextDocument != null) {
                return true;
            }
            do {
                if (!this.docIterator.hasNext()) {
                    return false;
                }
                doc = this.docIterator.next();
                idKey = DedupStream.getIdAsKey(doc);
            } while (DedupStream.this.idsSeen.contains(idKey));
            if (DedupStream.this.idsSeen.size() >= MAX_QUERY_DEDUP_LIMIT) {
                DedupStream.this.hitSizeLimit = true;
                throw new OjaiException("Result set size exceeds in-memory deduplication limit (" + MAX_QUERY_DEDUP_LIMIT + ")");
            }
            this.nextDocument = doc;
            DedupStream.this.idsSeen.add(idKey);
            return true;
        }

        @Override
        public Document next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Document returnDocument = this.nextDocument;
            this.nextDocument = null;
            return returnDocument;
        }
    }
}

