/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai.impl;

import com.google.common.collect.Maps;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.ojai.DBValueBuilder;
import com.mapr.db.ojai.impl.ForwardingDocumentStore;
import com.mapr.db.ojai.impl.SimulatedDocumentStore;
import com.mapr.db.ojai.impl.SimulatedMapRDriver;
import java.util.Map;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.exceptions.DecodingException;
import org.ojai.exceptions.OjaiException;
import org.ojai.store.Connection;
import org.ojai.store.DocumentMutation;
import org.ojai.store.DocumentStore;
import org.ojai.store.Driver;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.ValueBuilder;
import org.ojai.store.exceptions.StoreExistsException;
import org.ojai.store.exceptions.StoreNotFoundException;

public class SimulatedConnection
implements Connection {
    private final Map<String, DocumentStore> storeMap = Maps.newConcurrentMap();
    private final Document config;
    private boolean closed;
    private final Driver driver;

    public SimulatedConnection(SimulatedMapRDriver driver, Document config) {
        this.driver = driver;
        this.config = config;
        this.closed = false;
    }

    public ValueBuilder getValueBuilder() {
        return DBValueBuilder.INSTANCE;
    }

    public Document newDocument() {
        return MapRDBImpl.newDocument();
    }

    public Document newDocument(String jsonString) throws DecodingException {
        return MapRDBImpl.newDocument((String)jsonString);
    }

    public Document newDocument(Map<String, Object> map) throws DecodingException {
        return MapRDBImpl.newDocument(map);
    }

    public Document newDocument(Object bean) throws DecodingException {
        return MapRDBImpl.newDocument((Object)bean);
    }

    public DocumentBuilder newDocumentBuilder() {
        return MapRDBImpl.newDocumentBuilder();
    }

    public DocumentMutation newMutation() {
        return MapRDBImpl.newMutation();
    }

    public QueryCondition newCondition() {
        return MapRDBImpl.newCondition();
    }

    public Query newQuery() {
        throw new UnsupportedOperationException();
    }

    public Query newQuery(String queryJson) {
        throw new UnsupportedOperationException();
    }

    public Driver getDriver() {
        return this.driver;
    }

    public void close() {
        this.closed = true;
    }

    public DocumentStore createStore(String storeName) throws OjaiException {
        return this.createStore(storeName, this.config);
    }

    public DocumentStore createStore(String storeName, Document options) throws OjaiException {
        DocumentStore store = this.storeMap.putIfAbsent(storeName, new SimulatedDocumentStore(this, options));
        if (store != null) {
            throw new StoreExistsException(storeName);
        }
        return this.getStore(storeName, options);
    }

    public boolean deleteStore(String storeName) throws OjaiException {
        return this.storeMap.remove(storeName) != null;
    }

    public boolean storeExists(String storeName) throws OjaiException {
        return this.storeMap.containsKey(storeName);
    }

    public DocumentStore getStore(String storeName) throws OjaiException {
        return this.getStore(storeName, null);
    }

    public DocumentStore getStore(String storeName, Document options) throws OjaiException {
        DocumentStore store = this.storeMap.get(storeName);
        if (store == null) {
            throw new StoreNotFoundException(storeName);
        }
        return new ForwardingDocumentStore(store, options);
    }
}

