/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.persistence.FileHeader;
import org.apache.zookeeper.server.persistence.SnapShot;
import org.apache.zookeeper.server.persistence.Util;
import org.apache.zookeeper.server.util.SerializeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSnap
implements SnapShot {
    File snapDir;
    private volatile boolean close = false;
    private static final int VERSION = 2;
    private static final long dbId = -1L;
    private static final Logger LOG = LoggerFactory.getLogger(FileSnap.class);
    public static final int SNAP_MAGIC = ByteBuffer.wrap("ZKSN".getBytes()).getInt();

    public FileSnap(File snapDir) {
        this.snapDir = snapDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long deserialize(DataTree dt, Map<Long, Integer> sessions) throws IOException {
        List<File> snapList = this.findNValidSnapshots(100);
        if (snapList.size() == 0) {
            return -1L;
        }
        File snap = null;
        boolean foundValid = false;
        for (int i = 0; i < snapList.size(); ++i) {
            FilterInputStream crcIn;
            block11: {
                Object var15_11;
                snap = snapList.get(i);
                InputStream snapIS = null;
                crcIn = null;
                try {
                    try {
                        LOG.info("Reading snapshot " + snap);
                        snapIS = new BufferedInputStream(new FileInputStream(snap));
                        crcIn = new CheckedInputStream(snapIS, new Adler32());
                        BinaryInputArchive ia = BinaryInputArchive.getArchive(crcIn);
                        this.deserialize(dt, sessions, ia);
                        long checkSum = ((CheckedInputStream)crcIn).getChecksum().getValue();
                        long val = ia.readLong("val");
                        if (val != checkSum) {
                            throw new IOException("CRC corruption in snapshot :  " + snap);
                        }
                        foundValid = true;
                        var15_11 = null;
                        if (snapIS == null) break block11;
                    }
                    catch (IOException e) {
                        LOG.warn("problem reading snap file " + snap, (Throwable)e);
                        var15_11 = null;
                        if (snapIS != null) {
                            snapIS.close();
                        }
                        if (crcIn == null) continue;
                        crcIn.close();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var15_11 = null;
                    if (snapIS != null) {
                        snapIS.close();
                    }
                    if (crcIn != null) {
                        crcIn.close();
                    }
                    throw throwable;
                }
                snapIS.close();
            }
            if (crcIn == null) break;
            crcIn.close();
            break;
        }
        if (!foundValid) {
            throw new IOException("Not able to find valid snapshots in " + this.snapDir);
        }
        dt.lastProcessedZxid = Util.getZxidFromName(snap.getName(), "snapshot");
        return dt.lastProcessedZxid;
    }

    public void deserialize(DataTree dt, Map<Long, Integer> sessions, InputArchive ia) throws IOException {
        FileHeader header = new FileHeader();
        header.deserialize(ia, "fileheader");
        if (header.getMagic() != SNAP_MAGIC) {
            throw new IOException("mismatching magic headers " + header.getMagic() + " !=  " + SNAP_MAGIC);
        }
        SerializeUtils.deserializeSnapshot(dt, ia, sessions);
    }

    @Override
    public File findMostRecentSnapshot() throws IOException {
        List<File> files = this.findNValidSnapshots(1);
        if (files.size() == 0) {
            return null;
        }
        return files.get(0);
    }

    private List<File> findNValidSnapshots(int n) throws IOException {
        List<File> files = Util.sortDataDir(this.snapDir.listFiles(), "snapshot", false);
        int count = 0;
        ArrayList<File> list = new ArrayList<File>();
        for (File f : files) {
            try {
                if (!Util.isValidSnapshot(f)) continue;
                list.add(f);
                if (++count != n) continue;
                break;
            }
            catch (IOException e) {
                LOG.info("invalid snapshot " + f, (Throwable)e);
            }
        }
        return list;
    }

    public List<File> findNRecentSnapshots(int n) throws IOException {
        List<File> files = Util.sortDataDir(this.snapDir.listFiles(), "snapshot", false);
        int count = 0;
        ArrayList<File> list = new ArrayList<File>();
        for (File f : files) {
            if (count == n) break;
            if (Util.getZxidFromName(f.getName(), "snapshot") == -1L) continue;
            ++count;
            list.add(f);
        }
        return list;
    }

    protected void serialize(DataTree dt, Map<Long, Integer> sessions, OutputArchive oa, FileHeader header) throws IOException {
        if (header == null) {
            throw new IllegalStateException("Snapshot's not open for writing: uninitialized header");
        }
        header.serialize(oa, "fileheader");
        SerializeUtils.serializeSnapshot(dt, oa, sessions);
    }

    @Override
    public synchronized void serialize(DataTree dt, Map<Long, Integer> sessions, File snapShot) throws IOException {
        if (!this.close) {
            BufferedOutputStream sessOS = new BufferedOutputStream(new FileOutputStream(snapShot));
            CheckedOutputStream crcOut = new CheckedOutputStream(sessOS, new Adler32());
            BinaryOutputArchive oa = BinaryOutputArchive.getArchive(crcOut);
            FileHeader header = new FileHeader(SNAP_MAGIC, 2, -1L);
            this.serialize(dt, sessions, oa, header);
            long val = crcOut.getChecksum().getValue();
            oa.writeLong(val, "val");
            oa.writeString("/", "path");
            ((OutputStream)sessOS).flush();
            crcOut.close();
            ((OutputStream)sessOS).close();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.close = true;
    }
}

