/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.server.PurgeTxnLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatadirCleanupManager {
    private static final Logger LOG = LoggerFactory.getLogger(DatadirCleanupManager.class);
    private PurgeTaskStatus purgeTaskStatus = PurgeTaskStatus.NOT_STARTED;
    private final String snapDir;
    private final String dataLogDir;
    private final int snapRetainCount;
    private final int purgeInterval;
    private Timer timer;

    public DatadirCleanupManager(String snapDir, String dataLogDir, int snapRetainCount, int purgeInterval) {
        this.snapDir = snapDir;
        this.dataLogDir = dataLogDir;
        this.snapRetainCount = snapRetainCount;
        this.purgeInterval = purgeInterval;
        LOG.info("autopurge.snapRetainCount set to " + snapRetainCount);
        LOG.info("autopurge.purgeInterval set to " + purgeInterval);
    }

    public void start() {
        if (PurgeTaskStatus.STARTED == this.purgeTaskStatus) {
            LOG.warn("Purge task is already running.");
            return;
        }
        if (this.purgeInterval <= 0) {
            LOG.info("Purge task is not scheduled.");
            return;
        }
        this.timer = new Timer("PurgeTask", true);
        PurgeTask task = new PurgeTask(this.dataLogDir, this.snapDir, this.snapRetainCount);
        this.timer.scheduleAtFixedRate((TimerTask)task, 0L, TimeUnit.HOURS.toMillis(this.purgeInterval));
        this.purgeTaskStatus = PurgeTaskStatus.STARTED;
    }

    public void shutdown() {
        if (PurgeTaskStatus.STARTED == this.purgeTaskStatus) {
            LOG.info("Shutting down purge task.");
            this.timer.cancel();
            this.purgeTaskStatus = PurgeTaskStatus.COMPLETED;
        } else {
            LOG.warn("Purge task not started. Ignoring shutdown!");
        }
    }

    public PurgeTaskStatus getPurgeTaskStatus() {
        return this.purgeTaskStatus;
    }

    public String getSnapDir() {
        return this.snapDir;
    }

    public String getDataLogDir() {
        return this.dataLogDir;
    }

    public int getPurgeInterval() {
        return this.purgeInterval;
    }

    public int getSnapRetainCount() {
        return this.snapRetainCount;
    }

    static class PurgeTask
    extends TimerTask {
        private String logsDir;
        private String snapsDir;
        private int snapRetainCount;

        public PurgeTask(String dataDir, String snapDir, int count) {
            this.logsDir = dataDir;
            this.snapsDir = snapDir;
            this.snapRetainCount = count;
        }

        public void run() {
            LOG.info("Purge task started.");
            try {
                PurgeTxnLog.purge(new File(this.logsDir), new File(this.snapsDir), this.snapRetainCount);
            }
            catch (Exception e) {
                LOG.error("Error occurred while purging.", (Throwable)e);
            }
            LOG.info("Purge task completed.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PurgeTaskStatus {
        NOT_STARTED,
        STARTED,
        COMPLETED;

    }
}

