/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.memory;

import com.google.common.base.Preconditions;
import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.DrillBuf;
import io.netty.util.IllegalReferenceCountException;
import java.lang.reflect.Field;
import java.util.Formatter;
import org.apache.drill.exec.memory.BaseAllocator;
import org.apache.drill.exec.util.SystemPropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundsChecking {
    private static final Logger logger = LoggerFactory.getLogger(BoundsChecking.class);
    public static final String ENABLE_UNSAFE_BOUNDS_CHECK_PROPERTY = "drill.exec.memory.enable_unsafe_bounds_check";
    public static final String ENABLE_UNSAFE_MEMORY_ACCESS_PROPERTY = "drill.enable_unsafe_memory_access";
    public static final boolean BOUNDS_CHECKING_ENABLED = SystemPropertyUtil.getBoolean((String)"drill.exec.memory.enable_unsafe_bounds_check", (!SystemPropertyUtil.getBoolean((String)"drill.enable_unsafe_memory_access", (boolean)true) ? 1 : 0) != 0);
    private static final boolean checkAccessible = BoundsChecking.getStaticBooleanField(AbstractByteBuf.class, "checkAccessible", false);

    private BoundsChecking() {
    }

    private static boolean getStaticBooleanField(Class cls, String name, boolean def) {
        try {
            Field field = cls.getDeclaredField(name);
            field.setAccessible(true);
            return field.getBoolean(null);
        }
        catch (ReflectiveOperationException e) {
            return def;
        }
    }

    private static void checkIndex(DrillBuf buf, int index, int fieldLength) {
        Preconditions.checkNotNull((Object)buf);
        if (checkAccessible && buf.refCnt() == 0) {
            Formatter formatter = new Formatter().format("%s, refCnt: 0", buf);
            if (BaseAllocator.DEBUG) {
                formatter.format("%n%s", buf.toVerboseString());
            }
            throw new IllegalReferenceCountException(formatter.toString());
        }
        if (fieldLength < 0) {
            throw new IllegalArgumentException(String.format("length: %d (expected: >= 0)", fieldLength));
        }
        if (index < 0 || index > buf.capacity() - fieldLength) {
            Formatter formatter = new Formatter().format("%s, index: %d, length: %d (expected: range(0, %d))", buf, index, fieldLength, buf.capacity());
            if (BaseAllocator.DEBUG) {
                formatter.format("%n%s", buf.toVerboseString());
            }
            throw new IndexOutOfBoundsException(formatter.toString());
        }
    }

    public static void lengthCheck(DrillBuf buf, int start, int length) {
        if (BOUNDS_CHECKING_ENABLED) {
            BoundsChecking.checkIndex(buf, start, length);
        }
    }

    public static void rangeCheck(DrillBuf buf, int start, int end) {
        if (BOUNDS_CHECKING_ENABLED) {
            BoundsChecking.checkIndex(buf, start, end - start);
        }
    }

    public static void rangeCheck(DrillBuf buf1, int start1, int end1, DrillBuf buf2, int start2, int end2) {
        if (BOUNDS_CHECKING_ENABLED) {
            BoundsChecking.checkIndex(buf1, start1, end1 - start1);
            BoundsChecking.checkIndex(buf2, start2, end2 - start2);
        }
    }

    public static void ensureWritable(DrillBuf buf, int minWritableBytes) {
        if (BOUNDS_CHECKING_ENABLED) {
            buf.ensureWritable(minWritableBytes);
        }
    }

    static {
        if (BOUNDS_CHECKING_ENABLED) {
            logger.warn("Drill is running with direct memory bounds checking enabled. If this is a production system, disable it.");
        } else if (logger.isDebugEnabled()) {
            logger.debug("Direct memory bounds checking is disabled.");
        }
    }
}

