/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway.threads;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedThreadFactory
implements ThreadFactory {
    private static final Logger log = LoggerFactory.getLogger(NamedThreadFactory.class);
    private final String namePrefix;
    private final AtomicInteger nextThreadId = new AtomicInteger();

    public NamedThreadFactory(String prefix) {
        this.namePrefix = prefix;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        String threadName = this.namePrefix + this.nextThreadId.incrementAndGet();
        thread.setName(threadName);
        thread.setDaemon(true);
        log.debug("Created new worker thread " + threadName);
        return thread;
    }
}

