/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway.threads;

import com.mapr.data.gateway.Configs;
import com.mapr.data.gateway.threads.NamedThreadFactory;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.ojai.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger log = LoggerFactory.getLogger(GrpcThreadPoolExecutor.class);
    private static final int CORE_POOL_SIZE = 2;
    private static final int KEEP_ALIVE_TIME_SEC = 60;

    public GrpcThreadPoolExecutor(Document config) {
        super(2, Configs.getInt(config, "grpc.service.executor.thread-pool-limit", Integer.MAX_VALUE), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory("MapR GRPC Service Executor -"));
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        if (t != null) {
            log.error("{}.run() leaked an exception.", (Object)r.getClass().getName(), (Object)t);
        }
        super.afterExecute(r, t);
    }
}

