/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.data.gateway.ojai.grpc;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.mapr.data.db.proto.CreateTableRequest;
import com.mapr.data.db.proto.CreateTableResponse;
import com.mapr.data.db.proto.DeleteRequest;
import com.mapr.data.db.proto.DeleteResponse;
import com.mapr.data.db.proto.DeleteTableRequest;
import com.mapr.data.db.proto.DeleteTableResponse;
import com.mapr.data.db.proto.ErrorCode;
import com.mapr.data.db.proto.FindByIdRequest;
import com.mapr.data.db.proto.FindByIdResponse;
import com.mapr.data.db.proto.FindRequest;
import com.mapr.data.db.proto.FindResponse;
import com.mapr.data.db.proto.FindResponseType;
import com.mapr.data.db.proto.InsertMode;
import com.mapr.data.db.proto.InsertOrReplaceRequest;
import com.mapr.data.db.proto.InsertOrReplaceResponse;
import com.mapr.data.db.proto.MapRDbServerGrpc;
import com.mapr.data.db.proto.PayloadEncoding;
import com.mapr.data.db.proto.PingRequest;
import com.mapr.data.db.proto.PingResponse;
import com.mapr.data.db.proto.RpcError;
import com.mapr.data.db.proto.TableExistsRequest;
import com.mapr.data.db.proto.TableExistsResponse;
import com.mapr.data.db.proto.UpdateRequest;
import com.mapr.data.db.proto.UpdateResponse;
import com.mapr.data.gateway.Configs;
import com.mapr.data.gateway.Constants;
import com.mapr.data.gateway.ojai.ConnectionManager;
import com.mapr.data.gateway.ojai.codec.JsonCodec;
import com.mapr.data.gateway.ojai.grpc.AdminOperation;
import com.mapr.data.gateway.ojai.grpc.RpcErrorManager;
import com.mapr.data.gateway.ojai.grpc.RpcOperation;
import com.mapr.data.gateway.ojai.grpc.TableOperation;
import com.mapr.data.gateway.ojai.grpc.exceptions.UnknownEncodingException;
import com.mapr.data.gateway.ojai.store.CachingStoreManager;
import com.mapr.data.gateway.ojai.store.StoreManager;
import com.mapr.db.Admin;
import com.mapr.db.exceptions.TableExistsException;
import com.mapr.db.exceptions.TableNotFoundException;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.ExecutionException;
import org.ojai.Document;
import org.ojai.JsonString;
import org.ojai.OjaiCodec;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.exceptions.DecodingException;
import org.ojai.json.JsonOptions;
import org.ojai.store.Connection;
import org.ojai.store.DocumentMutation;
import org.ojai.store.DocumentStore;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.QueryResult;
import org.ojai.store.exceptions.DocumentExistsException;
import org.ojai.store.exceptions.DocumentNotFoundException;
import org.ojai.store.exceptions.IllegalMutationException;
import org.ojai.store.exceptions.StoreExistsException;
import org.ojai.store.exceptions.StoreNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRDbServerGrpcImpl
extends MapRDbServerGrpc.MapRDbServerImplBase {
    private static final Logger log = LoggerFactory.getLogger(MapRDbServerGrpcImpl.class);
    private static final Logger payloadLogger = LoggerFactory.getLogger((String)"com.mapr.db.rpc.Payload");
    private static final RpcError.Builder NO_ERROR = RpcErrorManager.noError();
    private static final RpcError.Builder TABLE_NOT_FOUND_ERROR = RpcErrorManager.newError(ErrorCode.TABLE_NOT_FOUND);
    private static final RpcError.Builder DOCUMENT_NOT_FOUND = RpcErrorManager.newError(ErrorCode.DOCUMENT_NOT_FOUND);
    private static final JsonCodec JSON_CODEC = new JsonCodec(Constants.MAPR_OJAI_DRIVER);
    private static final QueryCondition EMPTY_CONDITION = Constants.MAPR_OJAI_DRIVER.newCondition();
    private final Connection connection;
    private final StoreManager storeManager;
    private final OjaiCodec<String> codec = JSON_CODEC;
    private final Document config;
    private final int resultLimit;
    static final PingResponse PING_RESPONSE = PingResponse.newBuilder().build();

    public MapRDbServerGrpcImpl(Document config) {
        this.config = config;
        this.connection = ConnectionManager.getConnection(config);
        this.storeManager = new CachingStoreManager(config, this.connection);
        this.resultLimit = Configs.getInt(config, "grpc.service.ojai.query.result-limit", Integer.MAX_VALUE);
        RpcErrorManager.setIncludeStackTrace(Configs.getBoolean(config, "grpc.service.rpc.include-stack-trace", true));
    }

    public void ping(PingRequest request, StreamObserver<PingResponse> observer) {
        observer.onNext((Object)PING_RESPONSE);
        observer.onCompleted();
    }

    public void insertOrReplace(InsertOrReplaceRequest request, StreamObserver<InsertOrReplaceResponse> observer) {
        InsertOrReplaceResponse.Builder responseBuilder = InsertOrReplaceResponse.newBuilder();
        RpcError.Builder error = this.applyRpcFunction(request, responseBuilder, (req, resp) -> {
            this.checkEncoding(request.getPayloadEncoding());
            InsertMode insertMode = req.getInsertMode();
            String jsonDocument = this.checkNonEmpty(req.getJsonDocument(), "json_document");
            payloadLogger.debug("insertOrReplace:json_document: '{}'", (Object)jsonDocument);
            Document document = this.codec.decodeDocument((Object)jsonDocument);
            Value idValue = document.getId();
            Preconditions.checkArgument((idValue != null ? 1 : 0) != 0, (Object)"`_id` field was not specified.");
            QueryCondition condition = this.getCondition(req.getJsonCondition());
            Preconditions.checkArgument((condition.isEmpty() || insertMode == InsertMode.REPLACE ? 1 : 0) != 0, (String)"A QueryCondition cannot be specified for %s InsertMode.", (Object)insertMode);
            return this.applyStoreFunction(req.getTablePath(), store -> {
                switch (insertMode) {
                    case INSERT: {
                        store.insert(document);
                        break;
                    }
                    case INSERT_OR_REPLACE: {
                        store.insertOrReplace(document);
                        break;
                    }
                    case REPLACE: {
                        if (condition.isEmpty()) {
                            store.replace(document);
                            break;
                        }
                        if (store.checkAndReplace(idValue, condition, document)) break;
                        return DOCUMENT_NOT_FOUND;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized InsertMode: " + insertMode);
                    }
                }
                return NO_ERROR;
            });
        });
        observer.onNext((Object)responseBuilder.setError(error).build());
        observer.onCompleted();
    }

    public void findById(FindByIdRequest request, StreamObserver<FindByIdResponse> observer) {
        FindByIdResponse.Builder responseBuilder = FindByIdResponse.newBuilder();
        RpcError.Builder error = this.applyRpcFunction(request, responseBuilder, (req, resp) -> {
            this.checkEncoding(request.getPayloadEncoding());
            String jsonDocument = this.checkNonEmpty(req.getJsonDocument(), "json_document");
            payloadLogger.debug("findById:json_document: '{}'", (Object)jsonDocument);
            Document docPayload = this.codec.decodeDocument((Object)jsonDocument);
            QueryCondition condition = this.getCondition(req.getJsonCondition());
            String[] fieldPaths = null;
            int projetionsCount = req.getProjectionsCount();
            if (projetionsCount > 0) {
                int fpIdx = 0;
                fieldPaths = new String[projetionsCount];
                for (String fpStr : req.getProjectionsList()) {
                    fieldPaths[fpIdx++] = fpStr;
                }
            }
            String[] fieldPathsArray = fieldPaths;
            return this.applyStoreFunction(req.getTablePath(), store -> {
                Document doc = null;
                doc = condition == null || condition.isEmpty() ? store.findById(docPayload.getId(), fieldPathsArray) : store.findById(docPayload.getId(), condition, fieldPathsArray);
                if (doc == null) {
                    return DOCUMENT_NOT_FOUND;
                }
                String encodedDoc = (String)this.codec.encodeDocument(doc);
                responseBuilder.setPayloadEncoding(PayloadEncoding.JSON_ENCODING).setJsonDocument(encodedDoc);
                return NO_ERROR;
            });
        });
        observer.onNext((Object)responseBuilder.setError(error).build());
        observer.onCompleted();
    }

    public void find(FindRequest request, StreamObserver<FindResponse> observer) {
        FindResponse.Builder responseBuilder = FindResponse.newBuilder().setError(NO_ERROR).setPayloadEncoding(PayloadEncoding.JSON_ENCODING);
        ServerCallStreamObserver serverObserver = (ServerCallStreamObserver)observer;
        RpcError.Builder error = this.applyRpcFunction(request, responseBuilder, (req, resp) -> {
            this.checkEncoding(request.getPayloadEncoding());
            return this.applyStoreFunction(req.getTablePath(), store -> this.streamResults(store, (FindRequest)req, (FindResponse.Builder)resp, (ServerCallStreamObserver<FindResponse>)serverObserver));
        });
        try {
            if (error != NO_ERROR && serverObserver.isReady()) {
                observer.onNext((Object)FindResponse.newBuilder().setError(error).build());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        observer.onCompleted();
    }

    private RpcError.Builder streamResults(DocumentStore store, FindRequest req, FindResponse.Builder responseBuilder, ServerCallStreamObserver<FindResponse> observer) {
        String jsonQuery = this.checkNonEmpty(req.getJsonQuery(), "json_query");
        payloadLogger.debug("streamResults:json_query: '{}'", (Object)jsonQuery);
        Query query = this.codec.decodeQuery((Object)jsonQuery, this.config);
        try (QueryResult queryResult = store.find(query);){
            if (req.getIncludeQueryPlan()) {
                responseBuilder.setType(FindResponseType.QUERY_PLAN);
                responseBuilder.setJsonResponse(this.asJsonString((JsonString)queryResult.getQueryPlan()));
                observer.onNext((Object)responseBuilder.build());
            }
            int resultCount = 0;
            responseBuilder.setType(FindResponseType.RESULT_DOCUMENT);
            for (Document document : queryResult) {
                responseBuilder.setJsonResponse(this.asJsonString((JsonString)document));
                observer.onNext((Object)responseBuilder.build());
                if (resultCount++ != this.resultLimit) continue;
                log.warn("Number of query results reached the configured max {}.", (Object)this.resultLimit);
                break;
            }
        }
        return NO_ERROR;
    }

    public void update(UpdateRequest request, StreamObserver<UpdateResponse> observer) {
        UpdateResponse.Builder responseBuilder = UpdateResponse.newBuilder();
        RpcError.Builder error = this.applyRpcFunction(request, responseBuilder, (req, resp) -> {
            this.checkEncoding(request.getPayloadEncoding());
            String jsonDocument = this.checkNonEmpty(req.getJsonDocument(), "json_document");
            payloadLogger.debug("update:json_document '{}'", (Object)jsonDocument);
            Document idDoc = this.codec.decodeDocument((Object)jsonDocument);
            Value idValue = idDoc.getId();
            Preconditions.checkArgument((idValue != null ? 1 : 0) != 0, (Object)"`_id` field was not specified.");
            String jsonMutation = this.checkNonEmpty(req.getJsonMutation(), "json_mutation");
            payloadLogger.debug("update:json_mutation: '{}'", (Object)jsonMutation);
            DocumentMutation mutation = this.codec.decodeMutation((Object)jsonMutation);
            return this.applyStoreFunction(req.getTablePath(), store -> {
                QueryCondition condition = this.getCondition(req.getJsonCondition());
                if (condition.isEmpty()) {
                    store.update(idValue, mutation);
                } else if (!store.checkAndUpdate(idValue, condition, mutation)) {
                    return DOCUMENT_NOT_FOUND;
                }
                return NO_ERROR;
            });
        });
        observer.onNext((Object)responseBuilder.setError(error).build());
        observer.onCompleted();
    }

    public void delete(DeleteRequest request, StreamObserver<DeleteResponse> observer) {
        DeleteResponse.Builder responseBuilder = DeleteResponse.newBuilder();
        RpcError.Builder error = this.applyRpcFunction(request, responseBuilder, (req, resp) -> {
            this.checkEncoding(request.getPayloadEncoding());
            String jsonDocument = this.checkNonEmpty(req.getJsonDocument(), "json_document");
            Document idDoc = this.codec.decodeDocument((Object)jsonDocument);
            Value idValue = idDoc.getId();
            Preconditions.checkArgument((idValue != null ? 1 : 0) != 0, (Object)"`_id` field was not specified.");
            return this.applyStoreFunction(req.getTablePath(), store -> {
                QueryCondition condition = this.getCondition(req.getJsonCondition());
                if (condition.isEmpty()) {
                    store.delete(idValue);
                } else {
                    store.checkAndDelete(idValue, condition);
                }
                return NO_ERROR;
            });
        });
        observer.onNext((Object)responseBuilder.setError(error).build());
        observer.onCompleted();
    }

    public void createTable(CreateTableRequest request, StreamObserver<CreateTableResponse> observer) {
        CreateTableResponse.Builder responseBuilder = CreateTableResponse.newBuilder();
        RpcError.Builder error = this.applyRpcFunction(request, responseBuilder, (req, resp) -> this.applyAdminFunction(admin -> {
            String tablePath = request.getTablePath();
            admin.createTable(tablePath);
            return NO_ERROR;
        }));
        observer.onNext((Object)responseBuilder.setError(error).build());
        observer.onCompleted();
    }

    public void deleteTable(DeleteTableRequest request, StreamObserver<DeleteTableResponse> observer) {
        DeleteTableResponse.Builder responseBuilder = DeleteTableResponse.newBuilder();
        RpcError.Builder error = this.applyRpcFunction(request, responseBuilder, (req, resp) -> this.applyAdminFunction(admin -> {
            String tablePath = request.getTablePath();
            admin.deleteTable(tablePath);
            return NO_ERROR;
        }));
        observer.onNext((Object)responseBuilder.setError(error).build());
        observer.onCompleted();
    }

    public void tableExists(TableExistsRequest request, StreamObserver<TableExistsResponse> observer) {
        TableExistsResponse.Builder responseBuilder = TableExistsResponse.newBuilder();
        RpcError.Builder error = this.applyRpcFunction(request, responseBuilder, (req, resp) -> this.applyAdminFunction(admin -> {
            String tablePath = request.getTablePath();
            return admin.tableExists(tablePath) ? NO_ERROR : TABLE_NOT_FOUND_ERROR;
        }));
        observer.onNext((Object)responseBuilder.setError(error).build());
        observer.onCompleted();
    }

    private String checkNonEmpty(String arg, String missingArg) {
        Preconditions.checkArgument((arg != null && !arg.isEmpty() ? 1 : 0) != 0, (String)"The required parameter `%s` was not specified in the request", (Object)missingArg);
        return arg;
    }

    private void checkEncoding(PayloadEncoding payloadEncoding) {
        if (payloadEncoding != PayloadEncoding.JSON_ENCODING) {
            throw new UnknownEncodingException(payloadEncoding);
        }
    }

    @API.NonNullable
    private QueryCondition getCondition(String jsonCondition) {
        return jsonCondition == null || jsonCondition.isEmpty() ? EMPTY_CONDITION : this.codec.decodeCondition((Object)jsonCondition);
    }

    private String asJsonString(JsonString jsonObj) {
        return jsonObj == null ? "{}" : jsonObj.asJsonString(JsonOptions.WITH_TAGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RpcError.Builder applyStoreFunction(String tablePath, TableOperation function) {
        this.checkNonEmpty(tablePath, "table_path");
        DocumentStore store = this.storeManager.getStore(tablePath);
        try {
            RpcError.Builder builder = function.apply(store);
            return builder;
        }
        finally {
            this.storeManager.putStore(store);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RpcError.Builder applyAdminFunction(AdminOperation function) {
        Admin admin = this.storeManager.getAdmin();
        try {
            RpcError.Builder builder = function.apply(admin);
            return builder;
        }
        finally {
            this.storeManager.putAdmin(admin);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <REQ, RSP> RpcError.Builder applyRpcFunction(REQ request, RSP responseBuilder, RpcOperation<REQ, RSP> function) {
        try {
            try {
                return function.apply(request, responseBuilder);
            }
            catch (Throwable t) {
                try {
                    Throwable throwable;
                    log.error(t.getMessage());
                    log.debug(t.getMessage(), t);
                    if (!(t instanceof UncheckedExecutionException || t instanceof ExecutionException || t instanceof ExecutionError)) {
                        throwable = t;
                        throw throwable;
                    }
                    throwable = t.getCause();
                    throw throwable;
                }
                catch (Throwable e) {
                    return RpcErrorManager.newError(ErrorCode.UNKNOWN_ERROR, e);
                }
            }
        }
        catch (UnknownEncodingException e) {
            return RpcErrorManager.newError(ErrorCode.UNKNOWN_PAYLOAD_ENCODING, (Throwable)((Object)e));
        }
        catch (DecodingException e) {
            return RpcErrorManager.newError(ErrorCode.DECODING_ERROR, e);
        }
        catch (TableNotFoundException | StoreNotFoundException e) {
            return RpcErrorManager.newError(ErrorCode.TABLE_NOT_FOUND, e);
        }
        catch (TableExistsException | StoreExistsException e) {
            return RpcErrorManager.newError(ErrorCode.TABLE_ALREADY_EXISTS, e);
        }
        catch (DocumentNotFoundException e) {
            return RpcErrorManager.newError(ErrorCode.DOCUMENT_NOT_FOUND, e);
        }
        catch (DocumentExistsException e) {
            return RpcErrorManager.newError(ErrorCode.DOCUMENT_ALREADY_EXISTS, e);
        }
        catch (IllegalMutationException e) {
            return RpcErrorManager.newError(ErrorCode.ILLEGAL_MUTATION, e);
        }
        catch (IllegalArgumentException e) {
            return RpcErrorManager.newError(ErrorCode.INVALID_ARGUMENT, e);
        }
        catch (UnsupportedOperationException e) {
            return RpcErrorManager.newError(ErrorCode.UNSUPPORTED_OPERATION, e);
        }
    }
}

