/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.mapr.baseutils.BinaryString;
import com.mapr.cli.DbCommands;
import com.mapr.cli.DbReplicaCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.FileclientRun;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Marlinserver;
import com.mapr.fs.tables.TableProperties;
import com.mapr.kafka.eventstreams.Admin;
import com.mapr.kafka.eventstreams.Streams;
import com.mapr.kafka.eventstreams.impl.admin.MarlinAdminImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class ChangeLogReplicaCommands
extends DbReplicaCommands {
    private static final Logger LOG = Logger.getLogger(ChangeLogReplicaCommands.class);
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    private static final String PATH_PARAM_NAME = "path";
    private static final String CHANGELOG_PARAM_NAME = "changelog";
    private static final String NEWCHANGELOG_PARAM_NAME = "newchangelog";
    private static final String PAUSED_PARAM_NAME = "paused";
    private static final String THROTTLE_PARAM_NAME = "throttle";
    private static final String ENCRYPTION_PARAM_NAME = "networkencryption";
    private static final String SYNCHRONOUS_PARAM_NAME = "synchronous";
    private static final String COMPRESSION_PARAM_NAME = "networkcompression";
    private static final String MULTI_ARG_SEP = ",";
    private static final String COLUMN_SEP = ":";
    private static final String REFRESH_PARAM_NAME = "refreshnow";
    private static final String WAIT_FOR_COMPLETION_PARAM_NAME = "waitforcompletion";
    private static final String TICKET_PATH_PARAM_NAME = "ticketpath";
    private static final String USE_EXISTING_CHANGELOG_PARAM_NAME = "useexistingtopic";
    private static final String PROPAGATE_EXISTING_DATA_PARAM_NAME = "propagateexistingdata";
    private static final String INCLUDE_COLUMNS_PARAM_NAME = "includecolumns";
    private static final String MULTIVERSION_PARAM_NAME = "multiversion";
    private static final String DEBUG_PARAM_NAME = "debug";
    private static final CLICommand infoCommand = new CLICommand("info", "usage: table changelog info -changelog <changelogPath>", ChangeLogReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"changelog", (Object)new TextInputParameter("changelog", "remote changelog path", true, null)).put((Object)"debug", (Object)new BooleanInputParameter("debug", "list all topic meta info", false, Boolean.valueOf(false)).setInvisible(true)).put((Object)"columns", (Object)new TextInputParameter("columns", "columns", false, "all").setInvisible(true)).put((Object)"output", (Object)new TextInputParameter("output", "verbose|terse", false, "verbose").setInvisible(true)).put((Object)"start", (Object)new IntegerInputParameter("start", "start", false, Integer.valueOf(0)).setInvisible(true)).put((Object)"limit", (Object)new IntegerInputParameter("limit", "limit", false, Integer.valueOf(Integer.MAX_VALUE)).setInvisible(true)).build(), null).setShortUsage("table changelog info -changelog <changelog>");
    private static final CLICommand listCommand = new CLICommand("list", "usage: table changelog list -path <tablePath>", ChangeLogReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"refreshnow", (Object)new BooleanInputParameter("refreshnow", "refreshnow", false, Boolean.valueOf(false))).put((Object)"debug", (Object)new BooleanInputParameter("debug", "list all replica (including changelog) info", false, Boolean.valueOf(false)).setInvisible(true)).put((Object)"columns", (Object)new TextInputParameter("columns", "columns", false, "all").setInvisible(true)).put((Object)"output", (Object)new TextInputParameter("output", "verbose|terse", false, "verbose").setInvisible(true)).put((Object)"start", (Object)new IntegerInputParameter("start", "start", false, Integer.valueOf(0)).setInvisible(true)).put((Object)"limit", (Object)new IntegerInputParameter("limit", "limit", false, Integer.valueOf(Integer.MAX_VALUE)).setInvisible(true)).build(), null).setShortUsage("table changelog list -path <tablepath>");
    private static final CLICommand autoSetupCommand = new CLICommand("add", "usage: table changelog add -path <tablePath> -changelog <changelogPath> -columns <cf1[:col1],cf2,..>-useexistingtopic <true|false> -propagateexistingdata <true|false> -paused <true|false> -throttle <true|false> -synchronous <true|false> -networkencryption <true|false> -networkcompression <off|lz4|lzf|zlib> -waitforcompletion <true/false>-ticketpath <path>", ChangeLogReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"changelog", (Object)new TextInputParameter("changelog", "remote changelog path", true, null)).put((Object)"columns", (Object)new TextInputParameter("columns", "comma separated list of <family>[:<column>]", false, null)).put((Object)"includecolumns", (Object)new TextInputParameter("includecolumns", "publishing image of changed fields, or row, or selected columns as comma separated list of fieldpaths, <$none|$mutated|$row| <family>[:<column>]> default: $none", false, null).setInvisible(true)).put((Object)"useexistingtopic", (Object)new BooleanInputParameter("useexistingtopic", "allow publishing to an existing topic", false, Boolean.valueOf(false))).put((Object)"propagateexistingdata", (Object)new BooleanInputParameter("propagateexistingdata", "publish existing data to the change stream otherwise only new changes will be propagated", false, Boolean.valueOf(true))).put((Object)"paused", (Object)new BooleanInputParameter("paused", "is replication paused", false, Boolean.valueOf(false))).put((Object)"throttle", (Object)new BooleanInputParameter("throttle", "throttle propagate operations under load", false, Boolean.valueOf(false))).put((Object)"synchronous", (Object)new BooleanInputParameter("synchronous", "propagate to remote changelog before acknowledging producers", false, Boolean.valueOf(false))).put((Object)"networkencryption", (Object)new BooleanInputParameter("networkencryption", "enable on-wire encryption", false, Boolean.valueOf(false))).put((Object)"networkcompression", (Object)new TextInputParameter("networkcompression", "on-wire compression type: off|lz4|lzf|zlib default: compression setting on changelog", false, null)).put((Object)"waitforcompletion", (Object)new BooleanInputParameter("waitforcompletion", "wait for completion", false, Boolean.valueOf(true)).setInvisible(true)).put((Object)"ticketpath", (Object)new TextInputParameter("ticketpath", "ticket path", false, null).setInvisible(true)).build(), null).setShortUsage("table changelog add -path <tablePath> -changelog <changelogPath>");
    private static final CLICommand editCommand = new CLICommand("edit", "usage: table changelog edit -path <tablePath> -changelog <changelogPath> -paused <true|false> -allowallcfs <true> -throttle <true|false> -synchronous <true|false> -networkencryption <true|false> -networkcompression <off|lz4|lzf|zlib> ", ChangeLogReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "changelog path", true, null)).put((Object)"changelog", (Object)new TextInputParameter("changelog", "remote changelog path", true, null)).put((Object)"throttle", (Object)new BooleanInputParameter("throttle", "throttle publish operations under load", false, null)).put((Object)"networkencryption", (Object)new BooleanInputParameter("networkencryption", "enable on-wire encryption", false, null)).put((Object)"synchronous", (Object)new BooleanInputParameter("synchronous", "publish to remote changelog before acknowledging producers", false, null)).put((Object)"networkcompression", (Object)new TextInputParameter("networkcompression", "on-wire compression type: off|lz4|lzf|zlib", false, null)).build(), null).setShortUsage("table changelog edit -path <tablePath> -changelog <changelogPath> -paused <true|false> -allowallcfs <true> -throttle <true|false>  -synchronous <true|false> -networkencryption <true|false -networkcompression <off|lz4|lzf|zlib>");
    private static final CLICommand pauseCommand = new CLICommand("pause", "usage: table changelog pause -path <tablePath> -changelog <changelogPath>", ChangeLogReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "changelog path", true, null)).put((Object)"changelog", (Object)new TextInputParameter("changelog", "remote changelog path", true, null)).build(), null).setShortUsage("table changelog pause -path <tablePath> -changelog <changelogPath>");
    private static final CLICommand resumeCommand = new CLICommand("resume", "usage: table changelog resume -path <tablePath> -changelog <changelogPath>", ChangeLogReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "changelog path", true, null)).put((Object)"changelog", (Object)new TextInputParameter("changelog", "remote changelog path", true, null)).build(), null).setShortUsage("table changelog resume -path <tablePath> -changelog <changelogPath>");
    private static final CLICommand removeCommand = new CLICommand("remove", "usage: table changelog remove -path <tablePath> -changelog <changelogPath>", ChangeLogReplicaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "changelog path", true, null)).put((Object)"changelog", (Object)new TextInputParameter("changelog", "remote changelog path", true, null)).build(), null).setShortUsage("table changelog remove -path <tablePath> -changelog <changelogPath>");
    public static final CLICommand replicaCommands = new CLICommand("changelog", "changelog [add|edit|list|remove|pause|resume|info]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{autoSetupCommand, editCommand, listCommand, removeCommand, pauseCommand, resumeCommand, infoCommand}).setShortUsage("table changelog [add|edit|list|remove|pause|resume|info]");

    public ChangeLogReplicaCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    @Override
    public String entityName() {
        return CHANGELOG_PARAM_NAME;
    }

    public boolean isSrcSupported(CommandOutput.OutputHierarchy out, final String tablePath) {
        boolean support = true;
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    Path path;
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    if (!mfs.isTable(path = new Path(tablePath))) {
                        throw new CLIProcessingException("Path " + tablePath + " is not a valid table");
                    }
                    TableProperties tableProp = mfs.getTableProperties(path);
                    if (tableProp.getAttr().getIsMarlinTable()) {
                        throw new CLIProcessingException("Path " + tablePath + " is a stream. Only binary and json table are supported");
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            support = false;
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            support = false;
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (Exception e) {
            support = false;
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10002, e.getMessage()));
        }
        return support;
    }

    @Override
    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String tablePath;
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        String cname = this.cliCommand.getCommandName();
        if (!cname.equalsIgnoreCase(infoCommand.getCommandName()) && !this.isSrcSupported(out, tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId()))) {
            return output;
        }
        if (cname.equalsIgnoreCase(autoSetupCommand.getCommandName())) {
            this.autoSetup(out);
        } else if (cname.equalsIgnoreCase(editCommand.getCommandName())) {
            this.editReplica(out);
        } else if (cname.equalsIgnoreCase(listCommand.getCommandName())) {
            this.listReplica(out);
        } else if (cname.equalsIgnoreCase(removeCommand.getCommandName())) {
            this.removeReplica(out);
        } else if (cname.equalsIgnoreCase(pauseCommand.getCommandName())) {
            this.pauseOrResumeReplica(out, true);
        } else if (cname.equalsIgnoreCase(resumeCommand.getCommandName())) {
            this.pauseOrResumeReplica(out, false);
        } else if (cname.equalsIgnoreCase(infoCommand.getCommandName())) {
            this.upstreamInfoReplica(out);
        }
        return output;
    }

    @Override
    protected void autoSetup(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        super.changeLogSetup(out);
    }

    @Override
    protected void listReplica(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        super.listChangelogReplica(out);
    }

    @Override
    protected void editReplica(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        super.editChangelogReplica(out);
    }

    @Override
    protected void removeReplica(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        super.removeChangelogReplica(out);
    }

    @Override
    protected void pauseOrResumeReplica(CommandOutput.OutputHierarchy out, boolean pause) throws CLIProcessingException {
        super.pauseOrResumeChangelogReplica(out, pause);
    }

    protected void upstreamInfoReplica(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        try {
            final Configuration conf = new Configuration();
            String user = this.getUserLoginId();
            boolean isDebug = this.isParamPresent(DEBUG_PARAM_NAME) ? this.getParamBooleanValue(DEBUG_PARAM_NAME, 0) : false;
            String replicaFullPathParam = DbCommands.getTransformedPath(this.getParamTextValue(CHANGELOG_PARAM_NAME, 0), this.getUserLoginId());
            String[] stnames = new String[2];
            boolean ret = ChangeLogReplicaCommands.parseStreamTopicName(replicaFullPathParam, stnames, out);
            if (!ret) {
                return;
            }
            final String streamName = stnames[0];
            final String path = DbCommands.getTransformedPath(streamName, this.getUserLoginId());
            final String topic = stnames[1];
            final ArrayList upsList = new ArrayList();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("begin info topic=" + topic + " stream=" + path + " user=" + user));
            }
            new FileclientRun(user){

                @Override
                public void runAsProxyUser() throws CLIProcessingException, IOException {
                    try {
                        Admin admin = Streams.newAdmin((Configuration)conf);
                        MarlinAdminImpl madmin = (MarlinAdminImpl)admin;
                        DbReplicaCommands.verifyStreamPath(streamName, false);
                        String topicFullName = path + ChangeLogReplicaCommands.COLUMN_SEP + topic;
                        Marlinserver.MarlinTopicMetaEntry tmeta = madmin.getTopicMetaEntry(topicFullName);
                        if (tmeta.getIsDeleted()) {
                            throw new IOException("Topic " + topicFullName + " is already deleted");
                        }
                        upsList.add(tmeta);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("infoChangelog failed : " + e));
                        throw e;
                    }
                }
            };
            Marlinserver.MarlinTopicMetaEntry mtme = (Marlinserver.MarlinTopicMetaEntry)upsList.get(0);
            CommandOutput.OutputHierarchy.OutputNode upstreamNode = new CommandOutput.OutputHierarchy.OutputNode();
            if (isDebug) {
                if (mtme.hasTopicUniq()) {
                    upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("UopicUniq", mtme.getTopicUniq()));
                } else {
                    upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("UopicUniq", (Object)"null"));
                }
                if (mtme.hasUpdateSeq()) {
                    upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("UpdateSeq", mtme.getUpdateSeq()));
                } else {
                    upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("UpdateSeq", (Object)"null"));
                }
                if (mtme.hasIsDeleted()) {
                    upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("IsDeleted", (Object)mtme.getIsDeleted()));
                } else {
                    upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("IsDeleted", (Object)"null"));
                }
                int feedIdNum = mtme.getFeedIdsCount();
                Object strFeedIds = null;
                if (feedIdNum <= 0) {
                    strFeedIds = "null";
                } else {
                    List feedIds = mtme.getFeedIdsList();
                    strFeedIds = "[";
                    for (int i = 0; i < feedIds.size() - 1; ++i) {
                        strFeedIds = (String)strFeedIds + mtme.getFeedIds(i) + ", ";
                    }
                    strFeedIds = (String)strFeedIds + mtme.getFeedIds(feedIds.size() - 1) + "]";
                }
                upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("FeedIds", strFeedIds));
                int perFeedMaxSeqNumCount = mtme.getPerFeedMaxSeqNumCount();
                Object strPerFeedMaxSeqNum = null;
                if (perFeedMaxSeqNumCount <= 0) {
                    strPerFeedMaxSeqNum = "null";
                } else {
                    List perFeedMaxSeqNum = mtme.getPerFeedMaxSeqNumList();
                    strPerFeedMaxSeqNum = "[";
                    for (int i = 0; i < perFeedMaxSeqNum.size() - 1; ++i) {
                        strPerFeedMaxSeqNum = (String)strPerFeedMaxSeqNum + mtme.getPerFeedMaxSeqNum(i) + ", ";
                    }
                    strPerFeedMaxSeqNum = (String)strPerFeedMaxSeqNum + mtme.getPerFeedMaxSeqNum(perFeedMaxSeqNum.size() - 1) + "]";
                }
                upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("PerFeedMaxSeqNum", strPerFeedMaxSeqNum));
                upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("hasTag", (Object)mtme.hasTag()));
                upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("hasUpstreamDesc", (Object)(mtme.hasTag() && mtme.getTag().hasUpstreamDesc() ? 1 : 0)));
            }
            if (mtme.hasTag()) {
                Marlinserver.MarlinTopicMetaEntryTag upTag = mtme.getTag();
                if (upTag.hasUpstreamDesc()) {
                    Dbserver.TableUpstreamDesc ud = mtme.getTag().getUpstreamDesc();
                    upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("cluster", (Object)ud.getClusterName()));
                    upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("table", (Object)ud.getTablePath()));
                    upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("idx", ud.getIdx()));
                    upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("uuid", (Object)BinaryString.toUUIDString((byte[])ud.getTableUuid().toByteArray())));
                }
                if (isDebug) {
                    List cfs = upTag.getSrcColumnFamilyMapList();
                    upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("replicatedSrcCFCount", cfs.size()));
                    Object strCfInfo = "";
                    for (int i = 0; i < cfs.size() - 1; ++i) {
                        Dbserver.ColumnFamily cfInfo = (Dbserver.ColumnFamily)cfs.get(i);
                        strCfInfo = (String)strCfInfo + cfInfo.getId() + COLUMN_SEP + (String)(cfInfo.hasName() ? cfInfo.getName() + COLUMN_SEP : COLUMN_SEP) + (String)(cfInfo.hasJsonPath() ? cfInfo.getJsonPath() + MULTI_ARG_SEP : MULTI_ARG_SEP);
                    }
                    Dbserver.ColumnFamily cfInfo = (Dbserver.ColumnFamily)cfs.get(cfs.size() - 1);
                    strCfInfo = (String)strCfInfo + cfInfo.getId() + COLUMN_SEP + (String)(cfInfo.hasName() ? cfInfo.getName() + COLUMN_SEP : COLUMN_SEP) + (String)(cfInfo.hasJsonPath() ? cfInfo.getJsonPath() + MULTI_ARG_SEP : MULTI_ARG_SEP);
                    upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("replicatedSrcCF", strCfInfo));
                    if (upTag.hasCdcInfo()) {
                        Dbserver.CDCInfo cdcInfo = upTag.getCdcInfo();
                        if (cdcInfo.hasVersion()) {
                            upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("version", cdcInfo.getVersion()));
                        }
                        if (cdcInfo.hasPrevDataType()) {
                            Dbserver.CDCDataType cdcPrevDataType = cdcInfo.getPrevDataType();
                            upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("prevDataType", (Object)ChangeLogReplicaCommands.getCDCDataTypeName(cdcPrevDataType)));
                        }
                        if (cdcInfo.hasNewDataType()) {
                            Dbserver.CDCDataType cdcNewDataType = cdcInfo.getNewDataType();
                            upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("newDataType", (Object)ChangeLogReplicaCommands.getCDCDataTypeName(cdcNewDataType)));
                            if (cdcNewDataType != Dbserver.CDCDataType.CDT_COLUMNS) {
                                upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("includeColumns", (Object)ChangeLogReplicaCommands.getCDCDataTypeName(cdcNewDataType)));
                            } else {
                                boolean qualcount = false;
                                String strNewFields = "";
                                if (cdcInfo.getIncludeFieldsCount() > 0) {
                                    String newCols = ChangeLogReplicaCommands.qualsToStrColsByColumnFamily(true, cfs, cdcInfo.getIncludeFieldsList());
                                    upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("includeColumns", (Object)newCols));
                                } else {
                                    upstreamNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("includeColumns", (Object)"Missing fieldpath info"));
                                }
                            }
                        }
                    }
                }
            }
            out.addNode(upstreamNode);
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }
}

