/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.OffloadRuleCommands;
import com.mapr.cli.VolumeCommands;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.cldb.VolumeUtils;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cli.proto.CLIProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ojai.Document;
import org.ojai.exceptions.DecodingException;
import org.ojai.json.Json;

public class TierCommands
extends ListCommand
implements CLIInterface {
    static String[] TierPropertiesFieldShortName = new String[]{"id", "n", "typ", "url", "thr", "enc", "bn", "reg", "objtype", "metavol", "dbtopo", "dbvolid"};
    static String[] TierPropertiesFieldName = new String[]{"tierid", "tiername", "tiertype", "url", "throttling", "bucketname", "region", "objectstoretype", "volume", "dbtopology", "dbvolumeid"};
    static CLDBProto.ListSortKey[] TierSortKeys = new CLDBProto.ListSortKey[]{CLDBProto.ListSortKey.TierTierId, CLDBProto.ListSortKey.TierName, CLDBProto.ListSortKey.TierTierType, CLDBProto.ListSortKey.TierUrl, CLDBProto.ListSortKey.TierThrottling, CLDBProto.ListSortKey.TierBucketName, CLDBProto.ListSortKey.TierRegion, CLDBProto.ListSortKey.TierObjectstoreType, CLDBProto.ListSortKey.TierVolume, CLDBProto.ListSortKey.TierTopology, CLDBProto.ListSortKey.DBVolumeId};
    static Map<String, CLDBProto.ListSortKey> nameToEnumMap = new HashMap<String, CLDBProto.ListSortKey>();
    static String supportedSortKeys;
    static String[] TierTypeName;
    static String[] CompType;
    public static final String S3_AWS = "S3-AWS";
    public static final String S3_GCS = "S3-GCS";
    public static final String S3_HDS = "S3-HDS";
    public static final String S3_IBM = "S3-IBM";
    public static final String Azure_Blobs = "Azure-Blobs";
    public static final String S3_Others = "S3-Others";
    private static final int NUM_TIER_PER_RPC = 100;
    private static final int LIMIT_START_PARAM = 0;
    private static final int LIMIT_MAX_PARAM = Integer.MAX_VALUE;
    public static final int MAX_OBJ_SIZE = 0x800000;
    public static final String TIERNAME_PARAM_NAME = "name";
    public static final String TYPE_PARAM_NAME = "type";
    public static final String AUTH_PARAM_NAME = "credential";
    public static final String URL_PARAM_NAME = "url";
    public static final String OBJSIZE_PARAM_NAME = "maxobjectsize";
    public static final String THROTTLING_PARAM_NAME = "throttling";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String OBJECT_STORE_TYPE_PARAM_NAME = "tag";
    public static final String CRED_STR_PARAM_NAME = "credential_str";
    public static final String DB_TOPOLOGY_PARAM_NAME = "dbtopology";
    public static final int MAX_CREDENTIALS_FILE_SIZE = 102400;
    public static final String BUCKET_NAME = "bucketName";
    public static final String REGION = "region";
    public static final String CREDENTIALS_ACCESS_KEY = "credentials.accessKey";
    public static final String CREDENTIALS_SECRET_KEY = "credentials.secretKey";
    public static final String DEFAULT_REGION = "us-east-1";
    public static final String SORTBY_PARAM_NAME = "sortby";
    public static final String SORTING_ORDER_PARAM_NAME = "sortorder";
    public static final String ASCENDING_SORTING_ORDER_PARAM_NAME = "asc";
    public static final String DESCENDING_SORTING_ORDER_PARAM_NAME = "desc";
    public static final String RW_TIER_PARAM_FORCE = "force";
    public static final String tierCreateUsage = "tier create -name tierName -type <cold/ectier> -url tier storage url -credential <credential-file to access tier storage> ";
    public static final String tierModifyUsage = "tier modify -name tierName [ -credential <credential-file to access tier storage> ]";
    public static final String tierListUsage = "tier list";
    public static final String tierInfoUsage = "tier info -name tierName";
    public static final String tierRemoveUsage = "tier remove -name tierName";
    public static final String tierMoveUsage = "tier move -name tierName [ -credential <credential-file to access tier storage> ]";
    public static final String metaVolumePrefix = "mapr.internal.tier";
    public static final String metaVolumeParentDir = "/var/mapr/tier";
    public static final String autoECMetaVolumeParentDir = "/var/mapr/autoectier";
    private static final Logger LOG;
    public static Map<String, BaseInputParameter> baseParams;
    public static Map<String, BaseInputParameter> tierCreateParams;
    public static Map<String, BaseInputParameter> tierModifyParams;
    static final CLICommand tierCreateCommand;
    static final CLICommand tierModifyCommand;
    static final CLICommand tierMoveCommand;
    static final CLICommand tierListCommand;
    static final CLICommand tierInfoCommand;
    static final CLICommand tierRemoveCommand;
    public static final CLICommand tierCommands;

    public TierCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    private void verifySortSanity(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        if (TierPropertiesFieldName.length != TierSortKeys.length) {
            String errmsg = "Num of display fields(" + TierPropertiesFieldName.length + ") mismatch num of Sortkeys(" + TierSortKeys.length + "), may cause incorrect listing. Exiting.";
            LOG.error((Object)errmsg);
            System.err.println(errmsg);
            throw new CLIProcessingException(errmsg);
        }
        int i = 0;
        for (String name : TierPropertiesFieldName) {
            nameToEnumMap.put(name, TierSortKeys[i++]);
        }
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String cmd = this.cliCommand.getCommandName();
        if (cmd.equalsIgnoreCase("list")) {
            this.verifySortSanity(out);
            try {
                String sortbyStr;
                CLDBProto.ListSortKey sortKey;
                if (this.isParamPresent(SORTBY_PARAM_NAME) && (sortKey = nameToEnumMap.get((sortbyStr = this.getParamTextValue(SORTBY_PARAM_NAME, 0)).toLowerCase())) == null) {
                    LOG.error((Object)("failed to list sorted volumes, " + sortbyStr + " is not a valid keyword to sort volumes."));
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid sortkey: " + sortbyStr));
                    return output;
                }
                if (this.isParamPresent(SORTING_ORDER_PARAM_NAME)) {
                    if (!this.isParamPresent(SORTBY_PARAM_NAME)) {
                        String msg = "Invalid use of sortorder. Must be used with sortby";
                        LOG.error((Object)msg);
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                        return output;
                    }
                    String sortOrder = this.getParamTextValue(SORTING_ORDER_PARAM_NAME, 0);
                    if (!sortOrder.equalsIgnoreCase(ASCENDING_SORTING_ORDER_PARAM_NAME) && !sortOrder.equalsIgnoreCase(DESCENDING_SORTING_ORDER_PARAM_NAME)) {
                        String msg = "Invalid value for sortorder. Valid values are asc and desc";
                        LOG.error((Object)msg);
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                        return output;
                    }
                }
                this.list(out);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (cmd.equalsIgnoreCase("create")) {
            try {
                this.tierCreate(out);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (cmd.equalsIgnoreCase("modify")) {
            try {
                this.tierModify(out);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (cmd.equalsIgnoreCase("info")) {
            try {
                this.tierInfo(out);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (cmd.equalsIgnoreCase("remove")) {
            try {
                this.tierRemove(out);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (cmd.equalsIgnoreCase("move")) {
            try {
                this.tierMove(out);
            }
            catch (Exception e) {
                throw new CLIProcessingException("tier move failed with exception", (Throwable)e);
            }
        }
        return output;
    }

    private String getOutputParamValue() throws CLIProcessingException {
        return this.isParamPresent(OUTPUT_PARAM_NAME) ? this.getParamTextValue(OUTPUT_PARAM_NAME, 0) : "";
    }

    private String getTierName() throws CLIProcessingException {
        return this.isParamPresent(TIERNAME_PARAM_NAME) ? this.getParamTextValue(TIERNAME_PARAM_NAME, 0) : null;
    }

    private static String getVolumeName(String tierName) throws CLIProcessingException {
        return "mapr.internal.tier." + tierName;
    }

    public static String generateTierNameForAutoCreate(String ecVolumeName) {
        String currentSec = String.valueOf(System.currentTimeMillis() / 1000L);
        if (ecVolumeName.length() > VolumeUtils.validTierVolumeNameLength() - 9) {
            return CLDBProto.DefaultECConstants.getDefaultInstance().getAutoEcTierPrefix() + VolumeUtils.truncateVolumeNameWithHash((String)ecVolumeName, (String)currentSec) + "." + currentSec;
        }
        return CLDBProto.DefaultECConstants.getDefaultInstance().getAutoEcTierPrefix() + ecVolumeName + "." + currentSec;
    }

    private static String getTierMetaVolumeMountPath(String tierMetaVolumeName) throws CLIProcessingException {
        return "/var/mapr/tier/" + tierMetaVolumeName;
    }

    private static String getAutoECTierMetaVolumeMountPath(String tierMetaVolumeName) {
        return "/var/mapr/autoectier/" + tierMetaVolumeName;
    }

    private String getTagParamValue() throws CLIProcessingException {
        return this.isParamPresent(OBJECT_STORE_TYPE_PARAM_NAME) ? this.getParamTextValue(OBJECT_STORE_TYPE_PARAM_NAME, 0) : "";
    }

    private String getCredStrParamValue() throws CLIProcessingException {
        return this.isParamPresent(CRED_STR_PARAM_NAME) ? this.getParamTextValue(CRED_STR_PARAM_NAME, 0) : "";
    }

    private String getDbTopologyParamValue() throws CLIProcessingException {
        return this.isParamPresent(DB_TOPOLOGY_PARAM_NAME) ? this.getParamTextValue(DB_TOPOLOGY_PARAM_NAME, 0) : null;
    }

    public static CLDBProto.TierLookupResponse tierLookup(String cluster, Security.CredentialsMsg creds, int tierId) throws CLIProcessingException {
        return TierCommands.tierLookup(cluster, creds, "", tierId);
    }

    public static CLDBProto.TierLookupResponse tierLookup(String cluster, Security.CredentialsMsg creds, String tierName) throws CLIProcessingException {
        return TierCommands.tierLookup(cluster, creds, tierName, 0);
    }

    public static CLDBProto.TierLookupResponse tierLookup(String cluster, Security.CredentialsMsg creds, String tierName, int tierId) throws CLIProcessingException {
        byte[] data = null;
        CLDBProto.TierLookupRequest.Builder req = CLDBProto.TierLookupRequest.newBuilder().setCreds(creds);
        if (tierName != null && !tierName.isEmpty()) {
            req.setTierName(tierName);
        } else {
            req.setTierId(tierId);
        }
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierLookupProc.getNumber(), (MessageLite)req.build(), CLDBProto.TierLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierLookupProc.getNumber(), (MessageLite)req.build(), CLDBProto.TierLookupResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            return CLDBProto.TierLookupResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing tier lookup to CLDB, " + e.getLocalizedMessage());
        }
    }

    private String[] getCredentialFromJson(String jsonStr, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String accessKey = null;
        String secretKey = null;
        String bucketName = null;
        String region = null;
        String[] retVals = new String[4];
        retVals[3] = null;
        retVals[2] = null;
        retVals[1] = null;
        retVals[0] = null;
        Document doc = null;
        try {
            doc = Json.newDocument((String)jsonStr);
        }
        catch (DecodingException de) {
            String msg = de.getMessage();
            msg = msg.substring(msg.indexOf(": ") + 1);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Error parsing JSON string." + msg));
            return null;
        }
        bucketName = doc.getString(BUCKET_NAME);
        accessKey = doc.getString(CREDENTIALS_ACCESS_KEY);
        secretKey = doc.getString(CREDENTIALS_SECRET_KEY);
        region = doc.getString(REGION);
        if (accessKey != null && !accessKey.isEmpty()) {
            accessKey = accessKey.trim();
        }
        if (secretKey != null && !secretKey.isEmpty()) {
            secretKey = secretKey.trim();
        }
        if (region != null && !region.isEmpty()) {
            region = region.trim();
        }
        if (bucketName != null && !bucketName.isEmpty()) {
            bucketName = bucketName.trim();
        }
        retVals[0] = accessKey;
        retVals[1] = secretKey;
        retVals[2] = bucketName;
        retVals[3] = region;
        return retVals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] handleCredentialsParam(String credsFname, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        InputStreamReader fr = null;
        BufferedReader br = null;
        Object jsonStr = "";
        try {
            File f = new File(credsFname);
            if (!f.exists()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "File " + credsFname + " does not exist."));
                String[] stringArray = null;
                return stringArray;
            }
            if (f.isDirectory()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, credsFname + " is a directory. Provide valid file for credentials"));
                String[] stringArray = null;
                return stringArray;
            }
            if (f.length() > 102400L) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Size of Credentials file exceeds max supported size."));
                String[] stringArray = null;
                return stringArray;
            }
            fr = new FileReader(credsFname);
            br = new BufferedReader(fr);
            String line = null;
            while ((line = br.readLine()) != null) {
                jsonStr = (String)jsonStr + line;
            }
            String[] stringArray = this.getCredentialFromJson((String)jsonStr, out);
            return stringArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            String errMsg = "Error parsing S3 credentials file. Follow mapr documentation for credentials file template. ";
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errMsg));
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private String CheckAndTransformURL(String inURL) throws MalformedURLException {
        URL url = null;
        try {
            url = new URL(inURL);
        }
        catch (MalformedURLException e) {
            if (e.getMessage().contains("no protocol")) {
                return new String("http://" + inURL);
            }
            throw e;
        }
        if (!url.getProtocol().equals("http") && !url.getProtocol().equals("https")) {
            throw new MalformedURLException("only http/https is supported in url");
        }
        if (!inURL.contains("http://") && !inURL.contains("https://")) {
            throw new MalformedURLException("URL should start with http(s)://");
        }
        return new String(inURL);
    }

    void tierCreate(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.TierLookupResponse resp;
        String tierName = null;
        CLDBProto.TierType tierType = CLDBProto.TierType.COLD_TIER;
        boolean throttling = false;
        int maxObjSize = 0x800000;
        String volumeName = null;
        String volumePath = null;
        String cluster = null;
        String credentials = null;
        String url = null;
        String accessKey = null;
        String secretKey = null;
        String bucketName = null;
        String region = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        if ((tierName = this.getTierName()).startsWith(CLDBProto.DefaultECConstants.getDefaultInstance().getAutoEcTierPrefix())) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "tiername can not start with " + CLDBProto.DefaultECConstants.getDefaultInstance().getAutoEcTierPrefix()));
        }
        if ((resp = TierCommands.tierLookup(cluster, this.getUserCredentials(), tierName)).hasStatus() && resp.getStatus() == 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(17, "Tier " + tierName + " already exists."));
            return;
        }
        volumeName = TierCommands.getVolumeName(tierName);
        volumePath = TierCommands.getTierMetaVolumeMountPath(volumeName);
        if (volumePath == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(5, "Couldn't not create dir:/var/mapr/tier to mount meta volume for tier"));
            return;
        }
        CLDBProto.VolumeLookupResponse vlResp = VolumeCommands.volumeLookup(cluster, this.getUserCredentials(), volumeName, null, this.isServerCall);
        if (vlResp.hasStatus() && vlResp.getStatus() == 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Volume " + volumeName + " already exists in cluster"));
            return;
        }
        if (this.isParamPresent(TYPE_PARAM_NAME)) {
            String str = this.getParamTextValue(TYPE_PARAM_NAME, 0);
            if (str.equalsIgnoreCase("cold")) {
                tierType = CLDBProto.TierType.COLD_TIER;
            } else if (str.equalsIgnoreCase("ectier")) {
                tierType = CLDBProto.TierType.EC_TIER;
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid type " + str + " specified. Please specify cold/ectier"));
                return;
            }
        }
        if (this.isParamPresent(URL_PARAM_NAME)) {
            try {
                url = this.CheckAndTransformURL(this.getParamTextValue(URL_PARAM_NAME, 0).trim());
            }
            catch (MalformedURLException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid url: " + e.getMessage()));
                return;
            }
        }
        if (tierType == CLDBProto.TierType.EC_TIER && this.isParamPresent(OBJECT_STORE_TYPE_PARAM_NAME)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "tag not supported with tier type 'ectier'"));
            return;
        }
        String objectStoreType = this.getTagParamValue();
        String dbTopology = this.getDbTopologyParamValue();
        if (this.isParamPresent(CRED_STR_PARAM_NAME) && this.isParamPresent(AUTH_PARAM_NAME)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "options 'credential' and 'credential_str' can not given together"));
            return;
        }
        String credentialJson = this.getCredStrParamValue();
        String[] s3Creds = null;
        if (credentialJson != "" && (s3Creds = this.getCredentialFromJson(credentialJson, out)) == null) {
            return;
        }
        if (this.isParamPresent(AUTH_PARAM_NAME) && (s3Creds = this.handleCredentialsParam(credentials = this.getParamTextValue(AUTH_PARAM_NAME, 0), out)) == null) {
            return;
        }
        if (s3Creds != null) {
            accessKey = s3Creds[0];
            secretKey = s3Creds[1];
            bucketName = s3Creds[2];
            region = s3Creds[3];
            if (accessKey == null || accessKey.isEmpty() || secretKey == null || secretKey.isEmpty() || bucketName == null || bucketName.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Couldn't find valid bucket-name/access-key/secret-key"));
                return;
            }
            if (region == null || region.isEmpty()) {
                region = DEFAULT_REGION;
            }
        }
        if (this.isParamPresent(OBJSIZE_PARAM_NAME)) {
            maxObjSize = this.getParamIntValue(OBJSIZE_PARAM_NAME, 0);
        }
        if (this.isParamPresent(TYPE_PARAM_NAME)) {
            String str = this.getParamTextValue(TYPE_PARAM_NAME, 0);
            if (str.equalsIgnoreCase("cold")) {
                tierType = CLDBProto.TierType.COLD_TIER;
            } else if (str.equalsIgnoreCase("ectier")) {
                tierType = CLDBProto.TierType.EC_TIER;
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid type " + str + " specified. Please specify cold/ectier"));
                return;
            }
        }
        if (this.isParamPresent(THROTTLING_PARAM_NAME)) {
            throttling = this.getParamBooleanValue(THROTTLING_PARAM_NAME, 0);
        }
        if (tierType == CLDBProto.TierType.COLD_TIER && (accessKey == null || accessKey.isEmpty() || secretKey == null || secretKey.isEmpty() || bucketName == null || bucketName.isEmpty() || region == null || region.isEmpty() || url == null || url.isEmpty())) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot find valid url/access-key/secret-key/bucket-name/region"));
            return;
        }
        CLDBProto.TierCreateRequest.Builder tierCreate = CLDBProto.TierCreateRequest.newBuilder();
        CLDBProto.TierProperties.Builder tierProperties = CLDBProto.TierProperties.newBuilder();
        tierProperties.setTierName(tierName);
        tierProperties.setTierType(tierType);
        tierProperties.setMetaVolumeName(volumeName);
        tierProperties.setMetaVolumePath(volumePath);
        tierProperties.setThrotteling(throttling);
        tierProperties.setMaxObjSize(maxObjSize);
        if (tierType == CLDBProto.TierType.COLD_TIER) {
            if (this.getObjectStoreType(objectStoreType) == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid object store type"));
                return;
            }
            tierProperties.setObjectStoreType(this.getObjectStoreType(objectStoreType));
        }
        if (url != null) {
            tierProperties.setUrl(url);
        }
        if (credentials != null) {
            tierProperties.setCredential(credentials);
        }
        if (accessKey != null && secretKey != null && bucketName != null && region != null) {
            Security.TierCredentials.Builder tierCredentials = Security.TierCredentials.newBuilder().setCredType(Security.CredentialsType.CredentialsTypeAws).setAccessKey(accessKey).setSecretKey(secretKey).setBucketName(bucketName).setRegion(region);
            tierProperties.setTierCreds(tierCredentials);
        }
        tierCreate.setTierProperties(tierProperties);
        tierCreate.setCreds(this.getUserCredentials());
        if (dbTopology != null) {
            tierCreate.setMetaVolumeTopology(dbTopology);
        }
        try {
            byte[] data = null;
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierCreateProc.getNumber(), (MessageLite)tierCreate.build(), CLDBProto.TierCreateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierCreateProc.getNumber(), (MessageLite)tierCreate.build(), CLDBProto.TierCreateResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.TierCreateResponse createResp = CLDBProto.TierCreateResponse.parseFrom((byte[])data);
            if (createResp.getStatus() == 0) {
                out.addMessage("Successfully created tier: '" + tierName + "'");
                MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
                int status = fs.mountVolume(cluster, volumeName, volumePath, this.getUserLoginId());
                if (status != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "metadata volume failed to mount"));
                }
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(createResp.getStatus(), Errno.toString((int)createResp.getStatus()) + ": " + createResp.getErrMsg()));
                LOG.error((Object)("Failed to create tier. " + Errno.toString((int)createResp.getStatus()) + ": " + createResp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    public static CLDBProto.TierCreateResponse EcTierCreate(String cluster, Security.CredentialsMsg creds, String userLoginId, String tierName) throws CLIProcessingException {
        String metaVolumeName = TierCommands.getVolumeName(tierName);
        String metaVolumePath = TierCommands.getAutoECTierMetaVolumeMountPath(metaVolumeName);
        CLDBProto.TierProperties.Builder tierProperties = CLDBProto.TierProperties.newBuilder();
        tierProperties.setTierName(tierName);
        tierProperties.setTierType(CLDBProto.TierType.EC_TIER);
        tierProperties.setMetaVolumeName(metaVolumeName);
        tierProperties.setMetaVolumePath(metaVolumePath);
        CLDBProto.TierCreateRequest tierCreate = CLDBProto.TierCreateRequest.newBuilder().setTierProperties(tierProperties).setCreds(creds).build();
        try {
            byte[] data = null;
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierCreateProc.getNumber(), (MessageLite)tierCreate, CLDBProto.TierCreateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierCreateProc.getNumber(), (MessageLite)tierCreate, CLDBProto.TierCreateResponse.class);
            if (data == null) {
                return CLDBProto.TierCreateResponse.newBuilder().setStatus(10009).setErrMsg("could not create tier, check CLDB logs or retry it").build();
            }
            CLDBProto.TierCreateResponse tierCreateResp = CLDBProto.TierCreateResponse.parseFrom((byte[])data);
            if (tierCreateResp.getStatus() == 0) {
                LOG.info((Object)("Successfully created tier : " + tierName));
                MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
                int status = fs.mountVolume(cluster, metaVolumeName, metaVolumePath, userLoginId);
                if (status != 0) {
                    LOG.error((Object)("metadata volume mount failed, tiername:" + tierName + ", mountPath: " + metaVolumePath));
                    return CLDBProto.TierCreateResponse.newBuilder().setStatus(10003).setErrMsg("could not mount tier meta volume, check CLDB/MFS logs or retry it").build();
                }
            }
            return tierCreateResp;
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    void tierModify(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.TierLookupResponse tierLookupResp;
        String tierName = null;
        boolean throttling = false;
        int maxObjSize = Integer.MAX_VALUE;
        String cluster = null;
        String accessKey = null;
        String secretKey = null;
        String bucketName = null;
        String region = null;
        tierName = this.getTierName();
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        if ((tierLookupResp = TierCommands.tierLookup(cluster, this.getUserCredentials(), tierName)).hasStatus() && tierLookupResp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Tier " + tierName + " does not exist."));
            return;
        }
        CLDBProto.TierProperties oldTierProperties = tierLookupResp.getTierProperties();
        if (oldTierProperties == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Tier properties could not be found"));
            return;
        }
        if (this.isParamPresent(DB_TOPOLOGY_PARAM_NAME)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot modify dbtopology"));
            return;
        }
        if (this.isParamPresent(CRED_STR_PARAM_NAME) && this.isParamPresent(AUTH_PARAM_NAME)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "options 'credential' and 'credential_str' can not given together"));
            return;
        }
        String objectStoreType = this.getTagParamValue();
        String credentialJson = this.getCredStrParamValue();
        boolean forceModify = false;
        if (this.isParamPresent(RW_TIER_PARAM_FORCE)) {
            forceModify = this.getParamBooleanValue(RW_TIER_PARAM_FORCE, 0);
        }
        CLDBProto.TierProperties.Builder tierProperties = CLDBProto.TierProperties.newBuilder();
        tierProperties.setTierName(tierName);
        if (this.isParamPresent(OBJECT_STORE_TYPE_PARAM_NAME)) {
            if (oldTierProperties.getTierType() == CLDBProto.TierType.EC_TIER) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "tag not supported with tier type 'ectier'"));
                return;
            }
            if (oldTierProperties.getTierType() == CLDBProto.TierType.COLD_TIER) {
                if (this.getObjectStoreType(objectStoreType) == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid object store type"));
                    return;
                }
                LOG.info((Object)("Adding tag: " + objectStoreType + " for tier modification"));
                tierProperties.setObjectStoreType(this.getObjectStoreType(objectStoreType));
            }
        }
        if (this.isParamPresent(URL_PARAM_NAME)) {
            if (oldTierProperties.getTierType() == CLDBProto.TierType.EC_TIER) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "url not supported with tier type 'ectier'"));
                return;
            }
            try {
                String url = this.CheckAndTransformURL(this.getParamTextValue(URL_PARAM_NAME, 0).trim());
                tierProperties.setUrl(url);
            }
            catch (MalformedURLException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid url: " + e.getMessage()));
                return;
            }
        }
        String[] s3Creds = null;
        if (credentialJson != "") {
            if (oldTierProperties.getTierType() == CLDBProto.TierType.EC_TIER) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "credential not supported with tier type 'ectier'"));
                return;
            }
            s3Creds = this.getCredentialFromJson(credentialJson, out);
            if (s3Creds == null) {
                return;
            }
        }
        if (this.isParamPresent(AUTH_PARAM_NAME)) {
            if (oldTierProperties.getTierType() == CLDBProto.TierType.EC_TIER) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "credential not supported with tier type 'ectier'"));
                return;
            }
            tierProperties.setCredential(this.getParamTextValue(AUTH_PARAM_NAME, 0));
            String credentials = this.getParamTextValue(AUTH_PARAM_NAME, 0);
            s3Creds = this.handleCredentialsParam(credentials, out);
        }
        if (s3Creds != null) {
            accessKey = s3Creds[0];
            secretKey = s3Creds[1];
            bucketName = s3Creds[2];
            region = s3Creds[3];
            Security.TierCredentials.Builder tierCredentials = Security.TierCredentials.newBuilder().setCredType(Security.CredentialsType.CredentialsTypeAws);
            if (bucketName != null) {
                if (bucketName.isEmpty()) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Couldn't find valid bucket-name"));
                    return;
                }
                tierCredentials.setBucketName(bucketName);
            }
            if (region != null && !region.isEmpty()) {
                tierCredentials.setRegion(region);
            }
            if (accessKey != null) {
                if (accessKey.isEmpty()) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Couldn't find valid access-key"));
                    return;
                }
                tierCredentials.setAccessKey(accessKey);
            }
            if (secretKey != null) {
                if (secretKey.isEmpty()) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Couldn't find valid secret-key"));
                    return;
                }
                tierCredentials.setSecretKey(secretKey);
            }
            tierProperties.setTierCreds(tierCredentials);
        }
        if (this.isParamPresent(OBJSIZE_PARAM_NAME)) {
            tierProperties.setMaxObjSize(this.getParamIntValue(OBJSIZE_PARAM_NAME, 0));
        }
        if (this.isParamPresent(THROTTLING_PARAM_NAME)) {
            tierProperties.setThrotteling(this.getParamBooleanValue(THROTTLING_PARAM_NAME, 0));
        }
        CLDBProto.TierModifyRequest.Builder tierModify = CLDBProto.TierModifyRequest.newBuilder();
        tierModify.setTierProperties(tierProperties);
        tierModify.setCreds(this.getUserCredentials());
        tierModify.setForce(forceModify);
        try {
            byte[] data = null;
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierModifyProc.getNumber(), (MessageLite)tierModify.build(), CLDBProto.TierModifyResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierModifyProc.getNumber(), (MessageLite)tierModify.build(), CLDBProto.TierModifyResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.TierModifyResponse modifyResp = CLDBProto.TierModifyResponse.parseFrom((byte[])data);
            if (modifyResp.getStatus() == 0) {
                out.addMessage("Successfully updated tier: '" + tierName + "'");
            } else {
                String errMsg = modifyResp.hasErrMsg() ? modifyResp.getErrMsg() : Errno.toString((int)modifyResp.getStatus());
                out.addError(new CommandOutput.OutputHierarchy.OutputError(modifyResp.getStatus(), errMsg));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
    }

    void tierRemove(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.TierLookupResponse lookupResp;
        String tierName = null;
        String cluster = null;
        Object data = null;
        tierName = this.getTierName();
        String volumeName = TierCommands.getVolumeName(tierName);
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        if ((lookupResp = TierCommands.tierLookup(cluster, this.getUserCredentials(), tierName)).hasStatus() && lookupResp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Tier " + tierName + " does not exist."));
            return;
        }
        if (lookupResp.hasNumVols() && lookupResp.getNumVols() > 0) {
            LOG.error((Object)"Cannot remove tier, as some volumes are still using it.");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Can not remove tier, as some volumes are still using it."));
            return;
        }
        try {
            int unmountStatus = VolumeCommands.volumeUnmountByName(volumeName, cluster, this.getUserLoginId(), this.getUserCredentials(), this.isServerCall);
            if (unmountStatus != 0 && unmountStatus != 2) {
                LOG.error((Object)("Failed to remove volume " + volumeName + " error " + unmountStatus));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(unmountStatus, "Failed to unmount volume " + volumeName));
                return;
            }
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception in volume unmount, " + e.getLocalizedMessage());
        }
        try {
            CLDBProto.TierRemoveResponse tierDelResp = TierCommands.deleteTierFromCLDB(tierName, this.getUserCredentials(), cluster);
            if (tierDelResp.getStatus() == 0) {
                out.addMessage("Successfully deleted tier: '" + tierName + "'");
            } else if (tierDelResp.getStatus() == 1000) {
                String errMsg = "Cannot remove tier, as some volumes are still using it.";
                LOG.error((Object)(errMsg + ", tierName : " + tierName));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, errMsg));
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(tierDelResp.getStatus(), Errno.toString((int)tierDelResp.getStatus())));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing tier lookup to CLDB, " + e.getLocalizedMessage());
        }
    }

    public static int tierRemove(String tierName, String cluster, String userId, Security.CredentialsMsg creds, boolean isServerCall) throws CLIProcessingException {
        CLDBProto.TierLookupResponse tierLookupResp = TierCommands.tierLookup(cluster, creds, tierName);
        if (tierLookupResp == null || tierLookupResp.getStatus() != 0) {
            return 2;
        }
        String volumeName = TierCommands.getVolumeName(tierName);
        try {
            int unmountStatus = VolumeCommands.volumeUnmountByName(volumeName, cluster, userId, creds, isServerCall);
            if (unmountStatus != 0 && unmountStatus != 2) {
                LOG.error((Object)("Failed to remove volume " + volumeName + " error " + unmountStatus));
                return unmountStatus;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to unmount tier meta volume " + volumeName + " error " + e.getLocalizedMessage()));
            return -1;
        }
        try {
            return TierCommands.deleteTierFromCLDB(tierName, creds, cluster).getStatus();
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException in tier remove:  Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing tier lookup to CLDB, " + e.getLocalizedMessage());
        }
    }

    public static CLDBProto.TierRemoveResponse deleteTierFromCLDB(String tierName, Security.CredentialsMsg creds, String cluster) throws Exception {
        LOG.info((Object)("Removing tier " + tierName));
        byte[] data = null;
        if (tierName == null || tierName.isEmpty()) {
            return CLDBProto.TierRemoveResponse.newBuilder().setStatus(22).build();
        }
        CLDBProto.TierRemoveRequest req = CLDBProto.TierRemoveRequest.newBuilder().setTierName(tierName).setCreds(creds).build();
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierRemoveProc.getNumber(), (MessageLite)req, CLDBProto.TierRemoveResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierRemoveProc.getNumber(), (MessageLite)req, CLDBProto.TierRemoveResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            return CLDBProto.TierRemoveResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing tier lookup to CLDB, " + e.getLocalizedMessage());
        }
    }

    void tierInfo(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.TierLookupResponse resp;
        String tierName = null;
        String cluster = null;
        tierName = this.getTierName();
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        if ((resp = TierCommands.tierLookup(cluster, this.getUserCredentials(), tierName)).hasStatus() && resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Tier " + tierName + " does not exist."));
            return;
        }
        boolean terse = this.getOutputParamValue().equals("terse");
        this.addTierProperties(resp.getTierProperties(), terse, out);
    }

    public CLDBProto.TierListRequest buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.TierListRequest.Builder newReqBuilder = null;
        if (prevReq != null) {
            newReqBuilder = CLDBProto.TierListRequest.newBuilder((CLDBProto.TierListRequest)((CLDBProto.TierListRequest)prevReq));
        } else {
            CLIProto.Limiter limiter = this.getNextLimiter(0, 0, 0, Integer.MAX_VALUE, 100);
            newReqBuilder = CLDBProto.TierListRequest.newBuilder().setLimiter(limiter);
            if (this.isParamPresent(SORTBY_PARAM_NAME)) {
                String sortbyStr = this.getParamTextValue(SORTBY_PARAM_NAME, 0);
                CLDBProto.ListSortKey sortKey = nameToEnumMap.get(sortbyStr.toLowerCase());
                newReqBuilder.setSortKey(sortKey);
                if (this.isParamPresent(SORTING_ORDER_PARAM_NAME)) {
                    String sortOrder = this.getParamTextValue(SORTING_ORDER_PARAM_NAME, 0);
                    boolean order = false;
                    if (sortOrder.equalsIgnoreCase(DESCENDING_SORTING_ORDER_PARAM_NAME)) {
                        order = true;
                    }
                    newReqBuilder.setSortDescending(order);
                }
            }
        }
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = ((CLDBProto.TierListResponse)prevResp).getTotal();
            CLIProto.Limiter limiter = this.getNextLimiter(prevStart, prevCount, 0, Integer.MAX_VALUE, 100);
            newReqBuilder.setLimiter(limiter);
        }
        newReqBuilder.setCreds(this.getUserCredentials());
        return newReqBuilder.build();
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return this.hasMore(0, Integer.MAX_VALUE, ((CLDBProto.TierListRequest)prevReq).getLimiter().getStart(), ((CLDBProto.TierListResponse)prevResp).getTierPropertiesCount());
    }

    void addTierProperties(CLDBProto.TierProperties tierProperties, boolean terse, CommandOutput.OutputHierarchy out) {
        String[] columnName;
        CommandOutput.OutputHierarchy.OutputNode tierNode = new CommandOutput.OutputHierarchy.OutputNode();
        String[] stringArray = columnName = terse ? TierPropertiesFieldShortName : TierPropertiesFieldName;
        if (tierProperties.hasTierId()) {
            tierNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[TierPropertiesField.id.ordinal()], (Object)Integer.toString(tierProperties.getTierId())));
        }
        if (tierProperties.hasTierName()) {
            tierNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[TierPropertiesField.n.ordinal()], (Object)tierProperties.getTierName()));
        }
        if (tierProperties.hasTierType()) {
            tierNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[TierPropertiesField.typ.ordinal()], (Object)TierTypeName[tierProperties.getTierType().ordinal()]));
        }
        if (tierProperties.hasUrl()) {
            tierNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[TierPropertiesField.url.ordinal()], (Object)tierProperties.getUrl()));
        }
        if (tierProperties.hasTierCreds() && tierProperties.getTierCreds().hasBucketName()) {
            tierNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[TierPropertiesField.bn.ordinal()], (Object)tierProperties.getTierCreds().getBucketName()));
        }
        if (tierProperties.hasTierCreds() && tierProperties.getTierCreds().hasRegion() && (!tierProperties.hasObjectStoreType() || tierProperties.getObjectStoreType() != CLDBProto.ObjectStoreType.Azure_Blobs)) {
            tierNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[TierPropertiesField.reg.ordinal()], (Object)tierProperties.getTierCreds().getRegion()));
        }
        if (tierProperties.hasMetaVolumeName()) {
            tierNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[TierPropertiesField.metavol.ordinal()], (Object)tierProperties.getMetaVolumeName()));
            tierNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[TierPropertiesField.dbtopo.ordinal()], (Object)this.getMetaVolumeTopology(tierProperties.hasMetaVolumeName() ? tierProperties.getMetaVolumeName() : "")));
        }
        if (tierProperties.hasDbVolumeId()) {
            tierNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[TierPropertiesField.dbvolid.ordinal()], tierProperties.getDbVolumeId()));
        }
        if (tierProperties.hasObjectStoreType()) {
            tierNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName[TierPropertiesField.objtype.ordinal()], (Object)this.getObjectTypeString(tierProperties.getObjectStoreType())));
        }
        out.addNode(tierNode);
    }

    public String getMetaVolumeTopology(String metaVolumeName) {
        if (metaVolumeName == "" || metaVolumeName == null) {
            return "";
        }
        CLDBProto.VolumeLookupRequest volLookupReq = CLDBProto.VolumeLookupRequest.newBuilder().setVolumeName(metaVolumeName).setCreds(this.getUserCredentials()).build();
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)volLookupReq, CLDBProto.VolumeLookupResponse.class);
            if (data == null) {
                return "";
            }
            CLDBProto.VolumeLookupResponse volLoolupResp = CLDBProto.VolumeLookupResponse.parseFrom((byte[])data);
            if (volLoolupResp.getStatus() == 0) {
                return volLoolupResp.getVolInfo().getVolProperties().getTopology().getTopologyRestricted();
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBProto.TierListResponse resp = (CLDBProto.TierListResponse)response;
        boolean terse = this.getOutputParamValue().equals("terse");
        for (CLDBProto.TierProperties tierProperties : resp.getTierPropertiesList()) {
            this.addTierProperties(tierProperties, terse, out);
        }
        if (resp.hasTotal()) {
            out.setTotal(resp.getTotal());
        }
    }

    public CLDBProto.TierListResponse sendRequest(MessageLite request) throws CLIProcessingException {
        CLDBProto.TierListRequest req = (CLDBProto.TierListRequest)request;
        byte[] replyData = null;
        if (this.isParamPresent("cluster")) {
            String cluster = this.getParamTextValue("cluster", 0);
            if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                throw new CLIProcessingException("Invalid cluster: " + cluster);
            }
            try {
                replyData = CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierListProc.getNumber(), (MessageLite)req, CLDBProto.TierListResponse.class);
            }
            catch (Exception e) {
                throw new CLIProcessingException((Throwable)e);
            }
        }
        try {
            replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.TierListProc.getNumber(), (MessageLite)req, CLDBProto.TierListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            try {
                return CLDBProto.TierListResponse.parseFrom((byte[])replyData);
            }
            catch (InvalidProtocolBufferException ipbe) {
                throw new CLIProcessingException("Exception while parsing the RPC response data into TierListResponse proto object.", (Throwable)ipbe);
            }
        }
        throw new CLIProcessingException("Failed to get list of tiers for this cluster");
    }

    void tierMove(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.TierLookupResponse resp;
        String tierName = this.getTierName();
        String dbTopology = this.getDbTopologyParamValue();
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        if ((resp = TierCommands.tierLookup(cluster, this.getUserCredentials(), tierName)) == null || resp.hasStatus() && resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "tier " + tierName + " does not exist."));
            return;
        }
        String volumeName = resp.getTierProperties().getMetaVolumeName();
        LOG.info((Object)("Applying tier move operation for tier:" + tierName + ", meta volume name:" + volumeName + ", old topology:, new topology:" + dbTopology));
        CLDBProto.VolumeMoveResponse vmResp = VolumeCommands.sendVolumeMoveRequest(volumeName, dbTopology, null, null, cluster, this.getUserCredentials());
        if (vmResp == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "failed to move tier"));
            return;
        }
        if (vmResp.getStatus() == 0) {
            out.addMessage("moved tier successfully");
        } else {
            String errorMsg = "failed to move tier, " + (vmResp.hasErrMsg() ? vmResp.getErrMsg() : "");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(vmResp.getStatus(), errorMsg));
        }
    }

    public String getObjectTypeString(CLDBProto.ObjectStoreType objStore) {
        if (objStore == CLDBProto.ObjectStoreType.S3_AWS) {
            return S3_AWS;
        }
        if (objStore == CLDBProto.ObjectStoreType.S3_GCS) {
            return S3_GCS;
        }
        if (objStore == CLDBProto.ObjectStoreType.S3_HDS) {
            return S3_HDS;
        }
        if (objStore == CLDBProto.ObjectStoreType.S3_IBM) {
            return S3_IBM;
        }
        if (objStore == CLDBProto.ObjectStoreType.Azure_Blobs) {
            return Azure_Blobs;
        }
        if (objStore == CLDBProto.ObjectStoreType.S3_Others) {
            return S3_Others;
        }
        return "Invalid";
    }

    public CLDBProto.ObjectStoreType getObjectStoreType(String objectStoreType) {
        if (objectStoreType == null || objectStoreType == "") {
            return CLDBProto.ObjectStoreType.S3_AWS;
        }
        if (objectStoreType.equalsIgnoreCase(S3_AWS)) {
            return CLDBProto.ObjectStoreType.S3_AWS;
        }
        if (objectStoreType.equalsIgnoreCase(S3_GCS)) {
            return CLDBProto.ObjectStoreType.S3_GCS;
        }
        if (objectStoreType.equalsIgnoreCase(S3_HDS)) {
            return CLDBProto.ObjectStoreType.S3_HDS;
        }
        if (objectStoreType.equalsIgnoreCase(S3_IBM)) {
            return CLDBProto.ObjectStoreType.S3_IBM;
        }
        if (objectStoreType.equalsIgnoreCase(Azure_Blobs)) {
            return CLDBProto.ObjectStoreType.Azure_Blobs;
        }
        if (objectStoreType.equalsIgnoreCase(S3_Others)) {
            return CLDBProto.ObjectStoreType.S3_Others;
        }
        return null;
    }

    static {
        StringBuilder sb = new StringBuilder();
        for (String name : TierPropertiesFieldName) {
            if (sb.length() == 0) {
                sb.append(name);
                continue;
            }
            sb.append("|" + name);
        }
        supportedSortKeys = "<" + sb.toString() + ">";
        TierTypeName = new String[]{"cold", "ectier"};
        CompType = new String[]{"none", "lz4", "zlib"};
        LOG = Logger.getLogger(TierCommands.class);
        baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
        tierCreateParams = new ImmutableMap.Builder().put((Object)THROTTLING_PARAM_NAME, (Object)new BooleanInputParameter(THROTTLING_PARAM_NAME, "<true|false>", false, null).setInvisible(true)).put((Object)OBJSIZE_PARAM_NAME, (Object)new IntegerInputParameter(OBJSIZE_PARAM_NAME, "maximum size of object allowed", false, null).setInvisible(true)).put((Object)OBJECT_STORE_TYPE_PARAM_NAME, (Object)new TextInputParameter(OBJECT_STORE_TYPE_PARAM_NAME, "S3-AWS/S3-GCS/S3-HDS/S3-IBM/Azure-Blobs/S3-Others", false, null)).put((Object)CRED_STR_PARAM_NAME, (Object)new TextInputParameter(CRED_STR_PARAM_NAME, "tier credentials", false, null)).put((Object)DB_TOPOLOGY_PARAM_NAME, (Object)new TextInputParameter(DB_TOPOLOGY_PARAM_NAME, "db topology", false, null)).putAll(baseParams).build();
        tierModifyParams = new ImmutableMap.Builder().put((Object)THROTTLING_PARAM_NAME, (Object)new BooleanInputParameter(THROTTLING_PARAM_NAME, "<true|false>", false, null).setInvisible(true)).put((Object)OBJSIZE_PARAM_NAME, (Object)new IntegerInputParameter(OBJSIZE_PARAM_NAME, "maximum size of object allowed", false, null).setInvisible(true)).put((Object)AUTH_PARAM_NAME, (Object)new TextInputParameter(AUTH_PARAM_NAME, "tier credentials", false, null)).put((Object)OBJECT_STORE_TYPE_PARAM_NAME, (Object)new TextInputParameter(OBJECT_STORE_TYPE_PARAM_NAME, "S3-AWS/S3-GCS/S3-HDS/S3-IBM/Azure-Blobs/S3-Others", false, null)).put((Object)CRED_STR_PARAM_NAME, (Object)new TextInputParameter(CRED_STR_PARAM_NAME, "tier credentials", false, null)).put((Object)RW_TIER_PARAM_FORCE, (Object)new BooleanInputParameter(RW_TIER_PARAM_FORCE, "<true/false>", false, null)).put((Object)URL_PARAM_NAME, (Object)new TextInputParameter(URL_PARAM_NAME, "tier url", false, null)).putAll(baseParams).build();
        tierCreateCommand = new CLICommand("create", "", TierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)TIERNAME_PARAM_NAME, (Object)new TextInputParameter(TIERNAME_PARAM_NAME, "tier name", true, null)).put((Object)TYPE_PARAM_NAME, (Object)new TextInputParameter(TYPE_PARAM_NAME, "tier type cold/ectier", true, null)).put((Object)URL_PARAM_NAME, (Object)new TextInputParameter(URL_PARAM_NAME, "tier url", false, null)).put((Object)AUTH_PARAM_NAME, (Object)new TextInputParameter(AUTH_PARAM_NAME, "tier credentials", false, null)).putAll(tierCreateParams).build(), null).setShortUsage(tierCreateUsage);
        tierModifyCommand = new CLICommand("modify", "", TierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)TIERNAME_PARAM_NAME, (Object)new TextInputParameter(TIERNAME_PARAM_NAME, "tier name", true, null)).putAll(tierModifyParams).build(), null).setShortUsage(tierModifyUsage);
        tierMoveCommand = new CLICommand("move", "", TierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)TIERNAME_PARAM_NAME, (Object)new TextInputParameter(TIERNAME_PARAM_NAME, "tier name", true, null)).put((Object)DB_TOPOLOGY_PARAM_NAME, (Object)new TextInputParameter(DB_TOPOLOGY_PARAM_NAME, "db topology", true, null)).build(), null).setShortUsage(tierMoveUsage);
        tierListCommand = new CLICommand("list", "", TierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)SORTBY_PARAM_NAME, (Object)new TextInputParameter(SORTBY_PARAM_NAME, supportedSortKeys + ", column names of supported fields.", false, null)).put((Object)SORTING_ORDER_PARAM_NAME, (Object)new TextInputParameter(SORTING_ORDER_PARAM_NAME, "<asc|desc>", false, null)).build(), null).setShortUsage(tierListUsage);
        tierInfoCommand = new CLICommand("info", "", TierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)TIERNAME_PARAM_NAME, (Object)new TextInputParameter(TIERNAME_PARAM_NAME, "tier name", true, null)).putAll(baseParams).build(), null).setShortUsage(tierInfoUsage);
        tierRemoveCommand = new CLICommand("remove", "", TierCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)TIERNAME_PARAM_NAME, (Object)new TextInputParameter(TIERNAME_PARAM_NAME, "tier name", true, null)).putAll(baseParams).build(), null).setShortUsage(tierRemoveUsage);
        tierCommands = new CLICommand("tier", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{tierCreateCommand, tierModifyCommand, tierRemoveCommand, tierListCommand, tierInfoCommand, tierMoveCommand, OffloadRuleCommands.ruleCommands}).setShortUsage("tier [create|modify|remove|info|list|rule|move]");
    }

    static enum TierPropertiesField {
        id,
        n,
        typ,
        url,
        thr,
        bn,
        reg,
        objtype,
        metavol,
        dbtopo,
        dbvolid;

    }
}

