/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.NodeServicesManagementCommand;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class InsightCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(NodeServicesManagementCommand.class);
    public static final int MAX_CHARS_COUNT = 60;
    public static final String INSIGHT_PARAM = "insight";
    public static final String SETCONFIG_PARAM = "cluster";
    public static final String STATUS_PARAM = "info";
    public static final String PURGE_PARAM = "purge";
    public static final String ENABLE_PARAM = "enable";
    public static final String TRIALMODE_PARAM = "trialmode";
    public static final String NODES_PARAM = "nodes";
    public static final String TYPE_PARAM = "type";
    public static final String RETENTION_DAYS_PARAM = "retentionDays";
    public static final String INSIGHT_USAGE = "insight [cluster | info | purge]";
    public static final String SETCONFIG_USAGE = "cluster -enable <true|false>[-node <name> | -type [mfs|s3|auth|cldb] ] ";
    public static final String STATUS_USAGE = "info [-node <name> | -type [mfs|s3|auth|cldb] ] -purge <true|false>";
    public static final String PURGE_USAGE = "purge [-retentionDays <nDays>]";
    public static final String MODE_USAGE = "-trialmode <true|false>";
    public static final CLICommand setConfigCommand = new CLICommand("cluster", "insight cluster config command ", InsightCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"enable", (Object)new TextInputParameter("enable", "set true/false", false, null)).put((Object)"trialmode", (Object)new TextInputParameter("trialmode", "set true/false", false, null).setInvisible(true)).put((Object)"nodes", (Object)new TextInputParameter("nodes", "node names space separated ", false, null)).put((Object)"type", (Object)new TextInputParameter("type", "audit type [mfs, s3, auth, cldb] ", false, null)).build(), null).setShortUsage("cluster -enable <true|false>[-node <name> | -type [mfs|s3|auth|cldb] ] ");
    public static final CLICommand statusCommand = new CLICommand("info", "insight info command ", InsightCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"nodes", (Object)new TextInputParameter("nodes", "node names space separated ", false, null)).put((Object)"type", (Object)new TextInputParameter("type", "audit type [mfs, s3, auth, cldb] ", false, null)).put((Object)"purge", (Object)new TextInputParameter("purge", "true/false", false, null)).build(), null).setShortUsage("info [-node <name> | -type [mfs|s3|auth|cldb] ] -purge <true|false>");
    public static final CLICommand purgeCommand = new CLICommand("purge", "insight purge command ", InsightCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"retentionDays", (Object)new IntegerInputParameter("retentionDays", "set retention days", false, null)).build(), null).setShortUsage("purge [-retentionDays <nDays>]");
    public static final CLICommand insightCommands = new CLICommand("insight", "insight [cluster | info]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{setConfigCommand, statusCommand, purgeCommand}).setShortUsage("insight [cluster | info | purge]");

    public InsightCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        if (!super.validateInput()) {
            output.setOutput(out);
            return output;
        }
        String command = this.cliCommand.getCommandName();
        if (command.equalsIgnoreCase(SETCONFIG_PARAM)) {
            try {
                return this.processSetConfig();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (command.equalsIgnoreCase(STATUS_PARAM)) {
            try {
                return this.processGetStatus();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (command.equalsIgnoreCase(PURGE_PARAM)) {
            try {
                return this.processPurge();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        return new TextCommandOutput(("Insight command failed: unknown command " + command + " received.").getBytes());
    }

    CommandOutput processSetConfig() throws CLIProcessingException {
        CLDBProto.InsightConfigUpdateRequest.Builder req;
        CommandOutput.OutputHierarchy out;
        CommandOutput output;
        block16: {
            output = new CommandOutput();
            out = new CommandOutput.OutputHierarchy();
            output.setOutput(out);
            req = CLDBProto.InsightConfigUpdateRequest.newBuilder();
            if (!this.isParamPresent(ENABLE_PARAM) && !this.isParamPresent(TRIALMODE_PARAM)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing enable option. Check usage"));
                return output;
            }
            if (this.isParamPresent(ENABLE_PARAM) && this.isParamPresent(TRIALMODE_PARAM)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Both enable and trialmode can be present at same time"));
                return output;
            }
            boolean trialModeCfg = false;
            boolean trialMode = false;
            boolean enable = false;
            if (this.isParamPresent(TRIALMODE_PARAM)) {
                trialModeCfg = true;
                trialMode = this.getParamTextValue(TRIALMODE_PARAM, 0).equalsIgnoreCase("true");
            } else {
                boolean bl = enable = this.getParamTextValue(ENABLE_PARAM, 0).equalsIgnoreCase("true");
                if (!this.isValidParamCombination(out)) {
                    return output;
                }
            }
            try {
                if (trialModeCfg) {
                    CLDBProto.InsightConfig.Builder config = CLDBProto.InsightConfig.newBuilder();
                    req.setCreds(this.getUserCredentials());
                    config.setTrialModeEnabled(trialMode);
                    req.setInsightGlobalConfig(config.build());
                    break block16;
                }
                if (this.isGlobalConfig()) {
                    List<String> inputTypesList = this.prepareParamValueList(TYPE_PARAM);
                    inputTypesList = this.verifyTypes(inputTypesList, out);
                    CLDBProto.InsightConfig.Builder config = CLDBProto.InsightConfig.newBuilder();
                    req.setCreds(this.getUserCredentials());
                    config.setEnabled(enable);
                    this.populateTypeConfig(inputTypesList, config, enable);
                    req.setInsightGlobalConfig(config.build());
                    break block16;
                }
                List<String> inputNodeList = this.prepareParamValueList(NODES_PARAM);
                List<String> inputTypeList = new ArrayList<String>();
                try {
                    inputNodeList = this.verifyNodes(inputNodeList, out);
                    inputTypeList = this.verifyTypes(inputTypeList, out);
                }
                catch (Exception e) {
                    return output;
                }
                req.setCreds(this.getUserCredentials());
                this.populateConfig(req, inputNodeList, inputTypeList, enable, out);
            }
            catch (CLIProcessingException e) {
                LOG.error((Object)("Exception during set config " + e));
                throw new CLIProcessingException("Unable to parse request.", (Throwable)e);
            }
        }
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.InsightConfigUpdateProc.getNumber(), (MessageLite)req.build(), CLDBProto.InsightConfigUpdateResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.InsightConfigUpdateResponse resp = CLDBProto.InsightConfigUpdateResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                out.addMessage("Updated insight Config Successfully. ");
                return output;
            }
            String errorMsg = "Unable to update insight Config " + (resp.hasErrMsg() ? resp.getErrMsg() : "");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errorMsg));
            return output;
        }
        catch (CLIProcessingException e) {
            LOG.error((Object)("Exception during set config " + e));
            throw new CLIProcessingException("CLIProcessingException " + e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            LOG.error((Object)("Exception during set config " + e.getMessage()));
            return output;
        }
    }

    CommandOutput processGetStatus() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        CLDBProto.InsightStatusRequest.Builder req = CLDBProto.InsightStatusRequest.newBuilder();
        if (!this.isValidParamCombination(out)) {
            return output;
        }
        List<String> inputNodeList = this.prepareParamValueList(NODES_PARAM);
        List<String> inputTypeList = this.prepareParamValueList(TYPE_PARAM);
        boolean needPurge = false;
        boolean purgeOptionEn = false;
        boolean typeOptionEn = false;
        boolean nodeOptionEn = false;
        if (this.isParamPresent(PURGE_PARAM)) {
            needPurge = this.getParamTextValue(PURGE_PARAM, 0).equalsIgnoreCase("true");
            for (CLDBProto.InsightTypeConfig.InsightType type : CLDBProto.InsightTypeConfig.InsightType.values()) {
                inputTypeList.add(type.name());
            }
            purgeOptionEn = true;
        }
        try {
            if (this.isParamPresent(NODES_PARAM)) {
                inputNodeList = this.verifyNodes(inputNodeList, out);
                nodeOptionEn = true;
            } else if (this.isParamPresent(TYPE_PARAM)) {
                inputTypeList = this.verifyTypes(inputTypeList, out);
                typeOptionEn = true;
            } else if (!this.isParamPresent(PURGE_PARAM)) {
                needPurge = true;
                for (CLDBProto.InsightTypeConfig.InsightType type : CLDBProto.InsightTypeConfig.InsightType.values()) {
                    inputTypeList.add(type.name());
                }
            }
        }
        catch (Exception e) {
            return output;
        }
        req.setCreds(this.getUserCredentials());
        req.addAllNodes(inputNodeList);
        req.addAllTypes(this.prepareTypes(inputTypeList));
        req.setNeedPurge(needPurge);
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.InsightStatusProc.getNumber(), (MessageLite)req.build(), CLDBProto.InsightStatusResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.InsightStatusResponse resp = CLDBProto.InsightStatusResponse.parseFrom((byte[])data);
            if (resp.getStatus() != 0) {
                String errorMsg = "Unable to get insight status " + (resp.hasErrMsg() ? resp.getErrMsg() : "");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errorMsg));
                return output;
            }
            this.processStatusOutput(nodeOptionEn, typeOptionEn, purgeOptionEn, resp, out);
        }
        catch (CLIProcessingException e) {
            LOG.error((Object)("Exception during get insight status " + e));
            throw new CLIProcessingException("CLIProcessingException " + e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            LOG.error((Object)("Exception during get insight status " + e.getMessage()));
        }
        return output;
    }

    boolean isGlobalConfig() {
        return !this.isParamPresent(NODES_PARAM);
    }

    boolean isValidParamCombination(CommandOutput.OutputHierarchy out) {
        if (this.isParamPresent(NODES_PARAM) && this.isParamPresent(TYPE_PARAM)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Both -nodes and -types cannot be provided simultaneously. Check usage"));
            return false;
        }
        return true;
    }

    List<String> verifyNodes(List<String> inputNodeList, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        if (inputNodeList == null || inputNodeList.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Nodes not found"));
            throw new CLIProcessingException("Nodes not found.");
        }
        String zkConnectString = CLDBRpcCommonUtils.getInstance().getZkConnect();
        if (zkConnectString == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "Unable to obtain the ZooKeeper connection string"));
            throw new CLIProcessingException("Unable to fetch Cluster details.");
        }
        List<Object> inputHostList = new ArrayList();
        try {
            inputHostList = this.getHostList(inputNodeList, zkConnectString, out);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Error Fetching HostNames for nodes");
        }
        if (inputHostList.isEmpty()) {
            StringBuilder outputErrorParams = new StringBuilder(inputHostList.toString());
            if (outputErrorParams.length() > 60) {
                outputErrorParams.delete(61, outputErrorParams.length());
                outputErrorParams.append("...");
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10008, "Input for nodes: " + outputErrorParams.toString() + " does not match the IP address or hostname of any cluster nodes"));
            LOG.error((Object)("Input for nodes: " + outputErrorParams.toString() + " does not match the IP address or hostname of any cluster nodes."));
            throw new CLIProcessingException("Input IP address or hostname does not match any cluster nodes");
        }
        Map<String, Common.ServiceData> insightServiceData = NodesCommonUtils.getServiceNodeData(zkConnectString, INSIGHT_PARAM, "");
        if (insightServiceData == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Insight Service not found on cluster"));
            throw new CLIProcessingException("Insight Service not found on cluster");
        }
        insightServiceData.remove("master");
        ArrayList<String> hostList = new ArrayList<String>();
        for (Common.ServiceData serviceData : insightServiceData.values()) {
            String host = null;
            if (serviceData.hasHost()) {
                host = serviceData.getHost();
            }
            if (host == null) continue;
            hostList.add(host);
        }
        for (String string : inputHostList) {
            if (hostList.contains(string)) continue;
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Input host not found." + string));
            throw new CLIProcessingException("Insight Service not found on Host: " + string);
        }
        return inputHostList;
    }

    List<String> verifyTypes(List<String> inputTypesList, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        ArrayList<String> typeList = new ArrayList<String>();
        if (inputTypesList.size() > CLDBProto.InsightTypeConfig.InsightType.values().length) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Types count should be less than :" + CLDBProto.InsightTypeConfig.InsightType.values().length + "1"));
            throw new CLIProcessingException("Types count should be less than :" + CLDBProto.InsightTypeConfig.InsightType.values().length + "1");
        }
        for (String inputType : inputTypesList) {
            CLDBProto.InsightTypeConfig.InsightType matchedType = null;
            for (CLDBProto.InsightTypeConfig.InsightType type : CLDBProto.InsightTypeConfig.InsightType.values()) {
                if (!inputType.equalsIgnoreCase(type.name())) continue;
                matchedType = type;
                break;
            }
            if (matchedType == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Type not found: " + inputType));
                throw new CLIProcessingException("Type not found.");
            }
            typeList.add(matchedType.name());
        }
        if (inputTypesList.isEmpty()) {
            for (CLDBProto.InsightTypeConfig.InsightType type : CLDBProto.InsightTypeConfig.InsightType.values()) {
                typeList.add(type.name());
            }
        }
        return typeList;
    }

    List<String> prepareParamValueList(String PARAM) {
        ArrayList<String> valueList = new ArrayList<String>();
        List inputList = new ArrayList();
        if (this.isParamPresent(PARAM)) {
            inputList = this.input.getParameterByName(PARAM).getParamValues();
        }
        for (String input : inputList) {
            if (input.contains(",")) {
                valueList.addAll(Arrays.asList(input.split(",")));
                continue;
            }
            valueList.add(input);
        }
        return valueList;
    }

    void populateTypeConfig(List<String> inputTypeList, CLDBProto.InsightConfig.Builder config, boolean enabled) {
        block0: for (String type : inputTypeList) {
            CLDBProto.InsightTypeConfig.Builder typeBuilder = CLDBProto.InsightTypeConfig.newBuilder();
            for (CLDBProto.InsightTypeConfig.InsightType insightType : CLDBProto.InsightTypeConfig.InsightType.values()) {
                if (!type.equalsIgnoreCase(insightType.name())) continue;
                typeBuilder.setInsightType(insightType);
                typeBuilder.setEnabled(enabled);
                config.addTypeConfig(typeBuilder);
                continue block0;
            }
        }
    }

    List<CLDBProto.InsightTypeConfig.InsightType> prepareTypes(List<String> inputTypeList) {
        ArrayList<CLDBProto.InsightTypeConfig.InsightType> typeList = new ArrayList<CLDBProto.InsightTypeConfig.InsightType>();
        for (String typeStr : inputTypeList) {
            try {
                CLDBProto.InsightTypeConfig.InsightType type = CLDBProto.InsightTypeConfig.InsightType.valueOf((String)typeStr);
                typeList.add(type);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)("Invalid Type Found : " + typeStr), (Throwable)e);
            }
        }
        return typeList;
    }

    void populateConfig(CLDBProto.InsightConfigUpdateRequest.Builder req, List<String> inputNodeList, List<String> inputTypeList, boolean enabled, CommandOutput.OutputHierarchy out) {
        for (String host : inputNodeList) {
            CLDBProto.InsightConfig.Builder config = CLDBProto.InsightConfig.newBuilder();
            config.setNodeName(host);
            this.populateTypeConfig(inputTypeList, config, enabled);
            req.addInsightNodeConfig(config.build());
        }
    }

    CommandOutput processPurge() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        CLDBProto.InsightPurgeRequest.Builder req = CLDBProto.InsightPurgeRequest.newBuilder();
        if (!this.isParamPresent(RETENTION_DAYS_PARAM)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "retention days parameter is missing"));
            LOG.error((Object)"RETENTION_DAYS_PARAM Absent");
            return output;
        }
        int retention = this.getParamIntValue(RETENTION_DAYS_PARAM, 0);
        req.setRetentionDays(retention);
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.InsightPurgeProc.getNumber(), (MessageLite)req.build(), CLDBProto.InsightPurgeResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.InsightPurgeResponse resp = CLDBProto.InsightPurgeResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                out.addMessage("Set insight purge configuration Successfully. ");
                return output;
            }
            String errorMsg = "Unable to set purge config " + (resp.hasErrMsg() ? resp.getErrMsg() : "");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errorMsg));
            return output;
        }
        catch (CLIProcessingException e) {
            LOG.error((Object)("Exception during set purge config " + e));
            throw new CLIProcessingException("CLIProcessingException " + e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            LOG.error((Object)("Exception during set purge config " + e.getMessage()));
            return output;
        }
    }

    public static String epochMillisToStr(long epochTimeMillis) {
        if (epochTimeMillis == 0L) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS 'GMT'Z");
        dateFormat.setTimeZone(TimeZone.getDefault());
        String formattedDateTime = dateFormat.format(new Date(epochTimeMillis));
        return formattedDateTime;
    }

    void processStatusOutput(boolean nodeOptionEn, boolean typeOptionEn, boolean purgeOptionEn, CLDBProto.InsightStatusResponse resp, CommandOutput.OutputHierarchy out) {
        boolean allOptionEn;
        List nodeStatusList = resp.getNodeStatusList();
        CLDBProto.InsightStatus purgeStatus = resp.getPurgeStatus();
        CommandOutput.OutputHierarchy.OutputNode status = new CommandOutput.OutputHierarchy.OutputNode("status");
        CommandOutput.OutputHierarchy.OutputNode nodes = new CommandOutput.OutputHierarchy.OutputNode(NODES_PARAM);
        CommandOutput.OutputHierarchy.OutputNode purge = new CommandOutput.OutputHierarchy.OutputNode(PURGE_PARAM);
        CommandOutput.OutputHierarchy.OutputNode cluster = new CommandOutput.OutputHierarchy.OutputNode(SETCONFIG_PARAM);
        String insightMode = resp.getInsightMode();
        status.addChild(new CommandOutput.OutputHierarchy.OutputNode("insight mode", (Object)insightMode));
        status.addNode(cluster);
        boolean bl = allOptionEn = !nodeOptionEn && !typeOptionEn && !purgeOptionEn;
        if (!purgeOptionEn) {
            status.addNode(nodes);
        }
        if (allOptionEn || purgeOptionEn) {
            status.addNode(purge);
        }
        CLDBProto.InsightConfig clusterConfig = resp.getClusterConfig();
        for (CLDBProto.InsightTypeConfig typeConfig : clusterConfig.getTypeConfigList()) {
            cluster.addChild(new CommandOutput.OutputHierarchy.OutputNode(typeConfig.getInsightType().name().toLowerCase(), (Object)typeConfig.getEnabled()));
        }
        for (CLDBProto.InsightStatus nodeStatus : nodeStatusList) {
            CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode(nodeStatus.getNodeName());
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode("enabled", (Object)nodeStatus.getConfigEnabled()));
            for (CLDBProto.InsightTypeStatus typeStatus : nodeStatus.getTypeStatusList()) {
                CommandOutput.OutputHierarchy.OutputNode insightType = new CommandOutput.OutputHierarchy.OutputNode(typeStatus.getInsightType().name().toLowerCase());
                node.addChild(insightType);
                insightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("running", (Object)typeStatus.getRunning()));
                if (typeStatus.hasStatus()) {
                    insightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("status", typeStatus.getStatus()));
                }
                if (typeStatus.hasErrMsg()) {
                    insightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("errorMsg", (Object)typeStatus.getErrMsg()));
                }
                if (typeStatus.hasLastCommitTime()) {
                    long epochTimeMillis = typeStatus.getLastCommitTime();
                    String formattedDateTime = InsightCommands.epochMillisToStr(epochTimeMillis);
                    insightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("lastCommitTime", (Object)formattedDateTime));
                } else {
                    insightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("lastCommitTime", (Object)""));
                }
                if (!typeStatus.getRunning()) continue;
                CommandOutput.OutputHierarchy.OutputNode purgeInsightType = new CommandOutput.OutputHierarchy.OutputNode(typeStatus.getInsightType().name().toLowerCase());
                purgeInsightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("node", (Object)nodeStatus.getNodeName()));
                if (typeStatus.getLastExpiryAttemptTime() != 0L) {
                    purgeInsightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("attemptTime", (Object)InsightCommands.epochMillisToStr(typeStatus.getLastExpiryAttemptTime())));
                } else {
                    purgeInsightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("attemptTime", (Object)""));
                }
                if (typeStatus.getLastExpirySuccessTime() != 0L) {
                    purgeInsightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("finishTime", (Object)InsightCommands.epochMillisToStr(typeStatus.getLastExpirySuccessTime())));
                } else {
                    purgeInsightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("finishTime", (Object)""));
                }
                if (typeStatus.getLastExpirySnapEpochTime() != 0L) {
                    purgeInsightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapsEpoch", (Object)InsightCommands.epochMillisToStr(typeStatus.getLastExpirySnapEpochTime())));
                } else {
                    purgeInsightType.addChild(new CommandOutput.OutputHierarchy.OutputNode("snapsEpoch", (Object)""));
                }
                purge.addChild(purgeInsightType);
            }
            nodes.addChild(node);
        }
        if (purgeStatus.hasPurgeConfig() && purgeStatus.getPurgeConfig().hasRetentionDays()) {
            purge.addChild(new CommandOutput.OutputHierarchy.OutputNode(RETENTION_DAYS_PARAM, purgeStatus.getPurgeConfig().getRetentionDays()));
        }
        out.addNode(status);
    }

    List<String> getHostList(List<String> nodeHostNames, String zkConnectString, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        List<String> nodes = NodesCommonUtils.findNodeIps(zkConnectString, "");
        if (nodeHostNames == null || nodeHostNames.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10008, "No nodes matched input parameters"));
            throw new CLIProcessingException("No nodes matched input parameters");
        }
        List<String> nodeNames = NodesCommonUtils.convertHostToIpIncludingLocal(nodeHostNames);
        nodeNames.addAll(NodesCommonUtils.convertIpToHost(nodeHostNames));
        nodeNames.addAll(nodeHostNames);
        HashSet<String> nodeNamesSet = new HashSet<String>(nodeNames);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NodeNamesSet: " + nodeNamesSet));
        }
        nodeNamesSet.removeAll(nodes);
        nodeNames.removeAll(nodeNamesSet);
        HashSet<String> nodeNamesUnique = new HashSet<String>(nodeNames);
        ArrayList<String> UniqueHostList = new ArrayList<String>(nodeNamesUnique);
        return UniqueHostList;
    }
}

