/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.utils.Util;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.NoValueInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.cliframework.util.FilterUtil;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cli.proto.CLIProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.log4j.Logger;

public class ClusterGroupCommands
extends ListCommand
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(ClusterGroupCommands.class);
    public static final String CONF_FILE = "/opt/mapr/conf/mapr-clusters.conf";
    public static final String TICKET_FILE = "/opt/mapr/conf/maprserverticket";
    public static final String TMP_CONF_FILE = "/tmp/conf.file";
    public static final String TMP_TICKET_FILE = "/tmp/ticket.file";
    public static final String NFS_EXPORT_FILE = "/opt/mapr/conf/exports";
    public static final String CLUSTERGROUP_COMMAND_SETPRIMARY = "setprimary";
    public static final String CLUSTERGROUP_COMMAND_UPDATEPRIMARY = "updateprimary";
    public static final String CLUSTERGROUP_COMMAND_LIST = "list";
    public static final String CLUSTERGROUP_COMMAND_GET_CG_TABLE = "getcgtable";
    public static final String CLUSTERGROUP_COMMAND_REMOVE = "remove";
    public static final String CLUSTERGROUP_COMMAND_ADD_EXTERNAL = "addexternal";
    public static final String CLUSTERGROUP_COMMAND_UPDATE_S3_USER = "updates3user";
    public static final String CLUSTERGROUP_COMMAND_SETUPGRADE = "setupgrade";
    public static final String CLUSTERGROUP_COMMAND_SHOW_CLUSTER_CERT = "showclustercert";
    public static final String CLUSTERGROUP_COMMAND_FETCH_CHAIN_CA = "fetchchainca";
    public static final String CLUSTERGROUP_COMMAND_GET_NFS_EXPORTS = "getnfsexports";
    public static final String CLUSTERGROUP_COMMAND_GENERATE_CLUSTER_CONF = "generateclusterconf";
    public static final String CLUSTERGROUP_COMMAND_S3GNS = "s3gns";
    public static final String CLUSTERGROUP_COMMAND_RESTORE_TABLE = "restoretable";
    public static final String CLUSTERGROUP_COMMAND_GLOBALPOLICYIAM = "globaliampolicyserver";
    public static final String TABLEPATH_PARAM = "table";
    public static final String ALLTABLES_PARAM = "all";
    public static final String RESTORE_FORCE_PARAM = "force";
    public static final String CLUSTERNAME_PARAM = "clustername";
    public static final String ALLCLUSTERS_PARAM = "allclusters";
    public static final String SHOW_PRIMARY_PARAM = "showprimary";
    public static final String CLDBIPS_PARAM = "cldbips";
    public static final String CLDBEXTIPS_PARAM = "cldbextips";
    public static final String APIIPS_PARAM = "apiips";
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String CROSSCLUSTER_TICKET_PARAM = "crossclusterticket";
    public static final String CCTK_FILEPATH_PARAM = "cctktfilepath";
    public static final String EXTERNAL_SERVER_TYPE_PARAM = "type";
    public static final String EXTERNAL_SERVER_NAME_PARAM = "externalservername";
    public static final String EXTERNAL_SERVER_IPS_PARAM = "ips";
    public static final String EXTERNAL_SERVER_IPS_SKIP_CHECK = "force";
    public static final String EXTERNAL_SERVER_ACCESSKEY_PARAM = "accesskey";
    public static final String EXTERNAL_SERVER_SECRETEKEY_PARAM = "secretkey";
    public static final String EXTERNAL_SERVER_S3VENDOR = "s3vendor";
    public static final String EXTERNAL_SERVER_AWSREGION = "awsregion";
    public static final String EXTERNAL_SERVER_GCPREGION = "gcpregion";
    public static final String EXTERNAL_SERVER_AWS_WEBIDROLE_ARN = "awswebidrolearn";
    private static final String SETUPGRADE_STATUS_PARAM = "status";
    public static final String EXTERNAL_SERVER_S3TLS = "s3usetlsencryption";
    public static final String EXTERNAL_SERVER_S3CERT = "s3servercertfile";
    public static final String EXTERNAL_SERVER_S3CERTPATH = "s3servercertfilepath";
    public static final String EXTERNAL_SERVER_S3PORT = "s3serverport";
    public static final String EXTERNAL_SERVER_S3PROTO = "s3servertransferproto";
    public static final String EXTERNAL_SERVER_S3_ACCESSORUSERS = "accessorusers";
    public static final String EXTERNAL_SERVER_S3_ACCESSORGROUPS = "accessorgroups";
    public static final String EXTERNAL_SERVER_S3_OWNER = "owner";
    public static final String EXTERNAL_SERVER_S3_USER_ACTION = "action";
    public static final String FILTER_PARAM_NAME = "filter";
    public static final String SORTBY_PARAM_NAME = "sortby";
    public static final String SORTING_ORDER_PARAM_NAME = "sortorder";
    public static final String ASCENDING_SORTING_ORDER_PARAM_NAME = "asc";
    public static final String DESCENDING_SORTING_ORDER_PARAM_NAME = "desc";
    public static final String SORT_DIRECTION_PARAM_NAME = "dir";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    public static final String LICENSE_INFO_PARAM_NAME = "getlicenseinfo";
    private static final int NUM_ENTRIES_PER_RPC = 100;
    private static final boolean DEBUG_SERVERTICKET = false;
    private static final String S3HTTPSMODE_PARAM = "httpsmode";
    private static final String S3GNS_ENABLED = "enables3gns";
    private static final String GLOBALPOLICYIAM_ENABLE_PARAM = "enable";
    public static final String clusterGroupCommandsUsage = "clustergroup [setprimary|updateprimary|remove|getcgtable|addexternal|getnfsexports|s3gns|updates3user|globaliampolicyserver]";
    public static final String ClusterGroupSetPrimaryUsage = "clustergroup setprimary -clustername <cluster name of the primary> -cldbips \"hostname1:port1,hostname2:port2,....\"  of the primary-cldbextips \"hostname1:port1,hostname2:port2,....\"  of the primary-crossclusterticket \"<ticket>\" of the primarySet the given cluster as cluster group primary of the current cluster and also add the cluster in cluster group.";
    public static final String ClusterGroupUpdatePrimaryUsage = "clustergroup updateprimary -clustername <cluster name of the new primary> updates given cluster in cluster group as cluster group primary";
    public static final String ClusterGroupRemoveUsage = "clustergroup remove -clustername <cluster name> removes given cluster from cluster group";
    public static final String ClusterGroupListUsage = "clustergroup list";
    public static final String ClusterGroupGetCgTableUsage = "clustergroup getcgtable [-clustername <clustername>] [-getlicenseinfo <true/false>]";
    public static final String ClusterGroupGenerateClusterConfUsage = "clustergroup generateclusterconf";
    public static final String ClusterGroupSetUpgradeUsage = "clustergroup setupgrade [-status <upgrade-state>] [-clustername <clustername>]";
    public static final String ClusterGroupAddExternalUsage = "clustergroup addexternal -type <type of external server> NFS/S3-ips comma seperated list of external servers-externalservername external nfs server name";
    public static final String ClusterGroupGetNfsExportsUsage = "-externalservername external nfs server name";
    public static final String ClusterGroupUpdateS3UserUsage = "clustergroup updates3user -externalservername external s3 server name -action addaccessors|removeaccessors|updateowner -owneruid uid -accessorusers comma separated list of accessor users -accessorgroups comma separated list of accessor groups updateowner action need owner param only and addaccessors/removeaccessors action need atleast one of accessorusers or accessorgroups";
    public static final String ClusterGroupS3GNSUsage = "clustergroup s3gns [-httpsmode <forward/redirect>]";
    public static final String ClusterGroupGlobalIAMPolicyServerUsage = "clustergroup globaliampolicyserver [-enable <true/false>]";
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
    public static Map<CLDBProto.ClusterGroupConfInfoFields, FieldInfo> fieldTable = new ImmutableMap.Builder().put((Object)CLDBProto.ClusterGroupConfInfoFields.cname, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.cname.getNumber(), "cn", "clustername", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.clustergroupprimary, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.clustergroupprimary.getNumber(), "cgm", "clustergroupprimary", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.clusterid, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.clusterid.getNumber(), "ci", "clusterid", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.cldbip, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.cldbip.getNumber(), "cip", "cldbips", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.apiip, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.apiip.getNumber(), "aip", "apiips", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.ccticket, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.ccticket.getNumber(), "cct", "crossclusterticket", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.srvrticket, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.srvrticket.getNumber(), "srt", "serverticket", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.externalservername, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.externalservername.getNumber(), "ensn", "externalnfsservername", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.ips, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.ips.getNumber(), "ensips", "externalnfsserverips", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.extservertype, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.extservertype.getNumber(), "est", "externalservertype", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.clusterupgradestate, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.clusterupgradestate.getNumber(), "cus", "clusterupgradestate", Integer.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.clusterlocation, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.clusterlocation.getNumber(), "cl", "clusterlocation", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.clusterowner, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.clusterowner.getNumber(), "co", "clusterowner", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.installtype, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.installtype.getNumber(), "cit", "installtype", Integer.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.mossservers, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.mossservers.getNumber(), "s3ips", "mossips", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.gatewayips, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.gatewayips.getNumber(), "gwips", "gatewayips", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.s3vendor, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.s3vendor.getNumber(), "s3vdr", "s3vendor", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.awsregion, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.awsregion.getNumber(), "awsr", "awsregion", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.gcpregion, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.gcpregion.getNumber(), "gcpr", "gcpregion", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.numexports, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.numexports.getNumber(), "numex", "numexports", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.exportpath, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.exportpath.getNumber(), "expt", "exportpath", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.exportsize, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.exportsize.getNumber(), "exps", "size", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.exportused, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.exportused.getNumber(), "exps", "used", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.exportavail, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.exportavail.getNumber(), "expa", "avail", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.licenseinfo, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.licenseinfo.getNumber(), "ae", "licenseinfo", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.s3gnshttpsmode, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.s3gnshttpsmode.getNumber(), "hsm", "s3gnshttpsmode", Integer.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.enables3gns, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.enables3gns.getNumber(), "esg", "enables3gns", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.cldbextip, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.cldbextip.getNumber(), "cexip", "cldbextips", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.enableglobaliampolicyserver, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.enableglobaliampolicyserver.getNumber(), "egiamps", "enableglobaliampolicyserver", String.class)).build();
    private static int MAX_XCLUSTERCONFINFOFIELD = 0;
    static String supportedSortKeys;
    private static Map<String, CLDBProto.ListSortKey> nameToEnumMap;
    public static final CLICommand ClusterGroupSetPrimaryCommand;
    public static final CLICommand ClusterGroupUpdatePrimaryCommand;
    public static final CLICommand ClusterGroupS3Command;
    public static final CLICommand ClusterGroupGlobalIAMPolicyServerCommand;
    public static final CLICommand ClusterGroupRemoveCommand;
    public static final CLICommand ClusterGroupAddExternalCommand;
    public static final CLICommand ClusterGroupGetCgTableCommand;
    public static final CLICommand ClusterGroupSetUpgradeCommand;
    public static final CLICommand ClusterGroupShowClusterCertCommand;
    public static final CLICommand ClusterGroupFetchChainCaCommand;
    public static final CLICommand ClusterGroupGenerateClusterConfCommand;
    public static final CLICommand ClusterGroupListCommand;
    public static final CLICommand ClusterGroupGetNfsExportsCommand;
    public static final CLICommand ClusterGroupUpdateS3UserCommand;
    public static final String ClusterGroupRestoreTableUsage = "-restoretable [-table tablepath] table to be restored [-all] restore all tables [-force] overwrite existing table with backup(if backup exists)";
    public static final CLICommand ClusterGroupRestoreTableCommand;
    public static final CLICommand[] clusterGroupCommands;

    public ClusterGroupCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String commandName = this.cliCommand.getCommandName().toLowerCase(Locale.ENGLISH);
        try {
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_SETPRIMARY)) {
                return this.setClusterGroupPrimary();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_UPDATEPRIMARY)) {
                return this.updateClusterGroupPrimary();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_REMOVE)) {
                return this.removeServer();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_LIST)) {
                return this.listClusterGroupConfs();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_GET_CG_TABLE)) {
                return this.listClusterGroupConfs();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_ADD_EXTERNAL)) {
                return this.addExternal();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_SETUPGRADE)) {
                return this.setUpgrade();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_SHOW_CLUSTER_CERT)) {
                return this.showClusterCert();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_FETCH_CHAIN_CA)) {
                return this.fetchChainCa();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_GET_NFS_EXPORTS)) {
                return this.getNfsExports();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_GENERATE_CLUSTER_CONF)) {
                return this.GenerateClusterConf();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_S3GNS)) {
                return this.s3GNSCommand();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_GLOBALPOLICYIAM)) {
                return this.gloabalIAMPolicyServerCommand();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_RESTORE_TABLE)) {
                return this.restoreTable();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_UPDATE_S3_USER)) {
                return this.updateS3User();
            }
            return new TextCommandOutput("clusterGroup command failed".getBytes());
        }
        catch (MaprSecurityException e) {
            LOG.error((Object)("MaprSecurityException in command: " + commandName + " exception: " + e));
            throw new CLIProcessingException("MaprSecurityException...", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("clusterGroup command " + commandName + "failed, exception: " + e));
            throw new CLIProcessingException("MaprSecurityException...", (Throwable)e);
        }
    }

    CommandOutput restoreTable() throws Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        if (!this.isParamPresent(TABLEPATH_PARAM) && !this.isParamPresent(ALLTABLES_PARAM)) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "invalid use: one of table or all must be supplied."));
            return output;
        }
        if (this.isParamPresent(TABLEPATH_PARAM) && this.isParamPresent(ALLTABLES_PARAM)) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "invalid use: either table or all should be supplied."));
            return output;
        }
        boolean force = this.isParamPresent("force") ? this.getParamBooleanValue("force", 0) : false;
        CLDBProto.ClusterGroupRestoreTableRequest.Builder req = CLDBProto.ClusterGroupRestoreTableRequest.newBuilder().setCreds(this.getUserCredentials());
        if (this.isParamPresent(TABLEPATH_PARAM)) {
            req.setTable(this.getParamTextValue(TABLEPATH_PARAM, 0));
        }
        if (this.isParamPresent(ALLTABLES_PARAM)) {
            req.setRestoreAllTables(true);
        }
        if (this.isParamPresent("force")) {
            req.setForce(this.getParamBooleanValue("force", 0));
        }
        LOG.debug((Object)("restoreTable: req:" + req.toString()));
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterGroupRestoreTableProc.getNumber(), (MessageLite)req.build(), CLDBProto.ClusterGroupRestoreTableResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.ClusterGroupRestoreTableResponse resp = CLDBProto.ClusterGroupRestoreTableResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                if (this.isParamPresent(TABLEPATH_PARAM)) {
                    oh.addMessage("Successfully restored table '" + this.getParamTextValue(TABLEPATH_PARAM, 0) + "'.");
                } else {
                    oh.addMessage("Successfully restored all tables");
                }
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
        return output;
    }

    private String getCldbIpsZigZag(CLDBProto.ClusterGroupConf clusterGroupConf) {
        int i;
        Object cldbIpsStr = new String();
        String[] cldbIps = new String[]{};
        String[] cldbExtIps = new String[]{};
        if (!clusterGroupConf.getCldbIps().isEmpty()) {
            cldbIps = clusterGroupConf.getCldbIps().split(" ");
        }
        if (!clusterGroupConf.getCldbExtIps().isEmpty()) {
            cldbExtIps = clusterGroupConf.getCldbExtIps().split(" ");
        }
        int numElementsToZigZag = cldbIps.length <= cldbExtIps.length ? cldbIps.length : cldbExtIps.length;
        boolean isFirst = true;
        for (i = 0; i < numElementsToZigZag; ++i) {
            if (!isFirst) {
                cldbIpsStr = (String)cldbIpsStr + " ";
            } else {
                isFirst = false;
            }
            cldbIpsStr = (String)cldbIpsStr + cldbExtIps[i] + " " + cldbIps[i];
        }
        if (cldbExtIps.length > numElementsToZigZag) {
            for (i = numElementsToZigZag; i < cldbExtIps.length; ++i) {
                if (!isFirst) {
                    cldbIpsStr = (String)cldbIpsStr + " ";
                } else {
                    isFirst = false;
                }
                cldbIpsStr = (String)cldbIpsStr + cldbExtIps[i];
            }
        }
        if (cldbIps.length > numElementsToZigZag) {
            for (i = numElementsToZigZag; i < cldbIps.length; ++i) {
                if (!isFirst) {
                    cldbIpsStr = (String)cldbIpsStr + " ";
                } else {
                    isFirst = false;
                }
                cldbIpsStr = (String)cldbIpsStr + cldbIps[i];
            }
        }
        return cldbIpsStr;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatClusterInfo(CLDBProto.ClusterGroupConf clusterGroupConf, boolean needLicenseInfo) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode();
        boolean terse = this.getOutputParamValue().equals("terse");
        BitSet columns = this.getColumns();
        if (clusterGroupConf.hasClusterName() && columns.get(CLDBProto.ClusterGroupConfInfoFields.cname.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.cname).getName(terse), (Object)clusterGroupConf.getClusterName()));
        }
        if (clusterGroupConf.hasCldbIps() && columns.get(CLDBProto.ClusterGroupConfInfoFields.cldbip.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.cldbip).getName(terse), (Object)this.getCldbIpsZigZag(clusterGroupConf)));
        }
        if (clusterGroupConf.hasCldbExtIps() && columns.get(CLDBProto.ClusterGroupConfInfoFields.cldbextip.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.cldbextip).getName(terse), (Object)clusterGroupConf.getCldbExtIps()));
        }
        if (clusterGroupConf.hasApiIps() && columns.get(CLDBProto.ClusterGroupConfInfoFields.apiip.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.apiip).getName(terse), (Object)clusterGroupConf.getApiIps()));
        }
        if (columns.get(CLDBProto.ClusterGroupConfInfoFields.clusterid.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.clusterid).getName(terse), (Object)clusterGroupConf.getClusterId()));
        }
        if (clusterGroupConf.hasCcTicket() && columns.get(CLDBProto.ClusterGroupConfInfoFields.ccticket.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.ccticket).getName(terse), (Object)clusterGroupConf.getCcTicket()));
        }
        if (clusterGroupConf.hasIsClusterGroupPrimary() && columns.get(CLDBProto.ClusterGroupConfInfoFields.clustergroupprimary.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.clustergroupprimary).getName(terse), (Object)clusterGroupConf.getIsClusterGroupPrimary()));
        }
        if (columns.get(CLDBProto.ClusterGroupConfInfoFields.clusterupgradestate.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.clusterupgradestate).getName(terse), (Object)clusterGroupConf.getUpgradeState()));
        }
        if (columns.get(CLDBProto.ClusterGroupConfInfoFields.clusterlocation.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.clusterlocation).getName(terse), (Object)clusterGroupConf.getLocation()));
        }
        if (columns.get(CLDBProto.ClusterGroupConfInfoFields.clusterowner.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.clusterowner).getName(terse), (Object)clusterGroupConf.getOwner()));
        }
        if (columns.get(CLDBProto.ClusterGroupConfInfoFields.installtype.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.installtype).getName(terse), (Object)clusterGroupConf.getInstallType()));
        }
        if (columns.get(CLDBProto.ClusterGroupConfInfoFields.mossservers.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.mossservers).getName(terse), (Object)clusterGroupConf.getMossServers()));
        }
        if (clusterGroupConf.hasMossServersExtips()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("MossServerExtIPs", (Object)clusterGroupConf.getMossServersExtips()));
        }
        if (columns.get(CLDBProto.ClusterGroupConfInfoFields.gatewayips.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.gatewayips).getName(terse), (Object)clusterGroupConf.getDbgatewayIps()));
        }
        if (columns.get(CLDBProto.ClusterGroupConfInfoFields.installtype.getNumber()) && needLicenseInfo) {
            CommandOutput.OutputHierarchy.OutputNode licenseInfoNode = new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.licenseinfo).getName(terse));
            for (int i = 0; i < Common.LicenseFlags.values().length; ++i) {
                if ((clusterGroupConf.getLicenseInfo() & (long)(1 << i)) == (long)(1 << i)) {
                    licenseInfoNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(Common.LicenseFlags.values()[i].toString(), (Object)true));
                    continue;
                }
                licenseInfoNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(Common.LicenseFlags.values()[i].toString(), (Object)false));
            }
            outputNode.addChild(licenseInfoNode);
        }
        if (clusterGroupConf.getIsClusterGroupPrimary() && clusterGroupConf.hasS3GNSMode() && columns.get(CLDBProto.ClusterGroupConfInfoFields.s3gnshttpsmode.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.s3gnshttpsmode).getName(terse), (Object)clusterGroupConf.getS3GNSMode()));
        }
        if (clusterGroupConf.getIsClusterGroupPrimary() && clusterGroupConf.hasEnableS3GNS() && columns.get(CLDBProto.ClusterGroupConfInfoFields.enables3gns.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.enables3gns).getName(terse), (Object)clusterGroupConf.getEnableS3GNS()));
        }
        if (clusterGroupConf.getIsClusterGroupPrimary() && clusterGroupConf.hasEnableGlobalIAMPolicyServer() && columns.get(CLDBProto.ClusterGroupConfInfoFields.enableglobaliampolicyserver.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.enableglobaliampolicyserver).getName(terse), (Object)clusterGroupConf.getEnableGlobalIAMPolicyServer()));
        }
        return outputNode;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatExternalNfsServerInfo(CLDBProto.ExternalNfsServer externalNfsServer) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode();
        boolean terse = this.getOutputParamValue().equals("terse");
        BitSet columns = this.getColumns();
        outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.extservertype).getName(terse), (Object)"ExtNfs"));
        if (externalNfsServer.hasName() && columns.get(CLDBProto.ClusterGroupConfInfoFields.externalservername.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.externalservername).getName(terse), (Object)externalNfsServer.getName()));
        }
        if (externalNfsServer.hasIps() && columns.get(CLDBProto.ClusterGroupConfInfoFields.ips.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.ips).getName(terse), (Object)externalNfsServer.getIps()));
        }
        if (columns.get(CLDBProto.ClusterGroupConfInfoFields.numexports.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.numexports).getName(terse), externalNfsServer.getExportsCount()));
        }
        if (columns.get(CLDBProto.ClusterGroupConfInfoFields.exportsize.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.exportsize).getName(terse), (Object)(externalNfsServer.hasSize() ? externalNfsServer.getSize() : "0")));
        }
        if (columns.get(CLDBProto.ClusterGroupConfInfoFields.exportpath.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.exportused).getName(terse), (Object)(externalNfsServer.hasUsed() ? externalNfsServer.getUsed() : "0")));
        }
        if (columns.get(CLDBProto.ClusterGroupConfInfoFields.exportavail.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.exportavail).getName(terse), (Object)(externalNfsServer.hasAvail() ? externalNfsServer.getAvail() : "0")));
        }
        return outputNode;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatNfsServerExportsInfo(CLDBProto.NfsServerExportInfo eInfo) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode();
        boolean terse = this.getOutputParamValue().equals("terse");
        BitSet columns = this.getColumns();
        if (eInfo.hasPath() && columns.get(CLDBProto.ClusterGroupConfInfoFields.exportpath.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.exportpath).getName(terse), (Object)eInfo.getPath()));
        }
        if (eInfo.hasSize() && columns.get(CLDBProto.ClusterGroupConfInfoFields.exportsize.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.exportsize).getName(terse), (Object)eInfo.getSize()));
        }
        if (eInfo.hasUsed() && columns.get(CLDBProto.ClusterGroupConfInfoFields.exportpath.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.exportused).getName(terse), (Object)eInfo.getUsed()));
        }
        if (eInfo.hasAvail() && columns.get(CLDBProto.ClusterGroupConfInfoFields.exportavail.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.exportavail).getName(terse), (Object)eInfo.getAvail()));
        }
        return outputNode;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatExternalS3ServerInfo(CLDBProto.ExternalS3Server externalS3Server, boolean listAccessors) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode();
        boolean terse = this.getOutputParamValue().equals("terse");
        BitSet columns = this.getColumns();
        boolean isExtAWS = externalS3Server.hasVendor() && externalS3Server.getVendor().name().equalsIgnoreCase("AWS");
        boolean isExtGCP = !isExtAWS && externalS3Server.hasVendor() && externalS3Server.getVendor().name().equalsIgnoreCase("GCP");
        outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.extservertype).getName(terse), (Object)"ExtS3"));
        if (externalS3Server.hasName() && columns.get(CLDBProto.ClusterGroupConfInfoFields.externalservername.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(EXTERNAL_SERVER_NAME_PARAM, (Object)externalS3Server.getName()));
        }
        if (externalS3Server.hasIps() && columns.get(CLDBProto.ClusterGroupConfInfoFields.ips.getNumber())) {
            if (isExtAWS) {
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.awsregion).getName(terse), (Object)externalS3Server.getIps()));
            } else if (isExtGCP) {
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.gcpregion).getName(terse), (Object)externalS3Server.getIps()));
            } else {
                outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("externalserverips", (Object)externalS3Server.getIps()));
            }
        }
        if (externalS3Server.hasVendor() && columns.get(CLDBProto.ClusterGroupConfInfoFields.s3vendor.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.s3vendor).getName(terse), (Object)externalS3Server.getVendor()));
        }
        if (!isExtAWS && !isExtGCP && externalS3Server.hasPort()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("s3port", (Object)externalS3Server.getPort()));
        }
        if (externalS3Server.hasTlsenabled()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("s3tlsenabled", (Object)externalS3Server.getTlsenabled()));
        }
        if (externalS3Server.hasTransferProto()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("s3TransferProto", (Object)externalS3Server.getTransferProto()));
        }
        if (externalS3Server.hasWebidrolearn()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("webidrolearn", (Object)externalS3Server.getWebidrolearn()));
        }
        if (externalS3Server.hasExtServerUser()) {
            CommandOutput.OutputHierarchy.OutputNode extServerUser = new CommandOutput.OutputHierarchy.OutputNode("extserveruser");
            extServerUser.addNode(new CommandOutput.OutputHierarchy.OutputNode(EXTERNAL_SERVER_S3_OWNER, (Object)externalS3Server.getExtServerUser().getOwner().getName()));
            if (listAccessors) {
                StringBuilder users = new StringBuilder();
                for (CLDBProto.UserIdName userIdName : externalS3Server.getExtServerUser().getAccessorUsersList()) {
                    if (users.length() == 0) {
                        users.append(userIdName.getName());
                        continue;
                    }
                    users.append("," + userIdName.getName());
                }
                extServerUser.addNode(new CommandOutput.OutputHierarchy.OutputNode(EXTERNAL_SERVER_S3_ACCESSORUSERS, (Object)users.toString()));
                StringBuilder groups = new StringBuilder();
                for (CLDBProto.UserIdName userIdName : externalS3Server.getExtServerUser().getAccessorGroupsList()) {
                    if (groups.length() == 0) {
                        groups.append(userIdName.getName());
                        continue;
                    }
                    groups.append("," + userIdName.getName());
                }
                extServerUser.addNode(new CommandOutput.OutputHierarchy.OutputNode(EXTERNAL_SERVER_S3_ACCESSORGROUPS, (Object)groups.toString()));
            }
            outputNode.addChild(extServerUser);
        }
        return outputNode;
    }

    CommandOutput getNfsExports() throws Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        String name = this.getParamTextValue(EXTERNAL_SERVER_NAME_PARAM, 0);
        if (name.isEmpty()) {
            LOG.error((Object)"Missing External ServerName Param");
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Missing External ServerName Param"));
            return output;
        }
        CLDBProto.GetNfsExportsRequest req = CLDBProto.GetNfsExportsRequest.newBuilder().setCreds(this.getUserCredentials()).setServerName(name).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetNfsExportsProc.getNumber(), (MessageLite)req, CLDBProto.GetNfsExportsResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.GetNfsExportsResponse resp = CLDBProto.GetNfsExportsResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                for (CLDBProto.ExternalNfsServer server : resp.getServerList()) {
                    for (CLDBProto.NfsServerExportInfo es : server.getExportsList()) {
                        CommandOutput.OutputHierarchy.OutputNode eNode = this.formatNfsServerExportsInfo(es);
                        oh.addNode(eNode);
                    }
                }
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
        return output;
    }

    static List<Integer> getAccessors(String accessors) {
        ArrayList<Integer> accessorsList = new ArrayList<Integer>();
        try {
            String[] accessorList;
            for (String accessor : accessorList = accessors.split(",")) {
                accessorsList.add(Integer.parseInt(accessor.trim()));
            }
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException("invalid params for uid/gid");
        }
        return accessorsList;
    }

    CommandOutput updateS3User() throws Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        String name = this.getParamTextValue(EXTERNAL_SERVER_NAME_PARAM, 0);
        if (name.isEmpty()) {
            LOG.error((Object)"Missing External ServerName Param");
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Missing External ServerName Param"));
            return output;
        }
        String action = this.getParamTextValue(EXTERNAL_SERVER_S3_USER_ACTION, 0);
        if (action.isEmpty()) {
            LOG.error((Object)"Missing Action Param");
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Missing Action Param"));
            return output;
        }
        CLDBProto.ExtServerUser extServerUser = null;
        CLDBProto.ExtServerUserOp op = null;
        switch (action) {
            case "addaccessors": {
                op = CLDBProto.ExtServerUserOp.AddAccessors;
                break;
            }
            case "removeaccessors": {
                op = CLDBProto.ExtServerUserOp.RemoveAccessors;
                break;
            }
            case "updateowner": {
                op = CLDBProto.ExtServerUserOp.UpdateOwner;
                break;
            }
            default: {
                LOG.error((Object)"Invalid Action Param");
            }
        }
        if (op == CLDBProto.ExtServerUserOp.AddAccessors || op == CLDBProto.ExtServerUserOp.RemoveAccessors) {
            String accessorGroups;
            String accessorUsers = this.isParamPresent(EXTERNAL_SERVER_S3_ACCESSORUSERS) ? this.getParamTextValue(EXTERNAL_SERVER_S3_ACCESSORUSERS, 0) : "";
            String string = accessorGroups = this.isParamPresent(EXTERNAL_SERVER_S3_ACCESSORGROUPS) ? this.getParamTextValue(EXTERNAL_SERVER_S3_ACCESSORGROUPS, 0) : "";
            if (accessorUsers.isBlank() && accessorGroups.isBlank()) {
                LOG.error((Object)"Missing AccessorUsers/AccessorGroups Param");
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Missing AccessorUsers/AccessorGroups Param"));
                return output;
            }
            try {
                ArrayList<String> accessorUserList = accessorUsers.isBlank() ? null : new ArrayList<String>(Arrays.asList(accessorUsers.split(",")));
                ArrayList<String> accessorGroupList = accessorGroups.isBlank() ? null : new ArrayList<String>(Arrays.asList(accessorGroups.split(",")));
                CLDBProto.ExtServerUser.Builder extServerUserBuilder = CLDBProto.ExtServerUser.newBuilder();
                if (accessorUserList != null) {
                    for (String user : accessorUserList) {
                        extServerUserBuilder.addAccessorUsers(CLDBProto.UserIdName.newBuilder().setName(user).build());
                    }
                }
                if (accessorGroupList != null) {
                    for (String group : accessorGroupList) {
                        extServerUserBuilder.addAccessorGroups(CLDBProto.UserIdName.newBuilder().setName(group).build());
                    }
                }
                extServerUser = extServerUserBuilder.build();
            }
            catch (NumberFormatException ex) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "accessorUsers/accessorGroups passed is not in valid format"));
                return output;
            }
        } else if (op == CLDBProto.ExtServerUserOp.UpdateOwner) {
            if (!this.isParamPresent(EXTERNAL_SERVER_S3_OWNER)) {
                LOG.error((Object)"Missing Owner Param");
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Missing Owner Param"));
                return output;
            }
            String owner = this.getParamTextValue(EXTERNAL_SERVER_S3_OWNER, 0);
            extServerUser = CLDBProto.ExtServerUser.newBuilder().setOwner(CLDBProto.UserIdName.newBuilder().setName(owner).build()).build();
        } else {
            LOG.error((Object)"Invalid Action Param");
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Invalid Action Param"));
            return output;
        }
        CLDBProto.UpdateExtServerUserRequest req = CLDBProto.UpdateExtServerUserRequest.newBuilder().setCreds(this.getUserCredentials()).setServerName(name).setOp(op).setExtServerUser(extServerUser).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.UpdateExtServerUserProc.getNumber(), (MessageLite)req, CLDBProto.UpdateExtServerUserResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.UpdateExtServerUserResponse resp = CLDBProto.UpdateExtServerUserResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                oh.addMessage("Successfully performed op: " + action + " for external server: " + name);
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
        return output;
    }

    CommandOutput addExternal() throws Exception {
        CLDBProto.ExternalServer extServ;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        String type = this.getParamTextValue(EXTERNAL_SERVER_TYPE_PARAM, 0);
        String externalServerName = this.getParamTextValue(EXTERNAL_SERVER_NAME_PARAM, 0);
        String externalServerIps = this.isParamPresent(EXTERNAL_SERVER_IPS_PARAM) ? this.getParamTextValue(EXTERNAL_SERVER_IPS_PARAM, 0) : null;
        String accesskey = this.isParamPresent(EXTERNAL_SERVER_ACCESSKEY_PARAM) ? this.getParamTextValue(EXTERNAL_SERVER_ACCESSKEY_PARAM, 0) : "";
        String secretekey = this.isParamPresent(EXTERNAL_SERVER_SECRETEKEY_PARAM) ? this.getParamTextValue(EXTERNAL_SERVER_SECRETEKEY_PARAM, 0) : "";
        String webidrolearn = this.isParamPresent(EXTERNAL_SERVER_AWS_WEBIDROLE_ARN) ? this.getParamTextValue(EXTERNAL_SERVER_AWS_WEBIDROLE_ARN, 0) : "";
        String s3vendor = this.isParamPresent(EXTERNAL_SERVER_S3VENDOR) ? this.getParamTextValue(EXTERNAL_SERVER_S3VENDOR, 0) : null;
        String awsregion = this.isParamPresent(EXTERNAL_SERVER_AWSREGION) ? this.getParamTextValue(EXTERNAL_SERVER_AWSREGION, 0) : null;
        String gcpregion = this.isParamPresent(EXTERNAL_SERVER_GCPREGION) ? this.getParamTextValue(EXTERNAL_SERVER_GCPREGION, 0) : null;
        boolean s3UseTLS = this.isParamPresent(EXTERNAL_SERVER_S3TLS) ? this.getParamBooleanValue(EXTERNAL_SERVER_S3TLS, 0) : true;
        String s3Cert = this.isParamPresent(EXTERNAL_SERVER_S3CERT) ? this.getParamTextValue(EXTERNAL_SERVER_S3CERT, 0) : null;
        String s3CertPath = this.isParamPresent(EXTERNAL_SERVER_S3CERTPATH) ? this.getParamTextValue(EXTERNAL_SERVER_S3CERTPATH, 0) : null;
        String s3Port = this.isParamPresent(EXTERNAL_SERVER_S3PORT) ? this.getParamTextValue(EXTERNAL_SERVER_S3PORT, 0) : "9000";
        String s3TransferProto = this.isParamPresent(EXTERNAL_SERVER_S3PROTO) ? this.getParamTextValue(EXTERNAL_SERVER_S3PROTO, 0) : "https";
        StringTokenizer st = null;
        boolean skipIpsCheck = false;
        if (this.isParamPresent("force")) {
            skipIpsCheck = true;
        }
        if (type.isEmpty()) {
            LOG.error((Object)"External server type is not provided");
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "External server type is not provided"));
            return output;
        }
        if (!type.equals("nfs") && !type.equals("s3")) {
            LOG.error((Object)("External server type:" + type + " is not supported"));
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "External server type is not supported"));
            return output;
        }
        if (s3Cert != null && s3CertPath != null) {
            LOG.error((Object)"Cannot specify both the s3 server cert file and its path");
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Cannot specify both the s3 server cert file and its path"));
            return output;
        }
        if (externalServerName.isEmpty() || externalServerName.contains("-")) {
            LOG.error((Object)"External server name is either empty or contains an invalid character (hyphen)");
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "External server name is either empty or contains an invalid character (hyphen)"));
            return output;
        }
        if (type.equals("s3")) {
            if ((accesskey == null || accesskey.isEmpty() || secretekey == null || secretekey.isEmpty()) && (webidrolearn == null || webidrolearn.isEmpty())) {
                LOG.error((Object)"Web-identity role ARN/Access key and secrete key are mandatory while adding external s3 server.");
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Web-identity role ARN/Access key and secrete key are mandatory while adding external s3 server."));
                return output;
            }
            if ((accesskey != null && !accesskey.isEmpty() || secretekey != null && !secretekey.isEmpty()) && webidrolearn != null && !webidrolearn.isEmpty()) {
                LOG.error((Object)"Either Web-identity role ARN or Access key+secrete key are allowed while adding external s3 server.");
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Either Web-identity role ARN or Access key+secrete key are allowed while adding external s3 server."));
                return output;
            }
            if (s3vendor == null || s3vendor.isEmpty()) {
                LOG.error((Object)"S3 vendor type not mentioned. Please mention AWS or GCP or Generic.");
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "S3 vendor type not mentioned. Please mention AWS or GCP or Generic."));
                return output;
            }
            if (!(s3vendor.equalsIgnoreCase("AWS") || s3vendor.equalsIgnoreCase("GCP") || s3vendor.equalsIgnoreCase("Generic"))) {
                LOG.error((Object)"S3 vendor type could only be AWS OR GCP OR Generic.");
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "S3 vendor type could only be AWS OR GCP OR Generic."));
                return output;
            }
            if (s3vendor.equalsIgnoreCase("AWS")) {
                if (externalServerIps != null) {
                    LOG.error((Object)"For AWS S3, instead of IP, AWS region should be provided");
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "For AWS S3, instead of IP, AWS region should be provided"));
                    return output;
                }
                if (awsregion == null || awsregion.isEmpty()) {
                    LOG.error((Object)"For AWS S3, providing awsregion is mandatory");
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "For AWS S3, providing awsregion is mandatory"));
                    return output;
                }
            } else if (s3vendor.equalsIgnoreCase("GCP")) {
                if (externalServerIps != null) {
                    LOG.error((Object)"For GCP S3, instead of IP, GCP region should be provided");
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "For GCP S3, instead of IP, GCP region should be provided"));
                    return output;
                }
                if (gcpregion == null || gcpregion.isEmpty()) {
                    LOG.error((Object)"For GCP S3, providing gcpregion is mandatory");
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "For GCP S3, providing gcpregion is mandatory"));
                    return output;
                }
            } else if (externalServerIps == null || externalServerIps.isEmpty()) {
                LOG.error((Object)"External S3 server hostnames/ips are not provided");
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "External S3 server hostnames/ips are not provided"));
                return output;
            }
        } else {
            if (accesskey != null && !accesskey.isEmpty() || secretekey != null && !secretekey.isEmpty()) {
                LOG.error((Object)"Access key and secrete key are not required while adding external NFS server.");
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Access key and secrete key are not required while adding external NFS server."));
                return output;
            }
            if (s3vendor != null) {
                LOG.error((Object)"S3 vendor type is not required while adding external NFS server.");
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "S3 vendor type is not required while adding external NFS server."));
                return output;
            }
            if (externalServerIps == null || externalServerIps.isEmpty()) {
                LOG.error((Object)"External NFS server hostnames/ips are not provided");
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "External NFS server hostnames/ips are not provided"));
                return output;
            }
            st = new StringTokenizer(externalServerIps, ",");
        }
        while (type.equals("nfs") && st.hasMoreTokens() && !skipIpsCheck) {
            String nfsIp = st.nextToken().trim();
            Runtime rt = Runtime.getRuntime();
            String cmdStr = "rpcinfo -p " + nfsIp + " | grep 100003";
            String[] cmd = new String[]{"/bin/bash", "-c", cmdStr};
            Process proc = rt.exec(cmd);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            int numNfsRpcPrograms = 0;
            String s = null;
            while ((s = stdInput.readLine()) != null) {
                ++numNfsRpcPrograms;
            }
            if (stdError.readLine() != null) {
                LOG.error((Object)"External server ip is not responding");
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "External server ip: " + nfsIp + " is not responding"));
                return output;
            }
            if (numNfsRpcPrograms == 0) {
                LOG.error((Object)("External server ip: " + nfsIp + " don't have registered nfsserver"));
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "External server ip: " + nfsIp + " don't have registered nfsserver"));
                return output;
            }
            LOG.info((Object)("External server ip: " + nfsIp + " responded with: " + numNfsRpcPrograms + " nfs programes"));
        }
        if (type.equals("nfs")) {
            CLDBProto.ExternalNfsServer extNfsServ = CLDBProto.ExternalNfsServer.newBuilder().setName(externalServerName).setIps(externalServerIps).build();
            extServ = CLDBProto.ExternalServer.newBuilder().setExtNfs(extNfsServ).build();
        } else {
            CLDBProto.S3Vendor vendortype = this.getVendorType(s3vendor);
            String s3ips = externalServerIps;
            if (awsregion != null) {
                s3ips = awsregion;
            } else if (gcpregion != null) {
                s3ips = gcpregion;
            }
            if (s3UseTLS && s3TransferProto.equalsIgnoreCase("http")) {
                LOG.error((Object)"Http does not support TLS encryption, either use https or disable TLS");
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Http does not support TLS encryption, either use https or disable TLS"));
                return output;
            }
            CLDBProto.UserIdName userIdName = CLDBProto.UserIdName.newBuilder().setId((int)this.getUserId()).setName(this.getUserLoginId()).build();
            CLDBProto.ExtServerUser extServerUser = CLDBProto.ExtServerUser.newBuilder().setOwner(userIdName).build();
            CLDBProto.ExternalS3Server.Builder s3builder = CLDBProto.ExternalS3Server.newBuilder().setName(externalServerName).setIps(s3ips).setAccesskey(accesskey).setSecretekey(secretekey).setVendor(vendortype).setPort(s3Port).setTransferProto(s3TransferProto).setTlsenabled(s3UseTLS).setWebidrolearn(webidrolearn).setExtServerUser(extServerUser);
            if (s3CertPath != null) {
                String s3CertRead;
                try {
                    s3CertRead = new String(Files.readAllBytes(Paths.get(s3CertPath, new String[0])));
                }
                catch (IOException e) {
                    LOG.error((Object)("Exception while reading s3server cert file:" + s3CertPath));
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Exception while reading s3server cert file:" + s3CertPath));
                    return output;
                }
                s3builder.setCert(s3CertRead);
            } else if (s3Cert != null) {
                s3builder.setCert(s3Cert);
            }
            CLDBProto.ExternalS3Server extS3Serv = s3builder.build();
            extServ = CLDBProto.ExternalServer.newBuilder().setExtS3(extS3Serv).build();
        }
        CLDBProto.AddExternalServerRequest req = CLDBProto.AddExternalServerRequest.newBuilder().setCreds(this.getUserCredentials()).setExtServer(extServ).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AddExternalServerProc.getNumber(), (MessageLite)req, CLDBProto.AddExternalServerResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.AddExternalServerResponse resp = CLDBProto.AddExternalServerResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                oh.addMessage("Successfully added external server " + externalServerName);
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
        return output;
    }

    CommandOutput setClusterGroupPrimary() throws Exception {
        String crossClusterTicketPath;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        String clusterName = this.getParamTextValue(CLUSTERNAME_PARAM, 0);
        String cldbips = this.getParamTextValue(CLDBIPS_PARAM, 0);
        String cldbextips = null;
        String ccticket = this.isParamPresent(CROSSCLUSTER_TICKET_PARAM) ? this.getParamTextValue(CROSSCLUSTER_TICKET_PARAM, 0) : null;
        String string = crossClusterTicketPath = this.isParamPresent(CCTK_FILEPATH_PARAM) ? this.getParamTextValue(CCTK_FILEPATH_PARAM, 0) : null;
        if (ccticket == null && crossClusterTicketPath == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "either one of crossclusterticket or cctktfilepath param required."));
            return output;
        }
        if (ccticket == null) {
            try {
                ccticket = new String(Files.readAllBytes(Paths.get(crossClusterTicketPath, new String[0]))).trim();
            }
            catch (IOException e) {
                LOG.error((Object)("Exception while reading crosscluster ticket file: " + e.toString()));
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Exception while reading crosscluster ticket file: " + e.toString()));
                return output;
            }
        }
        if (!this.isValidIpPorts(oh, cldbips)) {
            return output;
        }
        LOG.info((Object)("CLDB ips: " + cldbips));
        if (this.isParamPresent(CLDBEXTIPS_PARAM)) {
            cldbextips = this.getParamTextValue(CLDBEXTIPS_PARAM, 0);
            if (!this.isValidIpPorts(oh, cldbextips)) {
                return output;
            }
            cldbips = this.removeExternalIps(cldbips, cldbextips);
        }
        CLDBProto.ClusterGroupConf.Builder bldr = CLDBProto.ClusterGroupConf.newBuilder().setClusterName(clusterName).setCldbIps(cldbips).setCcTicket(ccticket).setIsClusterGroupPrimary(false);
        if (this.isParamPresent(CLDBEXTIPS_PARAM)) {
            bldr.setCldbExtIps(cldbextips);
            LOG.info((Object)("CLDB external ips: " + cldbextips));
        }
        CLDBProto.ClusterGroupConf ccConf = bldr.build();
        LOG.debug((Object)("setClusterGroupPrimary: cluster name:" + clusterName + ", cldbips:" + cldbips + ", crossclusterticket:" + ccticket));
        CLDBProto.ClusterGroupAddRequest req = CLDBProto.ClusterGroupAddRequest.newBuilder().setCreds(this.getUserCredentials()).setCcConf(ccConf).setSetClusterGroupPrimary(true).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterGroupAddProc.getNumber(), (MessageLite)req, CLDBProto.ClusterGroupAddResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.ClusterGroupAddResponse resp = CLDBProto.ClusterGroupAddResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                oh.addMessage("Successfully added cluster '" + clusterName + "' to the group and updated primary.");
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
        return output;
    }

    CommandOutput updateClusterGroupPrimary() throws Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        String clusterName = this.getParamTextValue(CLUSTERNAME_PARAM, 0);
        CLDBProto.ClusterGroupConf ccConf = CLDBProto.ClusterGroupConf.newBuilder().setClusterName(clusterName).build();
        LOG.debug((Object)("updateClusterGroupPrimary: cluster name:" + clusterName));
        CLDBProto.ClusterGroupAddRequest req = CLDBProto.ClusterGroupAddRequest.newBuilder().setCreds(this.getUserCredentials()).setCcConf(ccConf).setUpdateClusterGroupPrimary(true).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterGroupAddProc.getNumber(), (MessageLite)req, CLDBProto.ClusterGroupAddResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.ClusterGroupAddResponse resp = CLDBProto.ClusterGroupAddResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                oh.addMessage("Successfully updated primary to '" + clusterName + "'.");
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
        return output;
    }

    CommandOutput s3GNSCommand() throws Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        if (!this.isParamPresent(S3HTTPSMODE_PARAM) && !this.isParamPresent(S3GNS_ENABLED)) {
            LOG.error((Object)"Atleast one parameter among httpsmode/enables3gns required");
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Atleast one parameter among httpsmode/enables3gns required"));
            return output;
        }
        CLDBProto.S3GNSRequest.Builder s3GNSRequest = CLDBProto.S3GNSRequest.newBuilder();
        if (this.isParamPresent(S3HTTPSMODE_PARAM)) {
            CLDBProto.S3GNSHttpsMode s3gnsmode;
            String httpsMode;
            String string = httpsMode = this.isParamPresent(S3HTTPSMODE_PARAM) ? this.getParamTextValue(S3HTTPSMODE_PARAM, 0) : null;
            assert (httpsMode != null);
            if (httpsMode.equalsIgnoreCase("redirect")) {
                s3gnsmode = CLDBProto.S3GNSHttpsMode.REDIRECT;
            } else if (httpsMode.equalsIgnoreCase("forward")) {
                s3gnsmode = CLDBProto.S3GNSHttpsMode.FORWARD;
            } else {
                LOG.error((Object)"Https mode could be either forward or redirect.");
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Https mode could be either forward or redirect."));
                return output;
            }
            s3GNSRequest.setS3GNSMode(s3gnsmode);
        }
        if (this.isParamPresent(S3GNS_ENABLED)) {
            s3GNSRequest.setEnableS3GNS(this.getParamBooleanValue(S3GNS_ENABLED, 0));
        }
        CLDBProto.S3GNSRequest req = s3GNSRequest.setCreds(this.getUserCredentials()).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.S3GNSProc.getNumber(), (MessageLite)req, CLDBProto.S3GNSResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.S3GNSResponse resp = CLDBProto.S3GNSResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                oh.addMessage("Successfully executed s3gns command");
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
        return output;
    }

    CommandOutput gloabalIAMPolicyServerCommand() throws Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        if (!this.isParamPresent(GLOBALPOLICYIAM_ENABLE_PARAM)) {
            LOG.error((Object)"No param provided");
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "No param provided"));
            return output;
        }
        CLDBProto.GlobalIAMPolicyServerRequest.Builder globalIAMPolicyServerRequest = CLDBProto.GlobalIAMPolicyServerRequest.newBuilder();
        if (this.isParamPresent(GLOBALPOLICYIAM_ENABLE_PARAM)) {
            globalIAMPolicyServerRequest.setEnableGlobalIAMPolicyServer(this.getParamBooleanValue(GLOBALPOLICYIAM_ENABLE_PARAM, 0));
        }
        CLDBProto.GlobalIAMPolicyServerRequest req = globalIAMPolicyServerRequest.setCreds(this.getUserCredentials()).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GlobalIAMPolicyServerProc.getNumber(), (MessageLite)req, CLDBProto.GlobalIAMPolicyServerResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.GlobalIAMPolicyServerResponse resp = CLDBProto.GlobalIAMPolicyServerResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                oh.addMessage("Successfully executed globalIAMPolicyServer command");
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
        return output;
    }

    CommandOutput removeServer() throws Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        String clusterName = this.getParamTextValue(CLUSTERNAME_PARAM, 0);
        CLDBProto.ClusterGroupConf ccConf = CLDBProto.ClusterGroupConf.newBuilder().setClusterName(clusterName).build();
        CLDBProto.ClusterGroupRemoveRequest req = CLDBProto.ClusterGroupRemoveRequest.newBuilder().setCreds(this.getUserCredentials()).setCcConf(ccConf).build();
        LOG.debug((Object)("removeServer: cluster name:" + clusterName));
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterGroupRemoveProc.getNumber(), (MessageLite)req, CLDBProto.ClusterGroupRemoveResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.ClusterGroupRemoveResponse resp = CLDBProto.ClusterGroupRemoveResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                oh.addMessage("Successfully removed cluster '" + clusterName + "'.");
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
        return output;
    }

    private CLDBProto.ClusterUpgradeState getClusterUpgradeState(String stateStr) {
        for (CLDBProto.ClusterUpgradeState state : CLDBProto.ClusterUpgradeState.values()) {
            if (!state.name().equalsIgnoreCase(stateStr)) continue;
            return state;
        }
        LOG.error((Object)("getClusterUpgradeState: invalid ClusterUpgradeState " + stateStr));
        return null;
    }

    private CLDBProto.S3Vendor getVendorType(String vendor) {
        for (CLDBProto.S3Vendor type : CLDBProto.S3Vendor.values()) {
            if (!type.name().equalsIgnoreCase(vendor)) continue;
            return type;
        }
        LOG.error((Object)("getVendorType : invalid vendor provided:" + vendor));
        return null;
    }

    CommandOutput setUpgrade() throws Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        String clusterName = this.getParamTextValue(CLUSTERNAME_PARAM, 0);
        String stateStr = this.getParamTextValue(SETUPGRADE_STATUS_PARAM, 0);
        CLDBProto.ClusterUpgradeState state = this.getClusterUpgradeState(stateStr);
        if (state == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid ClusterUpgradeState " + stateStr));
            return output;
        }
        CLDBProto.ClusterGroupConf ccConf = CLDBProto.ClusterGroupConf.newBuilder().setClusterName(clusterName).setUpgradeState(state).build();
        LOG.debug((Object)("setUpgrade: cluster name:" + clusterName + " state: " + state));
        CLDBProto.ClusterGroupUpdateRequest req = CLDBProto.ClusterGroupUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).setCcConf(ccConf).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterGroupUpdateProc.getNumber(), (MessageLite)req, CLDBProto.ClusterGroupUpdateResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.ClusterGroupUpdateResponse resp = CLDBProto.ClusterGroupUpdateResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                oh.addMessage("Successfully updated upgrade state for cluster " + clusterName + " to " + state);
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isClusterEntryPresent(String clusterName, String configFile) throws IOException {
        FileReader fr = null;
        File file = new File(configFile);
        fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String[] words = line.split("\\s");
                if (words[0].compareToIgnoreCase(clusterName) != 0) continue;
                LOG.debug((Object)("isClusterEntryPresent: cluster name: " + clusterName + " found in line: " + line));
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (fr != null) {
                fr.close();
            }
        }
        LOG.debug((Object)("isClusterEntryPresent: cluster name: " + clusterName + " NOT found in file: " + configFile));
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CommandOutput showClusterCert() throws CLIProcessingException {
        byte[] replyData;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        try {
            CLDBProto.ClusterGroupListRequest.Builder reqBuilder = CLDBProto.ClusterGroupListRequest.newBuilder().setCreds(this.getUserCredentials());
            if (!this.isParamPresent(ALLCLUSTERS_PARAM)) {
                if (!this.isParamPresent(CLUSTERNAME_PARAM)) {
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "either -clustername or -allclusters need to set true"));
                    return output;
                }
                reqBuilder.setClusterName(this.getParamTextValue(CLUSTERNAME_PARAM, 0));
            } else if (!this.getParamBooleanValue(ALLCLUSTERS_PARAM, 0) && !this.isParamPresent(CLUSTERNAME_PARAM)) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "either -clustername or -allclusters need to set true"));
                return output;
            }
            CLDBProto.ClusterGroupListRequest req = reqBuilder.build();
            replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterGroupListProc.getNumber(), (MessageLite)req, CLDBProto.ClusterGroupListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData == null) {
            LOG.error((Object)"RPC Request to list cross cluster entries failed. No data returned");
            return null;
        }
        try {
            String tmpRootCaFilePath = "/tmp/root-ca.crt";
            CLDBProto.ClusterGroupListResponse resp = CLDBProto.ClusterGroupListResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
                return output;
            }
            File oldfile = new File(tmpRootCaFilePath);
            if (oldfile.exists()) {
                oldfile.delete();
            }
            List respConfs = resp.getCcConfsList();
            if (this.isParamPresent(CLUSTERNAME_PARAM)) {
                Files.writeString(Paths.get(tmpRootCaFilePath, new String[0]), (CharSequence)resp.getCcConfs(0).getRootCaContent(), StandardOpenOption.CREATE);
            } else {
                boolean firstEntry = true;
                for (CLDBProto.ClusterGroupConf rcvCgConf : respConfs) {
                    LOG.info((Object)("showClusterCert: pulled rcvCgConf fir cluster: " + rcvCgConf.getClusterName()));
                    if (firstEntry) {
                        Files.writeString(Paths.get(tmpRootCaFilePath, new String[0]), (CharSequence)rcvCgConf.getRootCaContent(), StandardOpenOption.CREATE);
                        firstEntry = false;
                        continue;
                    }
                    Files.writeString(Paths.get(tmpRootCaFilePath, new String[0]), (CharSequence)(System.lineSeparator() + rcvCgConf.getRootCaContent()), StandardOpenOption.APPEND);
                }
            }
            oh.addMessage("Stored root-ca.crt content in /tmp/root-ca.crt");
            return output;
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into ClusterGroupListResponse proto object.", (Throwable)ipbe);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception while dumping to the file " + e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CommandOutput fetchChainCa() throws CLIProcessingException {
        byte[] replyData;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        try {
            CLDBProto.ClusterGroupListRequest.Builder reqBuilder = CLDBProto.ClusterGroupListRequest.newBuilder().setCreds(this.getUserCredentials());
            if (!this.isParamPresent(ALLCLUSTERS_PARAM)) {
                if (!this.isParamPresent(CLUSTERNAME_PARAM)) {
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "either -clustername or -allclusters need to set true"));
                    return output;
                }
                reqBuilder.setClusterName(this.getParamTextValue(CLUSTERNAME_PARAM, 0));
            } else if (!this.getParamBooleanValue(ALLCLUSTERS_PARAM, 0) && !this.isParamPresent(CLUSTERNAME_PARAM)) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "either -clustername or -allclusters need to set true"));
                return output;
            }
            CLDBProto.ClusterGroupListRequest req = reqBuilder.build();
            replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterGroupListProc.getNumber(), (MessageLite)req, CLDBProto.ClusterGroupListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData == null) {
            LOG.error((Object)"RPC Request to list cross cluster entries failed. No data returned");
            return null;
        }
        try {
            String tmpChainCaFilePath = "/tmp/chain-ca.pem";
            CLDBProto.ClusterGroupListResponse resp = CLDBProto.ClusterGroupListResponse.parseFrom((byte[])replyData);
            if (resp.getStatus() != 0) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
                return output;
            }
            File oldfile = new File(tmpChainCaFilePath);
            if (oldfile.exists()) {
                oldfile.delete();
            }
            List respConfs = resp.getCcConfsList();
            if (this.isParamPresent(CLUSTERNAME_PARAM)) {
                Files.writeString(Paths.get(tmpChainCaFilePath, new String[0]), (CharSequence)resp.getCcConfs(0).getChainCaContent(), StandardOpenOption.CREATE);
            } else {
                boolean firstEntry = true;
                for (CLDBProto.ClusterGroupConf rcvCgConf : respConfs) {
                    LOG.info((Object)("fetchChainCa: pulled rcvCgConf fir cluster: " + rcvCgConf.getClusterName()));
                    if (firstEntry) {
                        Files.writeString(Paths.get(tmpChainCaFilePath, new String[0]), (CharSequence)rcvCgConf.getChainCaContent(), StandardOpenOption.CREATE);
                        firstEntry = false;
                        continue;
                    }
                    Files.writeString(Paths.get(tmpChainCaFilePath, new String[0]), (CharSequence)rcvCgConf.getChainCaContent(), StandardOpenOption.APPEND);
                }
            }
            oh.addMessage("Stored chain-ca.pem content in /tmp/chain-ca.pem");
            return output;
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into ClusterGroupListResponse proto object.", (Throwable)ipbe);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception while dumping to the file " + e.toString());
        }
    }

    private void makeDirectory(File dir) {
        if (!dir.exists()) {
            dir.mkdir();
            String perm = "rwxrwxrwx";
            try {
                Set<PosixFilePermission> permissions = PosixFilePermissions.fromString(perm);
                Files.setPosixFilePermissions(dir.toPath(), permissions);
            }
            catch (IOException e) {
                LOG.error((Object)("Can't set permission '" + perm + "' to " + dir.getPath()));
            }
        }
    }

    CommandOutput GenerateClusterConf() throws CLIProcessingException {
        byte[] replyData;
        LOG.info((Object)"RPC Request to GenerateClusterConf");
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        try {
            CLDBProto.ClusterGroupListRequest.Builder reqBuilder = CLDBProto.ClusterGroupListRequest.newBuilder().setCreds(this.getUserCredentials());
            if (this.isParamPresent(CLUSTERNAME_PARAM)) {
                reqBuilder.setClusterName(this.getParamTextValue(CLUSTERNAME_PARAM, 0));
            }
            CLDBProto.ClusterGroupListRequest req = reqBuilder.build();
            replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterGroupListProc.getNumber(), (MessageLite)req, CLDBProto.ClusterGroupListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            try {
                this.makeDirectory(new File("/tmp/confdir/"));
                String tmpRootCaPathCG = "/tmp/confdir/ssl_truststore";
                String tmpRootconfPathCG = "/tmp/confdir/mapr-clusters.conf";
                String tmpRootCaPemPathCG = "/tmp/confdir/ssl_truststore.pem";
                ArrayList<String> fileList = new ArrayList<String>();
                fileList.add(tmpRootCaPathCG);
                fileList.add(tmpRootCaPemPathCG);
                fileList.add(tmpRootconfPathCG);
                String clustersTarFile = "/tmp/confdir/clusterconf.tar";
                String tarFileDirectory = "conf";
                CLDBProto.ClusterGroupListResponse resp = CLDBProto.ClusterGroupListResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() == 0) {
                    for (String path : fileList) {
                        File oldfile = new File(path);
                        if (!oldfile.exists()) continue;
                        oldfile.delete();
                    }
                    File oldfile = new File(clustersTarFile);
                    if (oldfile.exists()) {
                        oldfile.delete();
                    }
                    List respConfs = resp.getCcConfsList();
                    boolean firstEntry = true;
                    for (CLDBProto.ClusterGroupConf rcvCgConf : respConfs) {
                        LOG.info((Object)("GenerateClusterConf: pulled rcvCgConf for cluster: " + rcvCgConf.getClusterName()));
                        String confEntry = rcvCgConf.getClusterName() + " secure=true " + rcvCgConf.getCldbIps();
                        if (firstEntry) {
                            Files.writeString(Paths.get(tmpRootconfPathCG, new String[0]), (CharSequence)(confEntry + System.lineSeparator()), StandardOpenOption.CREATE);
                            Util.AddToTruststore((String)rcvCgConf.getRootCaContent(), (String)rcvCgConf.getClusterName(), (String)tmpRootCaPathCG, (boolean)false);
                            Files.writeString(Paths.get(tmpRootCaPemPathCG, new String[0]), (CharSequence)rcvCgConf.getRootCaContent(), StandardOpenOption.CREATE);
                            firstEntry = false;
                            continue;
                        }
                        Files.writeString(Paths.get(tmpRootconfPathCG, new String[0]), (CharSequence)(confEntry + System.lineSeparator()), StandardOpenOption.APPEND);
                        Util.AddToTruststore((String)rcvCgConf.getRootCaContent(), (String)rcvCgConf.getClusterName(), (String)tmpRootCaPathCG, (boolean)true);
                        Files.writeString(Paths.get(tmpRootCaPemPathCG, new String[0]), (CharSequence)(System.lineSeparator() + rcvCgConf.getRootCaContent()), StandardOpenOption.APPEND);
                    }
                    Thread.sleep(10L);
                    File clusterconf = new File(clustersTarFile);
                    FileOutputStream tar_output = new FileOutputStream(clusterconf);
                    ArchiveOutputStream tar_ball = new ArchiveStreamFactory().createArchiveOutputStream("tar", (OutputStream)tar_output);
                    for (String input_file : fileList) {
                        File tar_input_file = new File(input_file);
                        TarArchiveEntry tar_file = new TarArchiveEntry(tarFileDirectory + File.separator + tar_input_file.getName());
                        tar_file.setSize(tar_input_file.length());
                        tar_ball.putArchiveEntry((ArchiveEntry)tar_file);
                        IOUtils.copy((InputStream)new FileInputStream(tar_input_file), (OutputStream)tar_ball);
                        tar_ball.closeArchiveEntry();
                        Thread.sleep(10L);
                        tar_input_file.delete();
                    }
                    String msg = "Archived certificates and cluster conf files at location: /tmp/confdir/clusterconf.tar which contain directory conf which contains mapr-cluster.conf and ssl_truststore.crt files. Use 'tar -xvf /tmp/confdir/clusterconf.tar -C /opt/mapr/' to get files at required location. ";
                    oh.addMessage(msg);
                }
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
            catch (InvalidProtocolBufferException ipbe) {
                throw new CLIProcessingException("Exception while parsing the RPC response data into GenerateClusterConf proto object.", (Throwable)ipbe);
            }
            catch (Exception e) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Exception while deleting the Old files " + e.toString()));
                LOG.error((Object)("Exception while deleting the Old file " + e.toString()));
            }
        } else {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "RPC Request to list cross cluster entries failed. No data returned"));
            LOG.error((Object)"RPC Request to list cross cluster entries failed. No data returned");
        }
        return output;
    }

    CommandOutput listClusterGroupConfs() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        try {
            String sortbyStr;
            CLDBProto.ListSortKey sortKey;
            if (!super.validateInput()) {
                return output;
            }
            if (this.isParamPresent(SORTBY_PARAM_NAME) && (sortKey = nameToEnumMap.get((sortbyStr = this.getParamTextValue(SORTBY_PARAM_NAME, 0)).toLowerCase())) == null) {
                LOG.error((Object)("failed to list sorted cross cluster entries, " + sortbyStr + " is not a valid field to sort."));
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid sortkey: " + sortbyStr));
                return output;
            }
            if (this.isParamPresent(SORTING_ORDER_PARAM_NAME)) {
                if (!this.isParamPresent(SORTBY_PARAM_NAME)) {
                    String msg = "Invalid use of sortorder. Must be used with sortby";
                    LOG.error((Object)msg);
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                    return output;
                }
                String sortOrder = this.getParamTextValue(SORTING_ORDER_PARAM_NAME, 0);
                if (!sortOrder.equalsIgnoreCase(ASCENDING_SORTING_ORDER_PARAM_NAME) && !sortOrder.equalsIgnoreCase(DESCENDING_SORTING_ORDER_PARAM_NAME)) {
                    String msg = "Invalid value for sortorder. Valid values are asc and desc";
                    LOG.error((Object)msg);
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                    return output;
                }
            }
            this.list(oh);
        }
        catch (Exception e) {
            LOG.error((Object)"caught exception: ", (Throwable)e);
            throw new CLIProcessingException((Throwable)e);
        }
        return output;
    }

    private String getOutputParamValue() throws CLIProcessingException {
        return this.isParamPresent(OUTPUT_PARAM_NAME) ? this.getParamTextValue(OUTPUT_PARAM_NAME, 0) : "";
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBProto.ClusterGroupListResponse resp = (CLDBProto.ClusterGroupListResponse)response;
        if (resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            return;
        }
        boolean showPrimary = this.getParamBooleanValue(SHOW_PRIMARY_PARAM, 0);
        boolean needLicenseInfo = this.getParamBooleanValue(LICENSE_INFO_PARAM_NAME, 0);
        for (CLDBProto.ClusterGroupConf cgc : resp.getCcConfsList()) {
            if (showPrimary && !cgc.getIsClusterGroupPrimary()) continue;
            CommandOutput.OutputHierarchy.OutputNode outputNode = this.formatClusterInfo(cgc, needLicenseInfo);
            out.addNode(outputNode);
        }
        block1: for (CLDBProto.ExternalServer es : resp.getExtServersList()) {
            if (es.getExternalServerOneOfCase() == CLDBProto.ExternalServer.ExternalServerOneOfCase.EXTNFS) {
                CommandOutput.OutputHierarchy.OutputNode outputNode = this.formatExternalNfsServerInfo(es.getExtNfs());
                out.addNode(outputNode);
                continue;
            }
            if (es.getExternalServerOneOfCase() != CLDBProto.ExternalServer.ExternalServerOneOfCase.EXTS3) continue;
            boolean isListS3Allowed = resp.getIsExtServerListAllowed();
            int currUserUid = (int)this.getUserId();
            if (isListS3Allowed) {
                CommandOutput.OutputHierarchy.OutputNode outputNode = this.formatExternalS3ServerInfo(es.getExtS3(), true);
                out.addNode(outputNode);
                continue;
            }
            if (!es.getExtS3().hasExtServerUser()) continue;
            CLDBProto.ExtServerUser extServerUser = es.getExtS3().getExtServerUser();
            int ownerId = extServerUser.getOwner().getId();
            if (currUserUid == ownerId) {
                CommandOutput.OutputHierarchy.OutputNode outputNode = this.formatExternalS3ServerInfo(es.getExtS3(), true);
                out.addNode(outputNode);
                continue;
            }
            boolean found = false;
            for (CLDBProto.UserIdName userIdName : extServerUser.getAccessorUsersList()) {
                if (userIdName.getId() != currUserUid) continue;
                CommandOutput.OutputHierarchy.OutputNode outputNode = this.formatExternalS3ServerInfo(es.getExtS3(), false);
                out.addNode(outputNode);
                found = true;
                break;
            }
            if (found) continue;
            Iterator iterator = this.getGIds().iterator();
            while (iterator.hasNext()) {
                long curGid = (Long)iterator.next();
                found = false;
                for (CLDBProto.UserIdName userIdName : extServerUser.getAccessorGroupsList()) {
                    if ((long)userIdName.getId() != curGid) continue;
                    CommandOutput.OutputHierarchy.OutputNode outputNode = this.formatExternalS3ServerInfo(es.getExtS3(), false);
                    out.addNode(outputNode);
                    found = true;
                    break;
                }
                if (!found) continue;
                continue block1;
            }
        }
        if (resp.hasTotal()) {
            out.setTotal(-1);
        }
    }

    private BitSet getColumns() throws CLIProcessingException {
        String columnsString;
        BitSet columns = new BitSet();
        columns.set(0, MAX_XCLUSTERCONFINFOFIELD + 1);
        String string = columnsString = this.isParamPresent(COLUMNS_PARAM_NAME) ? this.getParamTextValue(COLUMNS_PARAM_NAME, 0) : null;
        if (columnsString != null && !columnsString.equals(ALLTABLES_PARAM)) {
            columns = FilterUtil.getColumns(fieldTable, (String)columnsString.trim());
        }
        return columns;
    }

    @Override
    public MessageLite sendRequest(MessageLite request) throws CLIProcessingException {
        byte[] replyData;
        CLDBProto.ClusterGroupListRequest req = (CLDBProto.ClusterGroupListRequest)request;
        try {
            if (this.isParamPresent(CLUSTERNAME_PARAM)) {
                req = CLDBProto.ClusterGroupListRequest.newBuilder((CLDBProto.ClusterGroupListRequest)req).setClusterName(this.getParamTextValue(CLUSTERNAME_PARAM, 0)).build();
            }
            replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterGroupListProc.getNumber(), (MessageLite)req, CLDBProto.ClusterGroupListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            try {
                return CLDBProto.ClusterGroupListResponse.parseFrom((byte[])replyData);
            }
            catch (InvalidProtocolBufferException ipbe) {
                throw new CLIProcessingException("Exception while parsing the RPC response data into ClusterGroupListResponse proto object.", (Throwable)ipbe);
            }
        }
        LOG.error((Object)"RPC Request to list cross cluster entries failed. No data returned");
        return null;
    }

    @Override
    public MessageLite buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.ClusterGroupListRequest.Builder newReqBuilder = null;
        newReqBuilder = prevReq != null ? CLDBProto.ClusterGroupListRequest.newBuilder((CLDBProto.ClusterGroupListRequest)((CLDBProto.ClusterGroupListRequest)prevReq)) : this.getClusterGroupListRequestBuilder();
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            CLDBProto.ClusterGroupListResponse resp = (CLDBProto.ClusterGroupListResponse)prevResp;
            int prevCount = resp.getCcConfsCount();
            int origStart = this.isParamPresent(START_PARAM_NAME) ? this.getParamIntValue(START_PARAM_NAME, 0) : 0;
            int origLimit = this.isParamPresent(LIMIT_PARAM_NAME) ? this.getParamIntValue(LIMIT_PARAM_NAME, 0) : Integer.MAX_VALUE;
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, origStart, origLimit, 100));
        }
        return newReqBuilder.build();
    }

    private CLDBProto.ClusterGroupListRequest.Builder getClusterGroupListRequestBuilder() throws CLIProcessingException {
        CLDBProto.ClusterGroupListRequest.Builder reqBuilder = CLDBProto.ClusterGroupListRequest.newBuilder().setCreds(this.getUserCredentials());
        if (this.isParamPresent(START_PARAM_NAME) && this.isParamPresent(LIMIT_PARAM_NAME)) {
            reqBuilder.setLimiter(this.getNextLimiter(this.getParamIntValue(START_PARAM_NAME, 0), 0, this.getParamIntValue(START_PARAM_NAME, 0), this.getParamIntValue(LIMIT_PARAM_NAME, 0), 100));
        }
        if (this.isParamPresent(FILTER_PARAM_NAME)) {
            List<CLIProto.Filter> filters = this.getFilters(fieldTable, FILTER_PARAM_NAME);
            reqBuilder.addAllFilter(filters);
        }
        if (this.isParamPresent(SORTBY_PARAM_NAME)) {
            String sortbyStr = this.getParamTextValue(SORTBY_PARAM_NAME, 0);
            CLDBProto.ListSortKey sortKey = nameToEnumMap.get(sortbyStr.toLowerCase());
            if (sortKey != null) {
                reqBuilder.setSortKey(sortKey);
            } else {
                LOG.error((Object)("failed to list cross cluster entries, " + sortbyStr + " is not a valid field to sort."));
            }
        }
        if (this.isParamPresent(SORTING_ORDER_PARAM_NAME)) {
            String sortOrder = this.getParamTextValue(SORTING_ORDER_PARAM_NAME, 0);
            boolean descOrder = false;
            if (sortOrder.equalsIgnoreCase(DESCENDING_SORTING_ORDER_PARAM_NAME)) {
                descOrder = true;
            }
            reqBuilder.setSortDescending(descOrder);
        }
        if (this.isParamPresent(SHOW_PRIMARY_PARAM) && this.getParamBooleanValue(SHOW_PRIMARY_PARAM, 0)) {
            reqBuilder.setShowPrimary(true);
        }
        if (this.isParamPresent(LICENSE_INFO_PARAM_NAME) && this.getParamBooleanValue(LICENSE_INFO_PARAM_NAME, 0)) {
            reqBuilder.setLicenseInfo(true);
        }
        return reqBuilder;
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        if (this.isParamPresent(CLUSTERNAME_PARAM)) {
            return false;
        }
        int start = this.isParamPresent(START_PARAM_NAME) ? this.getParamIntValue(START_PARAM_NAME, 0) : 0;
        int limit = this.isParamPresent(LIMIT_PARAM_NAME) ? this.getParamIntValue(LIMIT_PARAM_NAME, 0) : Integer.MAX_VALUE;
        CLDBProto.ClusterGroupListResponse resp = (CLDBProto.ClusterGroupListResponse)prevResp;
        int numItemsReceived = resp.getCcConfsCount();
        boolean retVal = this.hasMore(start, limit, ((CLDBProto.ClusterGroupListRequest)prevReq).getLimiter().getStart(), numItemsReceived);
        LOG.debug((Object)("hasMore: " + start + ", " + limit + ", " + ((CLDBProto.ClusterGroupListRequest)prevReq).getLimiter().getStart() + ", " + numItemsReceived + ",   hasMore:" + retVal));
        return retVal;
    }

    private boolean isValidIpPorts(CommandOutput.OutputHierarchy oh, String ipPorts) {
        String[] cldbIpPorts = ipPorts.split(" ");
        if (cldbIpPorts.length == 0) {
            LOG.error((Object)"ip-port tuple not found.");
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "ip-port tuple found."));
            return false;
        }
        for (int i = 0; i < cldbIpPorts.length; ++i) {
            String[] cldbProp = cldbIpPorts[i].split(":");
            if (cldbProp.length < 2) {
                LOG.error((Object)("Invalid ip:port tuple.: " + cldbIpPorts[i]));
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Invalid ip:port tuple."));
                return false;
            }
            LOG.error((Object)("CLDB properties : " + cldbProp[0] + "  " + cldbProp[1]));
            if (Util.isInteger((String)cldbProp[1])) continue;
            LOG.error((Object)("Invalid port value: " + cldbIpPorts[i]));
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Invalid port value"));
            return false;
        }
        return true;
    }

    private String removeExternalIps(String cldbips, String cldbextips) {
        HashSet<String> extips = new HashSet<String>(Arrays.asList(cldbextips.split(" ")));
        StringBuilder sb = new StringBuilder();
        for (String ip : cldbips.split(" ")) {
            if (extips.contains(ip)) continue;
            sb.append(ip + " ");
        }
        return sb.toString().trim();
    }

    static {
        CLDBProto.ClusterGroupConfInfoFields[] values = CLDBProto.ClusterGroupConfInfoFields.values();
        int max = 0;
        CLDBProto.ClusterGroupConfInfoFields[] clusterGroupConfInfoFieldsArray = values;
        int n = clusterGroupConfInfoFieldsArray.length;
        for (int i = 0; i < n; ++i) {
            CLDBProto.ClusterGroupConfInfoFields value = clusterGroupConfInfoFieldsArray[i];
            if (value.getNumber() <= max) continue;
            max = value.getNumber();
        }
        MAX_XCLUSTERCONFINFOFIELD = max;
        nameToEnumMap = new HashMap<String, CLDBProto.ListSortKey>();
        StringBuilder sb = new StringBuilder();
        for (CLDBProto.ListSortKey key : CLDBProto.ListSortKey.values()) {
            if (!key.name().startsWith("ClusterGroup")) continue;
            String displayName = key.name().toLowerCase().substring("ClusterGroup".length());
            nameToEnumMap.put(displayName, key);
            if (sb.length() == 0) {
                sb.append(displayName);
                continue;
            }
            sb.append("|" + displayName);
        }
        supportedSortKeys = "<" + sb.toString() + ">";
        for (FieldInfo fInfo : fieldTable.values()) {
            CLDBProto.ListSortKey sKey = fInfo.getListSortKey();
            if (sKey == null) continue;
            nameToEnumMap.put(fInfo.getShortName().toLowerCase(), sKey);
            nameToEnumMap.put(fInfo.getLongName().toLowerCase(), sKey);
        }
        ClusterGroupSetPrimaryCommand = new CLICommand(CLUSTERGROUP_COMMAND_SETPRIMARY, "Sets the primary cluster information and adds itself to the group usage: clustergroup setprimary -clustername <cluster name> -cldbips \"hostname1:port1 hostname2:port2 ....\" -crossclusterticket \"<crossclusterticket>\"", ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)CLUSTERNAME_PARAM, (Object)new TextInputParameter(CLUSTERNAME_PARAM, "name of the primary cluster of the group", true, null)).put((Object)CLDBIPS_PARAM, (Object)new TextInputParameter(CLDBIPS_PARAM, "\"hostname1:port1 hostname2:port2....\" of the primary cluster", true, null)).put((Object)CLDBEXTIPS_PARAM, (Object)new TextInputParameter(CLDBEXTIPS_PARAM, "\"extIpHost1:port1 extIpHost2:port2....\" external ip of the primary cluster", false, null)).put((Object)CROSSCLUSTER_TICKET_PARAM, (Object)new TextInputParameter(CROSSCLUSTER_TICKET_PARAM, "cross cluster ticket of the primary cluster", false, null)).put((Object)CCTK_FILEPATH_PARAM, (Object)new TextInputParameter(CCTK_FILEPATH_PARAM, "cross cluster ticket file path of the primary cluster", false, null)).build(), null).setShortUsage(ClusterGroupSetPrimaryUsage);
        ClusterGroupUpdatePrimaryCommand = new CLICommand(CLUSTERGROUP_COMMAND_UPDATEPRIMARY, ClusterGroupUpdatePrimaryUsage, ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)CLUSTERNAME_PARAM, (Object)new TextInputParameter(CLUSTERNAME_PARAM, "name of the exisiting cluster to be made as the new primary", true, null)).build(), null).setShortUsage(ClusterGroupUpdatePrimaryUsage);
        ClusterGroupS3Command = new CLICommand(CLUSTERGROUP_COMMAND_S3GNS, "usage: clustergroup s3gns -httpsmode <forward/redirect>", ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)S3HTTPSMODE_PARAM, (Object)new TextInputParameter(S3HTTPSMODE_PARAM, "either forward OR redirect. In Forward mode server sends the cross fabric request, while in redirect mode client.", false, null)).put((Object)S3GNS_ENABLED, (Object)new BooleanInputParameter(S3GNS_ENABLED, "enabling S3GNS will overwrite existing keys/IAM policies of the non-primary cluster.", false, null)).build(), null).setShortUsage(ClusterGroupS3GNSUsage);
        ClusterGroupGlobalIAMPolicyServerCommand = new CLICommand(CLUSTERGROUP_COMMAND_GLOBALPOLICYIAM, "usage: clustergroup globaliampolicyserver -enable <true/false>", ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)GLOBALPOLICYIAM_ENABLE_PARAM, (Object)new BooleanInputParameter(GLOBALPOLICYIAM_ENABLE_PARAM, "enabling Global IAM Policy Server will overwrite IAM policies of the non-primary cluster.", false, null)).build(), null).setShortUsage(ClusterGroupGlobalIAMPolicyServerUsage);
        ClusterGroupRemoveCommand = new CLICommand(CLUSTERGROUP_COMMAND_REMOVE, "usage: clustergroup remove -clustername name", ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)CLUSTERNAME_PARAM, (Object)new TextInputParameter(CLUSTERNAME_PARAM, "name of the cluster/external server to be removed from the group", true, null)).build(), null).setShortUsage(ClusterGroupRemoveUsage);
        ClusterGroupAddExternalCommand = new CLICommand(CLUSTERGROUP_COMMAND_ADD_EXTERNAL, "usage: clustergroup addexternal -type nfs/s3 -externalservername nfs/s3_servername -ips comma seperated list of ips", ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)EXTERNAL_SERVER_TYPE_PARAM, (Object)new TextInputParameter(EXTERNAL_SERVER_TYPE_PARAM, "Type of the external server being added, nfs/s3", true, null)).put((Object)EXTERNAL_SERVER_NAME_PARAM, (Object)new TextInputParameter(EXTERNAL_SERVER_NAME_PARAM, "External server name that would appear in global namespace", true, null)).put((Object)EXTERNAL_SERVER_IPS_PARAM, (Object)new TextInputParameter(EXTERNAL_SERVER_IPS_PARAM, "Comma seperated list of external server ips", false, null)).put((Object)EXTERNAL_SERVER_ACCESSKEY_PARAM, (Object)new TextInputParameter(EXTERNAL_SERVER_ACCESSKEY_PARAM, "Access key in case of S3 server", false, null)).put((Object)EXTERNAL_SERVER_SECRETEKEY_PARAM, (Object)new TextInputParameter(EXTERNAL_SERVER_SECRETEKEY_PARAM, "Secret key in case of S3 server", false, null)).put((Object)EXTERNAL_SERVER_AWS_WEBIDROLE_ARN, (Object)new TextInputParameter(EXTERNAL_SERVER_AWS_WEBIDROLE_ARN, "AWS web-identity role ARN for STS based access", false, null)).put((Object)EXTERNAL_SERVER_S3VENDOR, (Object)new TextInputParameter(EXTERNAL_SERVER_S3VENDOR, "External S3 server vendor, either AWS OR GCP OR Generic", false, null)).put((Object)EXTERNAL_SERVER_AWSREGION, (Object)new TextInputParameter(EXTERNAL_SERVER_AWSREGION, "AWS region in case the S3 vendor type is AWS", false, null)).put((Object)EXTERNAL_SERVER_GCPREGION, (Object)new TextInputParameter(EXTERNAL_SERVER_GCPREGION, "GCP region in case the S3 vendor type is GCP", false, null)).put((Object)"force", (Object)new NoValueInputParameter("force", "if provided skip checking external server ips", false, false)).put((Object)EXTERNAL_SERVER_S3TLS, (Object)new BooleanInputParameter(EXTERNAL_SERVER_S3TLS, "Use TLSEncryption for external s3", false, Boolean.valueOf(true))).put((Object)EXTERNAL_SERVER_S3PORT, (Object)new TextInputParameter(EXTERNAL_SERVER_S3PORT, "Port on which s3server is listening, default 9000", false, null)).put((Object)EXTERNAL_SERVER_S3CERT, (Object)new TextInputParameter(EXTERNAL_SERVER_S3CERT, "External S3 server certificate", false, null)).put((Object)EXTERNAL_SERVER_S3CERTPATH, (Object)new TextInputParameter(EXTERNAL_SERVER_S3CERTPATH, "External S3 server certificate file path", false, null)).put((Object)EXTERNAL_SERVER_S3PROTO, (Object)new TextInputParameter(EXTERNAL_SERVER_S3PROTO, "S3 server transfer proto, either https or http, default https", false, "https")).build(), null).setShortUsage(ClusterGroupAddExternalUsage);
        ClusterGroupGetCgTableCommand = new CLICommand(CLUSTERGROUP_COMMAND_GET_CG_TABLE, "", ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)SHOW_PRIMARY_PARAM, (Object)new BooleanInputParameter(SHOW_PRIMARY_PARAM, "display cluster info for cluster group primary only", false, Boolean.valueOf(false))).put((Object)CLUSTERNAME_PARAM, (Object)new TextInputParameter(CLUSTERNAME_PARAM, "name of cluster", false, null)).put((Object)LICENSE_INFO_PARAM_NAME, (Object)new BooleanInputParameter(LICENSE_INFO_PARAM_NAME, "get license info", false, Boolean.valueOf(false))).build(), null).setShortUsage(ClusterGroupGetCgTableUsage);
        ClusterGroupSetUpgradeCommand = new CLICommand(CLUSTERGROUP_COMMAND_SETUPGRADE, "", ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)SETUPGRADE_STATUS_PARAM, (Object)new TextInputParameter(SETUPGRADE_STATUS_PARAM, "set upgrade status for given cluster", true, null)).put((Object)CLUSTERNAME_PARAM, (Object)new TextInputParameter(CLUSTERNAME_PARAM, "name of cluster", true, null)).build(), null).setUsageInVisible(true).setShortUsage(ClusterGroupSetUpgradeUsage);
        ClusterGroupShowClusterCertCommand = new CLICommand(CLUSTERGROUP_COMMAND_SHOW_CLUSTER_CERT, "", ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)CLUSTERNAME_PARAM, (Object)new TextInputParameter(CLUSTERNAME_PARAM, "name of cluster", false, null)).put((Object)ALLCLUSTERS_PARAM, (Object)new BooleanInputParameter(ALLCLUSTERS_PARAM, "all clusters <true/false>", false, null)).build(), null).setUsageInVisible(true).setShortUsage(ClusterGroupGetCgTableUsage);
        ClusterGroupFetchChainCaCommand = new CLICommand(CLUSTERGROUP_COMMAND_FETCH_CHAIN_CA, "", ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)CLUSTERNAME_PARAM, (Object)new TextInputParameter(CLUSTERNAME_PARAM, "name of cluster", false, null)).put((Object)ALLCLUSTERS_PARAM, (Object)new BooleanInputParameter(ALLCLUSTERS_PARAM, "all clusters <true/false>", false, null)).build(), null).setShortUsage(ClusterGroupGetCgTableUsage);
        ClusterGroupGenerateClusterConfCommand = new CLICommand(CLUSTERGROUP_COMMAND_GENERATE_CLUSTER_CONF, "", ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().build(), null).setShortUsage(ClusterGroupGenerateClusterConfUsage);
        ClusterGroupListCommand = new CLICommand(CLUSTERGROUP_COMMAND_LIST, "", ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)SORT_DIRECTION_PARAM_NAME, (Object)new TextInputParameter(SORT_DIRECTION_PARAM_NAME, "none", false, "ASC").setInvisible(true)).put((Object)SORTBY_PARAM_NAME, (Object)new TextInputParameter(SORTBY_PARAM_NAME, supportedSortKeys + ", column names of supported fields.", false, null)).put((Object)SORTING_ORDER_PARAM_NAME, (Object)new TextInputParameter(SORTING_ORDER_PARAM_NAME, "<asc|desc>", false, null)).put((Object)OUTPUT_PARAM_NAME, (Object)new TextInputParameter(OUTPUT_PARAM_NAME, "verbose", false, "verbose")).put((Object)START_PARAM_NAME, (Object)new IntegerInputParameter(START_PARAM_NAME, START_PARAM_NAME, false, Integer.valueOf(0))).put((Object)LIMIT_PARAM_NAME, (Object)new IntegerInputParameter(LIMIT_PARAM_NAME, LIMIT_PARAM_NAME, false, Integer.valueOf(Integer.MAX_VALUE))).build(), null).setUsageInVisible(true).setShortUsage(ClusterGroupListUsage);
        ClusterGroupGetNfsExportsCommand = new CLICommand(CLUSTERGROUP_COMMAND_GET_NFS_EXPORTS, "usage: clustergroup getnfsexports -externalservername nfs server name", ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)EXTERNAL_SERVER_NAME_PARAM, (Object)new TextInputParameter(EXTERNAL_SERVER_NAME_PARAM, "name of the external server for exports info", true, null)).put((Object)START_PARAM_NAME, (Object)new IntegerInputParameter(START_PARAM_NAME, START_PARAM_NAME, false, Integer.valueOf(0))).put((Object)LIMIT_PARAM_NAME, (Object)new IntegerInputParameter(LIMIT_PARAM_NAME, LIMIT_PARAM_NAME, false, Integer.valueOf(Integer.MAX_VALUE))).build(), null).setShortUsage(ClusterGroupGetNfsExportsUsage);
        ClusterGroupUpdateS3UserCommand = new CLICommand(CLUSTERGROUP_COMMAND_UPDATE_S3_USER, "usage: clustergroup updates3user -externalservername s3 server name -action addaccessors|removeaccessors|updateowner -oweruid uid -accessorusers comma seperated list of accessor users -accessorgroups comma seperated list of accessor groups updateowner action need owner param only and addaccessors/removeaccessors action need atleast one of accessorusers or accessorgroups", ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)EXTERNAL_SERVER_NAME_PARAM, (Object)new TextInputParameter(EXTERNAL_SERVER_NAME_PARAM, "name of the external server", true, null)).put((Object)EXTERNAL_SERVER_S3_USER_ACTION, (Object)new TextInputParameter(EXTERNAL_SERVER_S3_USER_ACTION, "addaccessors|removeaccessors|updateowner", true, null)).put((Object)EXTERNAL_SERVER_S3_ACCESSORUSERS, (Object)new TextInputParameter(EXTERNAL_SERVER_S3_ACCESSORUSERS, "comma seperated list of accessor users", false, null)).put((Object)EXTERNAL_SERVER_S3_ACCESSORGROUPS, (Object)new TextInputParameter(EXTERNAL_SERVER_S3_ACCESSORGROUPS, "comma seperated list of accessor groups", false, null)).put((Object)EXTERNAL_SERVER_S3_OWNER, (Object)new TextInputParameter(EXTERNAL_SERVER_S3_OWNER, "owner name", false, null)).build(), null).setShortUsage(ClusterGroupUpdateS3UserUsage);
        ClusterGroupRestoreTableCommand = new CLICommand(CLUSTERGROUP_COMMAND_RESTORE_TABLE, "", ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)TABLEPATH_PARAM, (Object)new TextInputParameter(TABLEPATH_PARAM, "table path", false, null)).put((Object)ALLTABLES_PARAM, (Object)new NoValueInputParameter(ALLTABLES_PARAM, "restore all tables", false, false)).build(), null).setUsageInVisible(true).setShortUsage(ClusterGroupRestoreTableUsage);
        clusterGroupCommands = new CLICommand[]{ClusterGroupSetPrimaryCommand, ClusterGroupUpdatePrimaryCommand, ClusterGroupRemoveCommand, ClusterGroupListCommand, ClusterGroupGetCgTableCommand, ClusterGroupAddExternalCommand, ClusterGroupSetUpgradeCommand, ClusterGroupShowClusterCertCommand, ClusterGroupGetNfsExportsCommand, ClusterGroupGenerateClusterConfCommand, ClusterGroupS3Command, ClusterGroupFetchChainCaCommand, ClusterGroupRestoreTableCommand, ClusterGroupUpdateS3UserCommand, ClusterGroupGlobalIAMPolicyServerCommand};
    }
}

