/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.marlin;

import com.google.common.collect.ImmutableMap;
import com.mapr.cli.DbReplicaCommands;
import com.mapr.cli.marlin.StreamsCommands;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;

public class StreamCompactCommands
extends DbReplicaCommands {
    private static final Logger LOG = Logger.getLogger(StreamCompactCommands.class);
    private static final String PATH_PARAM_NAME = "path";
    public static final CLICommand compactInfoCommand = new CLICommand("compactinfo", "usage: stream compactinfo -path <path>", StreamCompactCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Stream Path", true, null)).build(), null).setShortUsage("stream [compactinfo] -path <path>").setUsageInVisible(true);

    public StreamCompactCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    @Override
    public String entityName() {
        return "stream";
    }

    @Override
    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        String streamPath = this.getParamTextValue(PATH_PARAM_NAME, 0);
        try {
            if (!StreamsCommands.isStream(streamPath)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Path " + streamPath + " is not a valid stream"));
                return output;
            }
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
            return output;
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        String cname = this.cliCommand.getCommandName();
        if (cname.equalsIgnoreCase(compactInfoCommand.getCommandName())) {
            this.listReplica(out);
        }
        return output;
    }

    @Override
    protected void listReplica(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        super.listLogCompactionReplica(out);
    }
}

