/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.common.RemoteCommandExecutor;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.proto.clustermetrics.ClusterMetricsProto;
import com.mapr.util.MapRFSUtil;
import java.io.EOFException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;

public class NodeMetricsCommand
extends CLIBaseClass
implements CLIInterface {
    private static final Log LOG = LogFactory.getLog(NodeMetricsCommand.class);
    public static final String NODES_PARAM = "nodes";
    public static final String START_TIME_PARAM = "start";
    public static final String END_TIME_PARAM = "end";
    public static final String INTERVAL_PARAM = "interval";
    public static final String EVENTS_PARAM = "events";
    public static final String COLUMNS_PARAM = "columns";
    public static final String NODE_PARAM = "node";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String PROCESSES_NUMBER_PARAM_NAME = "numberofprocesses";
    public static final int MIN_INTERVAL = 10;
    static String[][] processListFieldNames = new String[][]{{"mem", "memory"}, {"pid", "processid"}, {"cpu", "cpu"}, {"euser", "user"}, {"sz", "realmemoryusage"}, {"rss", "virtualmemoryusage"}, {"pri", "priority"}, {"s", "processstatuscode"}, {"cmd", "command"}};
    public static final CLICommand nodeMetricsCmd = new CLICommand("metrics", "display node metrics ", NodeMetricsCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"nodes", (Object)new TextInputParameter("nodes", "space-separated list of node names", true, null)).put((Object)"start", (Object)new TextInputParameter("start", "start_time (UTC timestamp in millisecond or a UTC date in MM/DD/YY format)", true, null)).put((Object)"end", (Object)new TextInputParameter("end", "end_time (UTC timestamp in millisecond or a UTC date in MM/DD/YY format)", true, null)).put((Object)"interval", (Object)new IntegerInputParameter("interval", "interval (in seconds. Minimum value is 10 seconds)", false, null)).put((Object)"events", (Object)new BooleanInputParameter("events", "print node events only", false, Boolean.valueOf(false))).put((Object)"columns", (Object)new TextInputParameter("columns", "columns", false, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build(), null).setShortUsage("metrics -nodes <nodes> -start <start time> -end <end time> [-interval <interval seconds> -events <1|0> -cluster <clustername>]");
    public static final CLICommand showMemoryCmd = new CLICommand("show", "display services memory", NodeMetricsCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"node", (Object)new TextInputParameter("node", "node name", true, null)).put((Object)"numberofprocesses", (Object)new TextInputParameter("numberofprocesses", "number of processes ", false, "10")).put((Object)"output", (Object)new TextInputParameter("output", "<terse|verbose>", false, "verbose")).build(), null).setShortUsage("show -node <node>");

    public NodeMetricsCommand(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    private static String prefixedInt(int n) {
        return (n < 10 ? "0" : "") + n;
    }

    private boolean canPrintMetricColumn(String[] columnsArr, String column) {
        if (columnsArr == null || columnsArr.length == 0) {
            return true;
        }
        for (String c : columnsArr) {
            if (!c.equalsIgnoreCase(column)) continue;
            return true;
        }
        return false;
    }

    private void printNodeMetrics(String node, ClusterMetricsProto.NodeMetric nm, long timestamp, boolean events, CommandOutput.OutputHierarchy out, String[] columnsArr) {
        if (!nm.hasMetricAttrs()) {
            return;
        }
        int version = this.getVersion();
        if (!events) {
            ClusterMetricsProto.NodeMetric.FinalMetric fm;
            CommandOutput.OutputHierarchy.OutputNode metricsNode = new CommandOutput.OutputHierarchy.OutputNode();
            metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("NODE", (Object)node));
            metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("TIMESTAMPSTR", new Date(timestamp), version));
            metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("TIMESTAMP", timestamp));
            if (nm.getCpuMetricsList() != null && nm.getCpuMetricsCount() > 0 && this.canPrintMetricColumn(columnsArr, "CPUS")) {
                CommandOutput.OutputHierarchy.OutputNode cpuNodes = new CommandOutput.OutputHierarchy.OutputNode("CPUS");
                for (ClusterMetricsProto.NodeMetric.CpuMetrics cm : nm.getCpuMetricsList()) {
                    CommandOutput.OutputHierarchy.OutputNode cpuNode = new CommandOutput.OutputHierarchy.OutputNode(cm.getCpuName());
                    if (cm.hasCpuIdle()) {
                        cpuNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("CPUIDLE", cm.getCpuIdle()));
                    }
                    if (cm.hasCpuIowait()) {
                        cpuNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("CPUIOWAIT", cm.getCpuIowait()));
                    }
                    if (cm.hasCpuTotal()) {
                        cpuNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("CPUTOTAL", cm.getCpuTotal()));
                    }
                    cpuNodes.addChild(cpuNode);
                }
                if (cpuNodes.getChildren() != null && !cpuNodes.getChildren().isEmpty()) {
                    metricsNode.addChild(cpuNodes);
                }
            }
            if (nm.getDiskMetricsList() != null && nm.getDiskMetricsCount() > 0 && this.canPrintMetricColumn(columnsArr, "DISKS")) {
                CommandOutput.OutputHierarchy.OutputNode diskNodes = new CommandOutput.OutputHierarchy.OutputNode("DISKS");
                for (ClusterMetricsProto.NodeMetric.DiskMetrics dm : nm.getDiskMetricsList()) {
                    CommandOutput.OutputHierarchy.OutputNode diskNode = new CommandOutput.OutputHierarchy.OutputNode(dm.getDiskName());
                    if (dm.hasReadOps()) {
                        diskNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("READOPS", dm.getReadOps()));
                    }
                    if (dm.hasReadKBytes()) {
                        diskNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("READKB", dm.getReadKBytes()));
                    }
                    if (dm.hasWriteOps()) {
                        diskNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("WRITEOPS", dm.getWriteOps()));
                    }
                    if (dm.hasWriteKBytes()) {
                        diskNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("WRITEKB", dm.getWriteKBytes()));
                    }
                    diskNodes.addChild(diskNode);
                }
                if (diskNodes.getChildren() != null && !diskNodes.getChildren().isEmpty()) {
                    metricsNode.addChild(diskNodes);
                }
            }
            if (nm.getNetMetricsList() != null && nm.getNetMetricsCount() > 0 && this.canPrintMetricColumn(columnsArr, "NETWORK")) {
                CommandOutput.OutputHierarchy.OutputNode networkNodes = new CommandOutput.OutputHierarchy.OutputNode("NETWORK");
                for (ClusterMetricsProto.NodeMetric.NetworkMetrics ntm : nm.getNetMetricsList()) {
                    CommandOutput.OutputHierarchy.OutputNode networkNode = new CommandOutput.OutputHierarchy.OutputNode(ntm.getIfaceName());
                    if (ntm.hasBytesIn()) {
                        networkNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("BYTESIN", ntm.getBytesIn()));
                    }
                    if (ntm.hasBytesOut()) {
                        networkNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("BYTESOUT", ntm.getBytesOut()));
                    }
                    if (ntm.hasPktsIn()) {
                        networkNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("PKTSIN", ntm.getPktsIn()));
                    }
                    if (ntm.hasPktsOut()) {
                        networkNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("PKTSOUT", ntm.getPktsOut()));
                    }
                    networkNodes.addChild(networkNode);
                }
                if (networkNodes.getChildren() != null && !networkNodes.getChildren().isEmpty()) {
                    metricsNode.addChild(networkNodes);
                }
            }
            if (nm.hasFinalMetric() && (fm = nm.getFinalMetric()) != null && fm.hasHostid() && this.canPrintMetricColumn(columnsArr, "HOSTID")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("HOSTID", (Object)fm.getHostid()));
            }
            if (nm.hasCpuUptime() && this.canPrintMetricColumn(columnsArr, "CPUTIME")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("CPUUPTIME", nm.getCpuUptime()));
            }
            if (nm.hasMemoryUsed() && this.canPrintMetricColumn(columnsArr, "MEMORYUSED")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("MEMORYUSED", nm.getMemoryUsed()));
            }
            if (nm.hasCpuIdle() && this.canPrintMetricColumn(columnsArr, "CPUIDLE")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("CPUIDLE", nm.getCpuIdle()));
            }
            if (nm.hasReadOps() && this.canPrintMetricColumn(columnsArr, "READOPS")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("READOPS", nm.getReadOps()));
            }
            if (nm.hasReadKBytes() && this.canPrintMetricColumn(columnsArr, "READKBYTES")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("READKBYTES", nm.getReadKBytes()));
            }
            if (nm.hasWriteOps() && this.canPrintMetricColumn(columnsArr, "WRITEOPS")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("WRITEOPS", nm.getWriteOps()));
            }
            if (nm.hasWriteKBytes() && this.canPrintMetricColumn(columnsArr, "WRITEKBYTES")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("WRITEKBYTES", nm.getWriteKBytes()));
            }
            if (nm.hasBytesIn() && this.canPrintMetricColumn(columnsArr, "BYTESIN")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("BYTESIN", nm.getBytesIn()));
            }
            if (nm.hasBytesOut() && this.canPrintMetricColumn(columnsArr, "BYTESOUT")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("BYTESOUT", nm.getBytesOut()));
            }
            if (nm.hasServerUsedSizeMB() && this.canPrintMetricColumn(columnsArr, "SERVUSEDSIZEMB")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("SERVUSEDSIZEMB", nm.getServerUsedSizeMB()));
            }
            if (nm.hasServerAvailableSizeMB() && this.canPrintMetricColumn(columnsArr, "SERVAVAILSIZEMB")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("SERVAVAILSIZEMB", nm.getServerAvailableSizeMB()));
            }
            if (nm.hasRpcCount() && this.canPrintMetricColumn(columnsArr, "RPCCOUNT")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("RPCCOUNT", nm.getRpcCount()));
            }
            if (nm.hasRpcInBytes() && this.canPrintMetricColumn(columnsArr, "RPCINBYTES")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("RPCINBYTES", nm.getRpcInBytes()));
            }
            if (nm.hasRpcOutBytes() && this.canPrintMetricColumn(columnsArr, "RPCOUTBYTES")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("RPCOUTBYTES", nm.getRpcOutBytes()));
            }
            if (nm.hasCpuNice() && this.canPrintMetricColumn(columnsArr, "CPUNICE")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("CPUNICE", nm.getCpuNice()));
            }
            if (nm.hasCpuSystem() && this.canPrintMetricColumn(columnsArr, "CPUSYSTEM")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("CPUSYSTEM", nm.getCpuSystem()));
            }
            if (nm.hasCpuUser() && this.canPrintMetricColumn(columnsArr, "CPUUSER")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("CPUUSER", nm.getCpuUser()));
            }
            if (nm.hasMemoryCached() && this.canPrintMetricColumn(columnsArr, "MEMORYCACHED")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("MEMORYCACHED", nm.getMemoryCached()));
            }
            if (nm.hasMemoryShared() && this.canPrintMetricColumn(columnsArr, "MEMORYSHARED")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("MEMORYSHARED", nm.getMemoryShared()));
            }
            if (nm.hasMemoryBuffers() && this.canPrintMetricColumn(columnsArr, "MEMORYBUFFERS")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("MEMORYBUFFERS", nm.getMemoryBuffers()));
            }
            if (nm.hasSwapFree() && this.canPrintMetricColumn(columnsArr, "SWAPFREE")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("SWAPFREE", nm.getSwapFree()));
            }
            if (nm.hasPktsIn() && this.canPrintMetricColumn(columnsArr, "PKTSIN")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("PKTSIN", nm.getPktsIn()));
            }
            if (nm.hasPktsOut() && this.canPrintMetricColumn(columnsArr, "PKTSOUT")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("PKTSOUT", nm.getPktsOut()));
            }
            if (nm.hasLoadOnePerc() && this.canPrintMetricColumn(columnsArr, "LOAD1PERCENT")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("LOAD1PERCENT", nm.getLoadOnePerc()));
            }
            if (nm.hasLoadFivePerc() && this.canPrintMetricColumn(columnsArr, "LOAD5PERCENT")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("LOAD5PERCENT", nm.getLoadFivePerc()));
            }
            if (nm.hasLoadFifteenPerc() && this.canPrintMetricColumn(columnsArr, "LOAD15PERCENT")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("LOAD15PERCENT", nm.getLoadFifteenPerc()));
            }
            if (nm.hasProcRun() && this.canPrintMetricColumn(columnsArr, "PROCRUN")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("PROCRUN", nm.getProcRun()));
            }
            if (nm.hasTtmapused() && this.canPrintMetricColumn(columnsArr, "TTMAPUSED")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("TTMAPUSED", nm.getTtmapused()));
            }
            if (nm.hasTtreduceused() && this.canPrintMetricColumn(columnsArr, "TTREDUCEUSED")) {
                metricsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("TTREDUCEUSED", nm.getTtreduceused()));
            }
            out.addNode(metricsNode);
        } else if (nm.hasEventMetric()) {
            CommandOutput.OutputHierarchy.OutputNode eventsNode = new CommandOutput.OutputHierarchy.OutputNode();
            eventsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("NODE", (Object)node));
            eventsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("TIMESTAMP", timestamp));
            ClusterMetricsProto.NodeMetric.EventMetric nEventMetric = nm.getEventMetric();
            if (nEventMetric.hasDiskCount() && this.canPrintMetricColumn(columnsArr, "DISCKCOUNT")) {
                eventsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("DISKCOUNT", nEventMetric.getDiskCount()));
            }
            if (nEventMetric.hasCpuCount() && this.canPrintMetricColumn(columnsArr, "CPUCOUNT")) {
                eventsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("CPUCOUNT", nEventMetric.getCpuCount()));
            }
            if (nEventMetric.hasTotalMB() && this.canPrintMetricColumn(columnsArr, "TOTALMEMORY")) {
                eventsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("TOTALMEMORY", nEventMetric.getTotalMB()));
            }
            if (nEventMetric.hasRootFull() && this.canPrintMetricColumn(columnsArr, "ROOTFULLSTATUS")) {
                eventsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("ROOTFULLSTATUS", (Object)nEventMetric.getRootFull()));
            }
            if (nEventMetric.hasOptMaprFull() && this.canPrintMetricColumn(columnsArr, "MAPRFULLSTATUS")) {
                eventsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("MAPRFULLSTATUS", (Object)nEventMetric.getOptMaprFull()));
            }
            if (nEventMetric.hasCorePresent() && this.canPrintMetricColumn(columnsArr, "COREPRESENTSTATUS")) {
                eventsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("COREPRESENTSTATUS", (Object)nEventMetric.getCorePresent()));
            }
            if (nEventMetric.hasNicCount() && this.canPrintMetricColumn(columnsArr, "TOTALNICS")) {
                eventsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("TOTALNICS", nEventMetric.getNicCount()));
            }
            if (nEventMetric.hasFaileddisks() && this.canPrintMetricColumn(columnsArr, "FAILEDDISKS")) {
                eventsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("FAILEDDISKS", nEventMetric.getFaileddisks()));
            }
            if (nEventMetric.hasMaprdiskCount() && this.canPrintMetricColumn(columnsArr, "MAPRDISKCOUNT")) {
                eventsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("MAPRDISKCOUNT", nEventMetric.getMaprdiskCount()));
            }
            if (nEventMetric.hasServerCapacitySizeMB() && this.canPrintMetricColumn(columnsArr, "SERVCAPACITYSIZEMB")) {
                eventsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("SERVCAPACITYSIZEMB", nEventMetric.getServerCapacitySizeMB()));
            }
            if (nEventMetric.hasSwapTotal() && this.canPrintMetricColumn(columnsArr, "SWAPTOTAL")) {
                eventsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("SWAPTOTAL", nEventMetric.getSwapTotal()));
            }
            if (nEventMetric.hasTtmapslots() && this.canPrintMetricColumn(columnsArr, "TTMAPSLOTS")) {
                eventsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("TTMAPSLOTS", nEventMetric.getTtmapslots()));
            }
            if (nEventMetric.hasTtreduceslots() && this.canPrintMetricColumn(columnsArr, "TTREDUCESLOTS")) {
                eventsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("TTREDUCESLOTS", nEventMetric.getTtreduceslots()));
            }
            if (nEventMetric.getConfServiceList() != null && nEventMetric.getConfServiceCount() > 0) {
                for (ClusterMetricsProto.Pair p : nEventMetric.getConfServiceList()) {
                    if (!this.canPrintMetricColumn(columnsArr, p.getName())) continue;
                    eventsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(p.getName(), (Object)p.getValue()));
                }
            }
            if (nEventMetric.getRunningServiceList() != null && nEventMetric.getRunningServiceCount() > 0) {
                for (ClusterMetricsProto.Pair p : nEventMetric.getRunningServiceList()) {
                    if (!this.canPrintMetricColumn(columnsArr, p.getName())) continue;
                    eventsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(p.getName(), (Object)p.getValue()));
                }
            }
            if (nEventMetric.getServiceFailedList() != null && nEventMetric.getServiceFailedCount() > 0) {
                for (ClusterMetricsProto.Pair p : nEventMetric.getServiceFailedList()) {
                    if (!this.canPrintMetricColumn(columnsArr, p.getName())) continue;
                    eventsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(p.getName(), (Object)p.getValue()));
                }
            }
            if (nEventMetric.getServiceStoppedList() != null && nEventMetric.getServiceStoppedCount() > 0) {
                for (ClusterMetricsProto.Pair p : nEventMetric.getServiceStoppedList()) {
                    if (!this.canPrintMetricColumn(columnsArr, p.getName())) continue;
                    eventsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(p.getName(), (Object)p.getValue()));
                }
            }
            if (nEventMetric.getAlarmsList() != null && nEventMetric.getAlarmsCount() > 0) {
                for (ClusterMetricsProto.Pair p : nEventMetric.getAlarmsList()) {
                    if (!this.canPrintMetricColumn(columnsArr, p.getName())) continue;
                    eventsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(p.getName(), (Object)p.getValue()));
                }
            }
            out.addNode(eventsNode);
        }
    }

    private long parseNodeMetricsFromProto(String node, byte[] buf, int interval, boolean events, CommandOutput.OutputHierarchy out, String[] columnsArr, long prevTimestamp) throws InvalidProtocolBufferException {
        ClusterMetricsProto.CombineMessageRequest.Builder requestBuilder = (ClusterMetricsProto.CombineMessageRequest.Builder)ClusterMetricsProto.CombineMessageRequest.newBuilder().mergeFrom(buf);
        for (ClusterMetricsProto.TimedMetric tm : requestBuilder.getTimedMetricList()) {
            if (interval > 10 && tm.getTimestamp() < prevTimestamp + (long)(1000 * interval)) continue;
            prevTimestamp = tm.getTimestamp();
            for (ClusterMetricsProto.Metric m : tm.getMetricList()) {
                if (!m.hasNodeMetric()) continue;
                this.printNodeMetrics(node, m.getNodeMetric(), tm.getTimestamp(), events, out, columnsArr);
            }
        }
        return prevTimestamp;
    }

    private long readNodeMetricsFromFile(String node, MapRFileSystem fs, String metricsFile, int startHour, int endHour, int interval, boolean events, CommandOutput.OutputHierarchy out, String[] columnsArr, long prevTimestamp) {
        FSDataInputStream fsdisM = null;
        try {
            if (!fs.isFile(new Path(metricsFile))) {
                return prevTimestamp;
            }
            fsdisM = fs.open(new Path(metricsFile));
            int fileLength = fsdisM.readInt();
            while (true) {
                int nextRecordbytes;
                byte[] buf;
                int readBytesCount;
                if ((readBytesCount = fsdisM.read(buf = new byte[nextRecordbytes = fsdisM.readInt()], 0, nextRecordbytes)) < 0) {
                    if (fileLength == nextRecordbytes) {
                        LOG.info((Object)("Reached end of file sucessfully. Lengths match: " + fileLength));
                    } else {
                        LOG.warn((Object)("Warning while reading data file. File might be still being written into. Length does not match. First length: " + fileLength + ", Last Length: " + nextRecordbytes));
                    }
                    if (fsdisM != null) {
                        fsdisM.close();
                    }
                    return prevTimestamp;
                }
                prevTimestamp = this.parseNodeMetricsFromProto(node, buf, interval, events, out, columnsArr, prevTimestamp);
            }
        }
        catch (EOFException e) {
            try {
                if (fsdisM != null) {
                    fsdisM.close();
                }
            }
            catch (Exception e1) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Exception while reading metrics file: " + metricsFile + " for node: " + node + ", " + e.getMessage()));
            }
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Exception while reading metrics file: " + metricsFile + " for node: " + node + ", " + e.getMessage()));
        }
        return prevTimestamp;
    }

    private void readNodeMetricsFromMapRFs(String node, MetricsDate start, MetricsDate end, int interval, boolean events, CommandOutput.OutputHierarchy out, String[] columnsArr) {
        String metricsDir = "/var/mapr/local/" + node + "/metrics/";
        try {
            String cluster;
            if (this.isParamPresent("cluster") && (cluster = this.getParamTextValue("cluster", 0)) != null && !cluster.isEmpty()) {
                metricsDir = "/mapr/" + cluster + metricsDir;
            }
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Could not fetch cluster name: " + e.getMessage()));
            return;
        }
        MapRFileSystem fs = MapRFSUtil.getMapRFileSystem();
        if (fs == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Could not connect to MapR-FS"));
            return;
        }
        try {
            if (!fs.isDirectory(new Path(metricsDir))) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Could not find metrics directory " + metricsDir + " for node: " + node));
                return;
            }
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Exception while checking metrics directory " + metricsDir + " for node: " + node + ", " + e.getMessage()));
            return;
        }
        long prevTimestamp = 0L;
        block4: for (int y = start.year; y <= end.year; ++y) {
            block5: for (int m = 1; m <= 12; ++m) {
                if (y == start.year && m < start.month) continue;
                if (y == end.year && m > end.month) continue block4;
                for (int d = 1; d <= 31; ++d) {
                    if (y == start.year && m == start.month && d < start.date) continue;
                    if (y == end.year && m == end.month && d > end.date) continue block5;
                    int startHour = 0;
                    int endHour = 24;
                    if (y == start.year && m == start.month && d == start.date) {
                        startHour = start.hour;
                    } else if (y == end.year && m == end.month && d == end.date && end.hour != 0) {
                        endHour = end.hour;
                    }
                    for (int hour = startHour; hour < endHour; ++hour) {
                        String metricsFile = metricsDir + "clustermetrics." + y + "-" + NodeMetricsCommand.prefixedInt(m) + "-" + NodeMetricsCommand.prefixedInt(d) + "." + NodeMetricsCommand.prefixedInt(hour) + ":00:00";
                        prevTimestamp = this.readNodeMetricsFromFile(node, fs, metricsFile, startHour, endHour, interval, events, out, columnsArr, prevTimestamp);
                    }
                }
            }
        }
    }

    private Date getValidDate(CommandOutput.OutputHierarchy out, String param, String keyword) {
        try {
            String value = this.getParamTextValue(param, 0);
            if (value == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid " + keyword + " time"));
                return null;
            }
            Date dt = null;
            try {
                dt = new Date(Long.parseLong(value));
            }
            catch (NumberFormatException nfe) {
                try {
                    DateFormat dateInstance = DateFormat.getDateInstance(3);
                    dateInstance.setLenient(false);
                    dt = dateInstance.parse(value);
                }
                catch (ParseException pe) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid " + keyword + " time"));
                    return null;
                }
            }
            if (dt == null) {
                return null;
            }
            if (!dt.after(DateFormat.getDateInstance(3).parse("1/1/70"))) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, keyword + " time cannot be before Unix epoch (1/1/70)"));
                return null;
            }
            return dt;
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Exception while parsing " + keyword + " date " + e.getMessage()));
            return null;
        }
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        CommandOutput co = new CommandOutput(oh);
        String cmd = this.cliCommand.getCommandName();
        if (cmd.equalsIgnoreCase("show")) {
            try {
                String nodeName = this.getParamTextValue(NODE_PARAM, 0);
                String numProcesses = this.getParamTextValue(PROCESSES_NUMBER_PARAM_NAME, 0);
                this.getServicesMemory(nodeName, numProcesses, oh);
            }
            catch (Exception e) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getLocalizedMessage()));
                return co;
            }
        } else if (cmd.equalsIgnoreCase("metrics")) {
            List nodeNames = this.input.getParameterByName(NODES_PARAM).getParamValues();
            if (nodeNames == null || nodeNames.isEmpty()) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid list of nodes"));
                return co;
            }
            Date startDate = this.getValidDate(oh, START_TIME_PARAM, "Start");
            if (startDate == null) {
                return co;
            }
            Date endDate = this.getValidDate(oh, END_TIME_PARAM, "End");
            if (endDate == null) {
                return co;
            }
            if (endDate.compareTo(startDate) < 0) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "End time should be greater than Start time"));
                return co;
            }
            boolean events = this.getParamBooleanValue(EVENTS_PARAM, 0);
            int interval = -1;
            if (this.isParamPresent(INTERVAL_PARAM)) {
                int i = this.getParamIntValue(INTERVAL_PARAM, 0);
                if (i < 10) {
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Interval should be atleast 10 seconds"));
                    return co;
                }
                interval = i;
            }
            String[] columnsArr = null;
            if (this.isParamPresent(COLUMNS_PARAM)) {
                String columns = this.getParamTextValue(COLUMNS_PARAM, 0);
                if (columns != null) {
                    columns = columns.trim();
                }
                columnsArr = columns.split(",");
            }
            if (this.isParamPresent("cluster")) {
                String cluster = this.getParamTextValue("cluster", 0);
                if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(133, "Invalid cluster: " + cluster));
                    return co;
                }
            }
            for (String node : nodeNames) {
                this.readNodeMetricsFromMapRFs(node, new MetricsDate(startDate), new MetricsDate(endDate), interval, events, oh, columnsArr);
            }
        }
        return co;
    }

    public void getServicesMemory(String host, String numProcesses, CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        ClusterMetricsProto.ExecuteCommandRequest.Builder requestBuilder = ClusterMetricsProto.ExecuteCommandRequest.newBuilder();
        requestBuilder.setCommandId(ClusterMetricsProto.CommandId.PROCESS_MEMORY_LIST);
        requestBuilder.setArgs(numProcesses);
        requestBuilder.setCreds(this.getUserCredentials());
        try {
            List<String> response = RemoteCommandExecutor.execute(host, requestBuilder.build());
            for (String s : response) {
                boolean verbose = true;
                if (this.isParamPresent(OUTPUT_PARAM_NAME) && this.getParamTextValue(OUTPUT_PARAM_NAME, 0).equalsIgnoreCase("terse")) {
                    verbose = false;
                }
                if ((s = s.trim()).isEmpty()) continue;
                CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
                StringTokenizer tokenizer = new StringTokenizer(s);
                String[] outputValues = new String[tokenizer.countTokens()];
                int count = 0;
                while (tokenizer.hasMoreTokens()) {
                    outputValues[count++] = tokenizer.nextToken();
                }
                for (int i = 0; i < processListFieldNames.length; ++i) {
                    String columnName = verbose ? processListFieldNames[i][1] : processListFieldNames[i][0].toString();
                    node.addChild(new CommandOutput.OutputHierarchy.OutputNode(columnName, (Object)outputValues[i]));
                }
                oh.addNode(node);
            }
        }
        catch (CLIProcessingException e) {
            throw new CLIProcessingException("Error trying to reach host \"" + host + "\". Check if hostname is valid and up");
        }
    }

    private class MetricsDate {
        public int month;
        public int date;
        public int year;
        public int hour;

        MetricsDate(int m, int d, int y, int h) {
            this.month = m;
            this.date = d;
            this.year = y;
            this.hour = h;
        }

        MetricsDate(Date d) {
            this.month = d.getMonth() + 1;
            this.date = d.getDate();
            this.year = 1900 + d.getYear();
            this.hour = d.getHours();
        }
    }
}

