/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.LongInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.Rpc;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.proto.Gtrace;
import com.mapr.fs.proto.Security;
import com.mapr.login.client.MapRLoginHttpsClient;
import com.mapr.login.common.TicketOptionalParams;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TraceCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(TraceCommands.class);
    public static final String PORT_PARAM_NAME = "port";
    public static final String HOST_PARAM_NAME = "host";
    public static final String USER_MODE_PARAM_NAME = "isusermode";
    public static final String MODULE_PARAM_NAME = "module";
    public static final String LEVEL_PARAM_NAME = "level";
    public static final String SIZE_PARAM_NAME = "size";
    public static final String MODE_PARAM_NAME = "mode";
    public static final String SLOW_OPS_MILLIS_PARAM_NAME = "slowopsmillis";
    static final CLICommand dumpCommand = new CLICommand("dump", "usage: trace dump -host IP/Hostname -port PORT", TraceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"port", (Object)new IntegerInputParameter("port", "port", false, Integer.valueOf(5660))).put((Object)"host", (Object)new TextInputParameter("host", "ip/hostname", false, "127.0.0.1")).put((Object)"isusermode", (Object)new TextInputParameter("isusermode", "isusermode", false, "false")).build(), null).setShortUsage("trace dump -host IP/Hostname -port PORT");
    static final CLICommand resizeCommand = new CLICommand("resize", "usage: trace resize -host IP/Hostname -port PORT -size inKB", TraceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"port", (Object)new IntegerInputParameter("port", "port", false, Integer.valueOf(5660))).put((Object)"host", (Object)new TextInputParameter("host", "ip/hostname", false, "127.0.0.1")).put((Object)"size", (Object)new IntegerInputParameter("size", "size", true, Integer.valueOf(0x200000))).build(), null).setShortUsage("trace resize -host IP/Hostname -port PORT -size inKB");
    static final CLICommand setSlowOpsMillisCommand = new CLICommand("setslowopsmillis", "usage: trace setslowopsmillis -host IP/Hostname -port PORT -slowopsmillis in ms -isusermode true/false", TraceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"port", (Object)new IntegerInputParameter("port", "port", false, Integer.valueOf(5660))).put((Object)"host", (Object)new TextInputParameter("host", "ip/hostname", false, "127.0.0.1")).put((Object)"slowopsmillis", (Object)new LongInputParameter("slowopsmillis", "slowopsmillis", true, (Object)0L)).put((Object)"isusermode", (Object)new TextInputParameter("isusermode", "isusermode", false, "false")).build(), null).setShortUsage("trace setslowopsmillis -host IP/Hostname -port PORT -slowopsmillis in ms -isusermode true/false");
    static final CLICommand setLevelCommand = new CLICommand("setlevel", "usage: trace setlevel -host IP/Hostname -port PORT -module <name/all> -level <level>", TraceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"port", (Object)new IntegerInputParameter("port", "port", false, Integer.valueOf(5660))).put((Object)"host", (Object)new TextInputParameter("host", "ip/hostname", false, "127.0.0.1")).put((Object)"module", (Object)new TextInputParameter("module", "module", true, "all")).put((Object)"level", (Object)new TextInputParameter("level", "level", true, "Info")).put((Object)"isusermode", (Object)new TextInputParameter("isusermode", "isusermode", false, "false")).build(), null).setShortUsage("trace setlevel -host IP/Hostname -port PORT -module <name/all> -level <level>");
    static final CLICommand setModeCommand = new CLICommand("setmode", "usage: trace setmode -host IP/Hostname -port PORT -mode MODE(default/continuous)", TraceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"port", (Object)new IntegerInputParameter("port", "port", false, Integer.valueOf(5660))).put((Object)"host", (Object)new TextInputParameter("host", "ip/hostname", false, "127.0.0.1")).put((Object)"mode", (Object)new TextInputParameter("mode", "ip", true, "default")).put((Object)"isusermode", (Object)new TextInputParameter("isusermode", "isusermode", false, "false")).build(), null).setShortUsage("trace setmode -host IP/Hostname -port PORT -mode MODE");
    static final CLICommand resetCommand = new CLICommand("reset", "usage: trace reset -host IP/Hostname -port PORT", TraceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"port", (Object)new IntegerInputParameter("port", "port", false, Integer.valueOf(5660))).put((Object)"host", (Object)new TextInputParameter("host", "ip/hostname", false, "127.0.0.1")).build(), null).setShortUsage("trace reset -host IP/Hostname -port PORT");
    static final CLICommand infoCommand = new CLICommand("info", "usage: trace info -host IP/Hostname -port PORT", TraceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"port", (Object)new IntegerInputParameter("port", "port", false, Integer.valueOf(5660))).put((Object)"host", (Object)new TextInputParameter("host", "ip/hostname", false, "127.0.0.1")).put((Object)"isusermode", (Object)new TextInputParameter("isusermode", "isusermode", false, "false")).build(), null).setShortUsage("trace info -host IP/Hostname -port PORT");
    static final CLICommand printCommand = new CLICommand("print", "usage: trace print -host IP/Hostname -port PORT -size inKB (max 64)", TraceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"port", (Object)new IntegerInputParameter("port", "port", false, Integer.valueOf(5660))).put((Object)"host", (Object)new TextInputParameter("host", "ip/hostname", false, "127.0.0.1")).put((Object)"size", (Object)new IntegerInputParameter("size", "size", true, Integer.valueOf(4096))).build(), null).setShortUsage("trace print -host IP/Hostname -port PORT -size inKB (max 64)");
    public static final CLICommand traceCommands = new CLICommand("trace", "trace [dump|setmode|setlevel|resize|reset|info|print|setslowopsmillis]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{setModeCommand, setLevelCommand, dumpCommand, resizeCommand, resetCommand, infoCommand, printCommand, setSlowOpsMillisCommand}).setShortUsage("trace [dump|setmode|setlevel|resize|reset|info|print|setslowopsmillis] -host x.x.x.x -port <port>");
    String clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();

    public TraceCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    List<Integer> getMfsInstancesPorts(CLDBRpcCommonUtils.IpAddr hostIp, int port) throws CLIProcessingException {
        ArrayList<Integer> portsList = new ArrayList<Integer>();
        long binding = Rpc.createBindingFor((byte[])hostIp.toByteArray(), (int)port, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
        try {
            Fileserver.GetNumInstancesResponse resp = null;
            byte[] replyData = Rpc.sendRequest((long)binding, (int)Common.MapRProgramId.FileServerProgramId.getNumber(), (int)Fileserver.FSProg.GetNumInstances.getNumber(), (MessageLite)Fileserver.GetNumInstancesRequest.getDefaultInstance());
            if (replyData != null) {
                resp = Fileserver.GetNumInstancesResponse.parseFrom((byte[])replyData);
            }
            if (resp != null) {
                portsList = resp.getPortsList();
            } else {
                portsList.add(port);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while obtaining the list of MFS ports ");
            throw new CLIProcessingException((Throwable)e);
        }
        return portsList;
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput output;
        block44: {
            CLDBRpcCommonUtils.IpAddr hostip;
            CommandOutput.OutputHierarchy out;
            block50: {
                MutableInt err;
                block49: {
                    block48: {
                        MutableInt err2;
                        block47: {
                            block46: {
                                MutableInt err3;
                                block45: {
                                    MutableInt err4;
                                    block43: {
                                        MutableInt err5;
                                        output = new CommandOutput();
                                        out = new CommandOutput.OutputHierarchy();
                                        output.setOutput(out);
                                        if (!super.validateInput()) {
                                            return output;
                                        }
                                        LOG.info((Object)"RPC Client Initialize");
                                        try {
                                            int port = Rpc.initialize((int)0, (int)0, null);
                                            if (port < 0) {
                                                throw new IOException("Error in RPC init");
                                            }
                                        }
                                        catch (Exception e) {
                                            LOG.error((Object)"Exception in Rpc.initialize");
                                            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Exception in Rpc.initialize"));
                                            throw new CLIProcessingException("Exception in Rpc.initialize " + e);
                                        }
                                        try {
                                            MapRLoginHttpsClient client = new MapRLoginHttpsClient();
                                            client.authenticateIfNeeded(this.clusterName);
                                        }
                                        catch (Exception e) {
                                            LOG.error((Object)"Exception unable to authenticate ", (Throwable)e);
                                            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "authentication failed"));
                                        }
                                        String hostName = this.getParamTextValue(HOST_PARAM_NAME, 0);
                                        hostip = new CLDBRpcCommonUtils.IpAddr(hostName);
                                        if (!this.cliCommand.getCommandName().equalsIgnoreCase("dump")) break block43;
                                        if (this.isParamPresent(USER_MODE_PARAM_NAME) && this.getParamTextValue(USER_MODE_PARAM_NAME, 0).equalsIgnoreCase("true") && (err5 = this.CreateNFSUserTicket(this.clusterName)).GetValue() != 0) {
                                            out.addError(new CommandOutput.OutputHierarchy.OutputError(10004, "Cannot create the ticket for nfs in user mode"));
                                            return output;
                                        }
                                        List<Integer> mfsPorts = this.getMfsInstancesPorts(hostip, this.getParamIntValue(PORT_PARAM_NAME, 0));
                                        if (mfsPorts == null) {
                                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Received null for the list of MFS ports"));
                                            return output;
                                        }
                                        for (Integer port : mfsPorts) {
                                            long binding = Rpc.createBindingFor((byte[])hostip.toByteArray(), (int)port, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
                                            Gtrace.GTraceRequest.Builder req = Gtrace.GTraceRequest.newBuilder();
                                            req.setReqType(Gtrace.GTraceRequestType.dump);
                                            try {
                                                byte[] replyData = Rpc.sendRequest((long)binding, (int)Common.MapRProgramId.GTraceProgramId.getNumber(), (int)Gtrace.GTraceProg.GTraceProc.getNumber(), (MessageLite)req.build());
                                            }
                                            catch (MaprSecurityException e) {
                                                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
                                            }
                                            catch (Exception e) {
                                            }
                                        }
                                        break block44;
                                    }
                                    if (!this.cliCommand.getCommandName().equalsIgnoreCase("setlevel")) break block45;
                                    if (this.isParamPresent(USER_MODE_PARAM_NAME) && this.getParamTextValue(USER_MODE_PARAM_NAME, 0).equalsIgnoreCase("true") && (err4 = this.CreateNFSUserTicket(this.clusterName)).GetValue() != 0) {
                                        out.addError(new CommandOutput.OutputHierarchy.OutputError(10004, "Cannot create the ticket for nfs in user mode"));
                                        return output;
                                    }
                                    int port = this.getParamIntValue(PORT_PARAM_NAME, 0);
                                    long binding = Rpc.createBindingFor((byte[])hostip.toByteArray(), (int)port, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
                                    Gtrace.GTraceRequest.Builder req = Gtrace.GTraceRequest.newBuilder();
                                    req.setReqType(Gtrace.GTraceRequestType.setLevel);
                                    req.setModule(this.getParamTextValue(MODULE_PARAM_NAME, 0));
                                    req.setLevel(this.getParamTextValue(LEVEL_PARAM_NAME, 0));
                                    try {
                                        byte[] replyData = Rpc.sendRequest((long)binding, (int)Common.MapRProgramId.GTraceProgramId.getNumber(), (int)Gtrace.GTraceProg.GTraceProc.getNumber(), (MessageLite)req.build());
                                        Gtrace.GTraceResponse resp = Gtrace.GTraceResponse.parseFrom((byte[])replyData);
                                        this.checkError(resp.getStatus(), out);
                                    }
                                    catch (MaprSecurityException e) {
                                        throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
                                    }
                                    catch (Exception e) {}
                                    break block44;
                                }
                                if (!this.cliCommand.getCommandName().equalsIgnoreCase("setmode")) break block46;
                                if (this.isParamPresent(USER_MODE_PARAM_NAME) && this.getParamTextValue(USER_MODE_PARAM_NAME, 0).equalsIgnoreCase("true") && (err3 = this.CreateNFSUserTicket(this.clusterName)).GetValue() != 0) {
                                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10004, "Cannot create the ticket for nfs in user mode"));
                                    return output;
                                }
                                int port = this.getParamIntValue(PORT_PARAM_NAME, 0);
                                long binding = Rpc.createBindingFor((byte[])hostip.toByteArray(), (int)port, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
                                Gtrace.GTraceRequest.Builder req = Gtrace.GTraceRequest.newBuilder();
                                req.setReqType(Gtrace.GTraceRequestType.setMode);
                                req.setMode(this.getParamTextValue(MODE_PARAM_NAME, 0));
                                try {
                                    byte[] replyData = Rpc.sendRequest((long)binding, (int)Common.MapRProgramId.GTraceProgramId.getNumber(), (int)Gtrace.GTraceProg.GTraceProc.getNumber(), (MessageLite)req.build());
                                    Gtrace.GTraceResponse resp = Gtrace.GTraceResponse.parseFrom((byte[])replyData);
                                    this.checkError(resp.getStatus(), out);
                                }
                                catch (MaprSecurityException e) {
                                    throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
                                }
                                catch (Exception e) {}
                                break block44;
                            }
                            if (!this.cliCommand.getCommandName().equalsIgnoreCase("resize")) break block47;
                            int port = this.getParamIntValue(PORT_PARAM_NAME, 0);
                            long binding = Rpc.createBindingFor((byte[])hostip.toByteArray(), (int)port, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
                            Gtrace.GTraceRequest.Builder req = Gtrace.GTraceRequest.newBuilder();
                            req.setReqType(Gtrace.GTraceRequestType.setSize);
                            req.setSize(this.getParamIntValue(SIZE_PARAM_NAME, 0));
                            try {
                                byte[] replyData = Rpc.sendRequest((long)binding, (int)Common.MapRProgramId.GTraceProgramId.getNumber(), (int)Gtrace.GTraceProg.GTraceProc.getNumber(), (MessageLite)req.build());
                                Gtrace.GTraceResponse resp = Gtrace.GTraceResponse.parseFrom((byte[])replyData);
                                this.checkError(resp.getStatus(), out);
                            }
                            catch (MaprSecurityException e) {
                                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
                            }
                            catch (Exception e) {}
                            break block44;
                        }
                        if (!this.cliCommand.getCommandName().equalsIgnoreCase("setslowopsmillis")) break block48;
                        if (this.isParamPresent(USER_MODE_PARAM_NAME) && this.getParamTextValue(USER_MODE_PARAM_NAME, 0).equalsIgnoreCase("true") && (err2 = this.CreateNFSUserTicket(this.clusterName)).GetValue() != 0) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(10004, "Cannot create the ticket for nfs in user mode"));
                            return output;
                        }
                        int port = this.getParamIntValue(PORT_PARAM_NAME, 0);
                        long binding = Rpc.createBindingFor((byte[])hostip.toByteArray(), (int)port, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
                        Gtrace.GTraceRequest.Builder req = Gtrace.GTraceRequest.newBuilder();
                        req.setReqType(Gtrace.GTraceRequestType.setSlowOpsMillis);
                        req.setSlowOpsMillis(this.getParamLongValue(SLOW_OPS_MILLIS_PARAM_NAME, 0));
                        try {
                            byte[] replyData = Rpc.sendRequest((long)binding, (int)Common.MapRProgramId.GTraceProgramId.getNumber(), (int)Gtrace.GTraceProg.GTraceProc.getNumber(), (MessageLite)req.build());
                            Gtrace.GTraceResponse resp = Gtrace.GTraceResponse.parseFrom((byte[])replyData);
                            this.checkError(resp.getStatus(), out);
                        }
                        catch (MaprSecurityException e) {
                            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
                        }
                        catch (Exception e) {}
                        break block44;
                    }
                    if (!this.cliCommand.getCommandName().equalsIgnoreCase("reset")) break block49;
                    int port = this.getParamIntValue(PORT_PARAM_NAME, 0);
                    long binding = Rpc.createBindingFor((byte[])hostip.toByteArray(), (int)port, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
                    Gtrace.GTraceRequest.Builder req = Gtrace.GTraceRequest.newBuilder();
                    req.setReqType(Gtrace.GTraceRequestType.reset);
                    try {
                        byte[] replyData = Rpc.sendRequest((long)binding, (int)Common.MapRProgramId.GTraceProgramId.getNumber(), (int)Gtrace.GTraceProg.GTraceProc.getNumber(), (MessageLite)req.build());
                    }
                    catch (MaprSecurityException e) {
                        throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
                    }
                    catch (Exception e) {}
                    break block44;
                }
                if (!this.cliCommand.getCommandName().equalsIgnoreCase("info")) break block50;
                if (this.isParamPresent(USER_MODE_PARAM_NAME) && this.getParamTextValue(USER_MODE_PARAM_NAME, 0).equalsIgnoreCase("true") && (err = this.CreateNFSUserTicket(this.clusterName)).GetValue() != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10004, "Cannot create the ticket for nfs in user mode"));
                    return output;
                }
                List<Integer> mfsPorts = this.getMfsInstancesPorts(hostip, this.getParamIntValue(PORT_PARAM_NAME, 0));
                if (mfsPorts == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Received null for the list of MFS ports"));
                    return output;
                }
                for (Integer port : mfsPorts) {
                    long binding = Rpc.createBindingFor((byte[])hostip.toByteArray(), (int)port, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
                    Gtrace.GTraceRequest.Builder req = Gtrace.GTraceRequest.newBuilder();
                    req.setReqType(Gtrace.GTraceRequestType.info);
                    try {
                        byte[] replyData = Rpc.sendRequest((long)binding, (int)Common.MapRProgramId.GTraceProgramId.getNumber(), (int)Gtrace.GTraceProg.GTraceProc.getNumber(), (MessageLite)req.build());
                        Gtrace.GTraceResponse resp = Gtrace.GTraceResponse.parseFrom((byte[])replyData);
                        System.out.println("** [Port No: " + port + "] Trace is in " + resp.getMode() + " mode.");
                        System.out.println("**Allowed Trace Levels are: ");
                        for (String l : resp.getLevelsList()) {
                            System.out.println(l);
                        }
                        System.out.println("**Trace buffer size: " + resp.getSize());
                        System.out.println("**Modules and levels: ");
                        for (Gtrace.ModuleDetail md : resp.getModulesList()) {
                            System.out.println(md.getName() + " : " + md.getLevel());
                        }
                        System.out.println("**SlowOpsMillis: " + resp.getSlowOpsMillis());
                    }
                    catch (MaprSecurityException e) {
                        throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
                    }
                    catch (Exception e) {
                    }
                }
                break block44;
            }
            if (!this.cliCommand.getCommandName().equalsIgnoreCase("print")) break block44;
            List<Integer> mfsPorts = this.getMfsInstancesPorts(hostip, this.getParamIntValue(PORT_PARAM_NAME, 0));
            if (mfsPorts == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Received null for the list of MFS ports"));
                return output;
            }
            for (Integer port : mfsPorts) {
                long binding = Rpc.createBindingFor((byte[])hostip.toByteArray(), (int)port, (String)this.clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
                Gtrace.GTraceRequest.Builder req = Gtrace.GTraceRequest.newBuilder();
                req.setReqType(Gtrace.GTraceRequestType.print);
                req.setSize(this.getParamIntValue(SIZE_PARAM_NAME, 0));
                try {
                    byte[] replyData = Rpc.sendRequest((long)binding, (int)Common.MapRProgramId.GTraceProgramId.getNumber(), (int)Gtrace.GTraceProg.GTraceProc.getNumber(), (MessageLite)req.build());
                    Gtrace.GTraceResponse resp = Gtrace.GTraceResponse.parseFrom((byte[])replyData);
                    System.out.println("-----------------------------------------------------");
                    System.out.println("[Port No: " + port + "] " + resp.getTracedata().toStringUtf8());
                    System.out.println("-----------------------------------------------------");
                    System.out.println("DONE");
                }
                catch (MaprSecurityException e) {
                    throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
                }
                catch (Exception exception) {
                }
            }
        }
        return output;
    }

    private MutableInt CreateNFSUserTicket(String clusterName) {
        MutableInt err = new MutableInt();
        Security.TicketAndKey ticketAndKey = Security.GetTicketAndKeyForCluster((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (String)clusterName, (MutableInt)err);
        if (err.GetValue() != 0) {
            return err;
        }
        Security.SetKey((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (Security.Key)ticketAndKey.getUserKey());
        String userName = ticketAndKey.getUserCreds().getUserName();
        int[] gids = new int[]{userName.length()};
        TicketOptionalParams tOptionalParams = new TicketOptionalParams();
        tOptionalParams.setIsExternal(true);
        ticketAndKey = Security.GenerateTicketAndKey((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (String)userName, (int)userName.length(), (int[])gids, (long)Security.MAX_EXPIRY_TIME, (long)0L, (TicketOptionalParams)tOptionalParams, (MutableInt)err);
        if (err.GetValue() != 0) {
            return err;
        }
        Security.SetTicketAndKey((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (String)clusterName, (Security.TicketAndKey)ticketAndKey);
        return err;
    }

    void checkError(int status, CommandOutput.OutputHierarchy out) {
        if (status == 22) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Operation failed :(EINVAL) Invalid parameters"));
        }
        if (status == 12) {
            System.out.println("Operation failed :(ENOMEM) could not allocate memory");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Operation failed :(ENOMEM) could not allocate memory"));
        }
    }

    public String getCommandUsage() {
        return "trace [dump|setmode|setlevel|resize|reset|info|print]";
    }
}

