/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.common;

import com.google.protobuf.MessageLite;
import com.mapr.cli.common.ListIterator;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.cliframework.util.FilterProcessingException;
import com.mapr.cliframework.util.FilterUtil;
import com.mapr.fs.cli.proto.CLIProto;
import com.mapr.fs.proto.CLDBS3ServerProto;
import com.mapr.fs.proto.IAMServerProto;
import com.mapr.fs.proto.PolicyServerProto;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class ListCommand
extends CLIBaseClass
implements ListIterator {
    private static final Logger LOG = Logger.getLogger(ListCommand.class);

    public ListCommand(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    protected CLIProto.Limiter getNextLimiter(int prevStart, int prevCount, int origStart, int origLimit, int numRecsPerRpc) {
        int nextStart = prevStart + prevCount;
        int nextLimit = origLimit - (nextStart - origStart);
        if (nextLimit > numRecsPerRpc) {
            nextLimit = numRecsPerRpc;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getNextLimiter - origStart = " + origStart + ", origLimit = " + origLimit + ", prevCount = " + prevCount + ", numRecsPerRpc = " + numRecsPerRpc + ", nextStart = " + nextStart + ", nextLimit = " + nextLimit));
        }
        return CLIProto.Limiter.newBuilder().setStart(nextStart).setLimit(nextLimit).build();
    }

    protected <T> List<CLIProto.Filter> getFilters(Map<T, FieldInfo> table, String filterParam) throws CLIProcessingException {
        List<Object> filters;
        String filterString = this.getParamTextValue(filterParam, 0);
        if (filterString != null && !filterString.equals("none") && !filterString.equals("[id=all]")) {
            try {
                ArrayList<String> filterStrings = new ArrayList<String>();
                filterStrings.add(filterString);
                filters = FilterUtil.compileFilter(table, filterStrings);
            }
            catch (FilterProcessingException fpe) {
                throw new CLIProcessingException(fpe.getMessage(), (Throwable)fpe);
            }
        } else {
            filters = new ArrayList<CLIProto.Filter>();
        }
        return filters;
    }

    protected boolean hasMore(int origStart, int origLimit, int prevStart, int prevCount) {
        if (prevCount == 0) {
            LOG.info((Object)"[hasMore] Last fetched record count is 0. no more records to fetch");
            return false;
        }
        int endIndex = origLimit == Integer.MAX_VALUE ? origLimit : origStart + origLimit;
        return endIndex > prevStart + prevCount;
    }

    @Override
    public void list(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        MessageLite req = null;
        MessageLite resp = null;
        do {
            if ((resp = this.sendRequest(req = this.buildNextRequest(req, resp))) == null) {
                if (req instanceof PolicyServerProto.SecurityPolicyListRequest) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the PolicyServer. Check for PolicyServer"));
                } else if (req instanceof CLDBS3ServerProto.S3DomainListRequest) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the S3 Server."));
                } else if (req instanceof IAMServerProto.RoleListRequest) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the IAM Role Server."));
                } else {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. Check for CLDB process"));
                }
                return;
            }
            this.processResponse(out, resp);
        } while (this.hasMore(req, resp));
    }

    @Override
    public abstract boolean hasMore(MessageLite var1, MessageLite var2) throws CLIProcessingException;

    @Override
    public abstract MessageLite buildNextRequest(MessageLite var1, MessageLite var2) throws CLIProcessingException;

    @Override
    public abstract MessageLite sendRequest(MessageLite var1) throws CLIProcessingException;

    @Override
    public abstract void processResponse(CommandOutput.OutputHierarchy var1, MessageLite var2) throws CLIProcessingException;
}

