/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.audit;

import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

class CreateRecordHandling {
    private ConcurrentHashMap<String, CreateRecord> createMap = new ConcurrentHashMap();
    private static final Logger LOG = Logger.getLogger(CreateRecordHandling.class);
    private MapRFileSystem fs;

    CreateRecordHandling(MapRFileSystem fs) {
        this.fs = fs;
    }

    public void ProcessCreateRecord(String pFid, String cFid, String name) {
        CreateRecord tmp;
        CreateRecord childcr = this.createMap.get(cFid);
        if (childcr == null) {
            childcr = new CreateRecord(cFid);
            CreateRecord tmpcr = this.createMap.get(cFid);
            if (tmpcr != null) {
                childcr = tmpcr;
            }
        }
        childcr.name = name;
        this.createMap.put(cFid, childcr);
        CreateRecord parentcr = this.createMap.get(pFid);
        if (parentcr == null && (tmp = this.createMap.putIfAbsent(pFid, parentcr = new CreateRecord(pFid))) != null) {
            parentcr = tmp;
        }
        childcr.parent = parentcr;
    }

    public void ResolveAllFids() throws Exception {
        for (Map.Entry<String, CreateRecord> entry : this.createMap.entrySet()) {
            String fid = entry.getKey();
            CreateRecord cr = entry.getValue();
            if (cr.fullPath != null) continue;
            StringBuilder sb = new StringBuilder(32);
            this.GetFullPath(sb, cr, fid);
        }
    }

    private void GetFullPath(StringBuilder sb, CreateRecord cr, String fid) throws Exception {
        if (cr.fullPath != null) {
            sb.append(cr.fullPath);
            return;
        }
        if (cr.parent == null) {
            String expandedFid;
            try {
                expandedFid = this.fs.getMountPathFid(cr.fid);
            }
            catch (IOException e) {
                LOG.error((Object)("getMountPath failed for invalid fid = " + cr.fid));
                expandedFid = null;
            }
            if (expandedFid != null) {
                sb.append(expandedFid);
            } else if (fid.endsWith("16.2")) {
                sb.append("<VolumeRootFid:" + fid + ">");
            } else {
                sb.append("<UnresolvedFid:" + fid + ">");
            }
            return;
        }
        this.GetFullPath(sb, cr.parent, cr.parent.fid);
        if (sb.toString().length() > 0 && sb.toString().charAt(sb.toString().length() - 1) != '/') {
            sb.append("/");
        }
        sb.append(cr.name);
        cr.fullPath = sb.toString();
    }

    public String GetFullPathForFid(String fid) {
        CreateRecord cr = this.createMap.get(fid);
        if (cr == null) {
            return null;
        }
        return cr.fullPath;
    }

    class CreateRecord {
        String fid;
        String name = null;
        String fullPath = null;
        CreateRecord parent = null;

        CreateRecord(String fid) {
            this.fid = fid;
        }
    }
}

