/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.s3serverutils.S3ServerRpcCommonUtils;
import com.mapr.cli.VolumeCommands;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cli.proto.CLIProto;
import com.mapr.fs.proto.CLDBS3ServerProto;
import com.mapr.security.MaprSecurityException;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class S3DomainCommands
extends ListCommand
implements CLIInterface {
    public static final String DOMAIN_COMMAND_CREATE = "create";
    public static final String DOMAIN_COMMAND_MODIFY = "modify";
    public static final String DOMAIN_COMMAND_INFO = "info";
    public static final String DOMAIN_COMMAND_DELETE = "delete";
    public static final String DOMAIN_COMMAND_LIST = "list";
    public static final String DOMAIN_NAME_PARAM = "name";
    public static final String DOMAIN_ROOT_PARAM = "root";
    public static final String DOMAIN_ACL_PARAM = "access_controls";
    private static final int LIMIT_START_PARAM = 0;
    private static final int LIMIT_MAX_PARAM = Integer.MAX_VALUE;
    private static final int NUM_DOMAIN_PER_RPC = 64;
    private static final Logger LOG = Logger.getLogger(S3DomainCommands.class);
    public static final String s3DomainCreateUsage = "s3domain create -name <domain_name> -root <uid> [-access_controls <file_containing_acls>]";
    public static final String s3DomainModifyUsage = "s3domain modify -name <domain_name> -root <uid> [-access_controls <file_containing_acls>]";
    public static final String s3DomainInfoUsage = "s3domain info -name <domain_name>";
    public static final String s3DomainDeleteUsage = "s3domain delete -name <domain_name>";
    public static final String s3DomainListUsage = "s3domain list";
    public static final CLICommand s3DomainCreateCommand = new CLICommand("create", "", S3DomainCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).put((Object)"name", (Object)new TextInputParameter("name", "<domain_name>", true, null)).put((Object)"root", (Object)new IntegerInputParameter("root", "<uid>", true, null)).put((Object)"access_controls", (Object)new TextInputParameter("access_controls", "<access_controls>", false, null)).build(), null).setShortUsage("s3domain create -name <domain_name> -root <uid> [-access_controls <file_containing_acls>]");
    public static final CLICommand s3DomainModifyCommand = new CLICommand("modify", "", S3DomainCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).put((Object)"root", (Object)new IntegerInputParameter("root", "<uid>", false, null)).put((Object)"access_controls", (Object)new TextInputParameter("access_controls", "<access_controls>", false, null)).build(), null).setShortUsage("s3domain modify -name <domain_name> -root <uid> [-access_controls <file_containing_acls>]");
    public static final CLICommand s3DomainInfoCommand = new CLICommand("info", "", S3DomainCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).build(), null).setShortUsage("s3domain info -name <domain_name>");
    public static final CLICommand s3DomainDeleteCommand = new CLICommand("delete", "", S3DomainCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).build(), null).setShortUsage("s3domain delete -name <domain_name>");
    public static final CLICommand s3DomainListCommand = new CLICommand("list", "", S3DomainCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).build(), null).setShortUsage("s3domain list");
    public static final CLICommand[] s3DomainCommands = new CLICommand[]{s3DomainCreateCommand, s3DomainModifyCommand, s3DomainInfoCommand, s3DomainDeleteCommand, s3DomainListCommand};

    public S3DomainCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        this.init();
        String commandName = this.cliCommand.getCommandName().toLowerCase(Locale.ENGLISH);
        try {
            switch (commandName) {
                case "create": {
                    return this.createS3Domain();
                }
                case "modify": {
                    return this.modifyS3Domain();
                }
                case "info": {
                    return this.infoS3Domain();
                }
                case "delete": {
                    return this.deleteS3Domain();
                }
                case "list": {
                    return this.listS3Domains();
                }
            }
            LOG.error((Object)("invalid s3 domain command name:" + commandName));
            return new TextCommandOutput("invalid s3 domain command".getBytes());
        }
        catch (MaprSecurityException e) {
            LOG.error((Object)("MaprSecurityException in command:" + commandName), (Throwable)e);
            throw new CLIProcessingException("MaprSecurityException:", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("s3 domain command " + commandName + "failed, exception:"), (Throwable)e);
            throw new CLIProcessingException("s3 domain command " + commandName + "failed, exception:", (Throwable)e);
        }
    }

    void init() throws CLIProcessingException {
    }

    CommandOutput createS3Domain() throws MaprSecurityException, Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        if (!this.isParamPresent(DOMAIN_NAME_PARAM)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "missing domain name").setField(DOMAIN_NAME_PARAM));
            return output;
        }
        if (!this.isParamPresent(DOMAIN_ROOT_PARAM)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "missing root name").setField(DOMAIN_ROOT_PARAM));
            return output;
        }
        String domainName = this.getParamTextValue(DOMAIN_NAME_PARAM, 0);
        int domainRoot = this.getParamIntValue(DOMAIN_ROOT_PARAM, 0);
        String cluster = this.getClusterName();
        CLDBS3ServerProto.S3DomainProperties domainProps = CLDBS3ServerProto.S3DomainProperties.newBuilder().setName(domainName).setRoot(domainRoot).build();
        CLDBS3ServerProto.S3DomainCreateRequest request = CLDBS3ServerProto.S3DomainCreateRequest.newBuilder().setDomainProps(domainProps).setCreds(this.getUserCredentials()).build();
        byte[] data = null;
        data = cluster != null ? S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(cluster, CLDBS3ServerProto.S3ServerProg.S3DomainCreateProc.getNumber(), (MessageLite)request, CLDBS3ServerProto.S3DomainCreateResponse.class) : S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(CLDBS3ServerProto.S3ServerProg.S3DomainCreateProc.getNumber(), (MessageLite)request, CLDBS3ServerProto.S3DomainCreateResponse.class);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "could not connect to s3 server").setField(DOMAIN_ROOT_PARAM));
            return output;
        }
        CLDBS3ServerProto.S3DomainCreateResponse resp = CLDBS3ServerProto.S3DomainCreateResponse.parseFrom((byte[])data);
        if (resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.hasErrString() ? resp.getErrString() : "create s3 domain failed").setField(DOMAIN_ROOT_PARAM));
        } else {
            out.addMessage(resp.hasErrString() ? resp.getErrString() : "s3 domain created successfully");
        }
        return output;
    }

    CommandOutput modifyS3Domain() throws MaprSecurityException, Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        if (!this.isParamPresent(DOMAIN_NAME_PARAM)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "missing domain name").setField(DOMAIN_NAME_PARAM));
            return output;
        }
        String domainName = this.getParamTextValue(DOMAIN_NAME_PARAM, 0);
        String cluster = this.getClusterName();
        CLDBS3ServerProto.S3DomainProperties.Builder domainProps = CLDBS3ServerProto.S3DomainProperties.newBuilder().setName(domainName);
        if (this.isParamPresent(DOMAIN_ROOT_PARAM)) {
            domainProps.setRoot(this.getParamIntValue(DOMAIN_ROOT_PARAM, 0));
        }
        CLDBS3ServerProto.S3DomainModifyRequest request = CLDBS3ServerProto.S3DomainModifyRequest.newBuilder().setDomainProps(domainProps).setCreds(this.getUserCredentials()).build();
        byte[] data = null;
        data = cluster != null ? S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(cluster, CLDBS3ServerProto.S3ServerProg.S3DomainModifyProc.getNumber(), (MessageLite)request, CLDBS3ServerProto.S3DomainModifyResponse.class) : S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(CLDBS3ServerProto.S3ServerProg.S3DomainModifyProc.getNumber(), (MessageLite)request, CLDBS3ServerProto.S3DomainModifyResponse.class);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "could not connect to s3 server").setField(DOMAIN_ROOT_PARAM));
            return output;
        }
        CLDBS3ServerProto.S3DomainModifyResponse resp = CLDBS3ServerProto.S3DomainModifyResponse.parseFrom((byte[])data);
        if (resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.hasErrString() ? resp.getErrString() : "modify s3 domain failed"));
        } else {
            out.addMessage(resp.hasErrString() ? resp.getErrString() : "s3 domain modified successfully");
        }
        return output;
    }

    CommandOutput infoS3Domain() throws MaprSecurityException, Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        if (!this.isParamPresent(DOMAIN_NAME_PARAM)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "missing domain name").setField(DOMAIN_NAME_PARAM));
            return output;
        }
        String domainName = this.getParamTextValue(DOMAIN_NAME_PARAM, 0);
        String cluster = this.getClusterName();
        CLDBS3ServerProto.S3DomainInfoRequest request = CLDBS3ServerProto.S3DomainInfoRequest.newBuilder().setName(domainName).setCreds(this.getUserCredentials()).build();
        byte[] data = null;
        data = cluster != null ? S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(cluster, CLDBS3ServerProto.S3ServerProg.S3DomainInfoProc.getNumber(), (MessageLite)request, CLDBS3ServerProto.S3DomainInfoResponse.class) : S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(CLDBS3ServerProto.S3ServerProg.S3DomainInfoProc.getNumber(), (MessageLite)request, CLDBS3ServerProto.S3DomainInfoResponse.class);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "could not connect to s3 server").setField(DOMAIN_ROOT_PARAM));
            return output;
        }
        CLDBS3ServerProto.S3DomainInfoResponse resp = CLDBS3ServerProto.S3DomainInfoResponse.parseFrom((byte[])data);
        if (resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.hasErrString() ? resp.getErrString() : "lookup s3 domain failed"));
            return output;
        }
        this.formatS3DomainProps(resp.getDomainProps(), out);
        return output;
    }

    CommandOutput deleteS3Domain() throws MaprSecurityException, Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        if (!this.isParamPresent(DOMAIN_NAME_PARAM)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "missing domain name").setField(DOMAIN_NAME_PARAM));
            return output;
        }
        String domainName = this.getParamTextValue(DOMAIN_NAME_PARAM, 0);
        String cluster = this.getClusterName();
        CLDBS3ServerProto.S3DomainDeleteRequest request = CLDBS3ServerProto.S3DomainDeleteRequest.newBuilder().setName(domainName).setCreds(this.getUserCredentials()).build();
        byte[] data = null;
        data = cluster != null ? S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(cluster, CLDBS3ServerProto.S3ServerProg.S3DomainDeleteProc.getNumber(), (MessageLite)request, CLDBS3ServerProto.S3DomainDeleteResponse.class) : S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(CLDBS3ServerProto.S3ServerProg.S3DomainDeleteProc.getNumber(), (MessageLite)request, CLDBS3ServerProto.S3DomainDeleteResponse.class);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "could not connect to s3 server").setField(DOMAIN_ROOT_PARAM));
            return output;
        }
        CLDBS3ServerProto.S3DomainDeleteResponse resp = CLDBS3ServerProto.S3DomainDeleteResponse.parseFrom((byte[])data);
        if (resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.hasErrString() ? resp.getErrString() : "delete s3 domain failed"));
        } else {
            out.addMessage(resp.hasErrString() ? resp.getErrString() : "s3 domain deleted successfully");
        }
        return output;
    }

    CommandOutput listS3Domains() throws MaprSecurityException, Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        this.list(out);
        return output;
    }

    String getClusterName() throws CLIProcessingException {
        return this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : null;
    }

    private void formatS3DomainProps(CLDBS3ServerProto.S3DomainProperties domainProps, CommandOutput.OutputHierarchy out) {
        CommandOutput.OutputHierarchy.OutputNode propsNode = new CommandOutput.OutputHierarchy.OutputNode();
        if (domainProps.hasName()) {
            propsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(DOMAIN_NAME_PARAM, (Object)domainProps.getName()));
        }
        if (domainProps.hasRoot()) {
            propsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(DOMAIN_ROOT_PARAM, domainProps.getRoot()));
        }
        if (domainProps.hasDomainStats()) {
            propsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalAccounts", domainProps.getDomainStats().getTotalAccounts()));
            propsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("unavailableAccounts", domainProps.getDomainStats().getUnavailableAccounts()));
            propsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("userCount", domainProps.getDomainStats().getUserCount()));
            propsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("bucketCount", domainProps.getDomainStats().getBucketCount()));
            propsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("usedSizeMB", domainProps.getDomainStats().getUsedSizeMB()));
        }
        out.addNode(propsNode);
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite mlResp) throws CLIProcessingException {
        CLDBS3ServerProto.S3DomainListResponse response = (CLDBS3ServerProto.S3DomainListResponse)mlResp;
        for (CLDBS3ServerProto.S3DomainProperties domaianProps : response.getDomainPropsList()) {
            this.formatS3DomainProps(domaianProps, out);
        }
        out.setTotal(response.getDomainPropsCount());
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return this.hasMore(0, Integer.MAX_VALUE, ((CLDBS3ServerProto.S3DomainListRequest)prevReq).getLimiter().getStart(), ((CLDBS3ServerProto.S3DomainListResponse)prevResp).getDomainPropsCount());
    }

    @Override
    public MessageLite buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBS3ServerProto.S3DomainListRequest.Builder request = null;
        CLIProto.Limiter limiter = null;
        if (prevResp != null) {
            int prevStart = ((CLDBS3ServerProto.S3DomainListRequest)prevReq).getLimiter().getStart();
            int prevCount = ((CLDBS3ServerProto.S3DomainListResponse)prevResp).getDomainPropsCount();
            limiter = this.getNextLimiter(prevStart, prevCount, 0, Integer.MAX_VALUE, 64);
        } else {
            limiter = this.getNextLimiter(0, 0, 0, Integer.MAX_VALUE, 64);
        }
        request = prevReq == null ? CLDBS3ServerProto.S3DomainListRequest.newBuilder().setCreds(this.getUserCredentials()).setLimiter(limiter) : CLDBS3ServerProto.S3DomainListRequest.newBuilder((CLDBS3ServerProto.S3DomainListRequest)((CLDBS3ServerProto.S3DomainListRequest)prevReq)).setLimiter(limiter);
        return request.build();
    }

    public CLDBS3ServerProto.S3DomainListResponse sendRequest(MessageLite mlReq) throws CLIProcessingException {
        CLDBS3ServerProto.S3DomainListRequest request = (CLDBS3ServerProto.S3DomainListRequest)mlReq;
        String cluster = this.getClusterName();
        byte[] data = null;
        try {
            data = cluster != null ? S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(cluster, CLDBS3ServerProto.S3ServerProg.S3DomainListProc.getNumber(), (MessageLite)request, CLDBS3ServerProto.S3DomainListResponse.class) : S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(CLDBS3ServerProto.S3ServerProg.S3DomainListProc.getNumber(), (MessageLite)request, CLDBS3ServerProto.S3DomainListResponse.class);
            if (data == null) {
                LOG.error((Object)"could not connect to cldb");
                return null;
            }
            return CLDBS3ServerProto.S3DomainListResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            LOG.error((Object)"MaprSecurityException: ", (Throwable)e);
            throw new CLIProcessingException("MaprSecurityException:", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"error while listing domain", (Throwable)e);
            return null;
        }
    }
}

