/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.mapr.cli.NodeRemoveCommand;
import com.mapr.cli.common.ServicesEnum;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.proto.Common;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class NodeInstallCommand
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(NodeInstallCommand.class);
    public static final String NODE_PARAM = "node";
    public static final String ROLES_PARAM = "roles";
    public static final String DISKS_PARAM = "disks";
    public static final String TOPO_PARAM = "topology";
    private static final String CLDB_SERVICE_MASTER_PATH = "/services/cldb/master";
    private ZooKeeper s_zk;
    public static final CLICommand nodeRemove = new CLICommand("install", "install Mapr software on a node ", NodeRemoveCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"node", (Object)new TextInputParameter("node", "node names ", true, null)).put((Object)"zkconnect", (Object)new TextInputParameter("zkconnect", "ZooKeeper Connect String: 'host:port,host:port,host:port,...'", false, "localhost:5181")).put((Object)"roles", (Object)new TextInputParameter("roles", "services to install.", true, null)).put((Object)"disks", (Object)new TextInputParameter("disks", "disks to format. Has no effect at present.usus all", false, "all")).put((Object)"topology", (Object)new TextInputParameter("topology", "topology. Has no effect at present. Uses default one", false, null)).build(), null);

    public NodeInstallCommand(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String retString;
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        CommandOutput co = new CommandOutput(oh);
        String nodeIp = this.getParamTextValue(NODE_PARAM, 0);
        List roles = this.input.getParameterByName(NODE_PARAM).getParamValues();
        int cldbPort = -1;
        String cldbHost = null;
        try {
            this.connect(this.getParamTextValue("zkconnect", 0));
        }
        catch (IOException e) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "Cannot connect to ZooKeeper with error:" + e.getLocalizedMessage()));
            return co;
        }
        ArrayList nodes = new ArrayList();
        try {
            Stat stats = this.s_zk.exists(CLDB_SERVICE_MASTER_PATH, false);
            if (stats != null) {
                byte[] cldbBytes = this.s_zk.getData(CLDB_SERVICE_MASTER_PATH, null, stats);
                Common.ServiceData cldbInfo = Common.ServiceData.parseFrom((byte[])cldbBytes);
                if (!cldbInfo.hasHost() || !cldbInfo.hasPort()) {
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(10007, "CLDB Master Info is invalid. Cannot Install node: " + nodeIp));
                    return co;
                }
                cldbHost = cldbInfo.getHost();
                cldbPort = cldbInfo.getPort();
            }
        }
        catch (KeeperException e) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "Cannot get data /services/cldb/masterwith error: " + e.getLocalizedMessage()));
            return co;
        }
        catch (InterruptedException e) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "Cannot get data /services/cldb/masterwith error: " + e.getLocalizedMessage()));
            return co;
        }
        catch (InvalidProtocolBufferException e) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10006, "Cannot get data /services/cldb/masterwith error: " + e.getLocalizedMessage()));
            return co;
        }
        if (cldbPort != -1 && cldbHost != null) {
            try {
                retString = new String(this.executeSimpleSHHCommand(NodeRemoveCommand.TIMEOUT, "ssh root@" + cldbHost + " clustersetup.sh"));
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)retString);
                }
                retString = new String(this.executeSimpleSHHCommand(NodeRemoveCommand.TIMEOUT, "ssh root@" + nodeIp + " /etc/init.d/warden start"));
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)retString);
                }
            }
            catch (CLIProcessingException e) {
                LOG.error((Object)("Cannot stop services on : " + nodeIp + " command failed with error: " + e.getLocalizedMessage()));
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Can not stop services on : " + nodeIp + " command failed with error: " + e.getLocalizedMessage()).setField(NODE_PARAM).setFieldValue(nodeIp));
                return co;
            }
            return co;
        }
        if (roles.contains(ServicesEnum.cldb.name())) {
            try {
                retString = new String(this.executeSimpleSHHCommand(NodeRemoveCommand.TIMEOUT, "ssh root@" + nodeIp + " clustersetup.sh"));
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)retString);
                }
                retString = new String(this.executeSimpleSHHCommand(NodeRemoveCommand.TIMEOUT, "ssh root@" + nodeIp + " /etc/init.d/warden start"));
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)retString);
                }
            }
            catch (CLIProcessingException e) {
                LOG.error((Object)("Cannot stop services on : " + nodeIp + " command failed with error: " + e.getLocalizedMessage()));
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Cannot stop services on : " + nodeIp + " command failed with error: " + e.getLocalizedMessage()).setField(NODE_PARAM).setFieldValue(nodeIp));
                return co;
            }
            return co;
        }
        oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Cannot install: " + nodeIp + " as CLDB is not installed/running anywhere").setField(NODE_PARAM).setFieldValue(nodeIp));
        return co;
    }

    private void connect(String zkConnectString) throws IOException {
        try {
            this.s_zk = new ZooKeeper(zkConnectString, 30000, null);
        }
        catch (IOException e) {
            LOG.fatal((Object)("Could not connect to ZooKeeper server: " + zkConnectString), (Throwable)e);
            throw e;
        }
    }
}

