/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.NoValueInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import java.util.Map;

public class StoragePoolCommands
extends CLIBaseClass
implements CLIInterface {
    static final String CMD_PARAM = "storagepool";
    static final String SET_LABEL_CMD_PARAM = "setlabel";
    static final String SPID_PARAM = "spid";
    static final String LABEL_PARAM = "label";
    static final String FORCE_OPTION_PARAM = "force";
    static final CLICommand[] subCommands = new CLICommand[]{StoragePoolCommands.getSetLabelCommand()};
    static final String usageStr = "setlabel";
    public static final CLICommand commands = new CLICommand("storagepool", "setlabel", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, subCommands).setShortUsage("setlabel");

    public StoragePoolCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    private static CLICommand getSetLabelCommand() {
        String setLabelUsage = "setlabel -label <label_name> -spid <storage_pool_id> [-force]";
        return new CLICommand("setlabel", setLabelUsage, StoragePoolCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, StoragePoolCommands.getSetLabelArgs(), null).setShortUsage(setLabelUsage);
    }

    private static Map<String, BaseInputParameter> getSetLabelArgs() {
        return new ImmutableMap.Builder().put((Object)SPID_PARAM, (Object)new TextInputParameter(SPID_PARAM, "SP whose label needs to be set", true, null)).put((Object)LABEL_PARAM, (Object)new TextInputParameter(LABEL_PARAM, "Label to be set on the SP", true, null)).put((Object)FORCE_OPTION_PARAM, (Object)new NoValueInputParameter(FORCE_OPTION_PARAM, "overrides the previous label", false, false)).build();
    }

    private CommandOutput setStorageLabel() throws CLIProcessingException {
        byte[] data;
        int programId = Common.MapRProgramId.CldbProgramId.getNumber();
        int procId = CLDBProto.CLDBProg.StorageLabelAssignProc.getNumber();
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String spId = this.getParamTextValue(SPID_PARAM, 0);
        if (spId == null || spId.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing spid argument in the command"));
            return output;
        }
        String label = this.getParamTextValue(LABEL_PARAM, 0);
        if (label == null || label.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing label argument in the command"));
            return output;
        }
        if (label.equalsIgnoreCase(Common.MapRClusterDefaults.getDefaultInstance().getAnywhereLabelName())) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Label " + label + " is not valid for storage pools"));
            return output;
        }
        CLDBProto.StorageLabelAssignRequest.Builder requestBuilder = CLDBProto.StorageLabelAssignRequest.newBuilder().setSpId(spId).setLabel(label);
        if (this.isParamPresent(FORCE_OPTION_PARAM)) {
            requestBuilder.setOverrideCurrentLabel(true);
        }
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(programId, procId, (MessageLite)requestBuilder.build(), CLDBProto.StorageLabelAssignResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Got null response from CLDB...check CLDB logs"));
            return output;
        }
        CLDBProto.StorageLabelAssignResponse resp = null;
        try {
            resp = CLDBProto.StorageLabelAssignResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Unable to parse response from CLDB...check for coding or versioning errors"));
            return output;
        }
        if (resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrorMsg()));
            return output;
        }
        return output;
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        if (!super.validateInput()) {
            CommandOutput output = new CommandOutput();
            output.setOutput(new CommandOutput.OutputHierarchy());
            return output;
        }
        String command = this.cliCommand.getCommandName();
        if (command.equalsIgnoreCase("setlabel")) {
            return this.setStorageLabel();
        }
        return new TextCommandOutput("Unknown storage pool command failed".getBytes());
    }

    public String getCommandUsage() {
        return "setlabel";
    }
}

