/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.VolumeCommands;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.cldb.proto.CLDBProto;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class VolumeLinkCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(VolumeLinkCommands.class);
    public static final String VOLUMELINK_NAME_PARAM_NAME = "volume";
    public static final String VOLUMELINK_PATH_PARAM_NAME = "path";
    public static final String VOLUMELINK_TYPE_PARAM_NAME = "type";
    public static final String VOLUMELINK_HIDDEN_PARAM_NAME = "hidden";
    public static final String volumeLinkCreateUsage = "volume link -volume name -path path [-type writeable|mirror][-cluster clustername]";
    public static String volumeLinkRemoveUsage = "volume link remove -link";
    static final CLICommand volumeLinkCreateCommand = new CLICommand("create", "usage : volume link -volume name -path path [-type writeable|mirror][-cluster clustername]", VolumeLinkCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).put((Object)"volume", (Object)new TextInputParameter("volume", "volume", true, null)).put((Object)"type", (Object)new TextInputParameter("type", "type <writeable|mirror>", true, null)).put((Object)"path", (Object)new TextInputParameter("path", "path", true, null)).put((Object)"hidden", (Object)new BooleanInputParameter("hidden", "hidden", false, (Object)0).setInvisible(true)).build(), null).setShortUsage("volume link -volume name -path path [-type writeable|mirror][-cluster clustername]");
    static final CLICommand volumeLinkRemoveCommand = new CLICommand("remove", "usage : " + volumeLinkRemoveUsage, VolumeLinkCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).put((Object)"path", (Object)new TextInputParameter("path", "vollink", true, null)).build(), null).setShortUsage(volumeLinkRemoveUsage);
    public static CLICommand VolumeLinkCommands = new CLICommand("link", "link", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{volumeLinkCreateCommand, volumeLinkRemoveCommand}).setShortUsage("link [create|remove]");

    public VolumeLinkCommands(ProcessedInput input, CLICommand cliCommand) throws CLIProcessingException {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        if (this.cliCommand.getCommandName().equalsIgnoreCase("create")) {
            try {
                return this.volumeLinkCreate();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("remove")) {
            try {
                return this.volumeLinkRemove();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        return new TextCommandOutput("Volume link command failed".getBytes());
    }

    CommandOutput volumeLinkRemove() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String path = this.getParamTextValue(VOLUMELINK_PATH_PARAM_NAME, 0);
        if (path == null || path.isEmpty() || !path.matches("/.+")) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid link").setField(VOLUMELINK_PATH_PARAM_NAME).setFieldValue(path));
            return output;
        }
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
            if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(133, "Invalid cluster: " + cluster));
                return output;
            }
        }
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        try {
            int error = fs.deleteVolLink(cluster, path);
            if (error != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(error, "Failed to remove vollink " + path + ", error: " + Errno.toString((int)error)));
            }
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to remove vollink " + path));
            return output;
        }
        return output;
    }

    CommandOutput volumeLinkCreate() throws CLIProcessingException {
        CLDBProto.VolumeLookupResponse resp;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String name = this.getParamTextValue(VOLUMELINK_NAME_PARAM_NAME, 0).trim();
        if (name.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid volume name").setField(VOLUMELINK_NAME_PARAM_NAME).setFieldValue(name));
            return output;
        }
        String path = this.getParamTextValue(VOLUMELINK_PATH_PARAM_NAME, 0).trim();
        if (path.isEmpty() || !path.matches("/.+")) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid link").setField(VOLUMELINK_PATH_PARAM_NAME).setFieldValue(path));
            return output;
        }
        String type = this.getParamTextValue(VOLUMELINK_TYPE_PARAM_NAME, 0).trim();
        if (type.trim().isEmpty() || !type.equalsIgnoreCase("writeable") && !type.equalsIgnoreCase("mirror")) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid type, should be writeable OR mirror").setField(VOLUMELINK_TYPE_PARAM_NAME).setFieldValue(type));
            return output;
        }
        boolean hidden = false;
        if (this.isParamPresent(VOLUMELINK_HIDDEN_PARAM_NAME)) {
            hidden = this.getParamBooleanValue(VOLUMELINK_HIDDEN_PARAM_NAME, 0);
        }
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
            if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(133, "Invalid cluster: " + cluster));
                return output;
            }
        }
        if ((resp = VolumeCommands.volumeLookup(cluster, this.getUserCredentials(), name, null, this.isServerCall)).getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Could not fetch volume info for volume " + name + ", error: " + Errno.toString((int)resp.getStatus())));
            return output;
        }
        CLDBProto.VolumeProperties vProps = resp.getVolInfo().getVolProperties();
        if (!vProps.getMounted()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Can only create vol-links to mounted and non-mirror volumes. Volume " + name + " is not mounted"));
            return output;
        }
        if (vProps.getIsMirrorVol()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Can only create vol-links to mounted and non-mirror volumes. Volume " + name + " is a mirror volume"));
            return output;
        }
        MapRFileSystem fs = MapRCliUtil.getMapRFileSystem();
        try {
            boolean writeable = type.charAt(0) == 'w';
            int error = fs.createVolLink(cluster, name, new Path(path), writeable, hidden);
            if (error != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(error, "Failed to create vollink " + name + ", error: " + Errno.toString((int)error)));
            }
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to create vollink " + name));
            return output;
        }
        return output;
    }
}

