/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.DataMaskSecurityCommands;
import com.mapr.cli.SecurityPolicyCommands;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.login.MapRLogin;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class SecurityCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(SecurityCommands.class);
    public static final String DEFAULT_INSTALL_LOCATION = "/opt/mapr";
    public static final String CLDB_KEY_LOCATION = "/conf/cldb.key";
    public static final String OUTKEYFILE_PARAM_NAME = "keyfile";
    public static final String DAREMASTERKEY_PARAM_NAME = "dare";
    public static final String INKEYFILE_PARAM_NAME = "inkeyfile";
    public static final String TICKETFILE_PARAM_NAME = "ticketfile";
    public static final String HSM_PARAM_NAME = "hsm";
    public static final String CLUSTER_PARAM_NAME = "cluster";
    public static final String UID_PARAM_NAME = "mapruid";
    public static final String GID_PARAM_NAME = "maprgid";
    public static final String USERNAME_PARAM_NAME = "maprusername";
    public static final String MAPR_CLUSTER_USER_NAME = "clusterusername";
    public static final String MAPR_SERVER_TICKETFILE_PARAM_NAME = "inmaprserverticketfile";
    static final String defaultMapRServerTicketFileLocation = "/opt/mapr/conf/maprserverticket";
    static final String defaultMapRUserTicketFileLocation = "/opt/mapr/conf/mapruserticket";
    static final String defaultMapRClusterTicketFileLocation = "/opt/mapr/conf/maprclusterticket";
    public static final String TICKET_TYPE_PARAM_NAME = "type";
    public static final String OUT_PARAM_NAME = "out";
    public static final String USER_PARAM_NAME = "user";
    public static final String DATA_PARAM_NAME = "data";
    public static final String KEYTYPE_PARAM_NAME = "keytype";
    public static final String securityGenKeyUsage = "security genkey -keyfile keyfilepath";
    public static String securityGenTicketUsage = "security genticket -cluster clustername -maprusername maprusername -mapruid mapruid -maprgid maprgid -inkeyfile inkeyfilepath-hsm -ticketfile ticketfilepath";
    public static String securityGenerateTicketUsage = "security generateticket -cluster clustername -out out -user user-type tickettype";
    public static String securityPrintKeyUsage = "security printkey-keyfile keyfilepath";
    public static String securityGetMapRUserTicketUsage = "security getmapruserticket-inmaprserverticket serverticketpath -ticketfile ticketfilepath";
    public static String securityGetMapRClusterTicketUsage = "security getmaprclusterticket-clusterusername username -inmaprserverticket serverticketpath -ticketfile ticketfilepath";
    public static String securityGenMfsUtilTicketUsage = "security genmfsutilticket-inmaprserverticket serverticketpath -ticketfile ticketfilepath";
    public static String securityPrintTicketUsage = "security printticket-ticketfile ticketfilepath";
    public static final String securityEncryptUsage = "security encrypt -data Base64-encoded plaintext -keytype Key type. Supported values are cldb or server -outfile outputfilepath ";
    public static final String securityDecryptUsage = "security decrypt -data Base64-encoded ciphertext -keytype Key type. Supported values are cldb or server -outfile outputfilepath ";
    static final CLICommand securityGenKeyCommand = new CLICommand("genkey", "usage : security genkey -keyfile keyfilepath", SecurityCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"keyfile", (Object)new TextInputParameter("keyfile", "keyfile", false, null)).put((Object)"dare", (Object)new BooleanInputParameter("dare", "true/false", false, Boolean.valueOf(false))).build(), null).setShortUsage("security genkey -keyfile keyfilepath");
    static final CLICommand securityGenTicketCommand = new CLICommand("genticket", "usage : " + securityGenTicketUsage, SecurityCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"inkeyfile", (Object)new TextInputParameter("inkeyfile", "inkeyfile", false, null)).put((Object)"ticketfile", (Object)new TextInputParameter("ticketfile", "ticketfile", true, null)).put((Object)"hsm", (Object)new BooleanInputParameter("hsm", "true/false", false, Boolean.valueOf(false))).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster", true, null)).put((Object)"maprusername", (Object)new TextInputParameter("maprusername", "maprusername", true, null)).put((Object)"mapruid", (Object)new IntegerInputParameter("mapruid", "mapruid", true, null)).put((Object)"maprgid", (Object)new IntegerInputParameter("maprgid", "maprgid", true, null)).build(), null).setShortUsage(securityGenTicketUsage);
    static final CLICommand securityGetMapRUserTicketCommand = new CLICommand("getmapruserticket", "usage : " + securityGetMapRUserTicketUsage, SecurityCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"inmaprserverticketfile", (Object)new TextInputParameter("inmaprserverticketfile", "inmaprserverticketfile", false, "/opt/mapr/conf/maprserverticket")).put((Object)"ticketfile", (Object)new TextInputParameter("ticketfile", "ticketfile", false, "/opt/mapr/conf/mapruserticket")).build(), null).setShortUsage(securityGetMapRUserTicketUsage).setUsageInVisible(true);
    static final CLICommand securityGetMapRClusterTicketCommand = new CLICommand("getmaprclusterticket", "usage : " + securityGetMapRClusterTicketUsage, SecurityCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"clusterusername", (Object)new TextInputParameter("clusterusername", "clusterusername", true, null)).put((Object)"inmaprserverticketfile", (Object)new TextInputParameter("inmaprserverticketfile", "inmaprserverticketfile", false, "/opt/mapr/conf/maprserverticket")).put((Object)"ticketfile", (Object)new TextInputParameter("ticketfile", "ticketfile", false, "/opt/mapr/conf/maprclusterticket")).build(), null).setShortUsage(securityGetMapRClusterTicketUsage).setUsageInVisible(true);
    static final CLICommand securityGenMfsUtilTicketCommand = new CLICommand("genmfsutilticket", "usage : " + securityGenMfsUtilTicketUsage, SecurityCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"inmaprserverticketfile", (Object)new TextInputParameter("inmaprserverticketfile", "inmaprserverticketfile", false, "/opt/mapr/conf/maprserverticket")).put((Object)"ticketfile", (Object)new TextInputParameter("ticketfile", "ticketfile", false, "/opt/mapr/conf/mapruserticket")).build(), null).setShortUsage(securityGenMfsUtilTicketUsage).setUsageInVisible(true);
    static final CLICommand securityPrintKeyCommand = new CLICommand("printkey", "usage : " + securityPrintKeyUsage, SecurityCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"inkeyfile", (Object)new TextInputParameter("inkeyfile", "keyfile", true, null)).build(), null).setShortUsage(securityPrintKeyUsage);
    static final CLICommand securityPrintTicketCommand = new CLICommand("printticket", "usage : " + securityPrintTicketUsage, SecurityCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"ticketfile", (Object)new TextInputParameter("ticketfile", "ticketfile", true, null)).build(), null).setShortUsage(securityPrintTicketUsage);
    static final CLICommand securityGenerateTicketCommand = new CLICommand("generateticket", "usage : " + securityGenerateTicketUsage, SecurityCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster", false, null)).put((Object)"out", (Object)new TextInputParameter("out", "out", true, null)).put((Object)"user", (Object)new TextInputParameter("user", "user", true, null)).put((Object)"type", (Object)new TextInputParameter("type", "type", true, null)).build(), null).setShortUsage(securityGenerateTicketUsage).setUsageInVisible(true);
    static final CLICommand securityEncryptCommand = new CLICommand("encrypt", "usage : security encrypt -data Base64-encoded plaintext -keytype Key type. Supported values are cldb or server -outfile outputfilepath ", SecurityCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"data", (Object)new TextInputParameter("data", "Base64-encoded plaintext", true, null)).put((Object)"keytype", (Object)new TextInputParameter("keytype", "Key type. Supported values are cldb or server", true, null)).build(), null).setShortUsage("security encrypt -data Base64-encoded plaintext -keytype Key type. Supported values are cldb or server -outfile outputfilepath ");
    static final CLICommand securityDecryptCommand = new CLICommand("decrypt", "usage : security decrypt -data Base64-encoded ciphertext -keytype Key type. Supported values are cldb or server -outfile outputfilepath ", SecurityCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"data", (Object)new TextInputParameter("data", "Base64-encoded ciphertext", true, null)).put((Object)"keytype", (Object)new TextInputParameter("keytype", "Key type. Supported values are cldb or server", true, null)).build(), null).setShortUsage("security decrypt -data Base64-encoded ciphertext -keytype Key type. Supported values are cldb or server -outfile outputfilepath ");
    public static CLICommand securityCommands = new CLICommand("security", "security", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{securityGenKeyCommand, securityGenTicketCommand, securityGenerateTicketCommand, securityGetMapRUserTicketCommand, securityGetMapRClusterTicketCommand, securityGenMfsUtilTicketCommand, securityEncryptCommand, securityDecryptCommand, SecurityPolicyCommands.securityPolicyCommands, DataMaskSecurityCommands.dataMaskCommands}).setShortUsage("security [genkey|genticket|getmapruserticket|policy]");

    public SecurityCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        if (this.cliCommand.getCommandName().equalsIgnoreCase("genkey")) {
            try {
                return this.handleGenKey();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("genticket")) {
            try {
                return this.generateTicket();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("getmapruserticket")) {
            try {
                return this.getMapRUserTicket();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("getmaprclusterticket")) {
            try {
                return this.getMapRClusterTicket();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send Request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("genmfsutilticket")) {
            try {
                return this.genMfsUtilTicket();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("printkey")) {
            try {
                return this.printKey();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("printticket")) {
            try {
                return this.printTicket();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("generateticket")) {
            try {
                return this.generateUserTicket();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("encrypt")) {
            try {
                return this.handleEncryptDecryptData(true);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("decrypt")) {
            try {
                return this.handleEncryptDecryptData(false);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request exception", (Throwable)e);
            }
        }
        return null;
    }

    private CommandOutput handleGenKey() throws CLIProcessingException {
        boolean dare;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        File keyFile = null;
        String filename = null;
        if (this.isParamPresent(OUTKEYFILE_PARAM_NAME)) {
            filename = this.getParamTextValue(OUTKEYFILE_PARAM_NAME, 0);
            keyFile = new File(filename);
            if (keyFile.exists()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(17, "key file " + filename + " already exists"));
                return output;
            }
            try {
                if (!keyFile.createNewFile()) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(17, "keyfile " + filename + " already exists"));
                    return output;
                }
                keyFile.setExecutable(false, false);
                keyFile.setWritable(false, false);
                keyFile.setReadable(false, false);
                keyFile.setWritable(true, true);
                keyFile.setReadable(true, true);
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to create file " + filename), (Throwable)e);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Failed to create file " + filename));
                return output;
            }
        }
        MutableInt err = new MutableInt();
        Security.Key key = Security.GenerateRandomKey();
        byte[] encodedKey = Security.EncodeDataForWritingToKeyFile((byte[])key.toByteArray(), (MutableInt)err);
        if (encodedKey == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(err.GetValue(), "failed to generate key"));
            return output;
        }
        boolean bl = dare = this.isParamPresent(DAREMASTERKEY_PARAM_NAME) ? this.getParamBooleanValue(DAREMASTERKEY_PARAM_NAME, 0) : false;
        if (dare) {
            StringBuilder keyString = new StringBuilder();
            IntBuffer intBuf = ByteBuffer.wrap(encodedKey).order(ByteOrder.BIG_ENDIAN).asIntBuffer();
            int[] array = new int[intBuf.remaining()];
            intBuf.get(array);
            keyString.append(String.format("%08X%08X%08X%08X%08X%08X%08X%08X", array[0], array[1], array[2], array[3], array[4], array[5], array[6], array[7]));
            try {
                encodedKey = keyString.toString().getBytes("UTF-8");
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to getBytes of keyString, " + e));
            }
        }
        if (!this.isParamPresent(OUTKEYFILE_PARAM_NAME)) {
            StringBuffer encodedKeyBuf = new StringBuffer("");
            for (int i = 0; i < encodedKey.length; ++i) {
                encodedKeyBuf.append((char)encodedKey[i]);
            }
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode(encodedKeyBuf.toString()));
            return output;
        }
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(keyFile);
            fout.write(encodedKey);
            if (!dare) {
                fout.write(new String("\n").getBytes("UTF-8"));
            }
            fout.close();
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)("Failed to open file " + filename), (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Failed to open file " + filename));
            return output;
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to write to file " + filename), (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Failed to write to file " + filename));
            return output;
        }
        return output;
    }

    private CommandOutput generateUserTicket() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String[] args = (String[])ArrayUtils.remove((Object[])this.getInput().getRawInput(), (int)0);
        try {
            MapRLogin.execute((String[])args);
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to create ticket", (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Failed to create ticket with error " + e.getMessage()));
            return output;
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to create ticket", (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Failed to create ticket with error " + e.getMessage()));
            return output;
        }
        return output;
    }

    private CommandOutput generateTicket() throws CLIProcessingException {
        Security.Key key;
        boolean isHSM;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        boolean bl = isHSM = this.isParamPresent(HSM_PARAM_NAME) ? this.getParamBooleanValue(HSM_PARAM_NAME, 0) : false;
        if (!isHSM && !this.isParamPresent(INKEYFILE_PARAM_NAME)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Either hsm or inkeyfile must be specified"));
            return output;
        }
        if (isHSM && this.isParamPresent(INKEYFILE_PARAM_NAME)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "hsm and inkeyfile are mutually exclusive"));
            return output;
        }
        if (isHSM) {
            MutableInt err = new MutableInt();
            if (!Security.isHSMFeatureEnabled()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "HSM feature is not enabled"));
                return output;
            }
            key = Security.getCLDBKeyFromHSM((MutableInt)err);
            if (err.GetValue() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(err.GetValue(), "Failed to obtain key from HSM"));
                return output;
            }
        } else {
            int len;
            String keyFileName = this.getParamTextValue(INKEYFILE_PARAM_NAME, 0);
            if (keyFileName == null || keyFileName.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid keyfile path").setField(INKEYFILE_PARAM_NAME).setFieldValue(keyFileName));
                return output;
            }
            File keyFile = new File(keyFileName);
            if (!keyFile.exists()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "keyfile " + keyFileName + " doesn't exist"));
                return output;
            }
            if (!keyFile.canRead()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "keyfile " + keyFileName + " is not readable"));
                return output;
            }
            byte[] fileData = new byte[4096];
            try {
                FileInputStream fin = new FileInputStream(keyFile);
                len = fin.read(fileData);
                if (fileData[len - 1] == 10 || fileData[len - 1] == 0) {
                    --len;
                }
                fin.close();
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)("Failed to open file " + keyFileName), (Throwable)e);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Failed to open file " + keyFileName));
                return output;
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to read file " + keyFileName), (Throwable)e);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Failed to read file " + keyFileName));
                return output;
            }
            byte[] encodedKey = new byte[len];
            System.arraycopy(fileData, 0, encodedKey, 0, len);
            MutableInt err = new MutableInt();
            byte[] decodedKey = Security.DecodeDataFromKeyFile((byte[])encodedKey, (MutableInt)err);
            if (decodedKey == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(err.GetValue(), "Failed to parse keyfile"));
                return output;
            }
            try {
                key = Security.Key.parseFrom((byte[])decodedKey);
            }
            catch (InvalidProtocolBufferException e) {
                LOG.error((Object)("Failed to parse keyfile " + keyFileName), (Throwable)e);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(74, "Failed to parse keyfile " + keyFileName));
                return output;
            }
        }
        String clusterName = this.getParamTextValue(CLUSTER_PARAM_NAME, 0);
        if (clusterName == null || clusterName.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid cluster name").setField(CLUSTER_PARAM_NAME).setFieldValue(clusterName));
            return output;
        }
        int uid = this.getParamIntValue(UID_PARAM_NAME, 0);
        int[] gid = new int[]{this.getParamIntValue(GID_PARAM_NAME, 0)};
        long expiryTime = Security.MAX_EXPIRY_TIME;
        String maprUserName = this.getParamTextValue(USERNAME_PARAM_NAME, 0);
        if (maprUserName == null || maprUserName.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid maprusername").setField(USERNAME_PARAM_NAME).setFieldValue(maprUserName));
            return output;
        }
        MutableInt err = new MutableInt();
        Security.TicketAndKey ticketAndKey = Security.GenerateTicketAndKeyUsingServerKey((Security.ServerKeyType)Security.ServerKeyType.CldbKey, (Security.Key)key, (String)maprUserName, (int)uid, (int[])gid, (long)expiryTime, (long)0L, (boolean)false, (long)0L, (MutableInt)err);
        if (ticketAndKey == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(err.GetValue(), "Failed to generate ticketfile"));
            return output;
        }
        byte[] encodedticket = Security.EncodeDataForWritingToKeyFile((byte[])ticketAndKey.toByteArray(), (MutableInt)err);
        if (encodedticket == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(err.GetValue(), "failed to encode ticketfile"));
            return output;
        }
        String ticketFileName = this.getParamTextValue(TICKETFILE_PARAM_NAME, 0);
        if (ticketFileName == null || ticketFileName.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid ticketfile path").setField(TICKETFILE_PARAM_NAME).setFieldValue(ticketFileName));
            return output;
        }
        File ticketFile = new File(ticketFileName);
        if (ticketFile.exists()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(17, "ticketfile " + ticketFileName + " already exists"));
            return output;
        }
        try {
            if (!ticketFile.createNewFile()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(17, "ticketfile " + ticketFileName + " already exists"));
                return output;
            }
            ticketFile.setExecutable(false, false);
            ticketFile.setWritable(false, false);
            ticketFile.setReadable(false, false);
            ticketFile.setWritable(true, true);
            ticketFile.setReadable(true, true);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to create file " + ticketFileName), (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Failed to create file " + ticketFileName));
            return output;
        }
        try {
            FileOutputStream fout = new FileOutputStream(ticketFile);
            fout.write(clusterName.getBytes("UTF-8"));
            fout.write(new String(" ").getBytes("UTF-8"));
            fout.write(encodedticket);
            fout.write(new String("\n").getBytes("UTF-8"));
            fout.close();
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)("Failed to open file " + ticketFileName), (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Failed to open file " + ticketFileName));
            return output;
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to write to file " + ticketFileName), (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Failed to write to file " + ticketFileName));
            return output;
        }
        return output;
    }

    private CommandOutput getMapRUserTicket() throws CLIProcessingException {
        CLDBProto.GetMapRUserTicketResp resp;
        File maprServerTicketFile;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String maprServerTicketFileName = this.getParamTextValue(MAPR_SERVER_TICKETFILE_PARAM_NAME, 0);
        if (maprServerTicketFileName == null || maprServerTicketFileName.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid maprserverticketfile path").setField(MAPR_SERVER_TICKETFILE_PARAM_NAME).setFieldValue(maprServerTicketFileName));
            return output;
        }
        String maprUserTicketFileName = this.getParamTextValue(TICKETFILE_PARAM_NAME, 0);
        if (maprUserTicketFileName == null || maprUserTicketFileName.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid mapruserticketfile path").setField(TICKETFILE_PARAM_NAME).setFieldValue(maprUserTicketFileName));
            return output;
        }
        long lastModifiedmaprUserTicket = 0L;
        long lastModifiedmaprServerTicket = 0L;
        int err = 0;
        File maprUserTicketFile = new File(maprUserTicketFileName);
        if (maprUserTicketFile.canRead()) {
            lastModifiedmaprUserTicket = maprUserTicketFile.lastModified();
        }
        if ((maprServerTicketFile = new File(maprServerTicketFileName)).canRead()) {
            lastModifiedmaprServerTicket = maprServerTicketFile.lastModified();
        }
        if (lastModifiedmaprUserTicket < lastModifiedmaprServerTicket) {
            LOG.info((Object)"mapruserticket does not exist or it is older then maprserverticket. Regenerating it");
        } else {
            err = Security.SetTicketAndKeyFile((String)maprUserTicketFileName);
            if (err == 0) {
                out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Not creating a new ticket file as valid ticketfile \"" + maprUserTicketFileName + "\" already exists"));
                return output;
            }
        }
        String clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        err = Security.SetTicketAndKeyFile((String)maprServerTicketFileName);
        if (err != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(err, "Failed to load the maprserverticketfile " + maprServerTicketFileName));
            return output;
        }
        CLDBProto.GetMapRUserTicketReq.Builder req = CLDBProto.GetMapRUserTicketReq.newBuilder();
        byte[] data = null;
        req.setCreds(this.getUserCredentials());
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(clusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetMapRUserTicket.getNumber(), (MessageLite)req.build(), CLDBProto.GetMapRUserTicketResp.class, Security.ServerKeyType.CldbKey);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            resp = CLDBProto.GetMapRUserTicketResp.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception while sending RPC to cluster" + clusterName, (Throwable)e);
        }
        if (resp.getStatus() != 0) {
            LOG.error((Object)("Rpc to CLDB failed with status " + resp.getStatus()));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Failed to send RPC to CLDB for cluster" + clusterName));
            return output;
        }
        File tmpUserTicketFile = null;
        File userTicketFile = new File(maprUserTicketFileName);
        try {
            String parentDir = userTicketFile.getParent();
            if (parentDir == null) {
                parentDir = ".";
            }
            tmpUserTicketFile = File.createTempFile(".maprticket", null, new File(parentDir));
            tmpUserTicketFile.deleteOnExit();
            tmpUserTicketFile.setExecutable(false, false);
            tmpUserTicketFile.setWritable(false, false);
            tmpUserTicketFile.setReadable(false, false);
            tmpUserTicketFile.setWritable(true, true);
            tmpUserTicketFile.setReadable(true, true);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to create file " + tmpUserTicketFile), (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Failed to create file " + tmpUserTicketFile));
            return output;
        }
        MutableInt mutablerr = new MutableInt();
        byte[] encodedticket = Security.EncodeDataForWritingToKeyFile((byte[])resp.getMaprUserTicketAndKey().toByteArray(), (MutableInt)mutablerr);
        if (encodedticket == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(mutablerr.GetValue(), "failed to encode ticket"));
            return output;
        }
        try {
            FileOutputStream fout = new FileOutputStream(tmpUserTicketFile);
            fout.write(clusterName.getBytes("UTF-8"));
            fout.write(new String(" ").getBytes("UTF-8"));
            fout.write(encodedticket);
            fout.write(new String("\n").getBytes("UTF-8"));
            fout.close();
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)("Failed to open file " + tmpUserTicketFile), (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Failed to open file " + tmpUserTicketFile));
            return output;
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to write to file " + tmpUserTicketFile), (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Failed to write to file " + tmpUserTicketFile));
            return output;
        }
        if (!tmpUserTicketFile.renameTo(userTicketFile)) {
            LOG.error((Object)("Failed to rename to file " + userTicketFile));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Failed to write to file " + userTicketFile));
            return output;
        }
        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Successfully wrote the mapruserticket to " + maprUserTicketFileName));
        return output;
    }

    private CommandOutput getMapRClusterTicket() throws CLIProcessingException {
        CLDBProto.GetClusterTicketResp resp;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String maprClusterUserName = this.getParamTextValue(MAPR_CLUSTER_USER_NAME, 0);
        if (maprClusterUserName == null || maprClusterUserName.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid cluster user name").setField(MAPR_CLUSTER_USER_NAME).setFieldValue(maprClusterUserName));
            return output;
        }
        String maprServerTicketFileName = this.getParamTextValue(MAPR_SERVER_TICKETFILE_PARAM_NAME, 0);
        if (maprServerTicketFileName == null || maprServerTicketFileName.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid maprserverticketfile path").setField(MAPR_SERVER_TICKETFILE_PARAM_NAME).setFieldValue(maprServerTicketFileName));
            return output;
        }
        String maprClusterTicketFileName = this.getParamTextValue(TICKETFILE_PARAM_NAME, 0);
        if (maprClusterTicketFileName == null || maprClusterTicketFileName.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid maprclusterticketfile path").setField(TICKETFILE_PARAM_NAME).setFieldValue(maprClusterTicketFileName));
            return output;
        }
        int err = 0;
        String clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        err = Security.SetTicketAndKeyFile((String)maprServerTicketFileName);
        if (err != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(err, "Failed to load the maprserverticketfile " + maprServerTicketFileName));
            return output;
        }
        CLDBProto.GetClusterTicketReq.Builder req = CLDBProto.GetClusterTicketReq.newBuilder();
        byte[] data = null;
        req.setCreds(this.getUserCredentials());
        req.setClusterUserName(maprClusterUserName);
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(clusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetClusterTicketProc.getNumber(), (MessageLite)req.build(), CLDBProto.GetClusterTicketResp.class, Security.ServerKeyType.CldbKey);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            resp = CLDBProto.GetClusterTicketResp.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception while sending RPC to cluster" + clusterName, (Throwable)e);
        }
        if (resp.getStatus() != 0) {
            LOG.error((Object)("Rpc to CLDB failed with status " + resp.getStatus()));
            if (resp.getStatus() == 2) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid cluster user name").setField(MAPR_CLUSTER_USER_NAME).setFieldValue(maprClusterUserName));
                return output;
            }
            if (resp.getStatus() == 1) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "No permissions to generate cluster ticket").setField(MAPR_CLUSTER_USER_NAME).setFieldValue(maprClusterUserName));
                return output;
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Failed to send RPC to CLDB for cluster: " + clusterName));
            return output;
        }
        File tmpClusterTicketFile = null;
        File clusterTicketFile = new File(maprClusterTicketFileName);
        try {
            String parentDir = clusterTicketFile.getParent();
            if (parentDir == null) {
                parentDir = ".";
            }
            tmpClusterTicketFile = File.createTempFile(".maprticket", null, new File(parentDir));
            tmpClusterTicketFile.deleteOnExit();
            tmpClusterTicketFile.setExecutable(false, false);
            tmpClusterTicketFile.setWritable(false, false);
            tmpClusterTicketFile.setReadable(false, false);
            tmpClusterTicketFile.setWritable(true, true);
            tmpClusterTicketFile.setReadable(true, true);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to create file " + tmpClusterTicketFile), (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Failed to create file " + tmpClusterTicketFile));
            return output;
        }
        MutableInt mutablerr = new MutableInt();
        byte[] encodedticket = Security.EncodeDataForWritingToKeyFile((byte[])resp.getClusterTicketAndKey().toByteArray(), (MutableInt)mutablerr);
        if (encodedticket == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(mutablerr.GetValue(), "failed to encode ticket"));
            return output;
        }
        try {
            FileOutputStream fout = new FileOutputStream(tmpClusterTicketFile);
            fout.write(clusterName.getBytes("UTF-8"));
            fout.write(new String(" ").getBytes("UTF-8"));
            fout.write(encodedticket);
            fout.write(new String("\n").getBytes("UTF-8"));
            fout.close();
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)("Failed to open file " + tmpClusterTicketFile), (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Failed to open file " + tmpClusterTicketFile));
            return output;
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to write to file " + tmpClusterTicketFile), (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Failed to write to file " + tmpClusterTicketFile));
            return output;
        }
        if (!tmpClusterTicketFile.renameTo(clusterTicketFile)) {
            LOG.error((Object)("Failed to rename to file " + clusterTicketFile));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Failed to write to file " + clusterTicketFile));
            return output;
        }
        out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Successfully wrote the mapruserticket to " + maprClusterTicketFileName));
        return output;
    }

    private CommandOutput genMfsUtilTicket() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String maprServerTicketFileName = this.getParamTextValue(MAPR_SERVER_TICKETFILE_PARAM_NAME, 0);
        if (maprServerTicketFileName == null || maprServerTicketFileName.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid maprserverticketfile path").setField(MAPR_SERVER_TICKETFILE_PARAM_NAME).setFieldValue(maprServerTicketFileName));
            return output;
        }
        String maprUserTicketFileName = this.getParamTextValue(TICKETFILE_PARAM_NAME, 0);
        if (maprUserTicketFileName == null || maprUserTicketFileName.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid mapruserticketfile path").setField(TICKETFILE_PARAM_NAME).setFieldValue(maprUserTicketFileName));
            return output;
        }
        String clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        int error = Security.SetTicketAndKeyFile((String)maprServerTicketFileName);
        if (error != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(error, "Failed to load the maprserverticketfile " + maprServerTicketFileName));
            return output;
        }
        MutableInt err = new MutableInt();
        Security.TicketAndKey mfsUtilsTicket = Security.GetTicketAndKeyForCluster((Security.ServerKeyType)Security.ServerKeyType.CldbKey, (String)clusterName, (MutableInt)err);
        if (mfsUtilsTicket == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(err.GetValue(), "Failed to generate mfs utils ticket and key"));
            return output;
        }
        String username = mfsUtilsTicket.getUserCreds().getUserName();
        int uid = mfsUtilsTicket.getUserCreds().getUid();
        List gidsList = mfsUtilsTicket.getUserCreds().getGidsList();
        int numGids = gidsList.size();
        int[] gids = new int[numGids];
        for (int index = 0; index < numGids; ++index) {
            gids[index] = (Integer)gidsList.get(index);
        }
        long expiryTime = Security.MAX_EXPIRY_TIME;
        Security.TicketAndKey ticketAndKey = Security.GenerateTicketAndKeyUsingServerKey((Security.ServerKeyType)Security.ServerKeyType.MfsUtilKey, (Security.Key)mfsUtilsTicket.getUserKey(), (String)username, (int)uid, (int[])gids, (long)expiryTime, (long)0L, (boolean)false, (long)0L, (MutableInt)err);
        if (ticketAndKey == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(err.GetValue(), "Failed to generate ticketfile"));
            return output;
        }
        byte[] encodedticket = Security.EncodeDataForWritingToKeyFile((byte[])ticketAndKey.toByteArray(), (MutableInt)err);
        if (encodedticket == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(err.GetValue(), "failed to encode ticketfile"));
            return output;
        }
        String ticketFileName = this.getParamTextValue(TICKETFILE_PARAM_NAME, 0);
        if (ticketFileName == null || ticketFileName.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid ticketfile path").setField(TICKETFILE_PARAM_NAME).setFieldValue(ticketFileName));
            return output;
        }
        File ticketFile = new File(ticketFileName);
        if (ticketFile.exists()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(17, "ticketfile " + ticketFileName + " already exists"));
            return output;
        }
        try {
            if (!ticketFile.createNewFile()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(17, "ticketfile " + ticketFileName + " already exists"));
                return output;
            }
            ticketFile.setExecutable(false, false);
            ticketFile.setWritable(false, false);
            ticketFile.setReadable(false, false);
            ticketFile.setWritable(true, true);
            ticketFile.setReadable(true, true);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to create file " + ticketFileName), (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Failed to create file " + ticketFileName));
            return output;
        }
        try {
            FileOutputStream fout = new FileOutputStream(ticketFile);
            fout.write(clusterName.getBytes("UTF-8"));
            fout.write(new String(" ").getBytes("UTF-8"));
            fout.write(encodedticket);
            fout.write(new String("\n").getBytes("UTF-8"));
            fout.close();
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)("Failed to open file " + ticketFileName), (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Failed to open file " + ticketFileName));
            return output;
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to write to file " + ticketFileName), (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(1, "Failed to write to file " + ticketFileName));
            return output;
        }
        return output;
    }

    private CommandOutput handleEncryptDecryptData(boolean isEncrypt) throws CLIProcessingException {
        Security.Key encryptionKey;
        String cldbKeyLocation;
        int errorCode;
        Security.ServerKeyType keyType;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        Object outFile = null;
        Object filename = null;
        MutableInt err = new MutableInt();
        String keyTypeStr = this.getParamTextValue(KEYTYPE_PARAM_NAME, 0);
        if (keyTypeStr.equalsIgnoreCase("cldb")) {
            keyType = Security.ServerKeyType.CldbKey;
        } else if (keyTypeStr.equalsIgnoreCase("server")) {
            keyType = Security.ServerKeyType.ServerKey;
        } else {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "invalid encryption key type"));
            return output;
        }
        String maprHomeDir = System.getenv("MAPR_HOME");
        String installDir = DEFAULT_INSTALL_LOCATION;
        if (maprHomeDir != null && !maprHomeDir.isEmpty()) {
            installDir = maprHomeDir;
        }
        if ((errorCode = Security.SetKeyFile((Security.ServerKeyType)Security.ServerKeyType.CldbKey, (String)(cldbKeyLocation = "/opt/mapr/conf/cldb.key"))) != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(err.GetValue(), "failed to set CLDB key file to " + cldbKeyLocation));
            return output;
        }
        Security.Key cldbKey = Security.GetKey((Security.ServerKeyType)Security.ServerKeyType.CldbKey, (MutableInt)err);
        if (cldbKey == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(err.GetValue(), "failed to get CLDB key"));
            return output;
        }
        if (keyType == Security.ServerKeyType.CldbKey) {
            encryptionKey = cldbKey;
        } else {
            encryptionKey = Security.GetServerKey((Security.Key)cldbKey, (long)0L);
            if (encryptionKey == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(err.GetValue(), "Cannot get server key"));
                return output;
            }
        }
        String inputDataStr = this.getParamTextValue(DATA_PARAM_NAME, 0);
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] decodedInputBytes = decoder.decode(inputDataStr);
        byte[] outputByteBuffer = Security.Encrypt((Security.Key)encryptionKey, (byte[])decodedInputBytes, (MutableInt)err);
        outputByteBuffer = isEncrypt ? Security.Encrypt((Security.Key)encryptionKey, (byte[])decodedInputBytes, (MutableInt)err) : Security.Decrypt((Security.Key)encryptionKey, (byte[])decodedInputBytes, (MutableInt)err);
        if (err.GetValue() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(err.GetValue(), "failed to encrypt data"));
            return output;
        }
        Base64.Encoder encoder = Base64.getEncoder();
        Object encodedOutputTextBuffer = encoder.encodeToString(outputByteBuffer);
        if (isEncrypt) {
            encodedOutputTextBuffer = "ENC:" + keyTypeStr + ":" + (String)encodedOutputTextBuffer;
        }
        out.addNode(new CommandOutput.OutputHierarchy.OutputNode((String)encodedOutputTextBuffer));
        return output;
    }

    private CommandOutput printTicket() {
        return null;
    }

    private CommandOutput printKey() {
        return null;
    }
}

