/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.mapr.cli.MapRCLIRegistry;
import com.mapr.cliframework.base.CLICommandFactory;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TableReplicaTest {
    private static final Logger LOG = Logger.getLogger(TableReplicaTest.class);
    private static final String SRCTABLE = "/SRCTABLE";
    private static final String DESTTABLE = "/DESTTABLE";

    public static CommandOutput runCommand(String[] args) throws Exception {
        ProcessedInput input = new ProcessedInput(args);
        CLIInterface commandIFace = CLICommandFactory.getInstance().getCLI(input);
        if (commandIFace == null) {
            LOG.error((Object)("Could not find Interface for a command: " + input.getCommandName()));
            Assert.fail((String)(input.getCommandName() + " " + CLICommandFactory.getInstance().getUsage(false)));
        }
        if (!commandIFace.validateInput()) {
            Assert.fail((String)("Invalid input " + commandIFace.getCLICommand().getUsageFromParametersOfCommandsTree()));
        }
        CommandOutput output = commandIFace.executeCommand();
        return output;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        String[] args = new String[]{"table", "create", "-path", SRCTABLE};
        CommandOutput output = TableReplicaTest.runCommand(args);
    }

    @AfterClass
    public static void setUpAfterClass() throws Exception {
        String[] args = new String[]{"table", "delete", "-path", SRCTABLE};
        CommandOutput output = TableReplicaTest.runCommand(args);
    }

    public void verifyReplica() throws Exception {
        String[] args = new String[]{"table", "replica", "list", "-path", SRCTABLE};
        CommandOutput output = TableReplicaTest.runCommand(args);
        String outStr = output.toPrettyString();
        Pattern p = Pattern.compile(".*/DESTTABLE.*", 32);
        Matcher m = p.matcher(outStr);
        Assert.assertTrue((boolean)m.matches());
    }

    @Test
    public void directCopyTest() throws Exception {
        String[] args = new String[]{"table", "replica", "autosetup", "-path", SRCTABLE, "-replica", DESTTABLE, "-directcopy", "true"};
        CommandOutput output = TableReplicaTest.runCommand(args);
        this.verifyReplica();
    }

    static {
        MapRCLIRegistry.getInstance().register();
    }
}

