/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.s3serverutils.S3ServerRpcCommonUtils;
import com.mapr.baseutils.sso.providers.keycloak.KeyCloakJwtValidator;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.fs.proto.CLDBS3ServerProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class S3KeysCommands
extends ListCommand
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(S3KeysCommands.class);
    public static final String S3KEYS_COMMAND_GENERATE = "generate";
    public static final String S3KEYS_COMMAND_DELETE = "delete";
    public static final String S3KEYS_COMMAND_LIST = "list";
    public static final String S3KEYS_COMMAND_GENTEMPKEY = "gentempkey";
    public static final String DOMAINNAME_PARAM = "domainname";
    public static final String ACCOUNTNAME_PARAM = "accountname";
    public static final String USERNAME_PARAM = "username";
    public static final String ACCESS_KEY_PARAM = "accesskey";
    public static final String DURATION_PARAM = "duration";
    public static final String PARSE_USER_JWT_PARAM = "userfromjwt";
    public static final String OUTPUT_PARAM_NAME = "output";
    private static final int NUM_KEYS_PER_RPC = 100;
    public static final String s3GenerateUsage = "s3key generate [-cluster <cluster_name>] -domainname <domain_name> -accountname <account_name> [-username <user_name>]";
    public static final String s3DeleteUsage = "s3key delete -accesskey <key>";
    public static final String s3ListUsage = "s3key list [-cluster <cluster_name>] [-username <user_name>]";
    public static final String s3GenerateTempKeyUsage = "s3key gentempkey [-cluster <cluster_name>] [-domainname <domain_name>] [-accountname <account_name>] [-username <user_name>][-duration <durationInSec>]";
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "<cluster_name>", false, null)).build();
    public static final CLICommand S3GenerateCommand = new CLICommand("generate", "", S3KeysCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"domainname", (Object)new TextInputParameter("domainname", "<domain_name>", true, null)).put((Object)"accountname", (Object)new TextInputParameter("accountname", "<account_name>", true, null)).put((Object)"username", (Object)new TextInputParameter("username", "<user_name>", false, null)).build(), null).setShortUsage("s3key generate [-cluster <cluster_name>] -domainname <domain_name> -accountname <account_name> [-username <user_name>]");
    public static final CLICommand S3DeleteCommand = new CLICommand("delete", "", S3KeysCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"accesskey", (Object)new TextInputParameter("accesskey", "<access_key>", true, null)).build(), null).setShortUsage("s3key delete -accesskey <key>");
    public static final CLICommand S3ListCommand = new CLICommand("list", "", S3KeysCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"username", (Object)new TextInputParameter("username", "<user_name>", false, null)).build(), null).setShortUsage("s3key list [-cluster <cluster_name>] [-username <user_name>]");
    public static final CLICommand S3GenerateTempKeyCommand = new CLICommand("gentempkey", "", S3KeysCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"domainname", (Object)new TextInputParameter("domainname", "<domain_name>", false, Common.MapRClusterS3Defaults.getDefaultInstance().getDefaultDomain())).put((Object)"accountname", (Object)new TextInputParameter("accountname", "<account_name>", false, Common.MapRClusterS3Defaults.getDefaultInstance().getDefaultAccount())).put((Object)"username", (Object)new TextInputParameter("username", "<user_name>", false, null)).put((Object)"userfromjwt", (Object)new BooleanInputParameter("userfromjwt", "true|false", false, Boolean.valueOf(false))).put((Object)"duration", (Object)new IntegerInputParameter("duration", "<durationInSec>", false, null)).build(), null).setUsageInVisible(true).setShortUsage("s3key gentempkey [-cluster <cluster_name>] [-domainname <domain_name>] [-accountname <account_name>] [-username <user_name>][-duration <durationInSec>]");
    public static final CLICommand[] s3KeysCommands = new CLICommand[]{S3GenerateCommand, S3DeleteCommand, S3ListCommand, S3GenerateTempKeyCommand};
    public static final String s3KeysCommandsUsage = "s3key [generate|delete|list]";
    private static String[] S3KeyEntryFieldLongName = new String[]{"username", "key"};
    public static Map<S3KeyEntryField, FieldInfo> fieldTable = new ImmutableMap.Builder().put((Object)S3KeyEntryField.n, (Object)new FieldInfo(S3KeyEntryField.n.ordinal(), S3KeyEntryField.n.name(), S3KeyEntryFieldLongName[S3KeyEntryField.n.ordinal()], String.class)).put((Object)S3KeyEntryField.k, (Object)new FieldInfo(S3KeyEntryField.k.ordinal(), S3KeyEntryField.k.name(), S3KeyEntryFieldLongName[S3KeyEntryField.k.ordinal()], String.class)).build();

    public S3KeysCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String commandName = this.cliCommand.getCommandName().toLowerCase(Locale.ENGLISH);
        try {
            switch (commandName) {
                case "list": {
                    try {
                        CommandOutput output = new CommandOutput();
                        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
                        output.setOutput(out);
                        this.list(out);
                        return output;
                    }
                    catch (Exception e) {
                        throw new CLIProcessingException("Send request Exception", (Throwable)e);
                    }
                }
                case "generate": {
                    return this.generateKey();
                }
                case "gentempkey": {
                    return this.generateTempKey();
                }
                case "delete": {
                    return this.deleteKey();
                }
            }
            LOG.error((Object)("invalid s3key command name:" + commandName));
            return new TextCommandOutput("invalid s3key command".getBytes());
        }
        catch (MaprSecurityException e) {
            LOG.error((Object)("MaprSecurityException in command:" + commandName), (Throwable)e);
            throw new CLIProcessingException("MaprSecurityException:", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("s3key command " + commandName + "failed, exception:"), (Throwable)e);
            throw new CLIProcessingException("s3keys command " + commandName + "failed, exception:", (Throwable)e);
        }
    }

    CommandOutput generateTempKey() throws MaprSecurityException, Exception {
        String username;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        String cluster = this.getClusterName();
        String domainname = this.getParamTextValue(DOMAINNAME_PARAM, 0);
        String acname = this.getParamTextValue(ACCOUNTNAME_PARAM, 0);
        String string = username = this.isParamPresent(USERNAME_PARAM) ? this.getParamTextValue(USERNAME_PARAM, 0) : this.getUserLoginId();
        if (this.isParamPresent(PARSE_USER_JWT_PARAM) && this.getParamBooleanValue(PARSE_USER_JWT_PARAM, 0)) {
            try {
                String jwtLocEnvName = Common.MapRClusterDefaults.getDefaultInstance().getJwtLocEnvName();
                String sysEnvJwtPath = System.getenv(jwtLocEnvName);
                if (sysEnvJwtPath != null) {
                    String jwtTokenStr = Files.readString(Path.of(sysEnvJwtPath, new String[0]));
                    jwtTokenStr = jwtTokenStr.trim();
                    KeyCloakJwtValidator validator = new KeyCloakJwtValidator();
                    if (validator != null) {
                        username = validator.getUserName(jwtTokenStr, false);
                        LOG.debug((Object)("UserName is " + username));
                    }
                }
            }
            catch (Exception e) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "could not parse username from jwt got exception :" + e.getLocalizedMessage()));
                return output;
            }
        }
        LOG.info((Object)("username:" + username + " domainname:" + domainname + " accountName:" + acname));
        CLDBS3ServerProto.S3GenerateTempKeyRequest.Builder reqB = CLDBS3ServerProto.S3GenerateTempKeyRequest.newBuilder().setDomainName(domainname).setAccountName(acname).setUserName(username);
        if (this.isParamPresent(DURATION_PARAM)) {
            reqB.setValidityPeriod(this.getParamIntValue(DURATION_PARAM, 0));
        }
        CLDBS3ServerProto.S3GenerateTempKeyRequest request = reqB.build();
        byte[] data = null;
        data = cluster != null ? S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(cluster, CLDBS3ServerProto.S3ServerProg.S3GenerateTempKeyProc.getNumber(), (MessageLite)request, CLDBS3ServerProto.S3GenerateTempKeyResponse.class) : S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(CLDBS3ServerProto.S3ServerProg.S3GenerateTempKeyProc.getNumber(), (MessageLite)request, CLDBS3ServerProto.S3GenerateTempKeyResponse.class);
        if (data == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "could not connect to s3 server"));
            return output;
        }
        CLDBS3ServerProto.S3GenerateTempKeyResponse resp = CLDBS3ServerProto.S3GenerateTempKeyResponse.parseFrom((byte[])data);
        if (resp.getStatus() != 0) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.hasErrString() ? resp.getErrString() : "generate temp key failed").setField(USERNAME_PARAM));
        } else {
            CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode(ACCESS_KEY_PARAM, (Object)resp.getAccessKey()));
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("secretkey", (Object)resp.getSecretKey()));
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("expiryTime", resp.getExpTime()));
            oh.addNode(out);
        }
        return output;
    }

    CommandOutput generateKey() throws MaprSecurityException, Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        String cluster = this.getClusterName();
        String domainname = this.getParamTextValue(DOMAINNAME_PARAM, 0);
        String acname = this.getParamTextValue(ACCOUNTNAME_PARAM, 0);
        String username = this.isParamPresent(USERNAME_PARAM) ? this.getParamTextValue(USERNAME_PARAM, 0) : this.getUserLoginId();
        LOG.info((Object)("username:" + username + " domainname:" + domainname + " accountName:" + acname));
        CLDBS3ServerProto.S3CreateKeyRequest request = CLDBS3ServerProto.S3CreateKeyRequest.newBuilder().setDomainName(domainname).setAccountName(acname).setUserName(username).build();
        byte[] data = null;
        data = cluster != null ? S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(cluster, CLDBS3ServerProto.S3ServerProg.S3CreateKeyProc.getNumber(), (MessageLite)request, CLDBS3ServerProto.S3CreateKeyResponse.class) : S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(CLDBS3ServerProto.S3ServerProg.S3CreateKeyProc.getNumber(), (MessageLite)request, CLDBS3ServerProto.S3CreateKeyResponse.class);
        if (data == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "could not connect to s3 server"));
            return output;
        }
        CLDBS3ServerProto.S3CreateKeyResponse resp = CLDBS3ServerProto.S3CreateKeyResponse.parseFrom((byte[])data);
        if (resp.getStatus() != 0) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.hasErrString() ? resp.getErrString() : "generate key failed").setField(USERNAME_PARAM));
        } else {
            CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode(ACCESS_KEY_PARAM, (Object)resp.getAccessKey()));
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("secretkey", (Object)resp.getSecretKey()));
            oh.addNode(out);
        }
        return output;
    }

    CommandOutput deleteKey() throws MaprSecurityException, Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        String cluster = this.getClusterName();
        String accessKey = this.getParamTextValue(ACCESS_KEY_PARAM, 0);
        CLDBS3ServerProto.S3RemoveKeyRequest request = CLDBS3ServerProto.S3RemoveKeyRequest.newBuilder().setAccessKey(accessKey).build();
        byte[] data = null;
        data = cluster != null ? S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(cluster, CLDBS3ServerProto.S3ServerProg.S3RemoveKeyProc.getNumber(), (MessageLite)request, CLDBS3ServerProto.S3RemoveUserResponse.class) : S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(CLDBS3ServerProto.S3ServerProg.S3RemoveKeyProc.getNumber(), (MessageLite)request, CLDBS3ServerProto.S3RemoveUserResponse.class);
        if (data == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "could not connect to s3 server"));
            return output;
        }
        CLDBS3ServerProto.S3RemoveUserResponse resp = CLDBS3ServerProto.S3RemoveUserResponse.parseFrom((byte[])data);
        if (resp.getStatus() != 0) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.hasErrString() ? resp.getErrString() : "remove key failed"));
        } else {
            CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Removed", (Object)accessKey));
            oh.addNode(out);
        }
        return output;
    }

    String getClusterName() throws CLIProcessingException {
        return this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : null;
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBS3ServerProto.S3ListKeyResponse resp = (CLDBS3ServerProto.S3ListKeyResponse)response;
        if (resp.getStatus() != 0) {
            LOG.error((Object)resp.getErrString());
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Operation failed. Error: " + resp.getErrString()));
            return;
        }
        String outParamValue = this.isParamPresent(OUTPUT_PARAM_NAME) ? this.getParamTextValue(OUTPUT_PARAM_NAME, 0) : "";
        boolean terse = outParamValue.equals("terse");
        for (CLDBS3ServerProto.S3AccessKeyInfo kinfo : resp.getKeyInfosList()) {
            this.addAccessKeyInfo(kinfo, terse, out);
        }
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return false;
    }

    @Override
    public MessageLite buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBS3ServerProto.S3ListKeyRequest.Builder newReqBuilder = null;
        newReqBuilder = prevReq != null ? CLDBS3ServerProto.S3ListKeyRequest.newBuilder((CLDBS3ServerProto.S3ListKeyRequest)((CLDBS3ServerProto.S3ListKeyRequest)prevReq)) : this.getS3KeyListRequestBuilder();
        return newReqBuilder.build();
    }

    @Override
    public MessageLite sendRequest(MessageLite request) throws CLIProcessingException {
        byte[] data;
        CLDBS3ServerProto.S3ListKeyRequest req = (CLDBS3ServerProto.S3ListKeyRequest)request;
        String cluster = this.getClusterName();
        try {
            data = cluster != null ? S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(cluster, CLDBS3ServerProto.S3ServerProg.S3ListKeyProc.getNumber(), request, CLDBS3ServerProto.S3ListKeyResponse.class) : S3ServerRpcCommonUtils.getInstance().sendRequestToS3Server(CLDBS3ServerProto.S3ServerProg.S3ListKeyProc.getNumber(), request, CLDBS3ServerProto.S3ListKeyResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (data == null) {
            LOG.error((Object)"RPC Request to list s3 access keys failed. No data returned");
            return null;
        }
        try {
            return CLDBS3ServerProto.S3ListKeyResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into S3ListKeyResponse proto object.", (Throwable)ipbe);
        }
    }

    private CLDBS3ServerProto.S3ListKeyRequest.Builder getS3KeyListRequestBuilder() throws CLIProcessingException {
        Security.CredentialsMsg creds = this.getUserCredentials();
        CLDBS3ServerProto.S3ListKeyRequest.Builder reqBuilder = CLDBS3ServerProto.S3ListKeyRequest.newBuilder().setCreds(creds);
        if (this.isParamPresent(DOMAINNAME_PARAM)) {
            reqBuilder.setDomainName(this.getParamTextValue(DOMAINNAME_PARAM, 0));
        }
        if (this.isParamPresent(ACCOUNTNAME_PARAM)) {
            reqBuilder.setAccountName(this.getParamTextValue(ACCOUNTNAME_PARAM, 0));
        }
        String username = this.isParamPresent(USERNAME_PARAM) ? this.getParamTextValue(USERNAME_PARAM, 0) : this.getUserLoginId();
        reqBuilder.setUserName(username);
        LOG.info((Object)("s3keys list creds.uid:" + creds.getUid() + " listing s3Keys for username:" + username));
        return reqBuilder;
    }

    private void addAccessKeyInfo(CLDBS3ServerProto.S3AccessKeyInfo keyInfo, boolean terse, CommandOutput.OutputHierarchy out) {
        CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode();
        this.formatAccessKeyInfo(keyInfo, terse, outputNode);
        out.addNode(outputNode);
    }

    private void formatAccessKeyInfo(CLDBS3ServerProto.S3AccessKeyInfo keyInfo, boolean terse, CommandOutput.OutputHierarchy.OutputNode outputNode) {
        if (keyInfo.hasUsername()) {
            outputNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)S3KeyEntryField.n).getName(terse), (Object)keyInfo.getUsername()));
        }
        for (String key : keyInfo.getAccessKeysList()) {
            outputNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get((Object)S3KeyEntryField.k).getName(terse), (Object)key));
        }
    }

    private static enum S3KeyEntryField {
        n,
        k;

    }
}

