/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.FileclientRun;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.ClusterConf;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.jni.GatewaySource;
import com.mapr.fs.jni.IPPort;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbreplicator;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DbGatewayCommands
extends CLIBaseClass
implements CLIInterface {
    private static final int DEFAULT_GATEWAY_PORT = 7660;
    private static final Logger LOG = Logger.getLogger(DbGatewayCommands.class);
    private static final String IPADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    public static final String MULTI_ADDR_SEPARATOR = ";";
    public static final String HOSTNAME_IP_SEPARATOR = ",";
    public static final String IP_PORT_SEPARATOR = ":";
    public static final int MAX_PORT_NUMBER = 65535;
    public static final String DST_CLUSTER_PARAM_NAME = "dstcluster";
    public static final String CLUSTER_PARAM_NAME = "cluster";
    public static final String GATEWAYS_PARAM_NAME = "gateways";
    public static final String FORMAT_PARAM_NAME = "format";
    private static final CLICommand getCommand = new CLICommand("get", "usage: cluster gateway get -dstcluster <clustername>", DbGatewayCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"dstcluster", (Object)new TextInputParameter("dstcluster", "cluster name", true, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster on which command to be run", false, null)).build(), null).setShortUsage("cluster gateway get -dstcluster <clustername>");
    private static final CLICommand listCommand = new CLICommand("list", "usage: cluster gateway list", DbGatewayCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster on which command to be run", false, null)).build(), null).setShortUsage("cluster gateway list");
    private static final CLICommand setCommand = new CLICommand("set", "usage: cluster gateway set -dstcluster <clustername> -gateways <gatewayList>", DbGatewayCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"dstcluster", (Object)new TextInputParameter("dstcluster", "cluster name", true, null)).put((Object)"gateways", (Object)new TextInputParameter("gateways", "space-separated list of hostnames", true, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster on which command to be run", false, null)).build(), null).setShortUsage("cluster gateway set -dstcluster <clustername> -gateways <gatewayList>");
    private static final CLICommand localCommand = new CLICommand("local", "usage: cluster gateway local -format <dns/text>", DbGatewayCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"format", (Object)new TextInputParameter("format", "dns/text", false, "text")).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster on which command to be run", false, null)).build(), null).setShortUsage("cluster gateway local -format <dns/text>");
    private static final CLICommand deleteCommand = new CLICommand("delete", "usage: cluster gateway delete -dstcluster <clustername>", DbGatewayCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"dstcluster", (Object)new TextInputParameter("dstcluster", "cluster name", true, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster on which command to be run", false, null)).build(), null).setShortUsage("cluster gateway delete -dstcluster <clustername>");
    private static final CLICommand resolveCommand = new CLICommand("resolve", "usage: cluster gateway resolve -dstcluster <clustername>", DbGatewayCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"dstcluster", (Object)new TextInputParameter("dstcluster", "cluster name", true, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster on which command to be run", false, null)).build(), null).setShortUsage("cluster gateway resolve -dstcluster <clustername>");
    public static final CLICommand gatewayCommands = new CLICommand("gateway", "gateway [get|set|delete|list|local]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{getCommand, setCommand, deleteCommand, listCommand, resolveCommand, localCommand}).setShortUsage("cluster gateway [get|set|delete|list|resolve|local]");

    public DbGatewayCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        String cname = this.cliCommand.getCommandName();
        if (cname.equalsIgnoreCase(getCommand.getCommandName())) {
            this.getGateway(out);
        } else if (cname.equalsIgnoreCase(setCommand.getCommandName())) {
            this.setGateway(out);
        } else if (cname.equalsIgnoreCase(deleteCommand.getCommandName())) {
            this.deleteGateway(out);
        } else if (cname.equalsIgnoreCase(listCommand.getCommandName())) {
            this.listGateway(out);
        } else if (cname.equalsIgnoreCase(resolveCommand.getCommandName())) {
            this.resolveGateway(out);
        } else if (cname.equalsIgnoreCase(localCommand.getCommandName())) {
            this.localGateway(out);
        }
        return output;
    }

    private void getGateway(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String clusterName = this.getParamTextValue(DST_CLUSTER_PARAM_NAME, 0);
        CLDBProto.DBReplGatewayConfigGetRequest.Builder gwBuilder = CLDBProto.DBReplGatewayConfigGetRequest.newBuilder();
        gwBuilder.setClusterName(clusterName);
        gwBuilder.setCreds(this.getUserCredentials());
        byte[] data = null;
        try {
            if (this.isParamPresent(CLUSTER_PARAM_NAME)) {
                String targetClusterName = this.getParamTextValue(CLUSTER_PARAM_NAME, 0);
                MapRCliUtil.getMapRFileSystem();
                ClusterConf clusterConf = MapRFileSystem.getClusterConf();
                if (clusterConf.getClusterEntryByName(targetClusterName) == null) {
                    throw new IOException("Cluster " + targetClusterName + " does not exist");
                }
                data = CLDBRpcCommonUtils.getInstance().sendRequest(targetClusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DBReplGatewayConfigGetProc.getNumber(), (MessageLite)gwBuilder.build(), CLDBProto.DBReplGatewayConfigGetResponse.class);
            } else {
                data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DBReplGatewayConfigGetProc.getNumber(), (MessageLite)gwBuilder.build(), CLDBProto.DBReplGatewayConfigGetResponse.class);
            }
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.DBReplGatewayConfigGetResponse resp = CLDBProto.DBReplGatewayConfigGetResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 2) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "gateway not defined for cluster " + clusterName));
                return;
            }
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Getting gateway config failed with error " + resp.getStatus()));
                return;
            }
            CommandOutput.OutputHierarchy.OutputNode gwNode = new CommandOutput.OutputHierarchy.OutputNode();
            gwNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(CLUSTER_PARAM_NAME, (Object)clusterName));
            gwNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("gatewayConfig", (Object)resp.getGatewayConfig()));
            out.addNode(gwNode);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            LOG.error((Object)("Exception during gateway get " + e));
        }
    }

    private void listGateway(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String startClusterName = null;
        boolean hasMore = false;
        do {
            CLDBProto.DBReplGatewayConfigListRequest.Builder gwBuilder = CLDBProto.DBReplGatewayConfigListRequest.newBuilder();
            gwBuilder.setCreds(this.getUserCredentials());
            if (startClusterName != null) {
                gwBuilder.setStartClusterName(startClusterName);
            }
            byte[] data = null;
            try {
                if (this.isParamPresent(CLUSTER_PARAM_NAME)) {
                    String targetClusterName = this.getParamTextValue(CLUSTER_PARAM_NAME, 0);
                    MapRCliUtil.getMapRFileSystem();
                    ClusterConf clusterConf = MapRFileSystem.getClusterConf();
                    if (clusterConf.getClusterEntryByName(targetClusterName) == null) {
                        throw new IOException("Cluster " + targetClusterName + " does not exist");
                    }
                    data = CLDBRpcCommonUtils.getInstance().sendRequest(targetClusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DBReplGatewayConfigListProc.getNumber(), (MessageLite)gwBuilder.build(), CLDBProto.DBReplGatewayConfigListResponse.class);
                } else {
                    data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DBReplGatewayConfigListProc.getNumber(), (MessageLite)gwBuilder.build(), CLDBProto.DBReplGatewayConfigListResponse.class);
                }
                if (data == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                    return;
                }
                CLDBProto.DBReplGatewayConfigListResponse resp = CLDBProto.DBReplGatewayConfigListResponse.parseFrom((byte[])data);
                if (resp.getStatus() == 0) {
                    if (resp.getGatewayConfigsCount() == 0) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "No gateways configured"));
                        return;
                    }
                    for (int i = 0; i < resp.getGatewayConfigsCount(); ++i) {
                        CommandOutput.OutputHierarchy.OutputNode gwNode = new CommandOutput.OutputHierarchy.OutputNode();
                        gwNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(CLUSTER_PARAM_NAME, (Object)resp.getGatewayConfigs(i).getClusterName()));
                        gwNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("gatewayConfig", (Object)resp.getGatewayConfigs(i).getGatewayConfig()));
                        out.addNode(gwNode);
                    }
                    if (resp.hasCookie() && resp.getCookie() != null) {
                        startClusterName = resp.getCookie();
                        hasMore = true;
                    } else {
                        hasMore = false;
                    }
                    continue;
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Listing gateway configs failed with error " + resp.getStatus()));
                return;
            }
            catch (InvalidProtocolBufferException e) {
                throw new CLIProcessingException("InvalidProtocolBufferException " + e);
            }
            catch (CLIProcessingException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
                return;
            }
            catch (IOException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
                return;
            }
            catch (Exception e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
                LOG.error((Object)("Exception during gateway list " + e));
                return;
            }
        } while (hasMore);
    }

    private void resolveGateway(final CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String dstCluster = this.getParamTextValue(DST_CLUSTER_PARAM_NAME, 0);
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    GatewaySource sourceObj = new GatewaySource();
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    String varFilePath = DbGatewayCommands.this.isParamPresent(DbGatewayCommands.CLUSTER_PARAM_NAME) && !CLDBRpcCommonUtils.getInstance().getCurrentClusterName().equals(DbGatewayCommands.this.getParamTextValue(DbGatewayCommands.CLUSTER_PARAM_NAME, 0)) ? new String("/mapr/" + DbGatewayCommands.this.getParamTextValue(DbGatewayCommands.CLUSTER_PARAM_NAME, 0) + "/var") : new String("/var");
                    IPPort[] ipPorts = mfs.getGatewayIps(varFilePath, dstCluster, true, sourceObj);
                    StringBuffer sb = new StringBuffer();
                    String delimiter1 = "";
                    for (IPPort ipPort : ipPorts) {
                        int port = ipPort.port;
                        String delimiter2 = "";
                        sb.append(delimiter1);
                        ArrayList<CLDBRpcCommonUtils.IpAddr> ipAddrList = new ArrayList<CLDBRpcCommonUtils.IpAddr>();
                        for (byte[] ip : ipPort.ips) {
                            CLDBRpcCommonUtils.IpAddr ipAddr = new CLDBRpcCommonUtils.IpAddr(ip);
                            ipAddrList.add(ipAddr);
                        }
                        Object object = ipAddrList.iterator();
                        while (object.hasNext()) {
                            CLDBRpcCommonUtils.IpAddr host = (CLDBRpcCommonUtils.IpAddr)object.next();
                            CLDBRpcCommonUtils.SocketAddr sockAddr = new CLDBRpcCommonUtils.SocketAddr(host, Integer.valueOf(port));
                            sb.append(delimiter2);
                            sb.append(sockAddr.toString());
                            delimiter2 = DbGatewayCommands.MULTI_ADDR_SEPARATOR;
                        }
                        delimiter1 = " ";
                    }
                    CommandOutput.OutputHierarchy.OutputNode gwSourceNode = new CommandOutput.OutputHierarchy.OutputNode();
                    gwSourceNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("GatewayHosts", (Object)sb.toString()));
                    gwSourceNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("Source", (Object)mfs.GatewaySourceToString(sourceObj.source)));
                    out.addNode(gwSourceNode);
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            LOG.error((Object)("Exception during gateway resolve " + e));
        }
    }

    private boolean isGatewayConfigValid(String config, StringBuilder error) {
        String[] tokens = config.split("[\\s]+");
        Pattern pattern = Pattern.compile(IPADDRESS_PATTERN);
        for (int i = 0; i < tokens.length; ++i) {
            for (String token : tokens[i].split(MULTI_ADDR_SEPARATOR)) {
                Matcher matcher;
                if ((token = token.trim()).isEmpty()) {
                    return false;
                }
                String addr = null;
                if (token.contains(IP_PORT_SEPARATOR)) {
                    int port;
                    String[] arr = token.split(IP_PORT_SEPARATOR);
                    if (arr.length < 2 || arr[0].isEmpty() || arr[1].isEmpty()) {
                        error.append("Empty host/port");
                        return false;
                    }
                    addr = arr[0];
                    int index = addr.indexOf(44);
                    if (index != -1) {
                        addr = index < addr.length() - 1 ? addr.substring(index + 1) : addr.substring(0, index);
                    }
                    if ((port = Integer.parseInt(arr[1])) < 0 || port > 65535) {
                        error.append("Invalid port: " + port);
                        return false;
                    }
                } else {
                    addr = token;
                }
                if (addr.matches(".*[a-zA-Z]+.*") || (matcher = pattern.matcher(addr)).matches()) continue;
                error.append("Invalid ipaddress " + addr);
                return false;
            }
        }
        return true;
    }

    private void setGateway(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        StringBuilder error;
        String clusterName = this.getParamTextValue(DST_CLUSTER_PARAM_NAME, 0);
        String confTxt = this.getParamTextValue(GATEWAYS_PARAM_NAME, 0);
        if (!this.isGatewayConfigValid(confTxt, error = new StringBuilder(""))) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Incorrect gateway config provided: " + error));
            return;
        }
        ArrayList<String> hostEntries = new ArrayList<String>();
        for (String hostEntry : confTxt.split("[\\s]+")) {
            if (hostEntries.contains(hostEntry)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Duplicate host entry " + hostEntry + " found!"));
                return;
            }
            hostEntries.add(hostEntry);
        }
        CLDBProto.DBReplGatewayConfigSetRequest.Builder gwBuilder = CLDBProto.DBReplGatewayConfigSetRequest.newBuilder();
        gwBuilder.setClusterName(clusterName);
        gwBuilder.setGatewayConfig(confTxt);
        gwBuilder.setCreds(this.getUserCredentials());
        byte[] data = null;
        try {
            if (this.isParamPresent(CLUSTER_PARAM_NAME)) {
                String targetClusterName = this.getParamTextValue(CLUSTER_PARAM_NAME, 0);
                MapRCliUtil.getMapRFileSystem();
                ClusterConf clusterConf = MapRFileSystem.getClusterConf();
                if (clusterConf.getClusterEntryByName(targetClusterName) == null) {
                    throw new IOException("Cluster " + targetClusterName + " does not exist");
                }
                data = CLDBRpcCommonUtils.getInstance().sendRequest(targetClusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DBReplGatewayConfigSetProc.getNumber(), (MessageLite)gwBuilder.build(), CLDBProto.DBReplGatewayConfigSetResponse.class);
            } else {
                data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DBReplGatewayConfigSetProc.getNumber(), (MessageLite)gwBuilder.build(), CLDBProto.DBReplGatewayConfigSetResponse.class);
            }
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.DBReplGatewayConfigSetResponse resp = CLDBProto.DBReplGatewayConfigSetResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 1) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(1, Errno.toString((int)1) + " : User not authorized on the cluster"));
                return;
            }
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Setting gateway config failed with error " + resp.getStatus()));
                return;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            LOG.error((Object)("Exception during gateway get " + e));
        }
    }

    private void deleteGateway(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String clusterName = this.getParamTextValue(DST_CLUSTER_PARAM_NAME, 0);
        CLDBProto.DBReplGatewayConfigDeleteRequest.Builder gwBuilder = CLDBProto.DBReplGatewayConfigDeleteRequest.newBuilder();
        gwBuilder.setClusterName(clusterName);
        gwBuilder.setCreds(this.getUserCredentials());
        byte[] data = null;
        try {
            if (this.isParamPresent(CLUSTER_PARAM_NAME)) {
                String targetClusterName = this.getParamTextValue(CLUSTER_PARAM_NAME, 0);
                MapRCliUtil.getMapRFileSystem();
                ClusterConf clusterConf = MapRFileSystem.getClusterConf();
                if (clusterConf.getClusterEntryByName(targetClusterName) == null) {
                    throw new IOException("Cluster " + targetClusterName + " does not exist");
                }
                data = CLDBRpcCommonUtils.getInstance().sendRequest(targetClusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DBReplGatewayConfigDeleteProc.getNumber(), (MessageLite)gwBuilder.build(), CLDBProto.DBReplGatewayConfigDeleteResponse.class);
            } else {
                data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DBReplGatewayConfigDeleteProc.getNumber(), (MessageLite)gwBuilder.build(), CLDBProto.DBReplGatewayConfigDeleteResponse.class);
            }
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.DBReplGatewayConfigDeleteResponse resp = CLDBProto.DBReplGatewayConfigDeleteResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 1) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(1, Errno.toString((int)1) + " : User not authorized on the cluster"));
                return;
            }
            if (resp.getStatus() == 2) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "gateway not defined for cluster " + clusterName));
                return;
            }
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Deleting gateway config failed with error " + resp.getStatus()));
                return;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            LOG.error((Object)("Exception during gateway delete " + e));
        }
    }

    private void localGateway(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String clusterName = null;
        String format = this.getParamTextValue(FORMAT_PARAM_NAME, 0);
        try {
            if (!format.equals("text") && !format.equals("dns")) {
                throw new CLIProcessingException("Invalid format, supported: text/dns");
            }
            clusterName = this.isParamPresent(CLUSTER_PARAM_NAME) ? this.getParamTextValue(CLUSTER_PARAM_NAME, 0) : CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
            this.getLocalGatewayInfo(clusterName, format, out);
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
    }

    private void getLocalGatewayInfo(String clusterName, String format, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String zkConnectString = CLDBRpcCommonUtils.getInstance().getZkConnect(clusterName);
        if (zkConnectString == null) {
            throw new CLIProcessingException("Invalid cluster provided: " + clusterName);
        }
        Map<String, Common.ServiceData> gatewayServiceData = NodesCommonUtils.getServiceNodeData(zkConnectString, "gateway", clusterName);
        if (gatewayServiceData == null) {
            throw new CLIProcessingException("Gateway service not found on cluster: " + clusterName);
        }
        gatewayServiceData.remove("master");
        StringBuffer sb = new StringBuffer();
        String delimiter = "";
        for (Common.ServiceData nodeServiceData : gatewayServiceData.values()) {
            block19: {
                if (nodeServiceData.hasIsRunning() && nodeServiceData.getIsRunning()) {
                    String host = null;
                    int port = 0;
                    if (nodeServiceData.hasHost()) {
                        host = nodeServiceData.getHost();
                    }
                    if (nodeServiceData.hasPort()) {
                        port = new Integer(nodeServiceData.getPort());
                    }
                    if (host != null) {
                        Common.IPAddress hostIP;
                        if (port == 0) {
                            port = 7660;
                        }
                        if ((hostIP = MapRCliUtil.buildIPAddressFromString(host)) == null) {
                            LOG.error((Object)("Cannot find valid hostname to IPAddress mapping in file/dns for host " + host));
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot get valid IP address out of hostname: " + host));
                            return;
                        }
                        CLDBRpcCommonUtils.IpAddr ipAddr = MapRCliUtil.buildIpAddrFromIPAddress(hostIP);
                        if (ipAddr == null) {
                            LOG.error((Object)("Could not convert IPAddress to IpAddr Class, for hostname:" + host));
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Could not convert IPAddress to IpAddr Class, for hostname:" + host));
                            return;
                        }
                        long gwbinding = Rpc.createBindingFor((byte[])ipAddr.toByteArray(), (int)port, (String)clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
                        Dbreplicator.GetHostNamesRequest req = Dbreplicator.GetHostNamesRequest.newBuilder().setCreds(this.getUserCredentials()).build();
                        try {
                            byte[] replyData = Rpc.sendRequest((long)gwbinding, (int)Common.MapRProgramId.DBReplicatorServerProgramId.getNumber(), (int)Dbreplicator.DBReplicatorProg.GetHostNamesProc.getNumber(), (MessageLite)req);
                            if (replyData == null) {
                                LOG.error((Object)"Got null reply from RPC");
                                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "gethostnames rpc failed"));
                                return;
                            }
                            Dbreplicator.GetHostNamesResponse resp = Dbreplicator.GetHostNamesResponse.parseFrom((byte[])replyData);
                            CommandOutput.OutputHierarchy.OutputNode dout = new CommandOutput.OutputHierarchy.OutputNode();
                            if (resp.getStatus() == 0) {
                                for (String name : resp.getNamesList()) {
                                    sb.append(delimiter);
                                    sb.append(name);
                                    if (port != 7660) {
                                        sb.append(IP_PORT_SEPARATOR + port);
                                    }
                                    delimiter = MULTI_ADDR_SEPARATOR;
                                }
                                break block19;
                            }
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "GetHostNames failed, Error : " + Errno.toString((int)resp.getStatus())));
                            return;
                        }
                        catch (MaprSecurityException e) {
                            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Exception processing getHostNames command", (Throwable)e);
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "db rpc failed"));
                            return;
                        }
                    }
                }
            }
            delimiter = " ";
        }
        StringBuffer outsb = null;
        if (format.equals("dns")) {
            outsb = new StringBuffer("\n; TXT Record addresses\n");
            outsb.append("gateway." + clusterName + " IN TXT \"");
            outsb.append(sb);
            outsb.append("\"");
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("gatewaydnsinfo", (Object)outsb.toString()));
        } else {
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("gatewayinfo", (Object)sb.toString()));
        }
    }
}

