/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.utils.Util;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.NoValueInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.cliframework.util.FilterUtil;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cli.proto.CLIProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ClusterGroupCommands
extends ListCommand
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(ClusterGroupCommands.class);
    public static final String CONF_FILE = "/opt/mapr/conf/mapr-clusters.conf";
    public static final String TICKET_FILE = "/opt/mapr/conf/maprserverticket";
    public static final String TMP_CONF_FILE = "/tmp/conf.file";
    public static final String TMP_TICKET_FILE = "/tmp/ticket.file";
    public static final String NFS_EXPORT_FILE = "/opt/mapr/conf/exports";
    public static final String CLUSTERGROUP_COMMAND_SETPRIMARY = "setprimary";
    public static final String CLUSTERGROUP_COMMAND_UPDATEPRIMARY = "updateprimary";
    public static final String CLUSTERGROUP_COMMAND_LIST = "list";
    public static final String CLUSTERGROUP_COMMAND_GET_CG_TABLE = "getcgtable";
    public static final String CLUSTERGROUP_COMMAND_REMOVE = "remove";
    public static final String CLUSTERGROUP_COMMAND_ADD_EXTERNAL = "addexternal";
    public static final String CLUSTERGROUP_COMMAND_SETUPGRADE = "setupgrade";
    public static final String CLUSTERGROUP_COMMAND_SHOW_CLUSTER_CERT = "showclustercert";
    public static final String CLUSTERNAME_PARAM = "clustername";
    public static final String SHOW_PRIMARY_PARAM = "showprimary";
    public static final String CLDBIPS_PARAM = "cldbips";
    public static final String APIIPS_PARAM = "apiips";
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String CROSSCLUSTER_TICKET_PARAM = "crossclusterticket";
    public static final String EXTERNAL_SERVER_TYPE_PARAM = "type";
    public static final String EXTERNAL_SERVER_NAME_PARAM = "externalservername";
    public static final String EXTERNAL_SERVER_IPS_PARAM = "ips";
    public static final String EXTERNAL_SERVER_IPS_SKIP_CHECK = "force";
    private static final String SETUPGRADE_STATUS_PARAM = "status";
    public static final String FILTER_PARAM_NAME = "filter";
    public static final String SORTBY_PARAM_NAME = "sortby";
    public static final String SORTING_ORDER_PARAM_NAME = "sortorder";
    public static final String ASCENDING_SORTING_ORDER_PARAM_NAME = "asc";
    public static final String DESCENDING_SORTING_ORDER_PARAM_NAME = "desc";
    public static final String SORT_DIRECTION_PARAM_NAME = "dir";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    private static final int NUM_ENTRIES_PER_RPC = 100;
    private static final boolean DEBUG_SERVERTICKET = false;
    public static final String clusterGroupCommandsUsage = "clustergroup [setprimary|updateprimary|remove|getcgtable|addexternal]";
    public static final String ClusterGroupSetPrimaryUsage = "clustergroup setprimary -clustername <cluster name of the primary> -cldbips \"hostname1:port1,hostname2:port2,....\"  of the primary-crossclusterticket \"<ticket>\" of the primarySet the given cluster as cluster group primary of the current cluster and also add the cluster in cluster group.";
    public static final String ClusterGroupUpdatePrimaryUsage = "clustergroup updateprimary -clustername <cluster name of the new primary> updates given cluster in cluster group as cluster group primary";
    public static final String ClusterGroupRemoveUsage = "clustergroup remove -clustername <cluster name> removes given cluster from cluster group";
    public static final String ClusterGroupListUsage = "clustergroup list";
    public static final String ClusterGroupGetCgTableUsage = "clustergroup getcgtable [-clustername <clustername>]";
    public static final String ClusterGroupSetUpgradeUsage = "clustergroup setupgrade [-status <upgrade-state>] [-clustername <clustername>]";
    public static final String ClusterGroupAddExternalUsage = "clustergroup addexternal -type <type of external server>-ips comma seperated list of external nfs servers-externalservername external nfs server name";
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
    public static Map<CLDBProto.ClusterGroupConfInfoFields, FieldInfo> fieldTable = new ImmutableMap.Builder().put((Object)CLDBProto.ClusterGroupConfInfoFields.cname, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.cname.getNumber(), "cn", "clustername", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.clustergroupprimary, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.clustergroupprimary.getNumber(), "cgm", "clustergroupprimary", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.clusterid, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.clusterid.getNumber(), "ci", "clusterid", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.cldbip, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.cldbip.getNumber(), "cip", "cldbips", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.apiip, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.apiip.getNumber(), "aip", "apiips", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.ccticket, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.ccticket.getNumber(), "cct", "crossclusterticket", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.srvrticket, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.srvrticket.getNumber(), "srt", "serverticket", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.externalservername, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.externalservername.getNumber(), "ensn", "externalnfsservername", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.ips, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.ips.getNumber(), "ensips", "externalnfsserverips", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.extservertype, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.extservertype.getNumber(), "est", "externalservertype", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.clusterupgradestate, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.clusterupgradestate.getNumber(), "cus", "clusterupgradestate", Integer.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.clusterlocation, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.clusterlocation.getNumber(), "cl", "clusterlocation", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.clusterowner, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.clusterowner.getNumber(), "co", "clusterowner", String.class)).put((Object)CLDBProto.ClusterGroupConfInfoFields.installtype, (Object)new FieldInfo(CLDBProto.ClusterGroupConfInfoFields.installtype.getNumber(), "cit", "installtype", Integer.class)).build();
    private static int MAX_XCLUSTERCONFINFOFIELD = 0;
    static String supportedSortKeys;
    private static Map<String, CLDBProto.ListSortKey> nameToEnumMap;
    public static final CLICommand ClusterGroupSetPrimaryCommand;
    public static final CLICommand ClusterGroupUpdatePrimaryCommand;
    public static final CLICommand ClusterGroupRemoveCommand;
    public static final CLICommand ClusterGroupAddExternalCommand;
    public static final CLICommand ClusterGroupGetCgTableCommand;
    public static final CLICommand ClusterGroupSetUpgradeCommand;
    public static final CLICommand ClusterGroupShowClusterCertCommand;
    public static final CLICommand ClusterGroupListCommand;
    public static final CLICommand[] clusterGroupCommands;

    public ClusterGroupCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String commandName = this.cliCommand.getCommandName().toLowerCase(Locale.ENGLISH);
        try {
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_SETPRIMARY)) {
                return this.setClusterGroupPrimary();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_UPDATEPRIMARY)) {
                return this.updateClusterGroupPrimary();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_REMOVE)) {
                return this.removeServer();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_LIST)) {
                return this.listClusterGroupConfs();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_GET_CG_TABLE)) {
                return this.listClusterGroupConfs();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_ADD_EXTERNAL)) {
                return this.addExternal();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_SETUPGRADE)) {
                return this.setUpgrade();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(CLUSTERGROUP_COMMAND_SHOW_CLUSTER_CERT)) {
                return this.showClusterCert();
            }
            return new TextCommandOutput("clusterGroup command failed".getBytes());
        }
        catch (MaprSecurityException e) {
            LOG.error((Object)("MaprSecurityException in command:" + commandName), (Throwable)e);
            throw new CLIProcessingException("MaprSecurityException:", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("clusterGroup command " + commandName + "failed, exception:"), (Throwable)e);
            throw new CLIProcessingException("clusterGroup command " + commandName + "failed, exception:", (Throwable)e);
        }
    }

    private String getCldbIpsZigZag(CLDBProto.ClusterGroupConf clusterGroupConf) {
        int i;
        Object cldbIpsStr = new String();
        String[] cldbIps = new String[]{};
        String[] cldbExtIps = new String[]{};
        if (!clusterGroupConf.getCldbIps().isEmpty()) {
            cldbIps = clusterGroupConf.getCldbIps().split(" ");
        }
        if (!clusterGroupConf.getCldbExtIps().isEmpty()) {
            cldbExtIps = clusterGroupConf.getCldbExtIps().split(" ");
        }
        int numElementsToZigZag = cldbIps.length <= cldbExtIps.length ? cldbIps.length : cldbExtIps.length;
        boolean isFirst = true;
        for (i = 0; i < numElementsToZigZag; ++i) {
            if (!isFirst) {
                cldbIpsStr = (String)cldbIpsStr + " ";
            } else {
                isFirst = false;
            }
            cldbIpsStr = (String)cldbIpsStr + cldbExtIps[i] + " " + cldbIps[i];
        }
        if (cldbExtIps.length > numElementsToZigZag) {
            for (i = numElementsToZigZag; i < cldbExtIps.length; ++i) {
                if (!isFirst) {
                    cldbIpsStr = (String)cldbIpsStr + " ";
                } else {
                    isFirst = false;
                }
                cldbIpsStr = (String)cldbIpsStr + cldbExtIps[i];
            }
        }
        if (cldbIps.length > numElementsToZigZag) {
            for (i = numElementsToZigZag; i < cldbIps.length; ++i) {
                if (!isFirst) {
                    cldbIpsStr = (String)cldbIpsStr + " ";
                } else {
                    isFirst = false;
                }
                cldbIpsStr = (String)cldbIpsStr + cldbIps[i];
            }
        }
        return cldbIpsStr;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatClusterInfo(CLDBProto.ClusterGroupConf clusterGroupConf) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode();
        boolean terse = this.getOutputParamValue().equals("terse");
        BitSet columns = this.getColumns();
        if (clusterGroupConf.hasClusterName() && columns.get(CLDBProto.ClusterGroupConfInfoFields.cname.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.cname).getName(terse), (Object)clusterGroupConf.getClusterName()));
        }
        if (clusterGroupConf.hasCldbIps() && columns.get(CLDBProto.ClusterGroupConfInfoFields.cldbip.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.cldbip).getName(terse), (Object)this.getCldbIpsZigZag(clusterGroupConf)));
        }
        if (clusterGroupConf.hasApiIps() && columns.get(CLDBProto.ClusterGroupConfInfoFields.apiip.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.apiip).getName(terse), (Object)clusterGroupConf.getApiIps()));
        }
        if (columns.get(CLDBProto.ClusterGroupConfInfoFields.clusterid.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.clusterid).getName(terse), (Object)clusterGroupConf.getClusterId()));
        }
        if (clusterGroupConf.hasCcTicket() && columns.get(CLDBProto.ClusterGroupConfInfoFields.ccticket.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.ccticket).getName(terse), (Object)clusterGroupConf.getCcTicket()));
        }
        if (clusterGroupConf.hasIsClusterGroupPrimary() && columns.get(CLDBProto.ClusterGroupConfInfoFields.clustergroupprimary.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.clustergroupprimary).getName(terse), (Object)clusterGroupConf.getIsClusterGroupPrimary()));
        }
        if (columns.get(CLDBProto.ClusterGroupConfInfoFields.clusterupgradestate.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.clusterupgradestate).getName(terse), (Object)clusterGroupConf.getUpgradeState()));
        }
        if (columns.get(CLDBProto.ClusterGroupConfInfoFields.clusterlocation.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.clusterlocation).getName(terse), (Object)clusterGroupConf.getLocation()));
        }
        if (columns.get(CLDBProto.ClusterGroupConfInfoFields.clusterowner.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.clusterowner).getName(terse), (Object)clusterGroupConf.getOwner()));
        }
        if (columns.get(CLDBProto.ClusterGroupConfInfoFields.installtype.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.installtype).getName(terse), (Object)clusterGroupConf.getInstallType()));
        }
        return outputNode;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatExternalNfsServerInfo(CLDBProto.ExternalNfsServer externalNfsServer) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode();
        boolean terse = this.getOutputParamValue().equals("terse");
        BitSet columns = this.getColumns();
        outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.extservertype).getName(terse), (Object)"ExtNfs"));
        if (externalNfsServer.hasName() && columns.get(CLDBProto.ClusterGroupConfInfoFields.externalservername.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.externalservername).getName(terse), (Object)externalNfsServer.getName()));
        }
        if (externalNfsServer.hasIps() && columns.get(CLDBProto.ClusterGroupConfInfoFields.ips.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(CLDBProto.ClusterGroupConfInfoFields.ips).getName(terse), (Object)externalNfsServer.getIps()));
        }
        return outputNode;
    }

    CommandOutput addExternal() throws Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        String type = this.getParamTextValue(EXTERNAL_SERVER_TYPE_PARAM, 0);
        String externalServerName = this.getParamTextValue(EXTERNAL_SERVER_NAME_PARAM, 0);
        String externalServerIps = this.getParamTextValue(EXTERNAL_SERVER_IPS_PARAM, 0);
        boolean skipIpsCheck = false;
        if (this.isParamPresent(EXTERNAL_SERVER_IPS_SKIP_CHECK)) {
            skipIpsCheck = true;
        }
        if (type.isEmpty()) {
            LOG.error((Object)"External server type is not provided");
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "External server type is not provided"));
            return output;
        }
        if (type.equals("nfs")) {
            if (externalServerName.isEmpty()) {
                LOG.error((Object)"External server path is not provided");
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "External server path is not provided"));
                return output;
            }
            if (externalServerIps.isEmpty()) {
                LOG.error((Object)"External server ips are not provided");
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "External server ips are not provided"));
                return output;
            }
            StringTokenizer st = new StringTokenizer(externalServerIps, ",");
            while (st.hasMoreTokens() && !skipIpsCheck) {
                String nfsIp = st.nextToken().trim();
                Runtime rt = Runtime.getRuntime();
                String cmdStr = "rpcinfo -p " + nfsIp + " | grep 100003";
                String[] cmd = new String[]{"/bin/bash", "-c", cmdStr};
                Process proc = rt.exec(cmd);
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                int numNfsRpcPrograms = 0;
                String s = null;
                while ((s = stdInput.readLine()) != null) {
                    ++numNfsRpcPrograms;
                }
                if (stdError.readLine() != null) {
                    LOG.error((Object)"External server ip is not responding");
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "External server ip: " + nfsIp + " is not responding"));
                    return output;
                }
                if (numNfsRpcPrograms == 0) {
                    LOG.error((Object)("External server ip: " + nfsIp + " don't have registered nfsserver"));
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "External server ip: " + nfsIp + " don't have registered nfsserver"));
                    return output;
                }
                LOG.info((Object)("External server ip: " + nfsIp + " responded with: " + numNfsRpcPrograms + " nfs programes"));
            }
            CLDBProto.ExternalNfsServer extNfsServ = CLDBProto.ExternalNfsServer.newBuilder().setName(externalServerName).setIps(externalServerIps).build();
            CLDBProto.ExternalServer extServ = CLDBProto.ExternalServer.newBuilder().setExtNfs(extNfsServ).build();
            CLDBProto.AddExternalServerRequest req = CLDBProto.AddExternalServerRequest.newBuilder().setCreds(this.getUserCredentials()).setExtServer(extServ).build();
            try {
                byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.AddExternalServerProc.getNumber(), (MessageLite)req, CLDBProto.AddExternalServerResponse.class);
                if (data == null) {
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                    return output;
                }
                CLDBProto.AddExternalServerResponse resp = CLDBProto.AddExternalServerResponse.parseFrom((byte[])data);
                if (resp.getStatus() == 0) {
                    oh.addMessage("Successfully added external nfs server " + externalServerName);
                } else {
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw new CLIProcessingException("InvalidProtocolBufferException " + e);
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
            return output;
        }
        LOG.error((Object)"External server type is not supported");
        oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "External server type is not supported"));
        return output;
    }

    CommandOutput setClusterGroupPrimary() throws Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        String clusterName = this.getParamTextValue(CLUSTERNAME_PARAM, 0);
        String cldbips = this.getParamTextValue(CLDBIPS_PARAM, 0);
        String apiips = new String();
        String ccticket = this.getParamTextValue(CROSSCLUSTER_TICKET_PARAM, 0);
        String[] cldbIpPorts = cldbips.split(" ");
        for (int i = 0; i < cldbIpPorts.length; ++i) {
            String[] cldbProp = cldbIpPorts[i].split(":");
            if (cldbProp.length < 2) {
                LOG.error((Object)("CLDB port is not provided: " + cldbIpPorts[i]));
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "CLDB port is not provided"));
                return output;
            }
            LOG.error((Object)("CLDB properties : " + cldbProp[0] + "  " + cldbProp[1]));
            if (Util.isInteger((String)cldbProp[1])) continue;
            LOG.error((Object)("CLDB port is not integer: " + cldbIpPorts[i]));
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "CLDB port is not integer"));
            return output;
        }
        LOG.info((Object)("CLDB ips: " + cldbips));
        CLDBProto.ClusterGroupConf ccConf = CLDBProto.ClusterGroupConf.newBuilder().setClusterName(clusterName).setCldbIps(cldbips).setApiIps(apiips).setCcTicket(ccticket).setIsClusterGroupPrimary(false).build();
        LOG.debug((Object)("setClusterGroupPrimary: cluster name:" + clusterName + ", cldbips:" + cldbips + ", crossclusterticket:" + ccticket));
        CLDBProto.ClusterGroupAddRequest req = CLDBProto.ClusterGroupAddRequest.newBuilder().setCreds(this.getUserCredentials()).setCcConf(ccConf).setSetClusterGroupPrimary(true).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterGroupAddProc.getNumber(), (MessageLite)req, CLDBProto.ClusterGroupAddResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.ClusterGroupAddResponse resp = CLDBProto.ClusterGroupAddResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                oh.addMessage("Successfully added cluster '" + clusterName + "' to the group and updated primary.");
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
        return output;
    }

    CommandOutput updateClusterGroupPrimary() throws Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        String clusterName = this.getParamTextValue(CLUSTERNAME_PARAM, 0);
        CLDBProto.ClusterGroupConf ccConf = CLDBProto.ClusterGroupConf.newBuilder().setClusterName(clusterName).build();
        LOG.debug((Object)("updateClusterGroupPrimary: cluster name:" + clusterName));
        CLDBProto.ClusterGroupAddRequest req = CLDBProto.ClusterGroupAddRequest.newBuilder().setCreds(this.getUserCredentials()).setCcConf(ccConf).setUpdateClusterGroupPrimary(true).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterGroupAddProc.getNumber(), (MessageLite)req, CLDBProto.ClusterGroupAddResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.ClusterGroupAddResponse resp = CLDBProto.ClusterGroupAddResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                oh.addMessage("Successfully updated primary to '" + clusterName + "'.");
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
        return output;
    }

    CommandOutput removeServer() throws Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        String clusterName = this.getParamTextValue(CLUSTERNAME_PARAM, 0);
        CLDBProto.ClusterGroupConf ccConf = CLDBProto.ClusterGroupConf.newBuilder().setClusterName(clusterName).build();
        CLDBProto.ClusterGroupRemoveRequest req = CLDBProto.ClusterGroupRemoveRequest.newBuilder().setCreds(this.getUserCredentials()).setCcConf(ccConf).build();
        LOG.debug((Object)("removeServer: cluster name:" + clusterName));
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterGroupRemoveProc.getNumber(), (MessageLite)req, CLDBProto.ClusterGroupRemoveResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.ClusterGroupRemoveResponse resp = CLDBProto.ClusterGroupRemoveResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                oh.addMessage("Successfully removed cluster '" + clusterName + "'.");
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
        return output;
    }

    private CLDBProto.ClusterUpgradeState getClusterUpgradeState(String stateStr, CommandOutput.OutputHierarchy oh) {
        for (CLDBProto.ClusterUpgradeState state : CLDBProto.ClusterUpgradeState.values()) {
            if (!state.name().equalsIgnoreCase(stateStr)) continue;
            return state;
        }
        LOG.error((Object)("getClusterUpgradeState: invalid ClusterUpgradeState " + stateStr));
        return null;
    }

    CommandOutput setUpgrade() throws Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        String clusterName = this.getParamTextValue(CLUSTERNAME_PARAM, 0);
        String stateStr = this.getParamTextValue(SETUPGRADE_STATUS_PARAM, 0);
        CLDBProto.ClusterUpgradeState state = this.getClusterUpgradeState(stateStr, oh);
        if (state == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid ClusterUpgradeState " + stateStr));
            return output;
        }
        CLDBProto.ClusterGroupConf ccConf = CLDBProto.ClusterGroupConf.newBuilder().setClusterName(clusterName).setUpgradeState(state).build();
        LOG.debug((Object)("setUpgrade: cluster name:" + clusterName + " state: " + state));
        CLDBProto.ClusterGroupUpdateRequest req = CLDBProto.ClusterGroupUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).setCcConf(ccConf).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterGroupUpdateProc.getNumber(), (MessageLite)req, CLDBProto.ClusterGroupUpdateResponse.class);
            if (data == null) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.ClusterGroupUpdateResponse resp = CLDBProto.ClusterGroupUpdateResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                oh.addMessage("Successfully updated upgrade state for cluster " + clusterName + " to " + state);
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isClusterEntryPresent(String clusterName, String configFile) throws IOException {
        FileReader fr = null;
        File file = new File(configFile);
        fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String[] words = line.split("\\s");
                if (words[0].compareToIgnoreCase(clusterName) != 0) continue;
                LOG.debug((Object)("isClusterEntryPresent: cluster name: " + clusterName + " found in line: " + line));
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (fr != null) {
                fr.close();
            }
        }
        LOG.debug((Object)("isClusterEntryPresent: cluster name: " + clusterName + " NOT found in file: " + configFile));
        return false;
    }

    CommandOutput showClusterCert() throws CLIProcessingException {
        byte[] replyData;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        try {
            String clusterName = this.getParamTextValue(CLUSTERNAME_PARAM, 0);
            CLDBProto.ClusterGroupListRequest req = CLDBProto.ClusterGroupListRequest.newBuilder().setClusterName(this.getParamTextValue(CLUSTERNAME_PARAM, 0)).setCreds(this.getUserCredentials()).build();
            replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterGroupListProc.getNumber(), (MessageLite)req, CLDBProto.ClusterGroupListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            try {
                String tmpRootCaFilePath = "/tmp/root-ca.crt";
                CLDBProto.ClusterGroupListResponse resp = CLDBProto.ClusterGroupListResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() == 0) {
                    Files.writeString(Paths.get(tmpRootCaFilePath, new String[0]), (CharSequence)resp.getCcConfs(0).getRootCaContent(), StandardOpenOption.CREATE);
                    oh.addMessage("Stored root-ca.crt content in /tmp/root-ca.crt");
                }
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
            catch (InvalidProtocolBufferException ipbe) {
                throw new CLIProcessingException("Exception while parsing the RPC response data into ClusterGroupListResponse proto object.", (Throwable)ipbe);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Exception while dumping to the file " + e.toString());
            }
        } else {
            LOG.error((Object)"RPC Request to list cross cluster entries failed. No data returned");
            return null;
        }
        return output;
    }

    CommandOutput listClusterGroupConfs() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        try {
            String sortbyStr;
            CLDBProto.ListSortKey sortKey;
            if (!super.validateInput()) {
                return output;
            }
            if (this.isParamPresent(SORTBY_PARAM_NAME) && (sortKey = nameToEnumMap.get((sortbyStr = this.getParamTextValue(SORTBY_PARAM_NAME, 0)).toLowerCase())) == null) {
                LOG.error((Object)("failed to list sorted cross cluster entries, " + sortbyStr + " is not a valid field to sort."));
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid sortkey: " + sortbyStr));
                return output;
            }
            if (this.isParamPresent(SORTING_ORDER_PARAM_NAME)) {
                if (!this.isParamPresent(SORTBY_PARAM_NAME)) {
                    String msg = "Invalid use of sortorder. Must be used with sortby";
                    LOG.error((Object)msg);
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                    return output;
                }
                String sortOrder = this.getParamTextValue(SORTING_ORDER_PARAM_NAME, 0);
                if (!sortOrder.equalsIgnoreCase(ASCENDING_SORTING_ORDER_PARAM_NAME) && !sortOrder.equalsIgnoreCase(DESCENDING_SORTING_ORDER_PARAM_NAME)) {
                    String msg = "Invalid value for sortorder. Valid values are asc and desc";
                    LOG.error((Object)msg);
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                    return output;
                }
            }
            this.list(oh);
        }
        catch (Exception e) {
            LOG.debug((Object)"caught exception: ", (Throwable)e);
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "caught " + e.getClass().getSimpleName() + " " + e.getMessage()));
        }
        return output;
    }

    private String getOutputParamValue() throws CLIProcessingException {
        return this.isParamPresent(OUTPUT_PARAM_NAME) ? this.getParamTextValue(OUTPUT_PARAM_NAME, 0) : "";
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode outputNode;
        CLDBProto.ClusterGroupListResponse resp = (CLDBProto.ClusterGroupListResponse)response;
        if (resp.getStatus() != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            return;
        }
        boolean showPrimary = this.getParamBooleanValue(SHOW_PRIMARY_PARAM, 0);
        for (CLDBProto.ClusterGroupConf cgc : resp.getCcConfsList()) {
            if (showPrimary && !cgc.getIsClusterGroupPrimary()) continue;
            outputNode = this.formatClusterInfo(cgc);
            out.addNode(outputNode);
        }
        for (CLDBProto.ExternalServer es : resp.getExtServersList()) {
            if (es.getExternalServerOneOfCase() != CLDBProto.ExternalServer.ExternalServerOneOfCase.EXTNFS) continue;
            outputNode = this.formatExternalNfsServerInfo(es.getExtNfs());
            out.addNode(outputNode);
        }
        if (resp.hasTotal()) {
            out.setTotal(-1);
        }
    }

    private BitSet getColumns() throws CLIProcessingException {
        String columnsString;
        BitSet columns = new BitSet();
        columns.set(0, MAX_XCLUSTERCONFINFOFIELD + 1);
        String string = columnsString = this.isParamPresent(COLUMNS_PARAM_NAME) ? this.getParamTextValue(COLUMNS_PARAM_NAME, 0) : null;
        if (columnsString != null && !columnsString.equals("all")) {
            columns = FilterUtil.getColumns(fieldTable, (String)columnsString.trim());
        }
        return columns;
    }

    @Override
    public MessageLite sendRequest(MessageLite request) throws CLIProcessingException {
        byte[] replyData;
        CLDBProto.ClusterGroupListRequest req = (CLDBProto.ClusterGroupListRequest)request;
        try {
            if (this.isParamPresent(CLUSTERNAME_PARAM)) {
                req = CLDBProto.ClusterGroupListRequest.newBuilder((CLDBProto.ClusterGroupListRequest)req).setClusterName(this.getParamTextValue(CLUSTERNAME_PARAM, 0)).build();
            }
            replyData = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterGroupListProc.getNumber(), (MessageLite)req, CLDBProto.ClusterGroupListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            try {
                return CLDBProto.ClusterGroupListResponse.parseFrom((byte[])replyData);
            }
            catch (InvalidProtocolBufferException ipbe) {
                throw new CLIProcessingException("Exception while parsing the RPC response data into ClusterGroupListResponse proto object.", (Throwable)ipbe);
            }
        }
        LOG.error((Object)"RPC Request to list cross cluster entries failed. No data returned");
        return null;
    }

    @Override
    public MessageLite buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.ClusterGroupListRequest.Builder newReqBuilder = null;
        newReqBuilder = prevReq != null ? CLDBProto.ClusterGroupListRequest.newBuilder((CLDBProto.ClusterGroupListRequest)((CLDBProto.ClusterGroupListRequest)prevReq)) : this.getClusterGroupListRequestBuilder();
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            CLDBProto.ClusterGroupListResponse resp = (CLDBProto.ClusterGroupListResponse)prevResp;
            int prevCount = resp.getCcConfsCount();
            int origStart = this.isParamPresent(START_PARAM_NAME) ? this.getParamIntValue(START_PARAM_NAME, 0) : 0;
            int origLimit = this.isParamPresent(LIMIT_PARAM_NAME) ? this.getParamIntValue(LIMIT_PARAM_NAME, 0) : Integer.MAX_VALUE;
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, origStart, origLimit, 100));
        }
        return newReqBuilder.build();
    }

    private CLDBProto.ClusterGroupListRequest.Builder getClusterGroupListRequestBuilder() throws CLIProcessingException {
        CLDBProto.ClusterGroupListRequest.Builder reqBuilder = CLDBProto.ClusterGroupListRequest.newBuilder().setCreds(this.getUserCredentials());
        if (this.isParamPresent(START_PARAM_NAME) && this.isParamPresent(LIMIT_PARAM_NAME)) {
            reqBuilder.setLimiter(this.getNextLimiter(this.getParamIntValue(START_PARAM_NAME, 0), 0, this.getParamIntValue(START_PARAM_NAME, 0), this.getParamIntValue(LIMIT_PARAM_NAME, 0), 100));
        }
        if (this.isParamPresent(FILTER_PARAM_NAME)) {
            List<CLIProto.Filter> filters = this.getFilters(fieldTable, FILTER_PARAM_NAME);
            reqBuilder.addAllFilter(filters);
        }
        if (this.isParamPresent(SORTBY_PARAM_NAME)) {
            String sortbyStr = this.getParamTextValue(SORTBY_PARAM_NAME, 0);
            CLDBProto.ListSortKey sortKey = nameToEnumMap.get(sortbyStr.toLowerCase());
            if (sortKey != null) {
                reqBuilder.setSortKey(sortKey);
            } else {
                LOG.error((Object)("failed to list cross cluster entries, " + sortbyStr + " is not a valid field to sort."));
            }
        }
        if (this.isParamPresent(SORTING_ORDER_PARAM_NAME)) {
            String sortOrder = this.getParamTextValue(SORTING_ORDER_PARAM_NAME, 0);
            boolean descOrder = false;
            if (sortOrder.equalsIgnoreCase(DESCENDING_SORTING_ORDER_PARAM_NAME)) {
                descOrder = true;
            }
            reqBuilder.setSortDescending(descOrder);
        }
        if (this.isParamPresent(SHOW_PRIMARY_PARAM) && this.getParamBooleanValue(SHOW_PRIMARY_PARAM, 0)) {
            reqBuilder.setShowPrimary(true);
        }
        return reqBuilder;
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        if (this.isParamPresent(CLUSTERNAME_PARAM)) {
            return false;
        }
        int start = this.isParamPresent(START_PARAM_NAME) ? this.getParamIntValue(START_PARAM_NAME, 0) : 0;
        int limit = this.isParamPresent(LIMIT_PARAM_NAME) ? this.getParamIntValue(LIMIT_PARAM_NAME, 0) : Integer.MAX_VALUE;
        CLDBProto.ClusterGroupListResponse resp = (CLDBProto.ClusterGroupListResponse)prevResp;
        int numItemsReceived = resp.getCcConfsCount();
        boolean retVal = this.hasMore(start, limit, ((CLDBProto.ClusterGroupListRequest)prevReq).getLimiter().getStart(), numItemsReceived);
        LOG.debug((Object)("hasMore: " + start + ", " + limit + ", " + ((CLDBProto.ClusterGroupListRequest)prevReq).getLimiter().getStart() + ", " + numItemsReceived + ",   hasMore:" + retVal));
        return retVal;
    }

    static {
        CLDBProto.ClusterGroupConfInfoFields[] values = CLDBProto.ClusterGroupConfInfoFields.values();
        int max = 0;
        CLDBProto.ClusterGroupConfInfoFields[] clusterGroupConfInfoFieldsArray = values;
        int n = clusterGroupConfInfoFieldsArray.length;
        for (int i = 0; i < n; ++i) {
            CLDBProto.ClusterGroupConfInfoFields value = clusterGroupConfInfoFieldsArray[i];
            if (value.getNumber() <= max) continue;
            max = value.getNumber();
        }
        MAX_XCLUSTERCONFINFOFIELD = max;
        nameToEnumMap = new HashMap<String, CLDBProto.ListSortKey>();
        StringBuilder sb = new StringBuilder();
        for (CLDBProto.ListSortKey key : CLDBProto.ListSortKey.values()) {
            if (!key.name().startsWith("ClusterGroup")) continue;
            String displayName = key.name().toLowerCase().substring("ClusterGroup".length());
            nameToEnumMap.put(displayName, key);
            if (sb.length() == 0) {
                sb.append(displayName);
                continue;
            }
            sb.append("|" + displayName);
        }
        supportedSortKeys = "<" + sb.toString() + ">";
        for (FieldInfo fInfo : fieldTable.values()) {
            CLDBProto.ListSortKey sKey = fInfo.getListSortKey();
            if (sKey == null) continue;
            nameToEnumMap.put(fInfo.getShortName().toLowerCase(), sKey);
            nameToEnumMap.put(fInfo.getLongName().toLowerCase(), sKey);
        }
        ClusterGroupSetPrimaryCommand = new CLICommand(CLUSTERGROUP_COMMAND_SETPRIMARY, "Sets the primary cluster information and adds itself to the group usage: clustergroup setprimary -clustername <cluster name> -cldbips \"hostname1:port1 hostname2:port2 ....\" -crossclusterticket \"<crossclusterticket>\"", ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)CLUSTERNAME_PARAM, (Object)new TextInputParameter(CLUSTERNAME_PARAM, "name of the primary cluster of the group", true, null)).put((Object)CLDBIPS_PARAM, (Object)new TextInputParameter(CLDBIPS_PARAM, "\"hostname1:port1 hostname2:port2....\" of the primary cluster", true, null)).put((Object)CROSSCLUSTER_TICKET_PARAM, (Object)new TextInputParameter(CROSSCLUSTER_TICKET_PARAM, "cross cluster ticket of the primary cluster", true, null)).build(), null).setShortUsage(ClusterGroupSetPrimaryUsage);
        ClusterGroupUpdatePrimaryCommand = new CLICommand(CLUSTERGROUP_COMMAND_UPDATEPRIMARY, ClusterGroupUpdatePrimaryUsage, ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)CLUSTERNAME_PARAM, (Object)new TextInputParameter(CLUSTERNAME_PARAM, "name of the exisiting cluster to be made as the new primary", true, null)).build(), null).setShortUsage(ClusterGroupUpdatePrimaryUsage);
        ClusterGroupRemoveCommand = new CLICommand(CLUSTERGROUP_COMMAND_REMOVE, "usage: clustergroup remove -clustername name", ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)CLUSTERNAME_PARAM, (Object)new TextInputParameter(CLUSTERNAME_PARAM, "name of the cluster/external server to be removed from the group", true, null)).build(), null).setShortUsage(ClusterGroupRemoveUsage);
        ClusterGroupAddExternalCommand = new CLICommand(CLUSTERGROUP_COMMAND_ADD_EXTERNAL, "usage: clustergroup addexternal -type nfs -externalservername nfs server name -ips comma seperated list of ips", ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)EXTERNAL_SERVER_TYPE_PARAM, (Object)new TextInputParameter(EXTERNAL_SERVER_TYPE_PARAM, "type of the external server being added", true, null)).put((Object)EXTERNAL_SERVER_NAME_PARAM, (Object)new TextInputParameter(EXTERNAL_SERVER_NAME_PARAM, "external server name", true, null)).put((Object)EXTERNAL_SERVER_IPS_PARAM, (Object)new TextInputParameter(EXTERNAL_SERVER_IPS_PARAM, "comma seperated list of external server ips", true, null)).put((Object)EXTERNAL_SERVER_IPS_SKIP_CHECK, (Object)new NoValueInputParameter(EXTERNAL_SERVER_IPS_SKIP_CHECK, "if provided skip checking external server ips", false, false)).build(), null).setShortUsage(ClusterGroupAddExternalUsage);
        ClusterGroupGetCgTableCommand = new CLICommand(CLUSTERGROUP_COMMAND_GET_CG_TABLE, "", ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)SHOW_PRIMARY_PARAM, (Object)new BooleanInputParameter(SHOW_PRIMARY_PARAM, "display cluster info for cluster group primary only", false, Boolean.valueOf(false))).put((Object)CLUSTERNAME_PARAM, (Object)new TextInputParameter(CLUSTERNAME_PARAM, "name of cluster", false, null)).build(), null).setShortUsage(ClusterGroupGetCgTableUsage);
        ClusterGroupSetUpgradeCommand = new CLICommand(CLUSTERGROUP_COMMAND_SETUPGRADE, "", ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)SETUPGRADE_STATUS_PARAM, (Object)new TextInputParameter(SETUPGRADE_STATUS_PARAM, "set upgrade status for given cluster", true, null)).put((Object)CLUSTERNAME_PARAM, (Object)new TextInputParameter(CLUSTERNAME_PARAM, "name of cluster", true, null)).build(), null).setShortUsage(ClusterGroupSetUpgradeUsage);
        ClusterGroupShowClusterCertCommand = new CLICommand(CLUSTERGROUP_COMMAND_SHOW_CLUSTER_CERT, "", ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)CLUSTERNAME_PARAM, (Object)new TextInputParameter(CLUSTERNAME_PARAM, "name of cluster", true, null)).build(), null).setShortUsage(ClusterGroupGetCgTableUsage);
        ClusterGroupListCommand = new CLICommand(CLUSTERGROUP_COMMAND_LIST, "", ClusterGroupCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)SORT_DIRECTION_PARAM_NAME, (Object)new TextInputParameter(SORT_DIRECTION_PARAM_NAME, "none", false, "ASC").setInvisible(true)).put((Object)SORTBY_PARAM_NAME, (Object)new TextInputParameter(SORTBY_PARAM_NAME, supportedSortKeys + ", column names of supported fields.", false, null)).put((Object)SORTING_ORDER_PARAM_NAME, (Object)new TextInputParameter(SORTING_ORDER_PARAM_NAME, "<asc|desc>", false, null)).put((Object)OUTPUT_PARAM_NAME, (Object)new TextInputParameter(OUTPUT_PARAM_NAME, "verbose", false, "verbose")).put((Object)START_PARAM_NAME, (Object)new IntegerInputParameter(START_PARAM_NAME, START_PARAM_NAME, false, Integer.valueOf(0))).put((Object)LIMIT_PARAM_NAME, (Object)new IntegerInputParameter(LIMIT_PARAM_NAME, LIMIT_PARAM_NAME, false, Integer.valueOf(Integer.MAX_VALUE))).build(), null).setUsageInVisible(true).setShortUsage(ClusterGroupListUsage);
        clusterGroupCommands = new CLICommand[]{ClusterGroupSetPrimaryCommand, ClusterGroupUpdatePrimaryCommand, ClusterGroupRemoveCommand, ClusterGroupListCommand, ClusterGroupGetCgTableCommand, ClusterGroupAddExternalCommand, ClusterGroupSetUpgradeCommand, ClusterGroupShowClusterCertCommand};
    }
}

