/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class InstallerCommands
extends ListCommand
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(InstallerCommands.class);
    public static final int START_ARGS = 2;
    public static final String CREATE_SCRIPT = "/opt/mapr/installer/ezdfaas/src/python/create_cluster.py";
    public static final String STATUS_SCRIPT = "/opt/mapr/installer/ezdfaas/src/python/create_cluster_status.py";
    public static final String REMOVE_SCRIPT = "/opt/mapr/installer/ezdfaas/src/python/remove_cluster.py";
    public static final String INFO_SCRIPT = "/opt/mapr/installer/ezdfaas/src/python/cluster_info.py";
    public static final String LIST_SCRIPT = "/opt/mapr/installer/ezdfaas/src/python/list_clusters.py";
    public static final String installerCommandsUsage = "installer  [clustercreate|clusterremove|clusterstatus|clusterinfo|listdeployments]";
    public static final String INSTALLER_COMMAND_CLUSTER_CREATE = "clustercreate";
    public static final String INSTALLER_COMMAND_CLUSTER_REMOVE = "clusterremove";
    public static final String INSTALLER_COMMAND_CLUSTER_STATUS = "clusterstatus";
    public static final String INSTALLER_COMMAND_CLUSTER_INFO = "clusterinfo";
    public static final String INSTALLER_COMMAND_LIST_DEPLOYMENTS = "listdeployments";
    public static final String P_PATH = "pypath";
    public static final String DEFAULT_PATH = "python3 ";
    public static final String usage = "for detailed usage use -h";
    public static final CLICommand InstallerClusterCreateCommand = new CLICommand("clustercreate", "for detailed usage use -h", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"pypath", (Object)new TextInputParameter("pypath", "pythonpath (optional, default is python3, use -h for help)", false, null)).build(), null).setShortUsage("for detailed usage use -h");
    public static final CLICommand InstallerClusterRemoveCommand = new CLICommand("clusterremove", "for detailed usage use -h", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"pypath", (Object)new TextInputParameter("pypath", "pythonpath (optional, default is python3, use -h for help)", false, null)).build(), null).setShortUsage("for detailed usage use -h");
    public static final CLICommand InstallerClusterStatusCommand = new CLICommand("clusterstatus", "for detailed usage use -h", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"pypath", (Object)new TextInputParameter("pypath", "pythonpath (optional, default is python3, use -h for help)", false, null)).build(), null).setShortUsage("for detailed usage use -h");
    public static final CLICommand InstallerClusterInfoCommand = new CLICommand("clusterinfo", "for detailed usage use -h", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"pypath", (Object)new TextInputParameter("pypath", "pythonpath (optional, default is python3, use -h for help)", false, null)).build(), null).setShortUsage("for detailed usage use -h");
    public static final CLICommand InstallerListDeploymentsCommand = new CLICommand("listdeployments", "for detailed usage use -h", InstallerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"pypath", (Object)new TextInputParameter("pypath", "pythonpath (optional, default is python3, use -h for help)", false, null)).build(), null).setShortUsage("for detailed usage use -h");
    public static final CLICommand[] installerCommands = new CLICommand[]{InstallerClusterCreateCommand, InstallerClusterRemoveCommand, InstallerClusterStatusCommand, InstallerClusterInfoCommand, InstallerListDeploymentsCommand};

    public InstallerCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String commandName = this.cliCommand.getCommandName().toLowerCase(Locale.ENGLISH);
        String[] input = this.getInput().getRawInput();
        StringBuilder sb = new StringBuilder();
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        boolean printHelp = false;
        boolean hasPypath = false;
        Object ppath = this.isParamPresent(P_PATH) ? this.getParamTextValue(P_PATH, 0) + " " : DEFAULT_PATH;
        int i = 0;
        for (String str : input) {
            if (++i <= 2) continue;
            if (!printHelp) {
                printHelp = str.equalsIgnoreCase("-h");
            }
            if (str.equalsIgnoreCase("-pypath")) {
                hasPypath = true;
                continue;
            }
            if (hasPypath) {
                hasPypath = false;
                continue;
            }
            if (str.equalsIgnoreCase("-json")) continue;
            sb.append(" " + str);
        }
        Object args = sb.toString();
        try {
            if (this.cliCommand.getCommandName().equalsIgnoreCase(INSTALLER_COMMAND_CLUSTER_CREATE)) {
                args = (String)ppath + CREATE_SCRIPT + (String)args;
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase(INSTALLER_COMMAND_CLUSTER_REMOVE)) {
                args = (String)ppath + REMOVE_SCRIPT + (String)args;
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase(INSTALLER_COMMAND_CLUSTER_STATUS)) {
                args = (String)ppath + STATUS_SCRIPT + (String)args;
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase(INSTALLER_COMMAND_CLUSTER_INFO)) {
                args = (String)ppath + INFO_SCRIPT + (String)args;
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase(INSTALLER_COMMAND_LIST_DEPLOYMENTS)) {
                args = (String)ppath + LIST_SCRIPT + (String)args;
            } else {
                return new TextCommandOutput("Not a valid installer command".getBytes());
            }
            return this.executeCommand((String)args, printHelp);
        }
        catch (Exception e) {
            LOG.error((Object)("Installer command " + commandName + "failed, exception:"), (Throwable)e);
            throw new CLIProcessingException("Installer command " + commandName + "failed, exception:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CommandOutput executeCommand(String inputString, boolean printHelp) {
        ArrayList<String> finalCommand;
        int ret;
        ByteArrayOutputStream baos;
        CommandOutput.OutputHierarchy oh;
        CommandOutput output;
        block11: {
            long timeout = 600L;
            output = new CommandOutput();
            oh = new CommandOutput.OutputHierarchy();
            output.setOutput(oh);
            String[] command = inputString.split(" ");
            baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            ret = -1;
            finalCommand = new ArrayList<String>();
            for (String comToken : command) {
                finalCommand.addAll(Arrays.asList(comToken.split(" ")));
            }
            try {
                ProcessBuilder pb = new ProcessBuilder(finalCommand);
                pb.directory(null);
                pb.redirectErrorStream(true);
                Process process = pb.start();
                BufferedInputStream is = new BufferedInputStream(process.getInputStream());
                try {
                    int len;
                    long startProcessingTime = System.currentTimeMillis();
                    while ((len = is.read(buf)) != -1 && System.currentTimeMillis() - startProcessingTime < timeout) {
                        baos.write(buf, 0, len);
                    }
                    if (System.currentTimeMillis() - startProcessingTime >= timeout) break block11;
                    try {
                        ret = process.waitFor();
                    }
                    catch (InterruptedException e) {
                        String msg = "Interrupted Exception during command: " + finalCommand + " run";
                        oh.addError(new CommandOutput.OutputHierarchy.OutputError(4, msg));
                        LOG.error((Object)msg, (Throwable)e);
                        CommandOutput commandOutput = output;
                        is.close();
                        process.destroy();
                        return commandOutput;
                    }
                }
                finally {
                    is.close();
                    process.destroy();
                }
            }
            catch (IOException ioex) {
                String msg = "IOException during process firing";
                LOG.error((Object)msg, (Throwable)ioex);
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(5, msg));
                return output;
            }
        }
        TextCommandOutput txt = new TextCommandOutput(baos.toByteArray());
        if (ret != 0) {
            String out = "Error:" + ret + " while running command: " + finalCommand + System.lineSeparator();
            LOG.error((Object)out);
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, out + txt.toPrettyString()));
            return output;
        }
        if (printHelp) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(0, txt.toPrettyString()));
            return output;
        }
        oh.addMessage(txt.toPrettyString());
        return output;
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
    }

    @Override
    public MessageLite sendRequest(MessageLite req) throws CLIProcessingException {
        return null;
    }

    @Override
    public MessageLite buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return null;
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return false;
    }
}

