/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.mapr.cli.JobLogLinkUtils;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.DefaultYarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.TaskLogUtil;
import org.apache.hadoop.yarn.webapp.log.DFSContainerLogsUtils;

public final class SetupYarnAppLogLinks {
    private static final Log LOG = LogFactory.getLog(SetupYarnAppLogLinks.class);
    private final String appIdStr;
    private final String targetBaseDir;

    public SetupYarnAppLogLinks(String appIdStr, String targetBaseDir) {
        this.appIdStr = appIdStr;
        this.targetBaseDir = targetBaseDir;
    }

    public void run() throws YarnException, IOException {
        if (this.appIdStr == null) {
            System.err.println("ApplicationId cannot be null!");
            return;
        }
        ApplicationId appId = null;
        try {
            appId = ConverterUtils.toApplicationId((String)this.appIdStr);
        }
        catch (Exception e) {
            System.err.println("Invalid ApplicationId specified");
            return;
        }
        YarnClient yarnClient = this.createYarnClient();
        ApplicationReport appReport = null;
        try {
            appReport = yarnClient.getApplicationReport(appId);
        }
        catch (ApplicationNotFoundException e) {
            LOG.error((Object)"Application not found", (Throwable)e);
            System.err.println("Application not found. Check application id.");
            return;
        }
        if (!this.isAppDone(appReport)) {
            String msg = "Application has not yet completed. So you will be viewing partial logs only.";
            LOG.warn((Object)msg);
            System.out.println("WARN: " + msg);
        }
        FileSystem fs = FileSystem.get((Configuration)DefaultYarnConfiguration.get());
        Path[] appLogs = TaskLogUtil.getDFSLoggingHandler().getLogDir(appId);
        boolean mapreduce = false;
        Path targetAppDirPath = JobLogLinkUtils.setupTargetJobDir(fs, this.targetBaseDir, this.appIdStr, mapreduce);
        if (appLogs == null) {
            return;
        }
        for (Path appLogDir : appLogs) {
            Path[] paths;
            String hostName = appLogDir.toUri().getPath().split("/")[4];
            Path hostsDirPath = JobLogLinkUtils.getHostDirPath(targetAppDirPath);
            Path hostDirPath = new Path(hostsDirPath, hostName);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating host dir: " + hostDirPath));
            }
            fs.mkdirs(hostDirPath);
            for (Path path : paths = DFSContainerLogsUtils.getFilesInDir((Path)appLogDir)) {
                JobLogLinkUtils.createSymlinkIfAbsent(fs, path, new Path(hostDirPath, path.getName()));
            }
        }
    }

    private boolean isAppDone(ApplicationReport appReport) {
        switch (appReport.getYarnApplicationState()) {
            case NEW: 
            case NEW_SAVING: 
            case ACCEPTED: 
            case SUBMITTED: 
            case RUNNING: {
                return false;
            }
        }
        return true;
    }

    private YarnClient createYarnClient() {
        YarnClient yarnClient = YarnClient.createYarnClient();
        yarnClient.init((Configuration)DefaultYarnConfiguration.get());
        yarnClient.start();
        return yarnClient;
    }
}

