/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.cli.common.ListCommand;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.security.MaprSecurityException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class GlobalNSCommands
extends ListCommand
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(GlobalNSCommands.class);
    public static final String CONF_FILE = "/opt/mapr/conf/mapr-clusters.conf";
    public static final String TICKET_FILE = "/opt/mapr/conf/maprserverticket";
    public static final String TMP_CONF_FILE = "/tmp/conf.file";
    public static final String TMP_TICKET_FILE = "/tmp/ticket.file";
    public static final String NFS_EXPORT_FILE = "/opt/mapr/conf/exports";
    public static final String GLOBALNS_COMMAND_ADD = "add";
    public static final String GLOBALNS_COMMAND_REMOVE = "remove";
    public static final String GLOBALNS_COMMAND_GET_SERVER_TICKET = "getserverticket";
    public static final String CLUSTERNAME_PARAM = "clustername";
    public static final String CLDBIPS_PARAM = "cldbips";
    public static final String SECURE_PARAM = "secure";
    public static final String SERVERTICKET_PARAM = "serverticket";
    public static final String globalNsCommandsUsage = "globalNs [add|remove|getserverticket]";
    public static final String GlobalNSAddUsage = "globalns add -clustername <name> -cldbips \"ip1:port ip2:port ip3:port\" -secure <true|false> -serverticket \"<maprserverticket>\" ";
    public static final String GlobalNSRemoveUsage = "globalNs remove -clustername name";
    public static final String GlobalNSGetServerTicketUsage = "globalNs getserverticket";
    public static final CLICommand GlobalNSAddCommand = new CLICommand("add", "usage: globalns add -clustername name -cldbips \"ip1:port ip2:port ip3:port\" -secure true/false -serverticket \"<maprserverticket>\"", GlobalNSCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).put((Object)"cldbips", (Object)new TextInputParameter("cldbips", "\"ip1:port ip2:port ip3:port ....\"", true, null)).put((Object)"secure", (Object)new BooleanInputParameter("secure", "secure", false, Boolean.valueOf(true))).put((Object)"serverticket", (Object)new TextInputParameter("serverticket", "maprserverticket", false, null)).build(), null).setShortUsage("globalns add -clustername <name> -cldbips \"ip1:port ip2:port ip3:port\" -secure <true|false> -serverticket \"<maprserverticket>\" ");
    public static final CLICommand GlobalNSRemoveCommand = new CLICommand("remove", "usage: globalns remove -clustername name", GlobalNSCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"clustername", (Object)new TextInputParameter("clustername", "clustername", true, null)).build(), null).setShortUsage("globalNs remove -clustername name");
    public static final CLICommand GlobalNSGetServerTicketCommand = new CLICommand("getserverticket", "usage: globalNs getserverticket", GlobalNSCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().build(), null).setShortUsage("globalNs getserverticket");
    public static final CLICommand[] globalNSCommands = new CLICommand[]{GlobalNSAddCommand, GlobalNSRemoveCommand, GlobalNSGetServerTicketCommand};

    public GlobalNSCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String commandName = this.cliCommand.getCommandName().toLowerCase(Locale.ENGLISH);
        try {
            if (this.cliCommand.getCommandName().equalsIgnoreCase(GLOBALNS_COMMAND_ADD)) {
                return this.addServer();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(GLOBALNS_COMMAND_REMOVE)) {
                return this.removeServer();
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase(GLOBALNS_COMMAND_GET_SERVER_TICKET)) {
                return this.getServerTicket();
            }
            return new TextCommandOutput("globalNS command failed".getBytes());
        }
        catch (MaprSecurityException e) {
            LOG.error((Object)("MaprSecurityException in command:" + commandName), (Throwable)e);
            throw new CLIProcessingException("MaprSecurityException:", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("globalNS command " + commandName + "failed, exception:"), (Throwable)e);
            throw new CLIProcessingException("globalNS command " + commandName + "failed, exception:", (Throwable)e);
        }
    }

    CommandOutput addServer() throws Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        String clusterName = this.getParamTextValue(CLUSTERNAME_PARAM, 0);
        String cldbips = this.getParamTextValue(CLDBIPS_PARAM, 0);
        boolean secure = true;
        String serverticket = null;
        if (this.isParamPresent(SECURE_PARAM)) {
            secure = this.getParamBooleanValue(SECURE_PARAM, 0);
        }
        if (secure && !this.isParamPresent(SERVERTICKET_PARAM)) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Secure cluster requires server ticket"));
            return output;
        }
        if (secure) {
            serverticket = this.getParamTextValue(SERVERTICKET_PARAM, 0);
        }
        try {
            if (GlobalNSCommands.isClusterEntryPresent(clusterName, CONF_FILE)) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(17, "Cluster is already part of globalNS"));
                return output;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (secure && GlobalNSCommands.isClusterEntryPresent(clusterName, TICKET_FILE)) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(17, "Cluster ticket is already present"));
                return output;
            }
        }
        catch (IOException e) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Add global namespace operation for " + clusterName + " failed with exception. " + e.getMessage()));
            LOG.error((Object)("IOException while adding globalnamespace for cluster " + clusterName), (Throwable)e);
            e.printStackTrace();
        }
        String centry = clusterName + " secure=" + Boolean.toString(secure) + " " + cldbips;
        GlobalNSCommands.appendClusterEntry(centry, CONF_FILE);
        if (secure) {
            String ticketEntry = clusterName + " " + serverticket;
            GlobalNSCommands.appendClusterEntry(ticketEntry, TICKET_FILE);
        }
        GlobalNSCommands.changeTimeStamp(NFS_EXPORT_FILE);
        return output;
    }

    CommandOutput removeServer() throws Exception {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        String clusterName = this.getParamTextValue(CLUSTERNAME_PARAM, 0);
        if (!GlobalNSCommands.isClusterEntryPresent(clusterName, CONF_FILE)) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Cluster entry not present in conf file"));
            return output;
        }
        try {
            GlobalNSCommands.removeClusterEntry(clusterName, CONF_FILE, TMP_CONF_FILE);
            GlobalNSCommands.removeClusterEntry(clusterName, TICKET_FILE, TMP_TICKET_FILE);
        }
        catch (IOException e) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Remove global namespace operation for " + clusterName + " failed with exception. " + e.getMessage()));
            LOG.error((Object)("IOException while removing globalnamespace for cluster " + clusterName), (Throwable)e);
            e.printStackTrace();
        }
        GlobalNSCommands.changeTimeStamp(NFS_EXPORT_FILE);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CommandOutput getServerTicket() throws IOException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        output.setOutput(oh);
        try (FileReader fr = null;){
            fr = new FileReader(TICKET_FILE);
            BufferedReader br = new BufferedReader(fr);
            String line = br.readLine();
            if (line != null) {
                LOG.debug((Object)("getServerTicket: line read: " + line));
                String[] words = line.split("\\s");
                if (words.length != 2) {
                    LOG.error((Object)("Invalid entry in /opt/mapr/conf/maprserverticket. Line: " + line));
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid entry for server ticket in /opt/mapr/conf/maprserverticket"));
                    CommandOutput commandOutput = output;
                    return commandOutput;
                }
                CommandOutput.OutputHierarchy.OutputNode opNode = new CommandOutput.OutputHierarchy.OutputNode();
                opNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(SERVERTICKET_PARAM, (Object)words[1]));
                oh.addNode(opNode);
                CommandOutput commandOutput = output;
                return commandOutput;
            }
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isClusterEntryPresent(String clusterName, String configFile) throws IOException {
        FileReader fr = null;
        File file = new File(configFile);
        fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String[] words = line.split("\\s");
                if (words[0].compareToIgnoreCase(clusterName) != 0) continue;
                LOG.debug((Object)("isClusterEntryPresent: cluster name: " + clusterName + " found in line: " + line));
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (fr != null) {
                fr.close();
            }
        }
        LOG.debug((Object)("isClusterEntryPresent: cluster name: " + clusterName + " NOT found in file: " + configFile));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeClusterEntry(String clusterName, String configFile, String tmpFileName) throws IOException {
        FileWriter tmpWrtr = new FileWriter(tmpFileName, true);
        BufferedWriter tmpBuffWrtr = new BufferedWriter(tmpWrtr);
        PrintWriter prntWrtr = new PrintWriter(tmpBuffWrtr);
        File confFile = new File(configFile);
        FileReader confRedr = new FileReader(confFile);
        BufferedReader br = new BufferedReader(confRedr);
        boolean entryFound = false;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String[] words = line.split("\\s");
                if (words[0].compareToIgnoreCase(clusterName) == 0) {
                    LOG.debug((Object)("removeClusterEntry: cluster name: " + clusterName + " found in line: " + line + ", skipping line"));
                    entryFound = true;
                    continue;
                }
                prntWrtr.println(line);
            }
        }
        finally {
            if (confRedr != null) {
                confRedr.close();
            }
            prntWrtr.close();
        }
        if (!entryFound) {
            LOG.info((Object)("removeClusterEntry: entry for cluster name " + clusterName + " not found in " + configFile));
            return;
        }
        LOG.debug((Object)("removeClusterEntry: entry for cluster name " + clusterName + " successfully removed from " + configFile));
        File bkup = new File(configFile + ".bkup");
        boolean status = confFile.renameTo(bkup);
        if (!status) {
            LOG.debug((Object)("removeClusterEntry: failed to rename " + configFile + " to " + configFile + ".bkup"));
            return;
        }
        LOG.debug((Object)("removeClusterEntry: Successfully renamed " + configFile + " to " + configFile + ".bkup"));
        File newFile = new File(tmpFileName);
        status = newFile.renameTo(confFile);
        bkup.delete();
        if (!status) {
            LOG.debug((Object)("removeClusterEntry: failed to rename " + newFile + " to " + configFile));
        }
        LOG.debug((Object)("removeClusterEntry: Successfully renamed " + newFile + " to " + configFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void appendClusterEntry(String confEntry, String configFile) throws IOException {
        try (PrintWriter prntWrtr = null;){
            FileWriter cfgWrtr = new FileWriter(configFile, true);
            BufferedWriter cfgBuff = new BufferedWriter(cfgWrtr);
            prntWrtr = new PrintWriter(cfgBuff);
            prntWrtr.println(confEntry);
        }
    }

    static void changeTimeStamp(String filePath) {
        File file = new File(filePath);
        long timestamp = System.currentTimeMillis();
        boolean success = file.setLastModified(timestamp);
        if (!success) {
            LOG.error((Object)("Cannot change timestamp for file: " + filePath));
        }
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
    }

    @Override
    public MessageLite sendRequest(MessageLite req) throws CLIProcessingException {
        return null;
    }

    @Override
    public MessageLite buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return null;
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return false;
    }
}

