/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.common;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import java.io.IOException;
import org.apache.log4j.Logger;

public class CLDBUtils {
    private static final Logger LOG = Logger.getLogger(CLDBUtils.class);

    public static boolean IsFeatureEnabled(String featureName, Security.CredentialsMsg creds) throws Exception, InvalidProtocolBufferException {
        CLDBProto.FeatureListRequest.Builder featureInfoBuilder = CLDBProto.FeatureListRequest.newBuilder().setCreds(creds);
        featureInfoBuilder.addFeatures(featureName);
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FeatureListProc.getNumber(), (MessageLite)featureInfoBuilder.build(), CLDBProto.FeatureListResponse.class);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to get information about feature " + featureName + " due to error: " + e.getMessage()));
            throw e;
        }
        CLDBProto.FeatureListResponse resp = null;
        try {
            resp = CLDBProto.FeatureListResponse.parseFrom((byte[])data);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to read feature list response from server for " + featureName + " due to error: " + e.getMessage()));
            throw e;
        }
        if (resp.getStatus() != 0) {
            throw new IOException("Failed to get feature list information  due to error: " + resp.getStatus());
        }
        if (resp.getFeaturesCount() > 0) {
            CLDBProto.MaprFeatureInfo mf = (CLDBProto.MaprFeatureInfo)resp.getFeaturesList().get(0);
            if (!mf.getFeatureName().equals(featureName)) {
                throw new IOException("Invalid feature information received,  expected " + featureName + ", received" + mf.getFeatureName());
            }
            if (mf.hasEnabled()) {
                return mf.getEnabled();
            }
        }
        return false;
    }
}

