/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.tedutils.TedConstants;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.CLDBS3ServerProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.PolicyServerProto;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.UnixUserGroupHelper;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;

public class TedCommands
extends CLIBaseClass
implements CLIInterface {
    private static final int DEFAULT_PORT_INSIGHT = 8010;
    private static final String DEFAULT_HOST_NAME = "localhost";
    private static final Logger LOG = Logger.getLogger(TedCommands.class);
    static final String TED_ID_PARAM_NAME = "id";
    static final String OBJECT_PARAM_NAME = "object";
    static final String SET_VALUE_PARAM_NAME = "setValue";
    static final String TED_SERVER_TYPE = "servertype";
    static final String TED_SERVER_CLDB = "cldb";
    static final String TED_SERVER_PBS = "policyServer";
    static final String TED_SERVER_S3 = "cldbs3server";
    static final String TED_SERVER_INSIGHT = "insightServer";
    static final String TED_PROC_ID = "procid";
    static final String TED_RET_FOR_PROC = "retval";
    static final String HOST_PARAM_NAME = "host";
    static final String PORT_PARAM_NAME = "port";
    static final Map<String, BaseInputParameter> params = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build();
    static final CLICommand enableCommand = new CLICommand("enable", "enable tedaction for an object", TedCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(params).put((Object)"id", (Object)new IntegerInputParameter("id", "tedaction to enable", true, null)).put((Object)"object", (Object)new TextInputParameter("object", "object on which to enable", false, null)).put((Object)"setValue", (Object)new TextInputParameter("setValue", "delta to apply", false, null)).put((Object)"procid", (Object)new IntegerInputParameter("procid", "proc id to apply", false, null)).put((Object)"retval", (Object)new IntegerInputParameter("retval", "return value for given proc", false, null)).put((Object)"servertype", (Object)new TextInputParameter("servertype", "<cldb|policyserver|cldbs3server|insightServer> Server to send request to", false, "cldb")).put((Object)"host", (Object)new TextInputParameter("host", "host to send the rpc to", false, null)).put((Object)"port", (Object)new IntegerInputParameter("port", "port to send the rpc to", false, null)).build(), null).setShortUsage("enable -id <tedaction> -object <ref> [-servertype <cldb|policyserver|cldbs3server|insightServer>] [-host <hostname>] [-p <port>]");
    static final CLICommand enableOnceCommand = new CLICommand("enableonce", "enable tedaction once for an object", TedCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(params).put((Object)"id", (Object)new IntegerInputParameter("id", "tedaction to enable", true, null)).put((Object)"object", (Object)new TextInputParameter("object", "object on which to enable", false, null)).put((Object)"setValue", (Object)new TextInputParameter("setValue", "absolute value to set", false, null)).put((Object)"procid", (Object)new IntegerInputParameter("procid", "proc id to apply", false, null)).put((Object)"retval", (Object)new IntegerInputParameter("retval", "return value for given proc", false, null)).put((Object)"servertype", (Object)new TextInputParameter("servertype", "<cldb|policyserver|cldbs3server|insightServer> Server to send request to", false, "cldb")).put((Object)"host", (Object)new TextInputParameter("host", "host to send the rpc to", false, null)).put((Object)"port", (Object)new IntegerInputParameter("port", "port to send the rpc to", false, null)).build(), null).setShortUsage("enableonce -id <tedaction> -object <ref> [-servertype <cldb|policyserver|cldbs3server|insightServer>] [-host <hostname>] [-p <port>]");
    static final CLICommand disableCommand = new CLICommand("disable", "disable tedaction for an object", TedCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(params).put((Object)"id", (Object)new IntegerInputParameter("id", "tedaction to disable", true, null)).put((Object)"object", (Object)new TextInputParameter("object", "object on which to disable (default:all)", false, null)).put((Object)"servertype", (Object)new TextInputParameter("servertype", "<cldb|policyserver|cldbs3server|insightServer> Server to send request to", false, "cldb")).put((Object)"procid", (Object)new IntegerInputParameter("procid", "proc id to disable", false, null)).put((Object)"host", (Object)new TextInputParameter("host", "host to send the rpc to", false, null)).put((Object)"port", (Object)new IntegerInputParameter("port", "port to send the rpc to", false, null)).build(), null).setShortUsage("disable -id <tedaction> -object <ref> [-servertype <cldb|policyserver|cldbs3server|insightServer>] [-host <hostname>] [-p <port>]");
    static final CLICommand statusCommand = new CLICommand("status", "status of tedactions", TedCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(params).put((Object)"servertype", (Object)new TextInputParameter("servertype", "<insightServer> Server to send request to", true, null)).put((Object)"id", (Object)new IntegerInputParameter("id", "status of tedactions", false, null)).put((Object)"host", (Object)new TextInputParameter("host", "host to send the rpc to", false, null)).put((Object)"port", (Object)new IntegerInputParameter("port", "port to send the rpc to", false, null)).build(), null).setShortUsage("status [-id <tedaction>] -servertype <insightServer> [-host <hostname>] [-p <port>]");
    static final CLICommand[] subCommands = new CLICommand[]{enableCommand, enableOnceCommand, disableCommand, statusCommand};
    static final String usageStr = "ted [enable|enableonce|disable|status] -id [tedaction] [-object <ref>] [-host <hostname>] [-p <port>]";
    public static final CLICommand commands = new CLICommand("ted", "usage: ted [enable|enableonce|disable|status] -id [tedaction] [-object <ref>] [-host <hostname>] [-p <port>]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, subCommands).setUsageInVisible(true).setShortUsage("ted [enable|enableonce|disable|status] -id [tedaction] [-object <ref>] [-host <hostname>] [-p <port>]");
    UnixUserGroupHelper userInfo;

    public TedCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    private long getBindingForHost(String hostname, int port) {
        String clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        CLDBRpcCommonUtils.IpAddr ipAddr = new CLDBRpcCommonUtils.IpAddr(hostname);
        return Rpc.createBindingFor((byte[])ipAddr.toByteArray(), (int)port, (String)clusterName, (int)Security.ServerKeyType.ServerKey.getNumber());
    }

    void init() throws CLIProcessingException {
        try {
            LOG.info((Object)"Initializing port for insight ted");
            int port = Rpc.initialize((int)0, (int)0, null);
            if (port < 0) {
                throw new IOException("Failed to initalize RPC");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Exception in Rpc.initialize " + e));
            throw new CLIProcessingException("Exception in Rpc.initialize ", (Throwable)e);
        }
    }

    private void printTedEventStatus(CLDBProto.TedEventsInfo eventInfo, CommandOutput.OutputHierarchy.OutputNode oEventName) {
        oEventName.addChild(new CommandOutput.OutputHierarchy.OutputNode("Enable", eventInfo.getEnabled()));
        oEventName.addChild(new CommandOutput.OutputHierarchy.OutputNode("EnableOnce", eventInfo.getEnabledOnce()));
        oEventName.addChild(new CommandOutput.OutputHierarchy.OutputNode("Disable", eventInfo.getDisabled()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CommandOutput enableTedAction() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        String hostname = DEFAULT_HOST_NAME;
        int port = 8010;
        long hostbinding = -1L;
        CLDBProto.TedActionRequest.Builder reqB = CLDBProto.TedActionRequest.newBuilder();
        reqB.setCmd(CLDBProto.TedActionRequest.TedActionType.ENABLE);
        int id = this.getParamIntValue(TED_ID_PARAM_NAME, 0);
        reqB.setId(id);
        if (this.isParamPresent(OBJECT_PARAM_NAME)) {
            reqB.setObjectRef(this.getParamTextValue(OBJECT_PARAM_NAME, 0));
        }
        if (this.isParamPresent(SET_VALUE_PARAM_NAME)) {
            reqB.setValue(this.getParamTextValue(SET_VALUE_PARAM_NAME, 0));
        }
        if (this.isParamPresent(TED_PROC_ID)) {
            if (!this.isParamPresent(TED_RET_FOR_PROC)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "retval needed with procid"));
                output.setOutput(out);
                return output;
            }
            reqB.setProc(this.getParamIntValue(TED_PROC_ID, 0));
            reqB.setRetVal(this.getParamIntValue(TED_RET_FOR_PROC, 0));
        } else if (this.isParamPresent(TED_RET_FOR_PROC)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "retval needed with procid"));
            output.setOutput(out);
            return output;
        }
        reqB.setCreds(this.getUserCredentials());
        byte[] data = null;
        CLDBRpcCommonUtils cldbRpc = CLDBRpcCommonUtils.getInstance();
        try {
            int procId;
            int progId;
            block20: {
                block21: {
                    String servertype;
                    block22: {
                        if (!this.isParamPresent(TED_SERVER_TYPE)) break block21;
                        servertype = this.getParamTextValue(TED_SERVER_TYPE, 0);
                        if (!servertype.equalsIgnoreCase(TED_SERVER_PBS)) break block22;
                        progId = Common.MapRProgramId.PolicyServerProgramId.getNumber();
                        procId = PolicyServerProto.SecurityPolicyProc.SecurityPolicyTedActionProc.getNumber();
                        break block20;
                    }
                    if (servertype.equalsIgnoreCase(TED_SERVER_INSIGHT)) {
                        progId = Common.MapRProgramId.InsightServerProgramId.getNumber();
                        procId = CLDBProto.CLDBProg.InsightTedActionProc.getNumber();
                        if (this.isParamPresent(HOST_PARAM_NAME)) {
                            hostname = this.getParamTextValue(HOST_PARAM_NAME, 0);
                        }
                        if (this.isParamPresent(PORT_PARAM_NAME)) {
                            port = this.getParamIntValue(PORT_PARAM_NAME, 0);
                        }
                        this.init();
                        hostbinding = this.getBindingForHost(hostname, port);
                        break block20;
                    } else if (servertype.equalsIgnoreCase(TED_SERVER_S3)) {
                        progId = Common.MapRProgramId.CldbS3ServerProgramId.getNumber();
                        procId = CLDBS3ServerProto.S3ServerProg.S3ServerTedActionProc.getNumber();
                        break block20;
                    } else {
                        if (!servertype.equalsIgnoreCase(TED_SERVER_CLDB)) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid server type " + servertype));
                            output.setOutput(out);
                            return output;
                        }
                        progId = Common.MapRProgramId.CldbProgramId.getNumber();
                        procId = CLDBProto.CLDBProg.TedActionProc.getNumber();
                    }
                    break block20;
                }
                progId = Common.MapRProgramId.CldbProgramId.getNumber();
                procId = CLDBProto.CLDBProg.TedActionProc.getNumber();
            }
            if (hostbinding > 0L) {
                if (id >= 1700 && id <= 1702) {
                    byte[] replyData = Rpc.sendRequest((long)hostbinding, (int)progId, (int)procId, (MessageLite)reqB.build());
                    if (replyData != null) return output;
                    LOG.error((Object)"Got null reply from RPC");
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "rpc to Insight Service failed"));
                    output.setOutput(out);
                    return output;
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Mismatch of id and server type."));
                output.setOutput(out);
                return output;
            }
            data = this.isParamPresent("cluster") ? cldbRpc.sendRequest(this.getParamTextValue("cluster", 0), progId, procId, (MessageLite)reqB.build(), CLDBProto.TedActionResponse.class) : cldbRpc.sendRequest(progId, procId, (MessageLite)reqB.build(), CLDBProto.TedActionResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.TedActionResponse resp = CLDBProto.TedActionResponse.parseFrom((byte[])data);
            int status = resp.getStatus();
            if (status == 0) return output;
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "enabling tedaction failed with error - " + resp.getErrMsg()));
            output.setOutput(out);
            return output;
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error while trying to enable tedaction"));
            output.setOutput(out);
            return output;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CommandOutput enableTedActionOnce() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        String hostname = DEFAULT_HOST_NAME;
        int port = 8010;
        long hostbinding = -1L;
        CLDBProto.TedActionRequest.Builder reqB = CLDBProto.TedActionRequest.newBuilder();
        reqB.setCmd(CLDBProto.TedActionRequest.TedActionType.ENABLEONCE);
        int id = this.getParamIntValue(TED_ID_PARAM_NAME, 0);
        reqB.setId(id);
        if (this.isParamPresent(OBJECT_PARAM_NAME)) {
            reqB.setObjectRef(this.getParamTextValue(OBJECT_PARAM_NAME, 0));
        }
        if (this.isParamPresent(SET_VALUE_PARAM_NAME)) {
            reqB.setValue(this.getParamTextValue(SET_VALUE_PARAM_NAME, 0));
        }
        if (this.isParamPresent(TED_PROC_ID)) {
            if (!this.isParamPresent(TED_RET_FOR_PROC)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "retval needed with procid"));
                output.setOutput(out);
                return output;
            }
            reqB.setProc(this.getParamIntValue(TED_PROC_ID, 0));
            reqB.setRetVal(this.getParamIntValue(TED_RET_FOR_PROC, 0));
        } else if (this.isParamPresent(TED_RET_FOR_PROC)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "retval needed with procid"));
            output.setOutput(out);
            return output;
        }
        reqB.setCreds(this.getUserCredentials());
        byte[] data = null;
        CLDBRpcCommonUtils cldbRpc = CLDBRpcCommonUtils.getInstance();
        try {
            int procId;
            int progId;
            block20: {
                block21: {
                    String servertype;
                    block22: {
                        if (!this.isParamPresent(TED_SERVER_TYPE)) break block21;
                        servertype = this.getParamTextValue(TED_SERVER_TYPE, 0);
                        if (!servertype.equalsIgnoreCase(TED_SERVER_PBS)) break block22;
                        progId = Common.MapRProgramId.PolicyServerProgramId.getNumber();
                        procId = PolicyServerProto.SecurityPolicyProc.SecurityPolicyTedActionProc.getNumber();
                        break block20;
                    }
                    if (servertype.equalsIgnoreCase(TED_SERVER_INSIGHT)) {
                        progId = Common.MapRProgramId.InsightServerProgramId.getNumber();
                        procId = CLDBProto.CLDBProg.InsightTedActionProc.getNumber();
                        if (this.isParamPresent(HOST_PARAM_NAME)) {
                            hostname = this.getParamTextValue(HOST_PARAM_NAME, 0);
                        }
                        if (this.isParamPresent(PORT_PARAM_NAME)) {
                            port = this.getParamIntValue(PORT_PARAM_NAME, 0);
                        }
                        this.init();
                        hostbinding = this.getBindingForHost(hostname, port);
                        break block20;
                    } else if (servertype.equalsIgnoreCase(TED_SERVER_S3)) {
                        progId = Common.MapRProgramId.CldbS3ServerProgramId.getNumber();
                        procId = CLDBS3ServerProto.S3ServerProg.S3ServerTedActionProc.getNumber();
                        break block20;
                    } else {
                        if (!servertype.equalsIgnoreCase(TED_SERVER_CLDB)) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid server type " + servertype));
                            output.setOutput(out);
                            return output;
                        }
                        progId = Common.MapRProgramId.CldbProgramId.getNumber();
                        procId = CLDBProto.CLDBProg.TedActionProc.getNumber();
                    }
                    break block20;
                }
                progId = Common.MapRProgramId.CldbProgramId.getNumber();
                procId = CLDBProto.CLDBProg.TedActionProc.getNumber();
            }
            if (hostbinding > 0L) {
                if (id >= 1700 && id <= 1702) {
                    byte[] replyData = Rpc.sendRequest((long)hostbinding, (int)progId, (int)procId, (MessageLite)reqB.build());
                    if (replyData != null) return output;
                    LOG.error((Object)"Got null reply from RPC");
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "rpc to Insight Service failed"));
                    output.setOutput(out);
                    return output;
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Mismatch of id and server type."));
                output.setOutput(out);
                return output;
            }
            data = this.isParamPresent("cluster") ? cldbRpc.sendRequest(this.getParamTextValue("cluster", 0), progId, procId, (MessageLite)reqB.build(), CLDBProto.TedActionResponse.class) : cldbRpc.sendRequest(progId, procId, (MessageLite)reqB.build(), CLDBProto.TedActionResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.TedActionResponse resp = CLDBProto.TedActionResponse.parseFrom((byte[])data);
            int status = resp.getStatus();
            if (status == 0) return output;
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "enabling tedaction once failed with error - " + resp.getErrMsg()));
            output.setOutput(out);
            return output;
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error while trying to enable tedaction once"));
            output.setOutput(out);
            return output;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CommandOutput disableTedAction() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        String hostname = DEFAULT_HOST_NAME;
        int port = 8010;
        long hostbinding = -1L;
        CLDBProto.TedActionRequest.Builder reqB = CLDBProto.TedActionRequest.newBuilder();
        reqB.setCmd(CLDBProto.TedActionRequest.TedActionType.DISABLE);
        int id = this.getParamIntValue(TED_ID_PARAM_NAME, 0);
        reqB.setId(id);
        if (this.isParamPresent(OBJECT_PARAM_NAME)) {
            reqB.setObjectRef(this.getParamTextValue(OBJECT_PARAM_NAME, 0));
        }
        if (this.isParamPresent(TED_PROC_ID)) {
            reqB.setProc(this.getParamIntValue(TED_PROC_ID, 0));
        }
        reqB.setCreds(this.getUserCredentials());
        byte[] data = null;
        CLDBRpcCommonUtils cldbRpc = CLDBRpcCommonUtils.getInstance();
        try {
            int procId;
            int progId;
            block16: {
                block17: {
                    String servertype;
                    block18: {
                        if (!this.isParamPresent(TED_SERVER_TYPE)) break block17;
                        servertype = this.getParamTextValue(TED_SERVER_TYPE, 0);
                        if (!this.getParamTextValue(TED_SERVER_TYPE, 0).equalsIgnoreCase(TED_SERVER_PBS)) break block18;
                        progId = Common.MapRProgramId.PolicyServerProgramId.getNumber();
                        procId = PolicyServerProto.SecurityPolicyProc.SecurityPolicyTedActionProc.getNumber();
                        break block16;
                    }
                    if (servertype.equalsIgnoreCase(TED_SERVER_INSIGHT)) {
                        progId = Common.MapRProgramId.InsightServerProgramId.getNumber();
                        procId = CLDBProto.CLDBProg.InsightTedActionProc.getNumber();
                        if (this.isParamPresent(HOST_PARAM_NAME)) {
                            hostname = this.getParamTextValue(HOST_PARAM_NAME, 0);
                        }
                        if (this.isParamPresent(PORT_PARAM_NAME)) {
                            port = this.getParamIntValue(PORT_PARAM_NAME, 0);
                        }
                        this.init();
                        hostbinding = this.getBindingForHost(hostname, port);
                        break block16;
                    } else if (servertype.equalsIgnoreCase(TED_SERVER_S3)) {
                        progId = Common.MapRProgramId.CldbS3ServerProgramId.getNumber();
                        procId = CLDBS3ServerProto.S3ServerProg.S3ServerTedActionProc.getNumber();
                        break block16;
                    } else {
                        if (!servertype.equalsIgnoreCase(TED_SERVER_CLDB)) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid server type " + servertype));
                            output.setOutput(out);
                            return output;
                        }
                        progId = Common.MapRProgramId.CldbProgramId.getNumber();
                        procId = CLDBProto.CLDBProg.TedActionProc.getNumber();
                    }
                    break block16;
                }
                progId = Common.MapRProgramId.CldbProgramId.getNumber();
                procId = CLDBProto.CLDBProg.TedActionProc.getNumber();
            }
            if (hostbinding > 0L) {
                if (id >= 1700 && id <= 1702) {
                    byte[] replyData = Rpc.sendRequest((long)hostbinding, (int)progId, (int)procId, (MessageLite)reqB.build());
                    if (replyData != null) return output;
                    LOG.error((Object)"Got null reply from RPC");
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "rpc to Insight Service failed"));
                    output.setOutput(out);
                    return output;
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Mismatch of id and server type."));
                output.setOutput(out);
                return output;
            }
            data = this.isParamPresent("cluster") ? cldbRpc.sendRequest(this.getParamTextValue("cluster", 0), progId, procId, (MessageLite)reqB.build(), CLDBProto.TedActionResponse.class) : cldbRpc.sendRequest(progId, procId, (MessageLite)reqB.build(), CLDBProto.TedActionResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.TedActionResponse resp = CLDBProto.TedActionResponse.parseFrom((byte[])data);
            int status = resp.getStatus();
            if (status == 0) return output;
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "disabling tedaction failed with error - " + resp.getErrMsg()));
            output.setOutput(out);
            return output;
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error while trying to disable tedaction"));
            output.setOutput(out);
            return output;
        }
    }

    CommandOutput statusTedAction() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput.OutputHierarchy.OutputNode oStatus = new CommandOutput.OutputHierarchy.OutputNode("status");
        output.setOutput(out);
        String hostname = DEFAULT_HOST_NAME;
        int port = 8010;
        long hostbinding = -1L;
        CLDBProto.TedActionRequest.Builder reqB = CLDBProto.TedActionRequest.newBuilder();
        reqB.setCmd(CLDBProto.TedActionRequest.TedActionType.STATUS);
        if (this.isParamPresent(TED_ID_PARAM_NAME)) {
            reqB.setId(this.getParamIntValue(TED_ID_PARAM_NAME, 0));
        }
        if (this.isParamPresent(SET_VALUE_PARAM_NAME)) {
            reqB.setValue(this.getParamTextValue(SET_VALUE_PARAM_NAME, 0));
        }
        if (this.isParamPresent(TED_PROC_ID)) {
            reqB.setProc(this.getParamIntValue(TED_PROC_ID, 0));
        }
        reqB.setCreds(this.getUserCredentials());
        try {
            CLDBProto.TedActionResponse resp;
            byte[] replyData;
            int progId = 0;
            int procId = 0;
            if (this.isParamPresent(TED_SERVER_TYPE)) {
                String servertype = this.getParamTextValue(TED_SERVER_TYPE, 0);
                if (servertype.equalsIgnoreCase(TED_SERVER_INSIGHT)) {
                    progId = Common.MapRProgramId.InsightServerProgramId.getNumber();
                    procId = CLDBProto.CLDBProg.InsightTedActionProc.getNumber();
                    if (this.isParamPresent(HOST_PARAM_NAME)) {
                        hostname = this.getParamTextValue(HOST_PARAM_NAME, 0);
                    }
                    if (this.isParamPresent(PORT_PARAM_NAME)) {
                        port = this.getParamIntValue(PORT_PARAM_NAME, 0);
                    }
                    this.init();
                    hostbinding = this.getBindingForHost(hostname, port);
                } else {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid server type " + servertype + ", supporting Insight server only"));
                    output.setOutput(out);
                    return output;
                }
            }
            if ((replyData = Rpc.sendRequest((long)hostbinding, (int)progId, (int)procId, (MessageLite)reqB.build())) == null) {
                LOG.error((Object)"Got null reply from RPC");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "rpc to Insight Service failed"));
                output.setOutput(out);
            }
            if ((resp = CLDBProto.TedActionResponse.parseFrom((byte[])replyData)).getStatus() == 0) {
                String eventName = null;
                int eventId = 0;
                if (this.isParamPresent(TED_ID_PARAM_NAME)) {
                    if (resp.getInfoCount() <= 0) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "No response received for the ted event"));
                        output.setOutput(out);
                        return output;
                    }
                    CLDBProto.TedEventsInfo eventInfo = resp.getInfo(0);
                    eventId = eventInfo.getEventId();
                    eventName = TedConstants.getInsightEventName((int)eventId);
                    CommandOutput.OutputHierarchy.OutputNode oEventName = new CommandOutput.OutputHierarchy.OutputNode(eventName + " (" + eventId + ")");
                    oStatus.addNode(oEventName);
                    this.printTedEventStatus(eventInfo, oEventName);
                } else {
                    if (resp.getInfoCount() <= 0) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "No response received for the ted event"));
                        output.setOutput(out);
                        return output;
                    }
                    for (CLDBProto.TedEventsInfo eventInfo : resp.getInfoList()) {
                        eventId = eventInfo.getEventId();
                        eventName = TedConstants.getInsightEventName((int)eventId);
                        CommandOutput.OutputHierarchy.OutputNode oEventName = new CommandOutput.OutputHierarchy.OutputNode(eventName + "(" + eventId + ")");
                        oStatus.addNode(oEventName);
                        this.printTedEventStatus(eventInfo, oEventName);
                    }
                }
                out.addNode(oStatus);
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to display status of tedactions, failed with error - " + resp.getErrMsg()));
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error while trying to display status of tedactions"));
        }
        return output;
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        if (!super.validateInput()) {
            CommandOutput output = new CommandOutput();
            CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
            output.setOutput(out);
            return output;
        }
        this.userInfo = new UnixUserGroupHelper();
        String command = this.cliCommand.getCommandName();
        if (command.equalsIgnoreCase("enable")) {
            return this.enableTedAction();
        }
        if (command.equalsIgnoreCase("enableonce")) {
            return this.enableTedActionOnce();
        }
        if (command.equalsIgnoreCase("disable")) {
            return this.disableTedAction();
        }
        if (command.equalsIgnoreCase("status")) {
            return this.statusTedAction();
        }
        return new TextCommandOutput(("ted command failed: unknown command " + command + " received.").getBytes());
    }

    public String getCommandUsage() {
        return usageStr;
    }
}

