/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.marlin;

import com.google.common.collect.ImmutableMap;
import com.mapr.cli.DbCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.FileclientRun;
import com.mapr.cli.marlin.RecentStreamsListManager;
import com.mapr.cli.marlin.RecentStreamsListManagers;
import com.mapr.cli.marlin.StreamsCommands;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.proto.Marlinserver;
import com.mapr.kafka.eventstreams.Admin;
import com.mapr.kafka.eventstreams.Streams;
import com.mapr.kafka.eventstreams.TimestampType;
import com.mapr.kafka.eventstreams.TopicDescriptor;
import com.mapr.kafka.eventstreams.impl.admin.CursorInfo;
import com.mapr.kafka.eventstreams.impl.admin.MarlinAdminImpl;
import com.mapr.kafka.eventstreams.impl.admin.TopicFeedInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class TopicCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(TopicCommands.class);
    private static final String PATH_PARAM_NAME = "path";
    private static final String TOPIC_PARAM_NAME = "topic";
    private static final String NUM_PARTITIONS_PARAM_NAME = "partitions";
    private static final String TIMESTAMP_TYPE_PARAM_NAME = "timestamptype";
    private static final CLICommand createCommand = new CLICommand("create", "usage: stream topic create -path <path> -topic <topic> -partitions <partitions> -timestamptype createtime | logappendtime", TopicCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Stream Path", true, null)).put((Object)"topic", (Object)new TextInputParameter("topic", "Topic Name", true, null)).put((Object)"partitions", (Object)new IntegerInputParameter("partitions", "Number of partitions. default: attribute defaultpartitions on the stream", false, null)).put((Object)"timestamptype", (Object)new TextInputParameter("timestamptype", "Timestamp type: createtime | logappendtime default: createtime", false, null)).build(), null).setShortUsage("stream topic create -path <path> -topic <topic>");
    private static final CLICommand compactNowCommand = new CLICommand("compactnow", "", TopicCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Stream Path", true, null)).put((Object)"topic", (Object)new TextInputParameter("topic", "Topic Name", true, null)).build(), null).setUsageInVisible(true);
    private static final CLICommand editCommand = new CLICommand("edit", "usage: stream topic edit -path <path> -topic <topic> -partitions <partitions>", TopicCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Stream Path", true, null)).put((Object)"topic", (Object)new TextInputParameter("topic", "Topic Name", true, null)).put((Object)"partitions", (Object)new IntegerInputParameter("partitions", "Number of partitions", false, null)).put((Object)"timestamptype", (Object)new TextInputParameter("timestamptype", "Timestamp type: createtime | logappendtime default: createtime", false, null)).build(), null).setShortUsage("stream topic edit -path <path> -topic <topic> -partitions <partitions>");
    private static final CLICommand infoCommand = new CLICommand("info", "usage: stream topic info -path <path> -topic <topic>", TopicCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Stream Path", true, null)).put((Object)"topic", (Object)new TextInputParameter("topic", "Topic Name", true, null)).build(), null).setShortUsage("stream topic info -path <path> -topic <topic>");
    private static final CLICommand listCommand = new CLICommand("list", "usage: stream topic list -path <path>", TopicCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Stream Path", true, null)).build(), null).setShortUsage("stream topic list -path <path>");
    private static final CLICommand deleteCommand = new CLICommand("delete", "usage: stream topic delete -path <path> -topic <topic>", TopicCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Stream Path", true, null)).put((Object)"topic", (Object)new TextInputParameter("topic", "Topic Name", true, null)).build(), null).setShortUsage("stream topic delete -path <path> -topic <topic>");
    public static final CLICommand topicCommands = new CLICommand("topic", "topic [create|edit|delete|info]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{createCommand, editCommand, deleteCommand, infoCommand, listCommand, compactNowCommand}).setShortUsage("stream topic [create|edit|delete|info|list]");

    public TopicCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        String cmdName = this.cliCommand.getCommandName();
        if (cmdName.equalsIgnoreCase(createCommand.getCommandName())) {
            this.createTopic(out);
        } else if (cmdName.equalsIgnoreCase(editCommand.getCommandName())) {
            this.editTopic(out);
        } else if (cmdName.equalsIgnoreCase(compactNowCommand.getCommandName())) {
            this.compactTopicNow(out);
        } else if (cmdName.equalsIgnoreCase(infoCommand.getCommandName())) {
            this.infoTopic(out);
        } else if (cmdName.equalsIgnoreCase(listCommand.getCommandName())) {
            this.listTopics(out);
        } else if (cmdName.equalsIgnoreCase(deleteCommand.getCommandName())) {
            this.deleteTopic(out);
        }
        return output;
    }

    private void createTopic(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        try {
            String user = this.getUserLoginId();
            String streamName = this.getParamTextValue(PATH_PARAM_NAME, 0);
            final String path = DbCommands.getTransformedPath(streamName, this.getUserLoginId());
            final String topicName = this.getParamTextValue(TOPIC_PARAM_NAME, 0);
            final Configuration conf = new Configuration();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("begin creating topic=" + topicName + " in stream=" + path + " user=" + user));
            }
            final TopicDescriptor topicDesc = Streams.newTopicDescriptor();
            if (this.isParamPresent(NUM_PARTITIONS_PARAM_NAME)) {
                int nf = this.getParamIntValue(NUM_PARTITIONS_PARAM_NAME, 0);
                if (nf < 1) {
                    throw new CLIProcessingException("Invalid value " + nf + " for numpartitions, but be >=1");
                }
                topicDesc.setPartitions(nf);
            }
            if (this.isParamPresent(TIMESTAMP_TYPE_PARAM_NAME)) {
                String timestampType = this.getParamTextValue(TIMESTAMP_TYPE_PARAM_NAME, 0);
                topicDesc.setTimestampType(TimestampType.forName((String)timestampType));
            }
            final RecentStreamsListManager manager = RecentStreamsListManagers.getRecentStreamsListManagerForUser(user);
            final MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
            new FileclientRun(user){

                @Override
                public void runAsProxyUser() throws CLIProcessingException, IOException {
                    try {
                        Admin madmin = Streams.newAdmin((Configuration)conf);
                        madmin.createTopic(path, topicName, topicDesc);
                        manager.moveToTop(path);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("createTopic failed : " + e));
                        manager.deleteIfNotExist(path, mfs);
                        throw e;
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private void compactTopicNow(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        try {
            String user = this.getUserLoginId();
            String streamName = this.getParamTextValue(PATH_PARAM_NAME, 0);
            final String path = DbCommands.getTransformedPath(streamName, this.getUserLoginId());
            final String topicName = this.getParamTextValue(TOPIC_PARAM_NAME, 0);
            final Configuration conf = new Configuration();
            final RecentStreamsListManager manager = RecentStreamsListManagers.getRecentStreamsListManagerForUser(user);
            final MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("begin compact topic=" + topicName + " in stream=" + path + " user=" + user));
            }
            new FileclientRun(user){

                @Override
                public void runAsProxyUser() throws CLIProcessingException, IOException {
                    try {
                        Admin madmin = Streams.newAdmin((Configuration)conf);
                        madmin.compactTopicNow(path, topicName);
                        manager.moveToTop(path);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("compactTopic failed : " + e));
                        manager.deleteIfNotExist(path, mfs);
                        throw e;
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private void editTopic(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        try {
            String user = this.getUserLoginId();
            String streamName = this.getParamTextValue(PATH_PARAM_NAME, 0);
            final String path = DbCommands.getTransformedPath(streamName, this.getUserLoginId());
            final String topicName = this.getParamTextValue(TOPIC_PARAM_NAME, 0);
            final Configuration conf = new Configuration();
            final RecentStreamsListManager manager = RecentStreamsListManagers.getRecentStreamsListManagerForUser(user);
            final MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("begin editing topic=" + topicName + " in stream=" + path + " user=" + user));
            }
            final TopicDescriptor topicDesc = Streams.newTopicDescriptor();
            if (this.isParamPresent(NUM_PARTITIONS_PARAM_NAME)) {
                int nf = this.getParamIntValue(NUM_PARTITIONS_PARAM_NAME, 0);
                if (nf < 1) {
                    throw new CLIProcessingException("Invalid value " + nf + " for numpartitions, but be >=1");
                }
                topicDesc.setPartitions(nf);
            }
            if (this.isParamPresent(TIMESTAMP_TYPE_PARAM_NAME)) {
                String timestampType = this.getParamTextValue(TIMESTAMP_TYPE_PARAM_NAME, 0);
                topicDesc.setTimestampType(TimestampType.forName((String)timestampType));
            }
            new FileclientRun(user){

                @Override
                public void runAsProxyUser() throws CLIProcessingException, IOException {
                    try {
                        Admin madmin = Streams.newAdmin((Configuration)conf);
                        madmin.editTopic(path, topicName, topicDesc);
                        manager.moveToTop(path);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("editTopic failed : " + e));
                        manager.deleteIfNotExist(path, mfs);
                        throw e;
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private void infoTopic(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        try {
            String user = this.getUserLoginId();
            String streamName = this.getParamTextValue(PATH_PARAM_NAME, 0);
            final String path = DbCommands.getTransformedPath(streamName, this.getUserLoginId());
            final String topic = this.getParamTextValue(TOPIC_PARAM_NAME, 0);
            final ArrayList feedsList = new ArrayList();
            final Configuration conf = new Configuration();
            final ArrayList descList = new ArrayList();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("begin info topic=" + topic + " stream=" + path + " user=" + user));
            }
            final RecentStreamsListManager manager = RecentStreamsListManagers.getRecentStreamsListManagerForUser(user);
            final MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
            new FileclientRun(user){

                @Override
                public void runAsProxyUser() throws CLIProcessingException, IOException {
                    try {
                        Admin admin = Streams.newAdmin((Configuration)conf);
                        MarlinAdminImpl madmin = (MarlinAdminImpl)admin;
                        TopicDescriptor desc = madmin.getTopicDescriptor(path, topic);
                        descList.add(desc);
                        String topicFullName = path + ":" + topic;
                        List tlist = madmin.infoTopic(topicFullName);
                        feedsList.addAll(tlist);
                        manager.moveToTop(path);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("infoTopic failed : " + e));
                        manager.deleteIfNotExist(path, mfs);
                        throw e;
                    }
                }
            };
            for (TopicFeedInfo tinfo : feedsList) {
                out.addNode(TopicCommands.formatFeedInfo(tinfo, (TopicDescriptor)descList.get(0)));
            }
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private static String getMaster(Marlinserver.TopicFeedStatInfo tinfo) {
        return tinfo.getMaster() + ":" + tinfo.getMasterPort();
    }

    private static String getServers(Marlinserver.TopicFeedStatInfo tinfo) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tinfo.getServersList().size(); ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append((String)tinfo.getServersList().get(i));
            builder.append(":");
            builder.append(tinfo.getServerPortsList().get(i));
        }
        return builder.toString();
    }

    private static void formatTopicDescriptor(CommandOutput.OutputHierarchy.OutputNode node, TopicDescriptor desc) {
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(TIMESTAMP_TYPE_PARAM_NAME, (Object)desc.getTimestampType().toString()));
    }

    private static String getLogCompactionStatus(Marlinserver.LogCompactionStatus lcStatus) {
        if (lcStatus == Marlinserver.LogCompactionStatus.LC_NOT_STARTED) {
            return "not started";
        }
        if (lcStatus == Marlinserver.LogCompactionStatus.LC_STARTED) {
            return "started";
        }
        if (lcStatus == Marlinserver.LogCompactionStatus.LC_DONE_SUCCESS) {
            return "completed";
        }
        return "failed";
    }

    public static CommandOutput.OutputHierarchy.OutputNode formatFeedInfo(TopicFeedInfo topicFeedinfo, TopicDescriptor desc) {
        CommandOutput.OutputHierarchy.OutputNode feedNode = new CommandOutput.OutputHierarchy.OutputNode();
        long minSeq = Long.MAX_VALUE;
        long minListenerTs = Long.MAX_VALUE;
        List cursorList = topicFeedinfo.cursorList();
        Marlinserver.TopicFeedStatInfo tinfo = topicFeedinfo.stat();
        for (CursorInfo c : cursorList) {
            if (c.cursor() < minSeq) {
                minSeq = c.cursor();
            }
            if (c.timestamp() >= minListenerTs) continue;
            minListenerTs = c.timestamp();
        }
        Marlinserver.LcPartitionStatus tpStatus = topicFeedinfo.logCompactionStatus();
        feedNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("partitionid", tinfo.getFeedId()));
        feedNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("physicalsize", tinfo.getPhysicalSize()));
        feedNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("logicalsize", tinfo.getLogicalSize()));
        feedNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxoffset", tinfo.getMaxSeq()));
        feedNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("minoffsetacrossconsumers", minSeq == Long.MAX_VALUE ? 0L : minSeq));
        long minTS = tinfo.getTimeRange().getMinTS();
        if (minTS == Long.MAX_VALUE) {
            minTS = 0L;
        }
        feedNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("mintimestamp", (Object)StreamsCommands.millisToDate(minTS)));
        long maxTS = tinfo.getTimeRange().getMaxTS();
        if (maxTS == Long.MIN_VALUE) {
            maxTS = 0L;
        }
        feedNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxtimestamp", (Object)StreamsCommands.millisToDate(maxTS)));
        if (minListenerTs == Long.MAX_VALUE) {
            minListenerTs = 0L;
        }
        feedNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("mintimestampacrossconsumers", (Object)StreamsCommands.millisToDate(minListenerTs)));
        if (tinfo.hasFid()) {
            String fid = MapRCliUtil.getFidAsString(tinfo.getFid());
            feedNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)fid));
        }
        if (tinfo.hasMaster()) {
            String master = TopicCommands.getMaster(tinfo);
            feedNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("master", (Object)master));
        }
        if (tinfo.getServersList().size() > 0) {
            String servers = TopicCommands.getServers(tinfo);
            feedNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("servers", (Object)servers));
        }
        TopicCommands.formatTopicDescriptor(feedNode, desc);
        feedNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("logcompactionlaststarted", (Object)StreamsCommands.millisToDate(tpStatus.getLastLcTimeMs())));
        feedNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("logcompactionlastcompleted", (Object)StreamsCommands.millisToDate(tpStatus.getLastLcCompactedTimeMs())));
        feedNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("logcompactionstatus", (Object)TopicCommands.getLogCompactionStatus(tpStatus.getLcStatus())));
        return feedNode;
    }

    private void listTopics(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        try {
            String user = this.getUserLoginId();
            String streamName = this.getParamTextValue(PATH_PARAM_NAME, 0);
            final String path = DbCommands.getTransformedPath(streamName, this.getUserLoginId());
            final Configuration conf = new Configuration();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("begin topic list for stream=" + path + " user=" + user));
            }
            final HashMap topicsMap = new HashMap();
            final RecentStreamsListManager manager = RecentStreamsListManagers.getRecentStreamsListManagerForUser(user);
            final MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
            new FileclientRun(user){

                @Override
                public void runAsProxyUser() throws CLIProcessingException, IOException {
                    try {
                        Admin admin = Streams.newAdmin((Configuration)conf);
                        MarlinAdminImpl madmin = (MarlinAdminImpl)admin;
                        Map tmap = madmin.listTopicsForStream(path);
                        topicsMap.putAll(tmap);
                        manager.moveToTop(path);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("listTopics failed : " + e));
                        manager.deleteIfNotExist(path, mfs);
                        throw e;
                    }
                }
            };
            for (Map.Entry entry : topicsMap.entrySet()) {
                String topicName = (String)entry.getKey();
                List feedList = (List)entry.getValue();
                CommandOutput.OutputHierarchy.OutputNode topicNode = new CommandOutput.OutputHierarchy.OutputNode();
                topicNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(TOPIC_PARAM_NAME, (Object)topicName));
                topicNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(NUM_PARTITIONS_PARAM_NAME, feedList.size()));
                long physicalSize = 0L;
                long logicalSize = 0L;
                long maxLag = 0L;
                long numConsumers = 0L;
                for (TopicFeedInfo feed : feedList) {
                    Marlinserver.TopicFeedStatInfo statInfo = feed.stat();
                    List cursorList = feed.cursorList();
                    physicalSize += statInfo.getPhysicalSize();
                    logicalSize += statInfo.getLogicalSize();
                    long maxProducerTS = statInfo.getTimeRange().getMaxTS();
                    if (maxProducerTS != Long.MIN_VALUE) {
                        for (CursorInfo c : cursorList) {
                            long lag = maxProducerTS - c.timestamp();
                            if (lag <= maxLag) continue;
                            maxLag = lag;
                        }
                    }
                    if ((long)cursorList.size() <= numConsumers) continue;
                    numConsumers = cursorList.size();
                }
                topicNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("consumers", numConsumers));
                topicNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("physicalsize", physicalSize));
                topicNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("logicalsize", logicalSize));
                topicNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("maxlag", maxLag));
                out.addNode(topicNode);
            }
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private void deleteTopic(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        try {
            String user = this.getUserLoginId();
            String streamName = this.getParamTextValue(PATH_PARAM_NAME, 0);
            final String path = DbCommands.getTransformedPath(streamName, this.getUserLoginId());
            final String topicName = this.getParamTextValue(TOPIC_PARAM_NAME, 0);
            final Configuration conf = new Configuration();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("begin deleting topic=" + topicName + " in stream=" + path + " user=" + user));
            }
            final RecentStreamsListManager manager = RecentStreamsListManagers.getRecentStreamsListManagerForUser(user);
            final MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
            new FileclientRun(user){

                @Override
                public void runAsProxyUser() throws CLIProcessingException, IOException {
                    try {
                        Admin madmin = Streams.newAdmin((Configuration)conf);
                        madmin.deleteTopic(path, topicName);
                        manager.moveToTop(path);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("deleteTopic failed : " + e));
                        manager.deleteIfNotExist(path, mfs);
                        throw e;
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }
}

