/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.table;

import com.google.common.collect.Lists;
import com.mapr.cli.MapRCliUtil;
import com.mapr.fs.MapRFileSystem;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class RecentTablesListManager {
    private static final Logger LOG = Logger.getLogger(RecentTablesListManager.class);
    private static final int MAX_RECENT_TABLES_LIST_SIZE = 50;
    private final String user;
    private static final String DISABLE_RECENT_LIST_NAME = "maprcli.disable-recentlist";
    private static final boolean disableRecentTablesList = System.getProperty("maprcli.disable-recentlist") != null;

    public RecentTablesListManager(String user) {
        this.user = user;
    }

    public boolean hasHomeDir() {
        try {
            return MapRCliUtil.getMapRFileSystem().exists(new Path(this.getHomeDir())) && !MapRCliUtil.getMapRFileSystem().isFile(new Path(this.getHomeDir()));
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String newTable) {
        if (disableRecentTablesList) {
            return;
        }
        RecentTablesListManager recentTablesListManager = this;
        synchronized (recentTablesListManager) {
            List<String> recentTables = this.getListFromFile();
            if (recentTables.indexOf(newTable) == -1) {
                recentTables.add(0, newTable);
                while (recentTables.size() > 50) {
                    recentTables.remove(recentTables.size() - 1);
                }
                this.writeListToFile(recentTables);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToTop(String mostRecentTable) {
        if (disableRecentTablesList) {
            return;
        }
        RecentTablesListManager recentTablesListManager = this;
        synchronized (recentTablesListManager) {
            List<String> recentTables = this.getListFromFile();
            if (recentTables.indexOf(mostRecentTable) != -1) {
                recentTables.remove(mostRecentTable);
            }
            recentTables.add(0, mostRecentTable);
            this.writeListToFile(recentTables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String tablePath) {
        if (disableRecentTablesList) {
            return;
        }
        RecentTablesListManager recentTablesListManager = this;
        synchronized (recentTablesListManager) {
            List<String> recentTablesList = this.getListFromFile();
            if (recentTablesList.remove(tablePath)) {
                this.writeListToFile(recentTablesList);
            }
        }
    }

    public void deleteIfNotExist(String tablePath, MapRFileSystem mfs) {
        try {
            if (!mfs.exists(new Path(tablePath)) || !mfs.getMapRFileStatus(new Path(tablePath)).isTable()) {
                this.delete(tablePath);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<String> getListFromFile() {
        ArrayList tablePaths = Lists.newArrayList();
        try {
            Path recentTablesFilePath = new Path(this.getPathForRecentList());
            MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
            if (mfs.isFile(recentTablesFilePath)) {
                String path;
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)mfs.open(new Path(this.getPathForRecentList()))));
                while ((path = reader.readLine()) != null) {
                    tablePaths.add(path);
                }
                reader.close();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return tablePaths;
    }

    private void writeListToFile(List<String> recentTablesList) {
        try {
            MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
            String filePath = this.getPathForRecentList();
            String tempFilePath = filePath + new Random().nextInt();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(mfs.create(new Path(tempFilePath), true).getWrappedStream()));
            for (String tablePath : recentTablesList) {
                writer.write(tablePath, 0, tablePath.length());
                writer.newLine();
            }
            writer.close();
            mfs.rename(new Path(tempFilePath), new Path(filePath));
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    protected String getPathForRecentList() {
        return this.getHomeDir() + "/.recent_tables";
    }

    protected String getHomeDir() {
        return "/user/" + this.user;
    }
}

